/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.desform.mongo.service.a;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.mongodb.client.result.UpdateResult;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringUtil;
import org.apache.shiro.SecurityUtils;
import org.bson.Document;
import org.jeecg.common.api.dto.message.MessageDTO;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.config.TenantContext;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.constant.enums.MessageTypeEnum;
import org.jeecg.common.exception.JeecgBootBizTipException;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.lowapp.api.ILowAppBaseApi;
import org.jeecg.common.lowapp.model.LowAppFormAuthRecordModel;
import org.jeecg.common.miniflow.ISignalProcessStartApi;
import org.jeecg.common.online.api.IOnlineBaseExtApi;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.query.MatchTypeEnum;
import org.jeecg.common.system.query.QueryRuleEnum;
import org.jeecg.common.system.vo.DictModel;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.AssertUtils;
import org.jeecg.common.util.DateUtils;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.common.util.RestUtil;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.JeecgBaseConfig;
import org.jeecg.config.mybatis.MybatisPlusSaasConfig;
import org.jeecg.modules.online.desform.constant.WidgetTypes;
import org.jeecg.modules.online.desform.constant.c;
import org.jeecg.modules.online.desform.constant.d;
import org.jeecg.modules.online.desform.datafactory.inter.dao.IDesformViewDao;
import org.jeecg.modules.online.desform.entity.DesignForm;
import org.jeecg.modules.online.desform.entity.DesignFormData;
import org.jeecg.modules.online.desform.mongo.b.a;
import org.jeecg.modules.online.desform.mongo.model.BaseColumn;
import org.jeecg.modules.online.desform.mongo.model.DateStats;
import org.jeecg.modules.online.desform.mongo.model.FieldOption;
import org.jeecg.modules.online.desform.mongo.model.ListViewModel;
import org.jeecg.modules.online.desform.mongo.model.SummaryModel;
import org.jeecg.modules.online.desform.mongo.service.IDataMongoCurdService;
import org.jeecg.modules.online.desform.mongo.service.IDesignFormListViewService;
import org.jeecg.modules.online.desform.service.IDesignFormDataService;
import org.jeecg.modules.online.desform.service.IDesignFormService;
import org.jeecg.modules.online.desform.util.DesformQueryUtils;
import org.jeecg.modules.online.desform.util.h;
import org.jeecg.modules.online.desform.vo.ADefValLinkageVo;
import org.jeecg.modules.online.desform.vo.BatchUpdateModel;
import org.jeecg.modules.online.desform.vo.DesformOperationEnum;
import org.jeecg.modules.online.desform.vo.DesformPageVo;
import org.jeecg.modules.online.desform.vo.LinkRecordSummary;
import org.jeecg.modules.online.desform.vo.excel.DesformWidgetList;
import org.jeecg.modules.online.desform.vo.query.DesformQuery;
import org.jeecg.modules.online.desform.vo.query.DesformSuperQuery;
import org.jeecg.modules.online.desform.vo.query.DesformSuperQueryGroup;
import org.jeecg.modules.online.desform.vo.query.IdOrCodeParam;
import org.jeecg.modules.online.desform.vo.query.SuperQueryItem;
import org.jeecg.modules.online.desform.vo.query.params.DesformExtentdParam;
import org.jeecg.modules.online.desform.vo.widget.DesformOptions;
import org.jeecg.modules.online.desform.vo.widget.DesformWidget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.GroupOperation;
import org.springframework.data.mongodb.core.aggregation.MatchOperation;
import org.springframework.data.mongodb.core.aggregation.ProjectionOperation;
import org.springframework.data.mongodb.core.aggregation.SortOperation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Conditional(value={org.jeecg.modules.online.desform.datafactory.a.b.class})
@Service(value="designFormDataMongoServiceImpl")
public class b
extends org.jeecg.modules.online.desform.datafactory.inter.service.a.b
implements IDesignFormDataService {
    @Generated
    private static final Logger o = LoggerFactory.getLogger(b.class);
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    IDataMongoCurdService dataMongoCurdService;
    @Autowired
    IDesignFormListViewService designFormListViewService;
    @Lazy
    @Autowired
    IDesformViewDao desformViewDao;
    @Autowired
    @Lazy
    ILowAppBaseApi lowAppBaseApi;
    private final String p = "UPDATE";
    private final String q = "DELETE";
    private final String r = "LOGIC_DELETE";

    @Autowired
    public b(JeecgBaseConfig jeecgBaseConfig, RedisUtil redisUtil, @Lazy ISysBaseAPI sysBaseApi, @Lazy org.jeecg.modules.online.desform.service.a.a oaSignService, @Lazy org.jeecg.modules.online.desform.d.a translService, @Lazy IDesignFormService desformService, @Lazy ISignalProcessStartApi signalProcessStartApi, @Lazy IOnlineBaseExtApi onlineBaseExtApi) {
        super(jeecgBaseConfig, redisUtil, sysBaseApi, translService, oaSignService, desformService, signalProcessStartApi, onlineBaseExtApi);
    }

    @Override
    public Result<IPage<DesignFormData>> pageList(String desformCode, Page<DesignFormData> page, DesformSuperQuery superQuery) {
        Result result = new Result();
        Query query = DesformQueryUtils.fillMongoQuery(superQuery);
        String delFlagValue = DesformQueryUtils.b("del_flag", superQuery.getParameterMap());
        if (oConvertUtils.isEmpty((Object)delFlagValue)) {
            delFlagCriteria = new Criteria("del_flag").is((Object)org.jeecg.modules.online.desform.constant.b.ak);
            query.addCriteria((CriteriaDefinition)delFlagCriteria);
        } else {
            delFlagCriteria = new Criteria("del_flag").is((Object)Integer.parseInt(delFlagValue));
            query.addCriteria((CriteriaDefinition)delFlagCriteria);
        }
        result.setMessage("\u67e5\u8be2\u6210\u529f");
        Page<DesignFormData> pageList = this.a(page, desformCode, query);
        DesignForm designForm = this.f.getByCode(desformCode);
        this.d.a(designForm, pageList.getRecords());
        result.setResult(pageList);
        return result;
    }

    @Override
    public Result<List<DesignFormData>> queryList(String desformCode, Page<DesignFormData> page, DesformSuperQuery superQuery, String username) throws UnsupportedEncodingException {
        Result result = new Result();
        Result<?> get = this.a(desformCode, page, superQuery, username, true);
        BeanUtils.copyProperties(get, (Object)result);
        return result;
    }

    @Override
    public Result<Page<DesignFormData>> queryPage(String desformCode, Page<DesignFormData> page, DesformSuperQuery superQuery, String username) throws UnsupportedEncodingException {
        Result result = new Result();
        Result<?> get = this.a(desformCode, page, superQuery, username, false);
        BeanUtils.copyProperties(get, (Object)result);
        return result;
    }

    @Override
    public Result<Page<DesignFormData>> queryPage(String desformCode, Page<DesignFormData> page, DesformSuperQueryGroup desformSuperQueryGroup, DesformExtentdParam desformExtentdParam) throws UnsupportedEncodingException {
        Result result = new Result();
        Result<?> get = this.a(desformCode, page, desformSuperQueryGroup, desformExtentdParam);
        BeanUtils.copyProperties(get, (Object)result);
        return result;
    }

    @Override
    public Result<?> queryOperation(String desformCode, DesformOperationEnum operationType, String operationField, DesformSuperQueryGroup desformSuperQueryGroup, DesformExtentdParam desformExtentdParam) throws UnsupportedEncodingException {
        Result result = new Result();
        desformExtentdParam.setOperationType(operationType);
        desformExtentdParam.setOperationField(operationField);
        Result<?> get = this.a(desformCode, null, desformSuperQueryGroup, desformExtentdParam);
        BeanUtils.copyProperties(get, (Object)result);
        return result;
    }

    @Override
    public List<DesignFormData> list(String desformCode, DesformSuperQuery superQuery) {
        Query query = DesformQueryUtils.fillMongoQuery(superQuery);
        return this.a(desformCode, query);
    }

    private List<DesignFormData> a(String desformCode, Query query) {
        if (query == null) {
            query = new Query();
        }
        o.debug("mongodb \u67e5\u8be2\u6761\u4ef6\uff0cdesformCode\uff1a{}\uff0cquery\uff1a{}", (Object)desformCode, (Object)query);
        return this.mongoTemplate.find(query, Document.class, desformCode).stream().map(document -> new DesignFormData(desformCode, (Document)document)).collect(Collectors.toList());
    }

    private List<DesignFormData> b(String desformCode, List<AggregationOperation> operations) {
        if (operations == null) {
            operations = new ArrayList<AggregationOperation>();
        }
        Aggregation agg = Aggregation.newAggregation(operations);
        o.info("mongodb aggregation: {}", (Object)JSON.toJSONString((Object)agg.toDocument(desformCode, Aggregation.DEFAULT_CONTEXT)));
        return this.mongoTemplate.aggregate(agg, desformCode, Document.class).getMappedResults().stream().map(document -> new DesignFormData(desformCode, (Document)document)).collect(Collectors.toList());
    }

    private Result<?> a(String desformCode, Page<DesignFormData> page, DesformSuperQuery superQuery, String username, boolean queryList) throws UnsupportedEncodingException {
        long startTime = System.currentTimeMillis();
        Result result = new Result();
        DesignForm designForm = this.a(desformCode);
        long endTime1 = System.currentTimeMillis();
        o.debug(" 1 \u67e5\u8be2\u8bbe\u8ba1\u8868\u5355\uff0c \u4ee3\u7801\u6267\u884c\u8017\u65f6\uff1a" + (endTime1 - startTime) + "\u6beb\u79d2");
        if (designForm == null) {
            result.setCode(CommonConstant.SC_INTERNAL_NOT_FOUND_404);
            result.setMessage("\u8868\u5355\u4e0d\u5b58\u5728");
            result.setSuccess(false);
            return result;
        }
        String queryDesformCode = designForm.getDesformCode();
        if (org.jeecg.modules.online.desform.constant.b.e.equals(designForm.getDesformType())) {
            queryDesformCode = designForm.getParentCode();
        }
        boolean hasListView = oConvertUtils.isNotEmpty((Object)superQuery.getListViewId());
        ListViewModel listViewModel = this.designFormListViewService.queryListViewInfo(designForm, superQuery.getListViewId(), username);
        long endTime2 = System.currentTimeMillis();
        o.debug(" 2 \u67e5\u8be2\u53f3\u4fa7\u7684\u6392\u5e8f\u914d\u7f6e\uff0c \u4ee3\u7801\u6267\u884c\u8017\u65f6\uff1a" + (endTime2 - endTime1) + "\u6beb\u79d2");
        List<FieldOption> top5List = DesformQueryUtils.a(designForm);
        listViewModel.setFieldList(top5List);
        List<OrderItem> orderList = listViewModel.getOrderList();
        if (CollectionUtils.isEmpty(orderList)) {
            orderList = new ArrayList<OrderItem>();
            orderList.add(OrderItem.desc((String)"create_time"));
        }
        DesformQueryUtils.a(page, orderList);
        result.setMessage("\u67e5\u8be2\u6210\u529f");
        ArrayList<AggregationOperation> operations = new ArrayList<AggregationOperation>();
        DesformQueryUtils.a(operations, superQuery, listViewModel);
        List<Criteria> criteriaList = this.designFormListViewService.getQueryCriterias(username, designForm, superQuery, listViewModel);
        Query query = new Query();
        if (!CollectionUtils.isEmpty(criteriaList)) {
            Criteria criteria = new Criteria();
            criteria.andOperator(criteriaList);
            MatchOperation matchOperation = Aggregation.match((Criteria)criteria);
            operations.add((AggregationOperation)matchOperation);
            query = new Query((CriteriaDefinition)criteria);
            o.debug("MongoDB \u67e5\u8be2\u6761\u4ef6: {}", (Object)JSON.toJSONString((Object)matchOperation.toDocument(Aggregation.DEFAULT_CONTEXT)));
        }
        if (hasListView) {
            Set<String> needFields = this.a(designForm, listViewModel);
            if (oConvertUtils.isNotEmpty((Object)superQuery.getParentField())) {
                needFields.add("__HAS_CHILD");
            }
            ProjectionOperation fieldOperation = Aggregation.project((String[])needFields.toArray(new String[0]));
            operations.add((AggregationOperation)fieldOperation);
            o.debug("MongoDB \u67e5\u8be2\u5b57\u6bb5: {}", (Object)JSON.toJSONString((Object)fieldOperation.toDocument(Aggregation.DEFAULT_CONTEXT)));
        }
        if (queryList) {
            List<AggregationOperation> sortOperations = DesformQueryUtils.b(page.orders());
            if (!CollectionUtils.isEmpty(sortOperations)) {
                operations.addAll(sortOperations);
            }
            result.setResult(this.b(queryDesformCode, operations));
            long endTime3 = System.currentTimeMillis();
            o.debug(" 3 \u67e5\u8be2mogodb\u6570\u636e\uff0c \u4ee3\u7801\u6267\u884c\u8017\u65f6\uff1a" + (endTime3 - endTime2) + "\u6beb\u79d2");
        } else {
            DesformPageVo<DesignFormData> res = new DesformPageVo<DesignFormData>(this.a(page, queryDesformCode, operations, query));
            long endTime3 = System.currentTimeMillis();
            o.debug(" 3 \u67e5\u8be2mogodb\u6570\u636e\uff0c \u4ee3\u7801\u6267\u884c\u8017\u65f6\uff1a" + (endTime3 - endTime2) + "\u6beb\u79d2");
            JSONObject translData = this.d.a(designForm, res.getRecords());
            long endTime4 = System.currentTimeMillis();
            o.debug(" 4 \u7ffb\u8bd1\u5217\u8868\u6570\u636e\uff0c \u4ee3\u7801\u6267\u884c\u8017\u65f6\uff1a" + (endTime4 - endTime3) + "\u6beb\u79d2");
            res.setTranslData(translData);
            res.setHasSuperQuery(superQuery.hasQuery());
            if (superQuery.isQueryLinkField()) {
                this.queryLinkFieldData(designForm, res.getRecords(), true);
            }
            long endTime5 = System.currentTimeMillis();
            o.debug(" 5 \u7ffb\u8bd1\u4ed6\u8868\u5b57\u6bb5\uff0c \u4ee3\u7801\u6267\u884c\u8017\u65f6\uff1a" + (endTime5 - endTime4) + "\u6beb\u79d2");
            List<SummaryModel> summaryList = listViewModel.getSummaryList();
            if (!CollectionUtils.isEmpty(summaryList)) {
                o.debug(" >>> \u8868\u5355\u89c6\u56fe\u8ba1\u7b97\u5408\u8ba1\uff0csummaryList={}", (Object)summaryList.toString());
                for (SummaryModel sm : summaryList) {
                    String type = sm.getType();
                    if (!oConvertUtils.isNotEmpty((Object)type)) continue;
                    String field = sm.getField();
                    String val = this.desformViewDao.statisticalValueByCriteria(queryDesformCode, field, type, criteriaList);
                    sm.setVal(val);
                }
            }
            res.setSummaryList(summaryList);
            long endTime6 = System.currentTimeMillis();
            o.debug(" 6 \u8ba1\u7b97\u5408\u8ba1\uff0c \u4ee3\u7801\u6267\u884c\u8017\u65f6\uff1a" + (endTime6 - endTime5) + "\u6beb\u79d2");
            result.setResult(res);
        }
        long endTime7 = System.currentTimeMillis();
        o.debug(" 7 \u4ece\u5f00\u59cb\u5230\u67e5\u8be2\u8868\u5355\u7ed3\u675f\uff0c \u603b\u8ba1\u4ee3\u7801\u6267\u884c\u8017\u65f6\uff1a" + (endTime7 - startTime) + "\u6beb\u79d2");
        return result;
    }

    private Result<?> a(String desformCode, Page<DesignFormData> page, DesformSuperQueryGroup superQueryGroup, DesformExtentdParam desformExtentdParam) throws UnsupportedEncodingException {
        Boolean queryList;
        long startTime = System.currentTimeMillis();
        Result result = new Result();
        DesignForm designForm = this.a(desformCode);
        long endTime1 = System.currentTimeMillis();
        o.debug(" 1 \u67e5\u8be2\u8bbe\u8ba1\u8868\u5355\uff0c \u4ee3\u7801\u6267\u884c\u8017\u65f6\uff1a" + (endTime1 - startTime) + "\u6beb\u79d2");
        if (designForm == null) {
            result.setCode(CommonConstant.SC_INTERNAL_NOT_FOUND_404);
            result.setMessage("\u8868\u5355\u4e0d\u5b58\u5728");
            result.setSuccess(false);
            return result;
        }
        String queryDesformCode = designForm.getDesformCode();
        if (org.jeecg.modules.online.desform.constant.b.e.equals(designForm.getDesformType())) {
            queryDesformCode = designForm.getParentCode();
        }
        boolean hasListView = oConvertUtils.isNotEmpty((Object)desformExtentdParam.getListViewId());
        ListViewModel listViewModel = this.designFormListViewService.queryListViewInfo(designForm, desformExtentdParam.getListViewId(), desformExtentdParam.getUsername());
        long endTime2 = System.currentTimeMillis();
        o.debug(" 2 \u67e5\u8be2\u53f3\u4fa7\u7684\u6392\u5e8f\u914d\u7f6e\uff0c \u4ee3\u7801\u6267\u884c\u8017\u65f6\uff1a" + (endTime2 - endTime1) + "\u6beb\u79d2");
        List<FieldOption> top5List = DesformQueryUtils.a(designForm);
        listViewModel.setFieldList(top5List);
        List<OrderItem> orderList = listViewModel.getOrderList();
        if (orderList == null || orderList.size() == 0) {
            orderList = new ArrayList<OrderItem>();
            orderList.add(OrderItem.desc((String)"create_time"));
        }
        DesformQueryUtils.a(page, orderList);
        result.setMessage("\u67e5\u8be2\u6210\u529f");
        Query query = new Query();
        Criteria groupCriteria = this.designFormListViewService.getQueryCriteriasGroup(desformExtentdParam.getUsername(), designForm, superQueryGroup, listViewModel, desformExtentdParam);
        if (groupCriteria != null) {
            query = new Query((CriteriaDefinition)groupCriteria);
            o.debug("MongoDB \u67e5\u8be2\u6761\u4ef6: {}", (Object)query);
        }
        if (hasListView) {
            Set<String> needFields = this.a(designForm, listViewModel);
            if (oConvertUtils.isNotEmpty((Object)desformExtentdParam.getParentField())) {
                needFields.add("__HAS_CHILD");
            }
            query.fields().include(needFields.toArray(new String[0]));
            o.debug("MongoDB \u67e5\u8be2\u5b57\u6bb5: {}", (Object)JSON.toJSONString((Object)query.getFieldsObject()));
        }
        if ((queryList = Boolean.valueOf(false)).booleanValue()) {
            DesformQueryUtils.a(page.orders(), query);
            result.setResult(this.a(queryDesformCode, query));
            long endTime3 = System.currentTimeMillis();
            o.debug(" 3 \u67e5\u8be2mogodb\u6570\u636e\uff0c \u4ee3\u7801\u6267\u884c\u8017\u65f6\uff1a" + (endTime3 - endTime2) + "\u6beb\u79d2");
        } else if (desformExtentdParam.getOperationType() != null) {
            Object res = this.a(desformCode, desformExtentdParam.getOperationType(), desformExtentdParam.getOperationField(), groupCriteria);
            result.setResult(res);
            long endTime3 = System.currentTimeMillis();
            o.debug(" 3 \u67e5\u8be2mogodb\u6570\u636e\uff0c \u4ee3\u7801\u6267\u884c\u8017\u65f6\uff1a" + (endTime3 - endTime2) + "\u6beb\u79d2");
        } else {
            List<SummaryModel> summaryList;
            DesformPageVo<DesignFormData> res = new DesformPageVo<DesignFormData>(this.a(page, queryDesformCode, query));
            long endTime3 = System.currentTimeMillis();
            o.debug(" 3 \u67e5\u8be2mogodb\u6570\u636e\uff0c \u4ee3\u7801\u6267\u884c\u8017\u65f6\uff1a" + (endTime3 - endTime2) + "\u6beb\u79d2");
            JSONObject translData = this.d.a(designForm, res.getRecords());
            res.setTranslData(translData);
            long endTime4 = System.currentTimeMillis();
            o.debug(" 4 \u7ffb\u8bd1mogodb\u6570\u636e\uff0c \u4ee3\u7801\u6267\u884c\u8017\u65f6\uff1a" + (endTime4 - endTime3) + "\u6beb\u79d2");
            res.setHasSuperQuery(superQueryGroup.hasQuery());
            if (desformExtentdParam.getQueryLinkField().booleanValue()) {
                this.queryLinkFieldData(designForm, res.getRecords(), true);
                long endTime5 = System.currentTimeMillis();
                o.debug(" 5 \u7ffb\u8bd1\u4ed6\u8868\u5b57\u6bb5\uff0c \u4ee3\u7801\u6267\u884c\u8017\u65f6\uff1a" + (endTime5 - endTime4) + "\u6beb\u79d2");
            }
            if ((summaryList = listViewModel.getSummaryList()) != null && summaryList.size() > 0) {
                for (SummaryModel sm : summaryList) {
                    String type = sm.getType();
                    if (!oConvertUtils.isNotEmpty((Object)type)) continue;
                    String field = sm.getField();
                    String val = this.desformViewDao.statisticalValueByCriteria(queryDesformCode, field, type, groupCriteria);
                    sm.setVal(val);
                }
            }
            res.setSummaryList(summaryList);
            result.setResult(res);
            long endTime5 = System.currentTimeMillis();
            o.debug(" 6 \u8ba1\u7b97\u5408\u8ba1\u503c\uff0c \u4ee3\u7801\u6267\u884c\u8017\u65f6\uff1a" + (endTime5 - endTime4) + "\u6beb\u79d2");
        }
        return result;
    }

    private Set<String> a(DesignForm designForm, ListViewModel listViewModel) {
        HashSet<String> needFields = new HashSet<String>();
        HashSet<String> noNeedFields = new HashSet<String>();
        List<BaseColumn> showColumnList = listViewModel.getShowColumnList();
        if (!CollectionUtils.isEmpty(showColumnList)) {
            for (BaseColumn column : showColumnList) {
                if (column.getShow() == null || column.getShow().booleanValue()) continue;
                noNeedFields.add(column.getField());
            }
        }
        List<BaseColumn> systemColumnList = listViewModel.getSystemColumnList();
        List<BaseColumn> columnList = listViewModel.getColumnList();
        if (listViewModel.isShowColumnIsDiy() && !CollectionUtils.isEmpty(columnList)) {
            for (BaseColumn column : columnList) {
                if (noNeedFields.contains(column.getField()) || column.getShow() == null || !column.getShow().booleanValue()) continue;
                needFields.add(column.getField());
            }
            if (!needFields.isEmpty()) {
                org.jeecg.modules.online.desform.util.h.a(designForm, (WidgetTypes type, JSONObject item, JSONObject parent) -> {
                    String key = item.getString("key");
                    if (needFields.contains(key)) {
                        String model = item.getString("model");
                        needFields.remove(key);
                        needFields.add(model);
                    }
                });
            }
        } else {
            HashSet<WidgetTypes> ignores = new HashSet<WidgetTypes>(Arrays.asList(WidgetTypes.BUTTON, WidgetTypes.BUTTONS, WidgetTypes.GRID, WidgetTypes.CARD, WidgetTypes.TABS, WidgetTypes.TEXT, WidgetTypes.DIVIDER, WidgetTypes.BARCODE, WidgetTypes.TEXTAREA, WidgetTypes.MARKDOWN, WidgetTypes.EDITOR));
            AtomicInteger count = new AtomicInteger(0);
            org.jeecg.modules.online.desform.util.h.a(designForm, (WidgetTypes type, JSONObject item, JSONObject parent) -> {
                JSONObject options;
                String parentType;
                if (count.get() >= 50) {
                    return;
                }
                if (item.getBooleanValue("delFlag")) {
                    return;
                }
                if (this.a(type, item)) {
                    return;
                }
                if (ignores.contains((Object)type)) {
                    return;
                }
                String string = parentType = parent == null ? "" : parent.getString("type");
                if (WidgetTypes.SUB_TABLE_DESIGN.getType().equals(parentType)) {
                    return;
                }
                String key = item.getString("key");
                String model = item.getString("model");
                if (noNeedFields.contains(key) || noNeedFields.contains(model)) {
                    return;
                }
                if (WidgetTypes.LINK_FIELD == type && !"save".equals((options = item.getJSONObject("options")).getString("saveType"))) {
                    return;
                }
                if (oConvertUtils.isEmpty((Object)model)) {
                    return;
                }
                needFields.add(model);
                count.incrementAndGet();
            });
            if (!CollectionUtils.isEmpty(systemColumnList)) {
                for (BaseColumn baseColumn : systemColumnList) {
                    if (baseColumn.getShow() == null || !baseColumn.getShow().booleanValue()) continue;
                    needFields.add(baseColumn.getField());
                }
            }
        }
        if (oConvertUtils.isNotEmpty((Object)listViewModel.getTitleField())) {
            needFields.add(listViewModel.getTitleField());
        }
        if (!CollectionUtils.isEmpty(listViewModel.getOrderList())) {
            for (OrderItem orderItem : listViewModel.getOrderList()) {
                needFields.add(orderItem.getColumn());
            }
        }
        needFields.add("_id");
        needFields.add("create_by");
        needFields.add("create_time");
        needFields.add("update_by");
        needFields.add("update_time");
        needFields.add("bpm_status");
        needFields.add("x_oa_archive_status");
        return needFields;
    }

    private boolean a(WidgetTypes type, JSONObject widget) {
        if (WidgetTypes.LINK_RECORD == type) {
            return widget.getJSONObject("options").getBooleanValue("sourceIsDelete");
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result<?> addOne(DesignFormData designFormData, boolean isExternal) {
        Object xOaTimeoutDateObj;
        if (designFormData == null) {
            return Result.error((String)"designFormData \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String desformCode = designFormData.getDesformCode();
        if (StringUtil.isEmpty((String)desformCode)) {
            return Result.error((String)"\u5fc5\u987b\u4f20\u9012 desformCode \u53c2\u6570");
        }
        DesignForm designForm = this.a(desformCode);
        if (designForm == null) {
            return Result.error((String)("\u8868\u5355\u8bbe\u8ba1\u5668\uff08" + desformCode + "\uff09\u4e0d\u5b58\u5728"));
        }
        designFormData.setDesformId(designForm.getId());
        designFormData.setDesformCode(designForm.getDesformCode());
        designFormData.setDesformName(designForm.getDesformName());
        JSONObject designJson = JSON.parseObject((String)designForm.getDesformDesignJson());
        JSONArray designList = designJson.getJSONArray("list");
        JSONObject config = designJson.getJSONObject("config");
        if (designFormData.getxOaArchiveStatus() == null) {
            designFormData.setxOaArchiveStatus(org.jeecg.modules.online.desform.constant.b.aJ);
        }
        if (oConvertUtils.isNotEmpty((Object)(xOaTimeoutDateObj = designFormData.getDesformData().get((Object)"x_oa_timeout_date")))) {
            try {
                if (xOaTimeoutDateObj instanceof Long) {
                    designFormData.setxOaTimeoutDate(new Date((Long)xOaTimeoutDateObj));
                }
            }
            catch (Exception e2) {
                o.warn("\u8d85\u65f6\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u65e0\u6cd5\u8f6c\u6362\u6210\u65e5\u671f\u7c7b\u578b", (Throwable)e2);
            }
        }
        if (!super.a(designFormData)) {
            throw new JeecgBootException("\u4fdd\u5b58\u5173\u8054\u8bb0\u5f55\u7684\u4e34\u65f6\u6570\u636e\u5931\u8d25");
        }
        Map<WidgetTypes, List<JSONObject>> specialWidgets = org.jeecg.modules.online.desform.util.h.d(designList);
        super.a(desformCode, specialWidgets.get((Object)WidgetTypes.AUTO_NUMBER), designFormData);
        super.a(desformCode, specialWidgets, designFormData);
        super.b(desformCode, specialWidgets.get((Object)WidgetTypes.SUB_TABLE_DESIGN), designFormData);
        super.a(designFormData, org.jeecg.modules.online.desform.constant.b.aF);
        HttpMethod method = HttpMethod.POST;
        try {
            String onlineFormCode = config.getString("onlineForm");
            if (oConvertUtils.isNotEmpty((Object)onlineFormCode)) {
                designFormData.setOnlineFormCode(onlineFormCode);
                super.a(designFormData, designList, method);
            }
        }
        catch (Exception e3) {
            o.error("\u540c\u6b65\u4fdd\u5b58\u5230Online\u8868\u5355\u5931\u8d25", (Throwable)e3);
            throw new JeecgBootBizTipException("\u540c\u6b65\u4fdd\u5b58\u5230Online\u8868\u5355\u5931\u8d25\uff1a" + e3.getMessage());
        }
        if ("ONLINE-DATA-TEMP-ID".equals(designFormData.getId())) {
            return Result.OK((String)"\u6dfb\u52a0\u6210\u529f", (Object)designFormData.getId());
        }
        try {
            if (CommonConstant.DESIGN_FORM_TYPE_SUB.equals(designForm.getDesformType())) {
                designFormData.setDesformId(designForm.getParentId());
                designFormData.setDesformCode(designForm.getParentCode());
            } else {
                designFormData.setDesformId(designForm.getId());
            }
            designFormData.setDesformName(designForm.getDesformName());
            this.save(designFormData.getDesformCode(), designFormData);
            boolean transactional = config.getBooleanValue("transactional");
            boolean customUrlFail = this.a(designFormData, designForm, method, transactional);
            this.a(designFormData, designForm, designList, config, isExternal);
            this.a(desformCode, specialWidgets.get((Object)WidgetTypes.LINK_RECORD), designFormData, null, this.p);
            Objects.requireNonNull(this);
            super.a("ADD", desformCode, specialWidgets, designFormData, null);
            super.a(desformCode, designFormData);
            this.e.a(specialWidgets.get((Object)WidgetTypes.OA_SIGN_PATCH_SELECT), designFormData);
            super.a("add", designFormData, desformCode, designFormData.isTriggerProcess());
            JSONObject result = new JSONObject();
            result.put("dataId", (Object)designFormData.getId());
            result.put("customURLFail", (Object)customUrlFail);
            return Result.OK((String)"\u6dfb\u52a0\u6210\u529f\uff01", (Object)result);
        }
        catch (Exception e4) {
            o.error(e4.getMessage(), (Throwable)e4);
            throw new JeecgBootException("\u64cd\u4f5c\u5931\u8d25\uff1a" + e4.getMessage());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result<?> addOne(DesignFormData designFormData) {
        return this.addOne(designFormData, false);
    }

    private synchronized void a(String desformCode, List<JSONObject> widgets, DesignFormData designFormData, DesignFormData oldFormData, String actionType) {
        if (widgets == null || widgets.isEmpty()) {
            return;
        }
        boolean isDelete = this.q.equals(actionType);
        boolean isLogicDelete = this.r.equals(actionType);
        isDelete = isDelete || isLogicDelete;
        JSONObject newData = designFormData.getDesformData();
        JSONObject oldData = null;
        if (oldFormData != null) {
            oldData = oldFormData.getDesformData();
        }
        if (oldData == null) {
            oldData = newData;
        }
        for (JSONObject widget : widgets) {
            JSONObject options = widget.getJSONObject("options");
            String twoWayModel = options.getString("twoWayModel");
            if (oConvertUtils.isEmpty((Object)twoWayModel)) continue;
            String model = widget.getString("model");
            o.info("---\u81ea\u52a8\u66f4\u65b0\u53cc\u5411\u5173\u8054\u6570\u636e---\u5b57\u6bb5: desformCode={}\uff0ctwoWayModel={}\uff0c model={}", new Object[]{desformCode, twoWayModel, model});
            o.debug("---\u81ea\u52a8\u66f4\u65b0\u53cc\u5411\u5173\u8054\u6570\u636e---\u5b57\u6bb5: options={}", (Object)options);
            List<String> oldDataIds = this.b(oldData, model);
            List<String> newDataIds = this.b(newData, model);
            ArrayList<String> needToDeleteDataIds = new ArrayList<String>(oldDataIds);
            needToDeleteDataIds.removeAll(newDataIds);
            String sourceCode = options.getString("sourceCode");
            boolean isSubTable = widget.getBooleanValue("isSubTable");
            if (isSubTable && isDelete) {
                if (isLogicDelete) {
                    this.removeBatchLogicallyByIds(sourceCode, newDataIds);
                    continue;
                }
                this.removeBatchByIds(sourceCode, newDataIds);
                continue;
            }
            if (isSubTable && !needToDeleteDataIds.isEmpty()) {
                this.removeBatchLogicallyByIds(sourceCode, needToDeleteDataIds);
            }
            ArrayList<DesignFormData> updateDataList = new ArrayList<DesignFormData>();
            ArrayList<String> newAndOldDataIds = new ArrayList<String>();
            newAndOldDataIds.addAll(oldDataIds);
            newAndOldDataIds.addAll(newDataIds);
            List<DesignFormData> sourceDataList = this.getByIds(sourceCode, newAndOldDataIds);
            if (sourceDataList == null) continue;
            for (DesignFormData sourceData : sourceDataList) {
                Object idsObj = sourceData.getDesformData().get((Object)twoWayModel);
                JSONArray ids = idsObj instanceof List ? sourceData.getDesformData().getJSONArray(twoWayModel) : new JSONArray();
                if (!isDelete) {
                    String relationPrimaryTableForeignKey = "sys:cache:desform:relFieldOldVal::" + sourceCode + ":" + twoWayModel;
                    this.b.set(relationPrimaryTableForeignKey, oldDataIds, 1800L);
                    o.info("---\u81ea\u52a8\u66f4\u65b0\u53cc\u5411\u5173\u8054\u6570\u636e----Cache Relation PrimaryTable\uff0ckey={}\uff0coldDataIds={}", (Object)relationPrimaryTableForeignKey, (Object)ids);
                }
                if (ids.contains((Object)designFormData.getId())) {
                    if (isDelete) {
                        ids.remove((Object)designFormData.getId());
                    } else {
                        if (!needToDeleteDataIds.contains(sourceData.getId())) continue;
                        ids.remove((Object)designFormData.getId());
                    }
                } else {
                    if (isDelete) continue;
                    ids.add((Object)designFormData.getId());
                }
                sourceData.getDesformData().put(twoWayModel, (Object)ids);
                this.b(sourceData);
                updateDataList.add(sourceData);
            }
            if (updateDataList.isEmpty()) continue;
            this.updateBatchById(updateDataList);
        }
    }

    private List<String> b(JSONObject data, String model) {
        ArrayList<String> dataIds;
        Object dataIdArrayObj = data.get((Object)model);
        if (oConvertUtils.isEmpty((Object)dataIdArrayObj)) {
            return new ArrayList<String>();
        }
        if (dataIdArrayObj instanceof JSONArray) {
            JSONArray dataIdArray = data.getJSONArray(model);
            if (dataIdArray == null) {
                return new ArrayList<String>();
            }
            dataIds = dataIdArray.toJavaList(String.class);
        } else if (dataIdArrayObj instanceof List) {
            dataIds = new ArrayList((List)dataIdArrayObj);
        } else {
            dataIds = new ArrayList<String>();
            dataIds.add(dataIdArrayObj.toString());
        }
        return dataIds;
    }

    @Deprecated
    private synchronized void c(String desformCode, List<JSONObject> widgets, DesignFormData designFormData) {
        if (widgets == null || widgets.isEmpty()) {
            return;
        }
        JSONObject data = designFormData.getDesformData();
        for (JSONObject widget : widgets) {
            String model;
            JSONArray dataIdArray;
            JSONObject options = widget.getJSONObject("options");
            String twoWayModel = options.getString("twoWayModel");
            if (oConvertUtils.isEmpty((Object)twoWayModel) || (dataIdArray = data.getJSONArray(model = widget.getString("model"))) == null || dataIdArray.isEmpty()) continue;
            String sourceCode = options.getString("sourceCode");
            List dataIds = dataIdArray.toJavaList(String.class);
            boolean isSubTable = widget.getBooleanValue("isSubTable");
            if (isSubTable) {
                this.restoreData(sourceCode, dataIds);
                continue;
            }
            List<DesignFormData> sourceDataList = this.getByIds(sourceCode, dataIds);
            ArrayList<DesignFormData> updateDataList = new ArrayList<DesignFormData>();
            for (DesignFormData sourceData : sourceDataList) {
                Object idsObj = sourceData.getDesformData().get((Object)twoWayModel);
                JSONArray ids = idsObj instanceof List ? sourceData.getDesformData().getJSONArray(twoWayModel) : new JSONArray();
                if (ids.contains((Object)designFormData.getId())) continue;
                ids.add((Object)designFormData.getId());
                JSONObject newData = new JSONObject();
                newData.put(twoWayModel, (Object)ids);
                DesignFormData updateData = new DesignFormData(sourceCode, newData);
                updateData.setId(sourceData.getId());
                updateDataList.add(updateData);
            }
            if (updateDataList.isEmpty()) continue;
            this.updateBatchById(updateDataList);
        }
    }

    private void a(DesignFormData designFormData, DesignForm designForm, JSONArray designList, JSONObject config, boolean isExternal) {
        org.jeecg.modules.online.desform.util.h.a(() -> {
            try {
                String formLink;
                String moreLink;
                boolean enableNotice;
                if (oConvertUtils.isNotEmpty((Object)designForm.getTenantId())) {
                    TenantContext.setTenant((String)designForm.getTenantId().toString());
                }
                if (!(enableNotice = config.getBooleanValue("enableNotice"))) {
                    return;
                }
                String noticeMode = config.getString("noticeMode");
                if ("external".equals(noticeMode) && !isExternal) {
                    return;
                }
                String lowAppId = designForm.getLowAppId();
                boolean isLowApp = oConvertUtils.isNotEmpty((Object)lowAppId) && MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL != false;
                String noticeType = config.getString("noticeType");
                Object noticeReceiverObject = config.get((Object)"noticeReceiver");
                String noticeReceiver = noticeReceiverObject instanceof List ? String.join((CharSequence)",", config.getJSONArray("noticeReceiver").toJavaList(String.class)) : config.getString("noticeReceiver");
                MessageDTO md = new MessageDTO();
                md.setToAll(Boolean.valueOf(false));
                md.setTitle("[" + designForm.getDesformName() + "]\u65b0\u589e\u4e86\u4e00\u6761\u6570\u636e");
                md.setToUser(noticeReceiver);
                String domainUrl = this.a.getDomainUrl().getPc();
                if (isLowApp) {
                    String menuType;
                    String menuUrl;
                    JSONObject menu = this.lowAppBaseApi.getLowAppMenuByDesformIdOrCode(lowAppId, designForm.getId(), designForm.getDesformCode());
                    String formType = "form";
                    if (menu != null) {
                        menuUrl = menu.getString("menuUrl");
                        menuType = menu.getString("type");
                    } else {
                        menuUrl = designForm.getId();
                        menuType = "form";
                    }
                    String linkAfter = formType.equals(menuType) ? "/form/" + menuUrl : "/desform/" + menuUrl;
                    moreLink = domainUrl + "/myapp/" + lowAppId + linkAfter;
                    formLink = (String)moreLink + "?open=" + designForm.getDesformCode();
                } else {
                    formLink = domainUrl + "/online/desform?open=" + designForm.getDesformCode();
                    moreLink = domainUrl + "/online/desform/list/" + designForm.getDesformCode();
                }
                HashMap<String, Object> data = new HashMap<String, Object>();
                try {
                    LoginUser createUser = this.c.getUserByName(designForm.getCreateBy());
                    if (createUser != null) {
                        data.put("userName", createUser.getRealname());
                    } else {
                        data.put("userName", designForm.getCreateBy());
                    }
                }
                catch (Exception e2) {
                    o.error(e2.getMessage(), (Throwable)e2);
                    data.put("userName", designForm.getCreateBy());
                }
                data.put("formLink", formLink);
                data.put("formName", designForm.getDesformName());
                data.put("moreLink", moreLink);
                data.put("createTime", ((SimpleDateFormat)DateUtils.datetimeFormat.get()).format(designFormData.getCreateTime()));
                StringBuffer dataMarkdown = new StringBuffer();
                this.d.a(designForm, designFormData);
                JSONObject dataJson = JSONObject.parseObject((String)designFormData.getDesformDataJson());
                org.jeecg.modules.online.desform.util.h.a(designList, (WidgetTypes type, JSONObject item, JSONObject parent) -> {
                    JSONArray dataArray;
                    List list;
                    DesformWidget widget = DesformWidget.parse(item);
                    if (type == WidgetTypes.SELECT_USER || type == WidgetTypes.SELECT_DEPART || type == WidgetTypes.ORG_ROLE) {
                        return;
                    }
                    String dictModel = widget.getModel() + "_dictText";
                    String dictValue = dataJson.getString(dictModel);
                    Object dataValue = oConvertUtils.isNotEmpty((Object)dictValue) ? dictValue : dataJson.get((Object)widget.getModel());
                    if (dataValue instanceof List && (list = (List)dataValue).isEmpty()) {
                        dataValue = "";
                    }
                    if (type == WidgetTypes.LINK_RECORD && (dataArray = dataJson.getJSONArray(widget.getModel())) != null && !dataArray.isEmpty()) {
                        String sourceCode = widget.getOptions().getSourceCode();
                        String titleField = widget.getOptions().getTitleField();
                        List<DesignFormData> designDataList = this.getByIds(sourceCode, dataArray.toJavaList(String.class));
                        ArrayList<String> resultData = new ArrayList<String>();
                        for (DesignFormData designData : designDataList) {
                            JSONObject desformData = designData.getDesformData();
                            resultData.add(desformData.getString(titleField));
                        }
                        dataValue = String.join((CharSequence)",", resultData);
                    }
                    if (dataValue instanceof List) {
                        list = (List)dataValue;
                        dataValue = list.isEmpty() ? "" : list.stream().map(String::valueOf).collect(Collectors.joining(","));
                    }
                    if (oConvertUtils.isNotEmpty((Object)dataValue)) {
                        dataMarkdown.append("> **").append(widget.getName()).append("\uff1a**\n> ").append(dataValue).append("\n> \n");
                    }
                });
                data.put("dataMarkdown", dataMarkdown.toString());
                md.setData(data);
                md.setFromUser("system");
                md.setTemplateCode("desform_notice_write");
                this.a(noticeType, md);
            }
            catch (Exception e3) {
                o.error(e3.getMessage(), (Throwable)e3);
            }
        });
    }

    private void a(String noticeType, MessageDTO md) {
        String[] types;
        for (String type : types = noticeType.split(",")) {
            MessageTypeEnum messageType = MessageTypeEnum.valueOfType((String)type);
            if (messageType == null) continue;
            md.setType(messageType.getType());
            this.c.sendTemplateMessage(md);
        }
    }

    private boolean a(DesignFormData designFormData, DesignForm designForm, HttpMethod method, boolean transactional) {
        Object url;
        boolean customUrlFail = false;
        JSONObject designJson = JSON.parseObject((String)designForm.getDesformDesignJson());
        JSONArray curl = designJson.getJSONObject("config").getJSONArray("customRequestURL");
        if (curl != null && curl.size() > 0 && oConvertUtils.isNotEmpty((Object)(url = curl.getJSONObject(0).getString("url")))) {
            url = ((String)url).trim();
            o.info("\u63d0\u4ea4\u5230\u7528\u6237\u81ea\u5b9a\u4e49url:" + (String)url);
            String regexp = "^https?:/{2}";
            if (!Pattern.matches(regexp, (CharSequence)url)) {
                url = RestUtil.getBaseUrl() + (String)url;
            }
            JSONObject formData = JSON.parseObject((String)JSON.toJSONString((Object)designFormData));
            formData.put("dataId", (Object)designFormData.getId());
            HttpHeaders headers = new HttpHeaders();
            String mediaType = "application/json";
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.set("Accept", mediaType);
            HttpServletRequest request = SpringContextUtils.getHttpServletRequest();
            String token = request.getHeader("X-Access-Token");
            headers.set("X-Access-Token", token);
            ResponseEntity response = RestUtil.request((String)url, (HttpMethod)method, (HttpHeaders)headers, null, (Object)formData, JSONObject.class);
            if (HttpStatus.OK == response.getStatusCode()) {
                JSONObject res = (JSONObject)response.getBody();
                String success = "success";
                if (res == null || !res.getBooleanValue(success)) {
                    String resMessage;
                    Object message = "";
                    if (res != null && oConvertUtils.isNotEmpty((Object)(resMessage = res.getString("message")))) {
                        message = ":" + resMessage;
                    }
                    o.error("\u540c\u6b65\u4fdd\u5b58\u5230\u7528\u6237\u81ea\u5b9a\u4e49URL\u5931\u8d25\uff1a" + response.toString());
                    if (transactional) {
                        throw new JeecgBootException("\u4fdd\u5b58\u5230\u81ea\u5b9a\u4e49URL\u5931\u8d25" + (String)message);
                    }
                    customUrlFail = true;
                }
            } else {
                o.error("\u540c\u6b65\u4fdd\u5b58\u5230\u7528\u6237\u81ea\u5b9a\u4e49URL\u5931\u8d25\uff1a" + response.toString());
                if (transactional) {
                    throw new JeecgBootException("\u540c\u6b65\u4fdd\u5b58\u5230\u7528\u6237\u81ea\u5b9a\u4e49URL\u5931\u8d25");
                }
                customUrlFail = true;
            }
        }
        return customUrlFail;
    }

    @Transactional(rollbackFor={Exception.class})
    public Result<?> editOne(DesignFormData designFormData) {
        String desformCode = designFormData.getDesformCode();
        if (StringUtil.isEmpty((String)desformCode)) {
            return Result.error((String)"\u5fc5\u987b\u4f20\u9012 desformCode \u53c2\u6570");
        }
        DesignForm designForm = this.a(desformCode);
        if (designForm == null) {
            return Result.error((String)("\u8868\u5355\u8bbe\u8ba1\u5668\uff08" + desformCode + "\uff09\u4e0d\u5b58\u5728"));
        }
        designFormData.setDesformId(designForm.getId());
        designFormData.setDesformCode(designForm.getDesformCode());
        designFormData.setDesformName(designForm.getDesformName());
        if (org.jeecg.modules.online.desform.constant.b.e.equals(designForm.getDesformType())) {
            desformCode = designForm.getParentCode();
        }
        JSONObject desformData = designFormData.getDesformData();
        JSONObject designJson = JSON.parseObject((String)designForm.getDesformDesignJson());
        JSONArray dataList = designJson.getJSONArray("list");
        String uniqueMessage = super.a(desformCode, dataList, desformData);
        if (oConvertUtils.isNotEmpty((Object)uniqueMessage)) {
            return Result.error((String)uniqueMessage);
        }
        Object xOaTimeoutDateObj = designFormData.getDesformData().get((Object)"x_oa_timeout_date");
        boolean removeXOaTimeoutDate = oConvertUtils.isEmpty((Object)xOaTimeoutDateObj);
        if (!removeXOaTimeoutDate) {
            try {
                if (xOaTimeoutDateObj instanceof Long) {
                    designFormData.setxOaTimeoutDate(new Date((Long)xOaTimeoutDateObj));
                }
            }
            catch (Exception e2) {
                o.warn("\u8d85\u65f6\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u65e0\u6cd5\u8f6c\u6362\u6210\u65e5\u671f\u7c7b\u578b", (Throwable)e2);
            }
        } else {
            designFormData.setxOaTimeoutDate(null);
        }
        if (!super.a(designFormData)) {
            throw new JeecgBootException("\u4fdd\u5b58\u5173\u8054\u8bb0\u5f55\u7684\u4e34\u65f6\u6570\u636e\u5931\u8d25");
        }
        desformData = designFormData.getDesformData();
        DesignFormData oldFormData = this.getById(desformCode, designFormData.getId());
        if (oldFormData == null) {
            return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e!");
        }
        ArrayList<String> removeKeys = new ArrayList<String>();
        ArrayList dataKeys = new ArrayList(desformData.keySet());
        for (String key : dataKeys) {
            if (!key.endsWith("_dictText") && !key.endsWith("_dictColor")) continue;
            desformData.remove((Object)key);
            removeKeys.add(key);
        }
        designFormData.setDesformDataJson(desformData.toJSONString());
        boolean isPartEdit = desformData.getBooleanValue("__CFG_PART_EDIT");
        if (!isPartEdit) {
            HashSet allKeys = new HashSet();
            allKeys.addAll(desformData.keySet());
            allKeys.addAll(oldFormData.getDesformData().keySet());
            for (String key : allKeys) {
                if (org.jeecg.modules.online.desform.constant.c.y.contains(key) || removeKeys.contains(key)) continue;
                Object newValue = desformData.get((Object)key);
                Object oldValue = oldFormData.getDesformData().get((Object)key);
                if (newValue != null || oldValue == null) continue;
                removeKeys.add(key);
            }
            if (removeXOaTimeoutDate) {
                removeKeys.add("x_oa_timeout_date");
            }
        } else {
            removeKeys.add("__CFG_PART_EDIT");
        }
        HttpMethod method = HttpMethod.PUT;
        try {
            if (oConvertUtils.isNotEmpty((Object)oldFormData.getOnlineFormCode())) {
                designFormData.setOnlineFormCode(oldFormData.getOnlineFormCode());
                designFormData.setOnlineFormDataId(oldFormData.getOnlineFormDataId());
                super.a(designFormData, dataList, method);
            }
        }
        catch (Exception e3) {
            o.error("\u540c\u6b65\u66f4\u65b0\u5230Online\u8868\u5355\u5931\u8d25", (Throwable)e3);
            throw new JeecgBootBizTipException("\u540c\u6b65\u66f4\u65b0\u5230Online\u8868\u5355\u5931\u8d25\uff1a" + e3.getMessage());
        }
        if ("ONLINE-DATA-TEMP-ID".equals(designFormData.getId())) {
            return Result.OK((String)"\u6dfb\u52a0\u6210\u529f", (Object)designFormData.getId());
        }
        JSONObject config = designJson.getJSONObject("config");
        Map<WidgetTypes, List<JSONObject>> specialWidgets = org.jeecg.modules.online.desform.util.h.d(dataList);
        super.b(desformCode, specialWidgets.get((Object)WidgetTypes.SUB_TABLE_DESIGN), designFormData);
        designFormData.setDesformId(null);
        designFormData.setDesformCode(null);
        this.dataMongoCurdService.update(desformCode, designFormData);
        if (removeKeys.size() > 0) {
            this.dataMongoCurdService.removeField(desformCode, designFormData.getId(), removeKeys.toArray(new String[0]));
        }
        boolean transactional = config.getBooleanValue("transactional");
        boolean customUrlFail = this.a(designFormData, designForm, method, transactional);
        this.a(desformCode, specialWidgets.get((Object)WidgetTypes.LINK_RECORD), designFormData, oldFormData, this.p);
        super.a(this.p, desformCode, specialWidgets, designFormData, oldFormData);
        super.a(designForm, oldFormData, designFormData);
        super.b(designForm, oldFormData, designFormData);
        super.a("update", oldFormData, desformCode, designFormData.isTriggerProcess());
        JSONObject result = new JSONObject();
        result.put("dataId", (Object)designFormData.getId());
        result.put("customURLFail", (Object)customUrlFail);
        return Result.OK((String)"\u4fee\u6539\u6210\u529f\uff01", (Object)result);
    }

    @Override
    protected boolean a(String desformCode, Collection<String> dataIds) {
        return this.dataMongoCurdService.deleteBatch(desformCode, dataIds);
    }

    public Result<?> deleteOne(DesignFormData designFormData) {
        String desformCode = designFormData.getDesformCode();
        if (oConvertUtils.isEmpty((Object)desformCode)) {
            throw new JeecgBootException("\u5fc5\u987b\u4f20\u9012 desformCode");
        }
        DesignForm designForm = this.a(desformCode);
        if (designForm == null) {
            return Result.error((String)("\u8868\u5355\u8bbe\u8ba1\u5668\uff08" + desformCode + "\uff09\u4e0d\u5b58\u5728"));
        }
        if ((designFormData = this.getById(desformCode, designFormData.getId())) == null) {
            return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        }
        this.dataMongoCurdService.delete(designFormData.getDesformCode(), designFormData.getId());
        this.c(designFormData);
        JSONObject designJson = JSON.parseObject((String)designForm.getDesformDesignJson());
        JSONArray designList = designJson.getJSONArray("list");
        Map<WidgetTypes, List<JSONObject>> specialWidgets = org.jeecg.modules.online.desform.util.h.d(designList);
        this.a(desformCode, specialWidgets.get((Object)WidgetTypes.LINK_RECORD), designFormData, null, this.q);
        super.b(designForm, designFormData, null);
        this.e.b(specialWidgets.get((Object)WidgetTypes.OA_SIGN_PATCH_SELECT), designFormData);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @Override
    public boolean removeBatchByIds(String desformCode, List<String> idList) {
        DesignForm designForm = this.a(desformCode);
        if (designForm == null) {
            throw new JeecgBootException("\u8868\u5355\u8bbe\u8ba1\u5668\uff08" + desformCode + "\uff09\u4e0d\u5b58\u5728");
        }
        JSONObject designJson = JSON.parseObject((String)designForm.getDesformDesignJson());
        JSONArray designList = designJson.getJSONArray("list");
        Map<WidgetTypes, List<JSONObject>> specialWidgets = org.jeecg.modules.online.desform.util.h.d(designList);
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").in(idList));
        List findList = this.mongoTemplate.find(query, Document.class, desformCode);
        for (Document document : findList) {
            DesignFormData designFormData = new DesignFormData(desformCode, document);
            this.dataMongoCurdService.delete(desformCode, designFormData.getId());
            this.c(designFormData);
            this.a(desformCode, specialWidgets.get((Object)WidgetTypes.LINK_RECORD), designFormData, null, this.q);
            super.b(designForm, designFormData, null);
            this.e.b(specialWidgets.get((Object)WidgetTypes.OA_SIGN_PATCH_SELECT), designFormData);
        }
        return true;
    }

    @Override
    public DesignFormData getByOnlineDataId(String desformCode, String onlineDataId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"online_form_id").is((Object)onlineDataId));
        Document document = (Document)this.mongoTemplate.findOne(query, Document.class, desformCode);
        if (document == null) {
            return null;
        }
        return new DesignFormData(desformCode, document);
    }

    private void c(DesignFormData designFormData) {
        String onlineFormCode = designFormData.getOnlineFormCode();
        String onlineDataId = designFormData.getOnlineFormDataId();
        if (StringUtil.isNotBlank((String)onlineFormCode) && StringUtil.isNotBlank((String)onlineDataId)) {
            try {
                this.g.cgformDeleteDataByCode(onlineFormCode, onlineDataId);
            }
            catch (Exception e2) {
                o.error(e2.getMessage(), (Throwable)e2);
            }
        }
    }

    @Override
    public JSONObject queryJmReportDataById(IdOrCodeParam idOrCode, String id) throws Exception {
        return super.queryJmReportDataById(idOrCode, id);
    }

    @Override
    public Page<JSONObject> queryJmReportDataList(String desformCode, int pageNo, int pageSize) {
        return super.queryJmReportDataList(desformCode, pageNo, pageSize);
    }

    @Override
    public List<JSONObject> queryJmReportSubDataById(IdOrCodeParam idOrCode, String id, String subCode) throws Exception {
        if (oConvertUtils.isEmpty((Object)subCode)) {
            throw new JeecgBootBizTipException("\u53c2\u6570subCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (oConvertUtils.isEmpty((Object)id)) {
            throw new JeecgBootBizTipException("\u53c2\u6570id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DesignForm designForm = this.f.getByIdOrCode(idOrCode);
        if (designForm == null) {
            throw new JeecgBootException("\u8868\u5355 id=[" + idOrCode.getValue() + "]\u4e0d\u5b58\u5728!");
        }
        DesignFormData designFormData = this.getById(designForm.getDesformCode(), id);
        if (designFormData == null) {
            throw new JeecgBootException("\u8868\u5355\u6570\u636e data id=[" + id + "]\u4e0d\u5b58\u5728!");
        }
        ArrayList<JSONObject> dataList = new ArrayList<JSONObject>();
        DesignForm subForm = this.f.getByCode(subCode);
        if (subForm == null) {
            subForm = this.f.getByIdCache(subCode);
        }
        if (subForm == null) {
            JSONObject subWidget = new JSONObject();
            org.jeecg.modules.online.desform.util.h.a(designForm, (WidgetTypes type, JSONObject item, JSONObject parent) -> {
                String model = item.getString("model");
                if (subCode.equals(model)) {
                    subWidget.putAll((Map)item);
                }
            });
            if (subWidget.isEmpty()) {
                throw new JeecgBootException("\u5b50\u8868[" + subCode + "]\u4e0d\u5b58\u5728");
            }
            String model = subWidget.getString("model");
            org.jeecg.modules.online.desform.d.b.a translConfig = new org.jeecg.modules.online.desform.d.b.a();
            translConfig.setFileUploadOnlyName(true);
            translConfig.a(model);
            this.d.a(designForm, designFormData, translConfig);
            JSONArray subDataList = designFormData.getDesformData().getJSONArray(model);
            if (subDataList == null || subDataList.isEmpty()) {
                return new ArrayList<JSONObject>();
            }
            DesformWidgetList widgetList = org.jeecg.modules.online.desform.util.h.e(designForm);
            if (widgetList != null) {
                ArrayList<Map<String, Object>> dataListMap = new ArrayList<Map<String, Object>>(subDataList.toJavaList(JSONObject.class));
                org.jeecg.modules.online.desform.b.a.b.a(1, dataListMap, widgetList.sub.get(model));
                dataList.addAll(dataListMap.stream().map(JSONObject::new).collect(Collectors.toList()));
                for (JSONObject data : dataList) {
                    super.a(data, widgetList.sub.get(model), true);
                }
            } else {
                dataList.addAll(subDataList.toJavaList(JSONObject.class));
            }
        } else {
            JSONObject fined = new JSONObject();
            ArrayList subIds = new ArrayList();
            String subDesformCode = subForm.getDesformCode();
            org.jeecg.modules.online.desform.util.h.a(designForm, (WidgetTypes type, JSONObject item, JSONObject parent) -> {
                JSONObject options = item.getJSONObject("options");
                String sourceCode = options.getString("sourceCode");
                if (subDesformCode.equals(sourceCode)) {
                    fined.put("fined", (Object)true);
                    JSONArray value = designFormData.getDesformData().getJSONArray(item.getString("model"));
                    if (value != null && !value.isEmpty()) {
                        subIds.addAll(value.toJavaList(String.class));
                    }
                }
            });
            if (fined.isEmpty()) {
                throw new JeecgBootException("\u5b50\u8868[" + subCode + "]\u4e0d\u5b58\u5728");
            }
            if (subIds.isEmpty()) {
                return new ArrayList<JSONObject>();
            }
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(subIds));
            List<DesignFormData> subDataList = this.a(subDesformCode, query);
            if (subDataList == null || subDataList.isEmpty()) {
                return new ArrayList<JSONObject>();
            }
            org.jeecg.modules.online.desform.d.b.a translConfig = new org.jeecg.modules.online.desform.d.b.a();
            translConfig.setFileUploadOnlyName(true);
            this.d.a(subForm, subDataList, translConfig);
            DesformWidgetList widgetList = org.jeecg.modules.online.desform.util.h.e(subForm);
            if (widgetList != null) {
                ArrayList<Map<String, Object>> dataListMap = new ArrayList<Map<String, Object>>();
                subDataList.forEach(item -> dataListMap.add((Map<String, Object>)item.getDesformData()));
                org.jeecg.modules.online.desform.b.a.b.a(1, dataListMap, widgetList.main);
                dataList.addAll(dataListMap.stream().map(JSONObject::new).collect(Collectors.toList()));
                for (JSONObject data : dataList) {
                    super.a(data, widgetList.main, true);
                }
            } else {
                subDataList.forEach(item -> dataList.add(item.getDesformData()));
            }
        }
        return dataList;
    }

    private boolean b(List<DesformWidget> widgetList, String key) {
        for (DesformWidget widget : widgetList) {
            if (!widget.getModel().equals(key)) continue;
            return true;
        }
        return false;
    }

    private DesignForm a(String desformCode) {
        return this.f.getByCode(desformCode);
    }

    @Override
    public List<DesignFormData> queryByCode(String desformCode) {
        return this.a(desformCode, new Query());
    }

    @Override
    public List<JSONObject> listFieldById(String desformCode, String id, String fieldKeys, DesformSuperQuery superQuery) {
        DesignForm designForm = this.f.getByCode(desformCode);
        if (designForm == null) {
            throw new JeecgBootException("\u8868\u5355\u4e0d\u5b58\u5728", CommonConstant.SC_INTERNAL_NOT_FOUND_404.intValue());
        }
        if (superQuery == null) {
            superQuery = new DesformSuperQuery();
        }
        HashSet<String> idSet = new HashSet<String>(Arrays.asList(id.split(",")));
        String[] fields = null;
        if (oConvertUtils.isNotEmpty((Object)fieldKeys)) {
            fields = fieldKeys.split(",");
        }
        superQuery.add(new SuperQueryItem("string", "_id", id, QueryRuleEnum.IN));
        List<DesignFormData> list = this.list(desformCode, superQuery);
        ArrayList<DesignFormData> newList = new ArrayList<DesignFormData>();
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        for (DesignFormData data : list) {
            JSONObject desformData;
            DesignFormData newData = new DesignFormData();
            newData.setId(data.getId());
            if (fields != null) {
                desformData = new JSONObject();
                for (String field : fields) {
                    desformData.put(field, data.getDesformData().get((Object)field));
                }
            } else {
                desformData = data.getDesformData();
            }
            newData.setDesformData(desformData);
            newList.add(newData);
            desformData.put("id", (Object)data.getId());
            result.add(desformData);
            idSet.remove(data.getId());
        }
        for (String tempId : idSet) {
            JSONObject record = new JSONObject();
            record.put("id", (Object)tempId);
            result.add(record);
        }
        this.d.a(designForm, newList);
        return result;
    }

    @Override
    public Page<DesignFormData> a(Page<DesignFormData> page, String desformCode) {
        return this.a(page, desformCode, new Query());
    }

    @Override
    public Page<DesignFormData> page(Page<DesignFormData> page, String desformCode, DesformSuperQuery superQuery) {
        Query query = DesformQueryUtils.fillMongoQuery(superQuery);
        return this.a(page, desformCode, query);
    }

    private Page<DesignFormData> a(Page<DesignFormData> page, String desformCode, Query query) {
        int pageNo = (int)page.getCurrent();
        int pageSize = (int)page.getSize();
        long skip = (long)(pageNo - 1) * (long)pageSize;
        if (query == null) {
            query = new Query();
        }
        long count = this.mongoTemplate.count(query, desformCode);
        page.setTotal(count);
        query.skip(skip).limit(pageSize);
        DesformQueryUtils.a(page.orders(), query);
        o.debug("mongodb \u67e5\u8be2\u6761\u4ef6\uff0cdesformCode\uff1a{}\uff0cquery\uff1a{}", (Object)desformCode, (Object)query);
        List pageList = this.mongoTemplate.find(query, Document.class, desformCode);
        o.debug("mongodb \u67e5\u8be2\u7ed3\u679c\uff1a pageList size:" + pageList.size());
        o.debug("mongodb \u67e5\u8be2\u7ed3\u679c\uff1a pageList :" + pageList.toString());
        List records = pageList.stream().map(document -> new DesignFormData(desformCode, (Document)document)).collect(Collectors.toList());
        page.setRecords(records);
        return page;
    }

    private Page<DesignFormData> a(Page<DesignFormData> page, String desformCode, List<AggregationOperation> operations, Query query) {
        List<AggregationOperation> sortOperations;
        if (CollectionUtils.isEmpty(operations)) {
            operations = new ArrayList<AggregationOperation>();
        }
        if (!CollectionUtils.isEmpty(sortOperations = DesformQueryUtils.b(page.orders()))) {
            operations.addAll(sortOperations);
        }
        int pageNo = (int)page.getCurrent();
        int pageSize = (int)page.getSize();
        if (pageNo == 0) {
            pageNo = 1;
        }
        if (pageSize == 0) {
            pageSize = 10;
        }
        long skip = (long)(pageNo - 1) * (long)pageSize;
        operations.add((AggregationOperation)Aggregation.skip((long)skip));
        operations.add((AggregationOperation)Aggregation.limit((long)pageSize));
        Aggregation agg = Aggregation.newAggregation(operations);
        List pageList = this.mongoTemplate.aggregate(agg, desformCode, Document.class).getMappedResults();
        if (query == null) {
            query = new Query();
        }
        long count = this.mongoTemplate.count(query, desformCode);
        page.setTotal(count);
        o.debug("mongodb \u67e5\u8be2\u7ed3\u679c\uff1a pageList size: {} count: {}", (Object)pageList.size(), (Object)count);
        List records = pageList.stream().map(document -> new DesignFormData(desformCode, (Document)document)).collect(Collectors.toList());
        page.setRecords(records);
        return page;
    }

    private Object a(String desformCode, DesformOperationEnum operationType, String operationField, Criteria groupCriteria) {
        String valueKey = "value";
        GroupOperation groupOperation = null;
        switch (operationType) {
            case COUNT: {
                Query query = new Query();
                if (groupCriteria != null) {
                    query.addCriteria((CriteriaDefinition)groupCriteria);
                }
                return this.mongoTemplate.count(query, desformCode);
            }
            case MAX: {
                groupOperation = Aggregation.group((String[])new String[0]).max(operationField).as(valueKey);
                break;
            }
            case MIN: {
                groupOperation = Aggregation.group((String[])new String[0]).min(operationField).as(valueKey);
                break;
            }
            case AVG: {
                groupOperation = Aggregation.group((String[])new String[0]).avg(operationField).as(valueKey);
                break;
            }
            case SUM: {
                groupOperation = Aggregation.group((String[])new String[0]).sum(operationField).as(valueKey);
            }
        }
        if (groupOperation != null) {
            MatchOperation match = Aggregation.match((Criteria)groupCriteria);
            Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{match, groupOperation});
            AggregationResults result = this.mongoTemplate.aggregate(agg, desformCode, Document.class);
            if (result.getUniqueMappedResult() != null) {
                return ((Document)result.getUniqueMappedResult()).get((Object)valueKey);
            }
        }
        return null;
    }

    @Override
    public List<Map<String, Object>> getExportDataPage(String username, DesignForm designForm, DesformSuperQuery superQuery, int pageNo, int pageSize, ListViewModel listViewModel) {
        List<OrderItem> orderList;
        Query query = this.designFormListViewService.getQuery(username, designForm, superQuery, listViewModel);
        if (query == null) {
            query = new Query();
        }
        if (CollectionUtils.isEmpty(orderList = listViewModel.getOrderList())) {
            orderList = new ArrayList<OrderItem>();
            orderList.add(OrderItem.desc((String)"create_time"));
        }
        DesformQueryUtils.a(orderList, query);
        long skip = (long)(pageNo - 1) * (long)pageSize;
        query.skip(skip).limit(pageSize);
        String desformCode = designForm.getDesformCode();
        List<DesignFormData> dataList = this.mongoTemplate.find(query, Document.class, desformCode).stream().map(document -> new DesignFormData(desformCode, (Document)document)).collect(Collectors.toList());
        this.queryLinkFieldData(designForm, dataList);
        return dataList.stream().map(DesignFormData::getDesformData).collect(Collectors.toList());
    }

    @Override
    public DesignFormData getById(String desformCode, String id) {
        if (oConvertUtils.isEmpty((Object)id)) {
            o.warn("Id must not be null!");
            return null;
        }
        Document document = (Document)this.mongoTemplate.findById((Object)id, Document.class, desformCode);
        if (document == null) {
            return null;
        }
        o.debug(" mongodb \u67e5\u8be2\u5355\u6761\u6570\u636e\uff1a getById jsonData :" + document.toString());
        return new DesignFormData(desformCode, document);
    }

    @Override
    public JSONObject getFieldDataById(String desformCode, String dataId, Collection<String> fieldNames) {
        AssertUtils.assertNotEmpty((String)"desformCode \u4e0d\u80fd\u4e3a\u7a7a", (Object)desformCode);
        AssertUtils.assertNotEmpty((String)"dataId \u4e0d\u80fd\u4e3a\u7a7a", (Object)dataId);
        DesignFormData formData = null;
        if (CollectionUtils.isEmpty(fieldNames)) {
            formData = this.getById(desformCode, dataId);
        } else {
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)dataId));
            HashSet<String> fieldSet = new HashSet<String>(fieldNames);
            fieldSet.add("_id");
            query.fields().include(fieldSet);
            Document document = (Document)this.mongoTemplate.findOne(query, Document.class, desformCode);
            if (document != null) {
                formData = new DesignFormData(desformCode, document);
            }
        }
        if (formData != null) {
            return formData.getDesformData();
        }
        return null;
    }

    @Override
    public DesignFormData getDataWithDictText(String desformCode, String id) {
        if (oConvertUtils.isEmpty((Object)id)) {
            o.warn("Id must not be null!");
            return null;
        }
        DesignForm designForm = this.f.getByCode(desformCode);
        if (designForm == null) {
            return null;
        }
        Document document = (Document)this.mongoTemplate.findById((Object)id, Document.class, desformCode);
        if (document == null) {
            return null;
        }
        o.debug(" mongodb \u67e5\u8be2\u5355\u6761\u6570\u636e\uff1a getDataWithDictText jsonData :" + document.toString());
        DesignFormData data = new DesignFormData(desformCode, document);
        this.d.a(designForm, data);
        return data;
    }

    @Override
    public List<DesignFormData> getByIds(String desformCode, Collection<String> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            o.warn("IdList must not be null!");
            return null;
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").in(idList));
        List dataList = this.mongoTemplate.find(query, Document.class, desformCode);
        return dataList.stream().map(document -> new DesignFormData(desformCode, (Document)document)).collect(Collectors.toList());
    }

    @Override
    protected List<JSONObject> a(String desformCode, List<String> ids) {
        Query linkRecordQuery = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(ids));
        return this.mongoTemplate.find(linkRecordQuery, JSONObject.class, desformCode);
    }

    @Override
    public boolean save(String desformCode, DesignFormData entity) {
        return this.dataMongoCurdService.save(desformCode, entity);
    }

    @Override
    public boolean saveBatch(String desformCode, Collection<DesignFormData> entityList) {
        boolean flag;
        boolean bl = flag = this.dataMongoCurdService.saveBatch(desformCode, entityList) > 0;
        if (flag) {
            for (DesignFormData data : entityList) {
                try {
                    if (!data.isTriggerProcess() || this.h == null) continue;
                    o.info(" \u6279\u91cf\u89e6\u53d1\u7b80\u6d41\u4e8b\u4ef6 formKey={}\uff0caction={},data={}", new Object[]{desformCode, "add", data});
                    this.h.signalStartProcess("add", data.getId(), null, desformCode, data.getCreateBy());
                }
                catch (NoSuchBeanDefinitionException e2) {
                    o.warn("\u4f4e\u4ee3\u7801\u6a21\u5f0f\u65e0\u7b80\u6d41\u6a21\u5757\uff0c\u4e0d\u652f\u6301\u89e6\u53d1\u6d41\u7a0b\u4fe1\u53f7\uff01");
                }
                catch (RuntimeException e3) {
                    if (e3.getClass().getName().contains("feign.FeignException") || oConvertUtils.isNotEmpty((Object)e3.getMessage()) && e3.getMessage().toLowerCase().contains("feign")) {
                        o.warn("\u4f4e\u4ee3\u7801\u6a21\u5f0f\u65e0\u7b80\u6d41\u5fae\u670d\u52a1\uff0c\u4e0d\u652f\u6301\u89e6\u53d1\u6d41\u7a0b\u4fe1\u53f7\uff01");
                        continue;
                    }
                    throw e3;
                }
            }
        }
        return flag;
    }

    @Override
    public boolean updateById(DesignFormData entity) {
        String desformCode = entity.getDesformCode();
        if (oConvertUtils.isEmpty((Object)desformCode)) {
            throw new JeecgBootException("\u8868\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.dataMongoCurdService.update(desformCode, entity);
    }

    @Override
    public boolean updateBatchById(List<DesignFormData> entityList) {
        if (entityList.size() == 0) {
            return false;
        }
        String desformCode = entityList.get(0).getDesformCode();
        if (oConvertUtils.isEmpty((Object)desformCode)) {
            throw new JeecgBootException("\u8868\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.dataMongoCurdService.updateBatch(desformCode, entityList);
        return false;
    }

    @Override
    public boolean removeById(String desformCode, Serializable id) {
        return this.dataMongoCurdService.delete(desformCode, id.toString());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean removeLogicallyById(String desformCode, Serializable id) {
        Update update;
        if (oConvertUtils.isEmpty((Object)desformCode)) {
            throw new JeecgBootException("\u5fc5\u987b\u4f20\u9012 desformCode");
        }
        DesignForm designForm = this.a(desformCode);
        if (designForm == null) {
            throw new JeecgBootException("\u8868\u5355\u8bbe\u8ba1\u5668\uff08" + desformCode + "\uff09\u4e0d\u5b58\u5728");
        }
        DesignFormData oldDesignFormData = this.getById(desformCode, id.toString());
        if (oldDesignFormData == null) {
            throw new JeecgBootException("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)id.toString()));
        UpdateResult result = this.mongoTemplate.updateFirst(query, (UpdateDefinition)(update = new Update().set("del_flag", (Object)org.jeecg.modules.online.desform.constant.b.al)), desformCode);
        if (result.getModifiedCount() > 0L) {
            JSONObject designJson = JSON.parseObject((String)designForm.getDesformDesignJson());
            JSONArray designList = designJson.getJSONArray("list");
            Map<WidgetTypes, List<JSONObject>> specialWidgets = org.jeecg.modules.online.desform.util.h.d(designList);
            this.a(desformCode, specialWidgets.get((Object)WidgetTypes.LINK_RECORD), oldDesignFormData, null, this.r);
            super.a(this.r, desformCode, specialWidgets, oldDesignFormData, null);
            super.a("delete", oldDesignFormData, desformCode, true);
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean removeBatchLogicallyByIds(String desformCode, List<String> idList) {
        return this.removeBatchLogicallyByIds(desformCode, idList, true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean removeBatchLogicallyByIds(String desformCode, List<String> idList, Boolean isTriggerProcess) {
        if (oConvertUtils.isEmpty((Object)desformCode)) {
            throw new JeecgBootException("\u5fc5\u987b\u4f20\u9012 desformCode");
        }
        DesignForm designForm = this.a(desformCode);
        if (designForm == null) {
            throw new JeecgBootException("\u8868\u5355\u8bbe\u8ba1\u5668\uff08" + desformCode + "\uff09\u4e0d\u5b58\u5728");
        }
        List<DesignFormData> dataList = this.getByIds(desformCode, idList);
        if (dataList == null || dataList.isEmpty()) {
            return true;
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").in(idList));
        Update update = new Update().set("del_flag", (Object)org.jeecg.modules.online.desform.constant.b.al);
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        if (sysUser != null) {
            update.set("delete_by", (Object)sysUser.getUsername());
            update.set("delete_by_dictText", (Object)sysUser.getRealname());
        }
        update.set("delete_time", (Object)new Date());
        UpdateResult result = this.mongoTemplate.updateMulti(query, (UpdateDefinition)update, desformCode);
        if (result.getModifiedCount() > 0L) {
            JSONObject designJson = JSON.parseObject((String)designForm.getDesformDesignJson());
            JSONArray designList = designJson.getJSONArray("list");
            Map<WidgetTypes, List<JSONObject>> specialWidgets = org.jeecg.modules.online.desform.util.h.d(designList);
            for (DesignFormData oldDesignFormData : dataList) {
                this.a(desformCode, specialWidgets.get((Object)WidgetTypes.LINK_RECORD), oldDesignFormData, null, this.r);
                super.a(this.r, desformCode, specialWidgets, oldDesignFormData, null);
                if (!isTriggerProcess.booleanValue()) continue;
                super.a("delete", oldDesignFormData, desformCode, true);
            }
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean restoreData(String desformCode, List<String> idList) {
        if (oConvertUtils.isEmpty((Object)desformCode)) {
            throw new JeecgBootException("\u5fc5\u987b\u4f20\u9012 desformCode");
        }
        if (idList == null) {
            throw new JeecgBootException("\u5fc5\u987b\u4f20\u9012 idList");
        }
        if ((idList = idList.stream().filter(id -> !oConvertUtils.isEmpty((Object)id)).collect(Collectors.toList())).isEmpty()) {
            throw new JeecgBootException("\u5fc5\u987b\u4f20\u9012 idList");
        }
        DesignForm designForm = this.a(desformCode);
        if (designForm == null) {
            throw new JeecgBootException("\u8868\u5355\u8bbe\u8ba1\u5668\uff08" + desformCode + "\uff09\u4e0d\u5b58\u5728");
        }
        List<DesignFormData> dataList = this.getByIds(desformCode, idList);
        if (dataList == null || dataList.isEmpty()) {
            throw new JeecgBootException("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        }
        JSONObject designJson = JSON.parseObject((String)designForm.getDesformDesignJson());
        JSONArray designList = designJson.getJSONArray("list");
        Map<WidgetTypes, List<JSONObject>> specialWidgets = org.jeecg.modules.online.desform.util.h.d(designList);
        List linkRecordList = specialWidgets.computeIfAbsent(WidgetTypes.LINK_RECORD, v2 -> new ArrayList()).stream().filter(widget -> widget.getBooleanValue("isSubTable")).collect(Collectors.toList());
        for (DesignFormData data : dataList) {
            String mainId = data.getId();
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)mainId));
            Update update = new Update().set("del_flag", (Object)org.jeecg.modules.online.desform.constant.b.ak);
            if (!linkRecordList.isEmpty()) {
                for (JSONObject linkRecord : linkRecordList) {
                    Query subQuery;
                    List<DesignFormData> subDataList;
                    String twoWayModel;
                    JSONObject options = linkRecord.getJSONObject("options");
                    String subTableCode = options.getString("sourceCode");
                    if (oConvertUtils.isEmpty((Object)subTableCode) || oConvertUtils.isEmpty((Object)(twoWayModel = options.getString("twoWayModel"))) || (subDataList = this.a(subTableCode, subQuery = Query.query((CriteriaDefinition)Criteria.where((String)twoWayModel).in(new Object[]{mainId})))) == null || subDataList.isEmpty()) continue;
                    Update subUpdate = new Update().set("del_flag", (Object)org.jeecg.modules.online.desform.constant.b.ak);
                    this.mongoTemplate.updateMulti(subQuery, (UpdateDefinition)subUpdate, subTableCode);
                    List subIdList = subDataList.stream().map(DesignFormData::getId).collect(Collectors.toList());
                    String model = linkRecord.getString("model");
                    update.set(model, subIdList);
                }
            }
            Objects.requireNonNull(this);
            super.a("LOGIC_RESTORE", desformCode, specialWidgets, data, null);
            this.mongoTemplate.updateMulti(query, (UpdateDefinition)update, desformCode);
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean clearRecycle(String desformCode) {
        if (oConvertUtils.isEmpty((Object)desformCode)) {
            throw new JeecgBootException("\u5fc5\u987b\u4f20\u9012 desformCode \u53c2\u6570");
        }
        DesignForm designForm = this.a(desformCode);
        if (designForm == null) {
            throw new JeecgBootException("\u8868\u5355\u8bbe\u8ba1\u5668\uff08" + desformCode + "\uff09\u4e0d\u5b58\u5728");
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"del_flag").is((Object)org.jeecg.modules.online.desform.constant.b.al));
        List<DesignFormData> list = this.a(desformCode, query);
        if (list != null && list.size() > 0) {
            List<String> mainIdList = list.stream().map(DesignFormData::getId).collect(Collectors.toList());
            boolean removeFlag = this.removeBatchByIds(desformCode, mainIdList);
            if (!removeFlag) {
                throw new JeecgBootException("\u5220\u9664\u5931\u8d25");
            }
            JSONObject designJson = JSON.parseObject((String)designForm.getDesformDesignJson());
            JSONArray designList = designJson.getJSONArray("list");
            Map<WidgetTypes, List<JSONObject>> specialWidgets = org.jeecg.modules.online.desform.util.h.d(designList);
            List linkRecordList = specialWidgets.computeIfAbsent(WidgetTypes.LINK_RECORD, v2 -> new ArrayList()).stream().filter(widget -> widget.getBooleanValue("isSubTable")).collect(Collectors.toList());
            if (!linkRecordList.isEmpty()) {
                for (JSONObject linkRecord : linkRecordList) {
                    String twoWayModel;
                    JSONObject options = linkRecord.getJSONObject("options");
                    String subTableCode = options.getString("sourceCode");
                    if (oConvertUtils.isEmpty((Object)subTableCode) || oConvertUtils.isEmpty((Object)(twoWayModel = options.getString("twoWayModel")))) continue;
                    Query subQuery = Query.query((CriteriaDefinition)Criteria.where((String)twoWayModel).in(mainIdList));
                    this.mongoTemplate.remove(subQuery, subTableCode);
                }
            }
        }
        return true;
    }

    @Override
    public boolean removeByCode(String desformCode) {
        this.mongoTemplate.getCollection(desformCode).drop();
        return true;
    }

    @Override
    public boolean removeFieldById(String desformCode, String dataId, String ... fieldNames) {
        return this.dataMongoCurdService.removeField(desformCode, dataId, fieldNames);
    }

    @Override
    public Result<?> batchUpdate(BatchUpdateModel batchUpdateModel) {
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String userId = sysUser.getId();
        String appId = batchUpdateModel.getAppId();
        String designFormCode = batchUpdateModel.getDesignFormCode();
        String authType = batchUpdateModel.getAuthType();
        if (oConvertUtils.isEmpty((Object)authType)) {
            return Result.error((String)"\u53c2\u6570\u7f3a\u5931!");
        }
        LowAppFormAuthRecordModel authRecord = null;
        if (oConvertUtils.isNotEmpty((Object)appId) && this.lowAppBaseApi != null) {
            try {
                authRecord = this.lowAppBaseApi.getLowAppReadAuth(userId, appId, designFormCode, authType);
            }
            catch (NoSuchBeanDefinitionException e2) {
                o.warn("\u4f4e\u4ee3\u7801\u6a21\u5f0f\uff0c\u4e0d\u9700\u8981\u96f6\u4ee3\u7801\u5e94\u7528\u6743\u9650\u5224\u65ad~");
            }
            catch (RuntimeException e3) {
                if (e3.getClass().getName().contains("feign.FeignException")) {
                    o.warn("\u3010\u5fae\u670d\u52a1\u3011\u4f4e\u4ee3\u7801\u6a21\u5f0f\uff0c\u4e0d\u9700\u8981\u96f6\u4ee3\u7801\u5e94\u7528\u6743\u9650\u5224\u65ad~");
                }
                throw e3;
            }
        }
        List<String> idList = batchUpdateModel.getIdList();
        if (authRecord == null || authRecord.isUpdateAll()) {
            this.a(designFormCode, idList, batchUpdateModel.getField(), batchUpdateModel.getVal());
        } else if (authRecord.isUpdateOwn()) {
            boolean hasNoAuthData = false;
            String username = sysUser.getUsername();
            List<DesignFormData> dataList = this.getByIds(designFormCode, idList);
            DesignForm designForm = this.a(designFormCode);
            List roleCodeList = this.c.getRolesByUsername(username);
            List departIdList = this.c.getDepartIdsByUsername(username);
            List<DesformWidget> widgets = org.jeecg.modules.online.desform.mongo.b.a.b(designForm, "owners");
            ArrayList<String> updateIdList = new ArrayList<String>();
            for (DesignFormData designFormData : dataList) {
                boolean ownAuth = this.a(designFormData, widgets, username, roleCodeList, departIdList);
                if (!ownAuth) {
                    hasNoAuthData = true;
                    continue;
                }
                updateIdList.add(designFormData.getId());
            }
            if (updateIdList.size() > 0) {
                this.a(designFormCode, updateIdList, batchUpdateModel.getField(), batchUpdateModel.getVal());
            }
            if (hasNoAuthData) {
                if (batchUpdateModel.isUpdate()) {
                    return Result.ok((String)"\u4fee\u6539\u6210\u529f\uff0c\u65e0\u7f16\u8f91\u6743\u9650\u7684\u8bb0\u5f55\u65e0\u6cd5\u4fee\u6539!");
                }
                return Result.ok((String)"\u5220\u9664\u6210\u529f\uff0c\u65e0\u5220\u9664\u6743\u9650\u7684\u8bb0\u5f55\u65e0\u6cd5\u5220\u9664!");
            }
        } else {
            return Result.error((String)"\u6ca1\u6709\u6743\u9650!");
        }
        return Result.ok((String)"\u64cd\u4f5c\u6210\u529f!");
    }

    private void a(String designFormCode, List<String> idList, String field, Object val) {
        DesignForm designForm = this.a(designFormCode);
        if (designForm == null) {
            return;
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").in(idList));
        boolean isLogicallyDelete = false;
        if ("del_flag".equals(field) && val != null && org.jeecg.modules.online.desform.constant.b.al.equals(val)) {
            isLogicallyDelete = true;
        }
        if (isLogicallyDelete) {
            this.removeBatchLogicallyByIds(designFormCode, idList);
            LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
            Update update = new Update();
            if (sysUser != null) {
                update.set("delete_by", (Object)sysUser.getUsername());
                update.set("delete_by_dictText", (Object)sysUser.getRealname());
            }
            update.set("delete_time", (Object)new Date());
            this.mongoTemplate.updateMulti(query, (UpdateDefinition)update, designFormCode);
        } else {
            Update update = new Update().set(field, val);
            Map<String, Object> linkRecordFieldVal = this.a(designForm, field, val);
            for (String key : linkRecordFieldVal.keySet()) {
                update.set(key, linkRecordFieldVal.get(key));
            }
            this.mongoTemplate.updateMulti(query, (UpdateDefinition)update, designFormCode);
        }
    }

    private boolean a(DesformWidget widget) {
        boolean isArray = false;
        switch (widget.getType()) {
            case CHECKBOX: 
            case LINK_RECORD: 
            case SELECT_USER: 
            case ORG_ROLE: 
            case SELECT_DEPART: {
                isArray = true;
                break;
            }
            case SELECT: {
                isArray = widget.getOptions().isMultiple();
                break;
            }
            default: {
                isArray = false;
            }
        }
        return isArray;
    }

    private Map<String, Object> a(DesignForm designForm, String field, Object val) {
        HashMap<String, Object> result;
        block10: {
            result = new HashMap<String, Object>();
            if (val == null) break block10;
            JSONArray dataList = org.jeecg.modules.online.desform.util.h.b(designForm);
            DesformWidgetList widgetList = org.jeecg.modules.online.desform.util.h.a(dataList, false);
            List tempList = widgetList.main.stream().filter(i2 -> i2.getModel().equals(field)).collect(Collectors.toList());
            if (tempList != null && tempList.size() > 0) {
                List<String> elements;
                boolean isArrayData;
                DesformWidget widget = (DesformWidget)tempList.get(0);
                if (val != null && (isArrayData = this.a(widget)) && !(val instanceof List)) {
                    elements = Arrays.asList(val.toString().split(","));
                    result.put(field, elements);
                }
                if (widget.getType() == WidgetTypes.LINK_RECORD) {
                    List linkRecordList = null;
                    if (val != null) {
                        elements = Arrays.asList(val.toString().split(","));
                        String table = widget.getOptions().getSourceCode();
                        Query linkRecordQuery = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(elements));
                        linkRecordList = this.mongoTemplate.find(linkRecordQuery, JSONObject.class, table);
                    }
                    String linkRecordKey = widget.getKey();
                    if ("many".equals(widget.getOptions().getShowMode())) {
                        for (DesformWidget temp : widgetList.main) {
                            DesformOptions options;
                            if (temp.getType() != WidgetTypes.SUMMARY || (options = temp.getOptions()) == null || !linkRecordKey.equals(options.getLinkTable())) continue;
                            if (linkRecordList == null || linkRecordList.size() == 0) {
                                result.put(temp.getModel(), null);
                                continue;
                            }
                            String model = options.getField();
                            LinkRecordSummary summary = this.a(linkRecordList, model);
                            Object summaryVal = summary.getSummaryVal(options.getSummary());
                            result.put(temp.getModel(), summaryVal);
                        }
                    } else {
                        for (DesformWidget temp : widgetList.main) {
                            DesformOptions options;
                            if (temp.getType() != WidgetTypes.LINK_FIELD || (options = temp.getOptions()) == null || !linkRecordKey.equals(options.getLinkRecordKey()) || !"save".equals(options.getSaveType())) continue;
                            if (linkRecordList == null || linkRecordList.size() == 0) {
                                result.put(temp.getModel(), null);
                                continue;
                            }
                            Object value = ((JSONObject)linkRecordList.get(0)).get((Object)options.getShowField());
                            result.put(temp.getModel(), value);
                        }
                    }
                }
            }
        }
        return result;
    }

    private boolean a(DesignFormData designFormData, List<DesformWidget> widgets, String username, List<String> roleCodeList, List<String> departIdList) {
        boolean flag = false;
        String createBy = designFormData.getCreateBy();
        if (createBy != null && createBy.equals(username)) {
            return true;
        }
        JSONObject json = designFormData.getDesformData();
        if (widgets.size() > 0) {
            block0: for (DesformWidget widget : widgets) {
                String str;
                int n2;
                int n3;
                String objStr;
                JSONArray dataArray;
                ArrayList list;
                Object obj;
                WidgetTypes type = widget.getType();
                String model = widget.getModel();
                if (flag) break;
                if (WidgetTypes.SELECT_USER.equals((Object)type)) {
                    obj = json.get((Object)model);
                    if (obj == null) continue;
                    if (obj instanceof ArrayList) {
                        list = (ArrayList)obj;
                        if (list.indexOf(username) < 0) continue;
                        flag = true;
                        break;
                    }
                    if (obj instanceof JSONArray) {
                        dataArray = json.getJSONArray(model);
                        if (dataArray.indexOf((Object)username) < 0) continue;
                        flag = true;
                        break;
                    }
                    objStr = obj.toString();
                    String[] stringArray = objStr.split(",");
                    n3 = stringArray.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        str = stringArray[n2];
                        if (!str.equals(username)) continue;
                        flag = true;
                        continue block0;
                    }
                    continue;
                }
                if (WidgetTypes.SELECT_DEPART.equals((Object)type)) {
                    obj = json.get((Object)model);
                    if (obj == null || departIdList == null || departIdList.size() <= 0) continue;
                    if (obj instanceof ArrayList) {
                        list = (ArrayList)obj;
                        for (String str2 : list) {
                            if (departIdList.indexOf(str2) < 0) continue;
                            flag = true;
                            continue block0;
                        }
                        continue;
                    }
                    if (obj instanceof JSONArray) {
                        dataArray = json.getJSONArray(model);
                        for (int i2 = 0; i2 < dataArray.size(); ++i2) {
                            String str3 = dataArray.getString(i2);
                            if (departIdList.indexOf(str3) < 0) continue;
                            flag = true;
                            continue block0;
                        }
                        continue;
                    }
                    objStr = obj.toString();
                    String[] i2 = objStr.split(",");
                    int str3 = i2.length;
                    for (n2 = 0; n2 < str3; ++n2) {
                        str = i2[n2];
                        if (departIdList.indexOf(str) < 0) continue;
                        flag = true;
                        continue block0;
                    }
                    continue;
                }
                if (!WidgetTypes.ORG_ROLE.equals((Object)type) || (obj = json.get((Object)model)) == null || roleCodeList == null || roleCodeList.size() <= 0) continue;
                if (obj instanceof ArrayList) {
                    list = (ArrayList)obj;
                    for (String str4 : list) {
                        if (roleCodeList.indexOf(str4) < 0) continue;
                        flag = true;
                        continue block0;
                    }
                    continue;
                }
                if (obj instanceof JSONArray) {
                    dataArray = json.getJSONArray(model);
                    for (int i3 = 0; i3 < dataArray.size(); ++i3) {
                        String str5 = dataArray.getString(i3);
                        if (roleCodeList.indexOf(str5) < 0) continue;
                        flag = true;
                        continue block0;
                    }
                    continue;
                }
                objStr = obj.toString();
                String[] stringArray = objStr.split(",");
                n3 = stringArray.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    str = stringArray[n2];
                    if (roleCodeList.indexOf(str) < 0) continue;
                    flag = true;
                    continue block0;
                }
            }
        }
        return flag;
    }

    @Override
    public void a(Set<String> approvalModels, DesignFormData data) {
        String dataId = data.getId();
        String desformCode = data.getDesformCode();
        Update update = new Update();
        for (String field : approvalModels) {
            update.set(field, (Object)"");
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)dataId));
        this.mongoTemplate.updateFirst(query, (UpdateDefinition)update, desformCode);
    }

    @Override
    public List<DesignFormData> querySubTableData(String designFormCode, String subTableField, String mainDataId, DesformSuperQuery desformSuperQuery) {
        Criteria criteria = new Criteria("_id").is((Object)mainDataId);
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(Aggregation.match((Criteria)criteria));
        list.add(Aggregation.project((String[])new String[]{subTableField}));
        list.add(Aggregation.unwind((String)subTableField));
        desformSuperQuery.setSubTableKey(subTableField + ".");
        Criteria superQueryCriteria = DesformQueryUtils.b(desformSuperQuery);
        if (superQueryCriteria != null) {
            MatchOperation match4 = Aggregation.match((Criteria)superQueryCriteria);
            list.add(match4);
        }
        Aggregation aggregation = Aggregation.newAggregation(list);
        ArrayList<DesignFormData> dataList = new ArrayList<DesignFormData>();
        AggregationResults results = this.mongoTemplate.aggregate(aggregation, designFormCode, JSONObject.class);
        for (JSONObject item : results) {
            Object obj;
            if (!item.containsKey((Object)subTableField) || (obj = item.get((Object)subTableField)) == null || !(obj instanceof Map)) continue;
            Map temp = (Map)obj;
            dataList.add(new DesignFormData(designFormCode, new Document(temp)));
        }
        return dataList;
    }

    @Override
    public List<DictModel> queryLinkDataOptions(String desformCode, String fieldModel) {
        ArrayList<Object> operations = new ArrayList<Object>();
        operations.add(Aggregation.group((String[])new String[]{fieldModel}));
        Criteria criteria = Criteria.where((String)"").andOperator(new Criteria[]{Criteria.where((String)"_id").ne(null), Criteria.where((String)"_id").ne((Object)"")});
        operations.add(Aggregation.match((Criteria)criteria));
        operations.add(Aggregation.sort((Sort)Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)"_id")})));
        Fields fields = Fields.from((Field[])new Field[]{Fields.field((String)"value", (String)"_id"), Fields.field((String)"text", (String)"_id")});
        operations.add(Aggregation.project((Fields)fields));
        Aggregation agg = Aggregation.newAggregation(operations);
        o.info("mongodb aggregation: {}", (Object)JSON.toJSONString((Object)agg.toDocument(desformCode, Aggregation.DEFAULT_CONTEXT)));
        return this.mongoTemplate.aggregate(agg, desformCode, DictModel.class).getMappedResults();
    }

    @Override
    public void handlerSubTableDataByBatchInsert(DesignFormData designFormData) {
        String code = designFormData.getDesformCode();
        o.info("\u8c03\u7528\u4e86 \u3010\u6279\u91cf\u63d2\u5165\u5b50\u8868\u65b0\u6570\u636e\uff0c\u5173\u8054\u8bb0\u5f55\uff08\u5b50\u8868\u6a21\u5f0f\uff09\u3011\uff0ccode\uff1a {}\uff0cdesignFormData\uff1a {}", (Object)code, (Object)designFormData);
        DesignForm designForm = this.f.getByCode(code);
        JSONArray dataList = org.jeecg.modules.online.desform.util.h.b(designForm);
        DesformWidgetList allWidgetList = org.jeecg.modules.online.desform.util.h.a(dataList, false);
        List<DesformWidget> widgetList = allWidgetList.main;
        JSONObject formData = designFormData.getDesformData();
        for (DesformWidget widget : widgetList) {
            Object val;
            WidgetTypes type = widget.getType();
            String model = widget.getModel();
            if (WidgetTypes.LINK_RECORD != type || !widget.isSubTable() || (val = formData.get((Object)model)) == null) continue;
            try {
                List<JSONObject> subTableRecordList = this.a(widget, val);
                DesignForm subDesignForm = this.f.getByCode(widget.getOptions().getSourceCode());
                String twoWayModel = widget.getOptions().getTwoWayModel();
                subTableRecordList.stream().forEach(jsonObject -> jsonObject.remove((Object)twoWayModel));
                this.saveBatchByImport(subDesignForm, subTableRecordList, false);
                JSONArray relationIds = subTableRecordList.stream().map(jsonObject -> jsonObject.get((Object)"_id")).collect(Collectors.toCollection(JSONArray::new));
                formData.put(model, (Object)relationIds);
            }
            catch (Exception e2) {
                o.error("\u5b50\u8868\u6570\u636e\u8f6c\u5316\u5931\u8d25:" + val.toString());
            }
        }
    }

    @Override
    public void updateLinkRecordDataForAdd(String desformCode, List<JSONObject> linkRecordList, List<JSONObject> dataList) {
        if (linkRecordList != null && linkRecordList.size() > 0 && dataList != null && dataList.size() > 0) {
            for (JSONObject data : dataList) {
                DesignFormData designFormData = new DesignFormData(desformCode, data);
                String id = data.getString("_id");
                designFormData.setId(id);
                this.a(desformCode, linkRecordList, designFormData, null, this.p);
            }
        }
    }

    @Override
    public void updateLinkRecordDataForUpdate(String desformCode, List<JSONObject> linkRecordList, DesignFormData designFormData, DesignFormData oldData) {
        if (linkRecordList != null && linkRecordList.size() > 0) {
            this.a(desformCode, linkRecordList, oldData, null, this.r);
            this.a(desformCode, linkRecordList, designFormData, null, this.p);
        }
    }

    @Override
    public boolean checkUniqueForField(String desformCode, String fieldName, String fieldValue, String dataId) {
        long count;
        if (oConvertUtils.isEmpty((Object)fieldValue)) {
            return true;
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)fieldName).is((Object)fieldValue));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"del_flag").is((Object)CommonConstant.DEL_FLAG_0));
        if (oConvertUtils.isNotEmpty((Object)dataId)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").ne((Object)dataId));
        }
        return (count = this.mongoTemplate.count(query, desformCode)) == 0L;
    }

    @Override
    protected Long a(String desformCode, String parentField, String parentId) {
        DesformSuperQueryGroup superQueryGroup = super.a(parentField, parentId);
        ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
        criteriaList.add(DesformQueryUtils.a(superQueryGroup, false));
        criteriaList.add(Criteria.where((String)"del_flag").is((Object)org.jeecg.modules.online.desform.constant.b.ak));
        Query query = Query.query((CriteriaDefinition)new Criteria().andOperator(criteriaList));
        return this.mongoTemplate.count(query, desformCode);
    }

    @Override
    public Object queryADefValLinkageData(ADefValLinkageVo vo, DesformExtentdParam desformExtentdParam) throws UnsupportedEncodingException {
        DesformSuperQueryGroup desformSuperQueryGroup = DesformQueryUtils.parseSuperQueryGroup(vo.getSuperQueryString(), null);
        Page page = new Page(1L, 1L);
        if (vo.getOperation() == null) {
            vo.setOperation(DesformOperationEnum.FIRST);
        }
        if (vo.isMultiple()) {
            page.setSize(vo.getMaxRecordCount() == null ? 200L : (long)vo.getMaxRecordCount().intValue());
        }
        boolean isAsc = true;
        boolean isCount = false;
        boolean isCustomSort = false;
        boolean isIgnore = false;
        switch (vo.getOperation()) {
            case IGNORE: {
                isIgnore = true;
            }
            case CUSTOM_SORT: {
                isCustomSort = true;
            }
            case FIRST: {
                isAsc = false;
            }
            case LAST: {
                List dataList;
                Result<Page<DesignFormData>> result;
                String order = isAsc ? "asc" : "desc";
                String sortString = isCustomSort ? vo.getSortString() : null;
                List<OrderItem> orderItemList = DesformQueryUtils.a("create_time", order, sortString);
                page.setOrders(orderItemList);
                if (isIgnore) {
                    page.setSize(2L);
                }
                if (!(result = this.queryPage(vo.getDesformCode(), (Page<DesignFormData>)page, desformSuperQueryGroup, desformExtentdParam)).isSuccess() || CollectionUtils.isEmpty((Collection)(dataList = ((Page)result.getResult()).getRecords()))) break;
                if (isIgnore && dataList.size() > 1) {
                    return "";
                }
                if (vo.isDesignSubMode()) {
                    return this.a(vo, dataList);
                }
                ADefValLinkageVo.LinkageItem linkageItem = vo.getLinkages().get(0);
                String linkModel = linkageItem.getLinkModel();
                if (vo.isMultiple()) {
                    ArrayList<String> dataObjs = new ArrayList<String>();
                    for (DesignFormData data : dataList) {
                        JSONObject formData = data.getDesformData();
                        dataObjs.add(formData.getString(linkModel));
                    }
                    return dataObjs;
                }
                JSONObject formData = ((DesignFormData)dataList.get(0)).getDesformData();
                return formData.getString(linkModel);
            }
            case COUNT: {
                isCount = true;
            }
            case MAX: 
            case MIN: 
            case AVG: 
            case SUM: {
                Result<?> result2;
                String linkModel = "";
                if (!isCount) {
                    if (vo.getLinkages().isEmpty()) {
                        o.error("\u805a\u5408\u65f6\u975ecount\u64cd\u4f5c\uff0clinkages\u4e0d\u80fd\u4e3a\u7a7a");
                        return "";
                    }
                    ADefValLinkageVo.LinkageItem linkageItem = vo.getLinkages().get(0);
                    linkModel = linkageItem.getLinkModel();
                }
                if (!(result2 = this.queryOperation(vo.getDesformCode(), vo.getOperation(), linkModel, desformSuperQueryGroup, desformExtentdParam)).isSuccess()) break;
                return result2.getResult();
            }
        }
        return "";
    }

    private List<JSONObject> a(ADefValLinkageVo vo, List<DesignFormData> dataList) {
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        for (DesignFormData data : dataList) {
            JSONObject source = data.getDesformData();
            JSONObject target = new JSONObject();
            for (ADefValLinkageVo.LinkageItem linkageItem : vo.getLinkages()) {
                target.put(linkageItem.getModel(), source.get((Object)linkageItem.getLinkModel()));
            }
            list.add(target);
        }
        return list;
    }

    @Override
    @Deprecated
    public List<DictModel> linkFormGetOptions(String desformCode, String fieldModel) {
        return this.a(desformCode, fieldModel, (Criteria)null, (d)null);
    }

    @Override
    public List<DictModel> linkDataGetOptions(String desformCode, String fieldModel, String superQueryString, d sortType) throws UnsupportedEncodingException {
        DesformSuperQueryGroup superQueryGroup = DesformQueryUtils.parseSuperQueryGroup(superQueryString, new HashMap<String, String[]>());
        List<DesformSuperQuery> superQueryGroupList = superQueryGroup.getSuperQueryGroup();
        Criteria criteriaGroup = new Criteria();
        ArrayList<Criteria> criteriaGroupList = new ArrayList<Criteria>();
        for (DesformSuperQuery superQuery : superQueryGroupList) {
            List<Criteria> criteriaList = DesformQueryUtils.b(superQuery, false);
            if (CollectionUtils.isEmpty(criteriaList)) continue;
            if (MatchTypeEnum.AND.equals((Object)superQuery.getMatchType())) {
                criteriaGroupList.add(new Criteria().andOperator(criteriaList));
                continue;
            }
            criteriaGroupList.add(new Criteria().orOperator(criteriaList));
        }
        if (!CollectionUtils.isEmpty(criteriaGroupList)) {
            if (MatchTypeEnum.AND.equals((Object)superQueryGroup.getMatchType())) {
                criteriaGroup.andOperator(criteriaGroupList);
            } else {
                criteriaGroup.orOperator(criteriaGroupList);
            }
        }
        ArrayList<Criteria> defCriteriaGroupList = new ArrayList<Criteria>();
        defCriteriaGroupList.add(new Criteria().orOperator(new Criteria[]{new Criteria("del_flag").is((Object)org.jeecg.modules.online.desform.constant.b.ak), new Criteria("del_flag").isNull()}));
        defCriteriaGroupList.add(criteriaGroup);
        Criteria defCriteriaGroup = new Criteria();
        defCriteriaGroup.andOperator(defCriteriaGroupList);
        return this.a(desformCode, fieldModel, defCriteriaGroup, sortType);
    }

    private List<DictModel> a(String desformCode, String fieldModel, Criteria criteria, d sortType) {
        Aggregation aggregation;
        if (sortType == null) {
            sortType = org.jeecg.modules.online.desform.constant.d.a;
        }
        GroupOperation groupOperation = Aggregation.group((String[])new String[]{fieldModel});
        SortOperation sortOperation = Aggregation.sort((Sort)Sort.by((Sort.Order[])new Sort.Order[]{new Sort.Order(sortType.b() ? Sort.Direction.ASC : Sort.Direction.DESC, "order_num"), new Sort.Order(Sort.Direction.DESC, "_id")}));
        String sortField = sortType.getField() == null ? fieldModel : sortType.getField();
        groupOperation = sortType.b() ? groupOperation.first(sortField).as("order_num") : groupOperation.last(sortField).as("order_num");
        if (criteria == null) {
            aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{groupOperation, sortOperation});
        } else {
            MatchOperation match = Aggregation.match((Criteria)criteria);
            aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{match, groupOperation, sortOperation});
        }
        o.debug("MongoDB \u805a\u5408\u6761\u4ef6: {}", (Object)aggregation);
        AggregationResults results = this.mongoTemplate.aggregate(aggregation, desformCode, JSONObject.class);
        o.debug("MongoDB \u805a\u5408\u7ed3\u679c: {}", (Object)JSON.toJSONString((Object)results.getMappedResults()));
        ArrayList<DictModel> dictModelList = new ArrayList<DictModel>();
        for (JSONObject jsonObject : results.getMappedResults()) {
            String value = jsonObject.getString("_id");
            if (!oConvertUtils.isNotEmpty((Object)value)) continue;
            DictModel dictModel = new DictModel();
            dictModel.setValue(value);
            dictModel.setText(value);
            dictModelList.add(dictModel);
        }
        return dictModelList;
    }

    public DateStats a(String tableName, String fieldname, Object ids) {
        if (oConvertUtils.isEmpty((Object)ids)) {
            return null;
        }
        List<String> elements = this.a(ids);
        Criteria criteria = Criteria.where((String)"_id").in(elements);
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[0]).min(fieldname).as("minDate").max(fieldname).as("maxDate")});
        AggregationResults result = this.mongoTemplate.aggregate(aggregation, tableName, DateStats.class);
        return (DateStats)result.getUniqueMappedResult();
    }

    @Override
    public List<DesignFormData> list(DesformQuery desformQuery) {
        Collection<String> queryFields;
        String desformCode = desformQuery.getDesformCode();
        if (oConvertUtils.isEmpty((Object)desformCode)) {
            throw new JeecgBootBizTipException("\u8868\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Query query = new Query();
        Criteria filterCriteria = DesformQueryUtils.a(desformQuery.getSuperQueryGroup(), true);
        if (filterCriteria != null) {
            query.addCriteria((CriteriaDefinition)filterCriteria);
        }
        if (desformQuery.getQueryDeleted() != null && !desformQuery.getQueryDeleted().booleanValue()) {
            Criteria defFlagCriteria = new Criteria("del_flag").is((Object)org.jeecg.modules.online.desform.constant.b.ak);
            query.addCriteria((CriteriaDefinition)defFlagCriteria);
        }
        if (!CollectionUtils.isEmpty(queryFields = desformQuery.getQueryFields())) {
            query.fields().include(queryFields.toArray(new String[0]));
        }
        o.debug("mongodb DesformQuery list \u67e5\u8be2\u6761\u4ef6\uff0cdesformCode\uff1a{}\uff0cquery\uff1a{}", (Object)desformCode, (Object)query);
        List queryList = this.mongoTemplate.find(query, JSONObject.class, desformCode);
        ArrayList<DesignFormData> dataList = new ArrayList<DesignFormData>();
        for (JSONObject item : queryList) {
            dataList.add(new DesignFormData(desformCode, item));
        }
        return dataList;
    }

    @Override
    public boolean updateWithOldData(String desformCode, DesignFormData newData, DesignFormData oldData) {
        return this.updateWithOldData(desformCode, newData.getDesformData(), oldData.getDesformData());
    }

    @Override
    public boolean updateWithOldData(String desformCode, JSONObject newData, JSONObject oldData) {
        String id = newData.getString("_id");
        if (oConvertUtils.isEmpty((Object)id)) {
            return false;
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)id));
        Update update = null;
        for (String key : newData.keySet()) {
            if ("_id".equals(key)) continue;
            if (update == null) {
                update = Update.update((String)key, (Object)newData.get((Object)key));
                continue;
            }
            update.set(key, newData.get((Object)key));
        }
        if (update != null) {
            return this.mongoTemplate.updateFirst(query, update, desformCode).getModifiedCount() > 0L;
        }
        return false;
    }

    @Override
    public List<JSONObject> getMainData(String desformCode, String matchMainField, String subTableKey, Set<Object> matchValues) {
        ArrayList<Object> operations = new ArrayList<Object>();
        operations.add(Aggregation.match((Criteria)Criteria.where((String)matchMainField).in(matchValues).and("del_flag").is((Object)org.jeecg.modules.online.desform.constant.b.ak)));
        ArrayList<Sort.Order> sorts = new ArrayList<Sort.Order>();
        sorts.add(new Sort.Order(Sort.Direction.DESC, "create_time"));
        operations.add(Aggregation.sort((Sort)Sort.by(sorts)));
        operations.add(Aggregation.group((String[])new String[]{matchMainField}).first("$$ROOT").as("first"));
        operations.add(Aggregation.replaceRoot((String)"first"));
        operations.add(Aggregation.project((String[])new String[]{"_id", matchMainField, subTableKey}));
        Aggregation agg = Aggregation.newAggregation(operations);
        return this.mongoTemplate.aggregate(agg, desformCode, JSONObject.class).getMappedResults();
    }
}

