/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.desform.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringUtil;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.query.MatchTypeEnum;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.query.QueryRuleEnum;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.online.desform.constant.PermissionTypeEnum;
import org.jeecg.modules.online.desform.constant.WidgetTypes;
import org.jeecg.modules.online.desform.entity.DesignForm;
import org.jeecg.modules.online.desform.entity.DesignFormAuth;
import org.jeecg.modules.online.desform.entity.DesignFormData;
import org.jeecg.modules.online.desform.mapper.DesignFormAuthMapper;
import org.jeecg.modules.online.desform.service.IDesignFormAuthService;
import org.jeecg.modules.online.desform.service.IDesignFormService;
import org.jeecg.modules.online.desform.util.c;
import org.jeecg.modules.online.desform.util.g;
import org.jeecg.modules.online.desform.util.h;
import org.jeecg.modules.online.desform.vo.DesformAuthGroupVo;
import org.jeecg.modules.online.desform.vo.ExtActProcessNodeAuth;
import org.jeecg.modules.online.desform.vo.query.DesformSuperQuery;
import org.jeecg.modules.online.desform.vo.query.SuperQueryItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="designFormAuthServiceImpl")
public class b
extends ServiceImpl<DesignFormAuthMapper, DesignFormAuth>
implements IDesignFormAuthService {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(b.class);
    @Autowired
    ISysBaseAPI sysBaseApi;
    @Autowired
    public RedisTemplate redisTemplate;
    @Lazy
    @Autowired
    private IDesignFormService designFormService;

    private LambdaQueryWrapper<DesignFormAuth> a(String desformCode) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DesignFormAuth::getDesformCode, (Object)desformCode);
        return queryWrapper;
    }

    @Override
    public List<DesignFormAuth> queryByCode(String desformCode, boolean isGroup) {
        return this.queryByCode(desformCode, null, isGroup, true);
    }

    @Override
    public List<DesignFormAuth> queryByCode(String desformCode, String permissionType, boolean isGroup, boolean onlyEnabled) {
        LambdaQueryWrapper<DesignFormAuth> queryWrapper = this.a(desformCode);
        if (isGroup) {
            queryWrapper.eq(DesignFormAuth::getAuthType, (Object)"1");
            permissionType = PermissionTypeEnum.FIELD.getValue();
        }
        if (onlyEnabled) {
            queryWrapper.eq(DesignFormAuth::getStatus, (Object)CommonConstant.STATUS_1_INT);
        }
        if (oConvertUtils.isNotEmpty((Object)permissionType)) {
            queryWrapper.eq(DesignFormAuth::getPermissionType, (Object)permissionType);
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<DesignFormAuth> queryByCode(String desformCode) {
        return this.queryByCode(desformCode, false);
    }

    @Override
    public List<DesformAuthGroupVo> queryByCodeMerge(String desformCode) {
        return ((DesignFormAuthMapper)this.baseMapper).selectByCodeMerge(desformCode);
    }

    @Override
    public List<DesignFormAuth> queryByCodeAndAuthComKey(String desformCode, String authComKey) {
        return this.list((Wrapper)this.a(desformCode).eq(DesignFormAuth::getAuthComKey, (Object)authComKey));
    }

    @Override
    public List<DesignFormAuth> queryByTaskId(String desformCode, String taskId) {
        List<ExtActProcessNodeAuth> list = ((DesignFormAuthMapper)this.baseMapper).selectByTaskId(desformCode, taskId);
        ArrayList<DesignFormAuth> result = new ArrayList<DesignFormAuth>(list.size());
        for (ExtActProcessNodeAuth item : list) {
            DesignFormAuth auth = new DesignFormAuth();
            auth.setDesformCode(desformCode);
            String authField = item.getRuleCode();
            if (authField != null && authField.indexOf("::") != -1) {
                auth.setSubKey(authField.substring(0, authField.indexOf("::")));
                auth.setSubTable(true);
                auth.setAuthField(authField.substring(authField.indexOf("::") + 2));
            } else {
                auth.setAuthField(authField);
                auth.setSubTable(false);
            }
            auth.setAuthComKey(item.getDesformComKey());
            auth.setAuthTitle(item.getRuleName());
            String ruleType = item.getRuleType();
            String status = item.getStatus();
            if ("0".equals(status)) {
                if ("1".equals(ruleType)) {
                    auth.setAuthScopeIsAll("N");
                } else {
                    auth.setAuthScopeIsAll("Y");
                }
            } else if ("1".equals(ruleType)) {
                auth.setAuthScopeIsAll("Y");
            } else {
                auth.setAuthScopeIsAll("N");
            }
            auth.setAuthType(ruleType);
            if (item.getRequired() != null && item.getRequired().booleanValue()) {
                auth.setRequired(true);
            }
            auth.setPermissionType("field");
            auth.setStatus(1);
            result.add(auth);
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateBatch(List<DesignFormAuth> auths) {
        for (DesignFormAuth auth : auths) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            if (StringUtil.isEmpty((String)auth.getId())) {
                if ("3".equals(auth.getAuthType())) {
                    if (auth.getStatus() == null) {
                        auth.setStatus(org.jeecg.modules.online.desform.constant.b.h);
                    }
                    super.save((Object)auth);
                    continue;
                }
                queryWrapper.eq(DesignFormAuth::getDesformCode, (Object)auth.getDesformCode());
                queryWrapper.eq(DesignFormAuth::getAuthComKey, (Object)auth.getAuthComKey());
                if (!StringUtil.isEmpty((String)auth.getAuthType())) {
                    queryWrapper.eq(DesignFormAuth::getAuthType, (Object)auth.getAuthType());
                }
            } else {
                queryWrapper.eq(DesignFormAuth::getId, (Object)auth.getId());
            }
            this.update(auth, (Wrapper)queryWrapper);
        }
        return true;
    }

    @Override
    public boolean deleteTempAuth(String desformCode) {
        LambdaQueryWrapper deleteWrapper = new LambdaQueryWrapper();
        deleteWrapper.eq(DesignFormAuth::getDesformCode, (Object)desformCode);
        deleteWrapper.eq(DesignFormAuth::getStatus, (Object)org.jeecg.modules.online.desform.constant.b.j);
        return this.remove((Wrapper)deleteWrapper);
    }

    @Override
    public JSONObject getUserInfoByUsername(String username) {
        String keyString = String.format("sys:cache:desform:user_info::%s", username);
        if (this.redisTemplate.hasKey((Object)keyString).booleanValue()) {
            a.debug("[DesignForm Redis] \u901a\u8fc7Redis\u7f13\u5b58\u67e5\u8be2\u7528\u6237\u7684\u6743\u9650\u914d\u7f6e\uff0cusername={}", (Object)username);
            return (JSONObject)this.redisTemplate.opsForValue().get((Object)keyString);
        }
        a.debug("[DesignForm DB] \u901a\u8fc7\u6570\u636e\u5e93\u67e5\u8be2\u7528\u6237\u7684\u6743\u9650\u914d\u7f6e\uff0cusername={}", (Object)username);
        LoginUser userInfo = this.sysBaseApi.getUserByName(username);
        userInfo.setPassword(null);
        userInfo.setUserIdentity(null);
        userInfo.setRelTenantIds(null);
        userInfo.setActivitiSync(null);
        userInfo.setStatus(null);
        userInfo.setClientId(null);
        userInfo.setDelFlag(null);
        userInfo.setPhone(null);
        userInfo.setTelephone(null);
        if (userInfo == null) {
            throw new JeecgBootException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        List roles = this.sysBaseApi.getRolesByUserId(userInfo.getId());
        List departs = this.sysBaseApi.getDepartIdsByUserId(userInfo.getId());
        JSONObject json = new JSONObject(3);
        json.put("userInfo", (Object)userInfo);
        json.put("roles", (Object)roles);
        json.put("departs", (Object)departs);
        this.redisTemplate.opsForValue().set((Object)keyString, (Object)json, 10L, TimeUnit.SECONDS);
        return json;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean initialAuthInfo(DesignFormAuth auth) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DesignFormAuth::getDesformCode, (Object)auth.getDesformCode());
        queryWrapper.eq(DesignFormAuth::getAuthComKey, (Object)auth.getAuthComKey());
        queryWrapper.eq(DesignFormAuth::getAuthField, (Object)auth.getAuthField());
        super.remove((Wrapper)queryWrapper);
        g.a(() -> {
            List<DesignFormAuth> authList = this.parseAuths(auth);
            super.saveBatch(authList);
        });
        return true;
    }

    @Override
    public List<DesignFormAuth> parseAuths(DesignFormAuth auth) {
        auth.setAuthScopeIsAll("N");
        if (auth.getSubTable() == null) {
            auth.setSubTable(false);
        }
        if (auth.getStatus() == null) {
            auth.setStatus(org.jeecg.modules.online.desform.constant.b.h);
        }
        auth.setPermissionType(PermissionTypeEnum.FIELD.getValue());
        ArrayList<DesignFormAuth> authList = new ArrayList<DesignFormAuth>();
        DesignFormAuth authTemp = new DesignFormAuth();
        BeanUtils.copyProperties((Object)auth, (Object)authTemp);
        authTemp.setAuthType("1");
        authList.add(authTemp);
        authTemp = new DesignFormAuth();
        BeanUtils.copyProperties((Object)auth, (Object)authTemp);
        authTemp.setAuthType("2");
        authList.add(authTemp);
        authTemp = new DesignFormAuth();
        BeanUtils.copyProperties((Object)auth, (Object)authTemp);
        authTemp.setAuthType("3");
        authList.add(authTemp);
        return authList;
    }

    @Override
    public boolean checkPermissionType(String permissionType) {
        PermissionTypeEnum type = PermissionTypeEnum.getByValue(permissionType);
        if (type != null) {
            return true;
        }
        throw new JeecgBootException("\u4e0d\u8bc6\u522b\u7684permissionType\u503c");
    }

    @Override
    public IPage<DesignFormAuth> pageList(Integer pageNo, Integer pageSize, Wrapper<DesignFormAuth> wrapper) {
        if (pageNo == null) {
            pageNo = 1;
        }
        if (pageSize == null) {
            pageSize = 10;
        }
        if (pageNo == -1) {
            Page pageList = new Page();
            List list = super.list(wrapper);
            pageList.setRecords(list);
            pageList.setTotal((long)list.size());
            return pageList;
        }
        return super.page((IPage)new Page((long)pageNo.intValue(), (long)pageSize.intValue()), wrapper);
    }

    @Override
    public boolean addAuthByPermissionType(DesignFormAuth auth, String permissionType) {
        if (this.checkPermissionType(permissionType)) {
            auth.setPermissionType(permissionType);
            return super.save((Object)auth);
        }
        return false;
    }

    @Override
    public boolean editAuthByPermissionType(DesignFormAuth auth, String permissionType) {
        if (this.checkPermissionType(permissionType)) {
            auth.setPermissionType(permissionType);
            if (PermissionTypeEnum.BUTTON.getValue().equals(permissionType)) {
                return this.a(auth);
            }
            DesignFormAuth designFormAuthEntity = (DesignFormAuth)super.getById((Serializable)((Object)auth.getId()));
            if (designFormAuthEntity == null) {
                throw new JeecgBootException("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
            }
            return super.updateById((Object)auth);
        }
        return false;
    }

    public boolean a(DesignFormAuth auth) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DesignFormAuth::getPermissionType, (Object)auth.getPermissionType());
        queryWrapper.eq(DesignFormAuth::getDesformId, (Object)auth.getDesformId());
        queryWrapper.eq(DesignFormAuth::getDesformCode, (Object)auth.getDesformCode());
        queryWrapper.eq(DesignFormAuth::getAuthField, (Object)auth.getAuthField());
        DesignFormAuth entity = (DesignFormAuth)super.getOne((Wrapper)queryWrapper);
        if (entity == null) {
            if (auth.getStatus() == null) {
                auth.setStatus(org.jeecg.modules.online.desform.constant.b.h);
            }
            if (oConvertUtils.isEmpty((Object)auth.getAuthScopeIsAll())) {
                auth.setAuthScopeIsAll("N");
            }
            return super.save((Object)auth);
        }
        return super.update((Object)auth, (Wrapper)queryWrapper);
    }

    @Override
    public JSONObject queryButtonsAuth(String desformCode, String username) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DesignFormAuth::getPermissionType, (Object)PermissionTypeEnum.BUTTON.getValue());
        queryWrapper.eq(DesignFormAuth::getDesformCode, (Object)desformCode);
        queryWrapper.eq(DesignFormAuth::getStatus, (Object)org.jeecg.modules.online.desform.constant.b.i);
        List entityList = super.list((Wrapper)queryWrapper);
        JSONObject userInfo = this.getUserInfoByUsername(username);
        return c.a((List<DesignFormAuth>)entityList, userInfo);
    }

    @Override
    public void queryDataAuth(String desformCode, String username, QueryWrapper<DesignFormData> queryWrapper, DesformSuperQuery superQuery) {
        LambdaQueryWrapper getQueryWrapper = new LambdaQueryWrapper();
        getQueryWrapper.eq(DesignFormAuth::getPermissionType, (Object)PermissionTypeEnum.DATA.getValue());
        getQueryWrapper.eq(DesignFormAuth::getDesformCode, (Object)desformCode);
        getQueryWrapper.eq(DesignFormAuth::getStatus, (Object)org.jeecg.modules.online.desform.constant.b.i);
        List entityList = super.list((Wrapper)getQueryWrapper);
        JSONObject allUserInfo = this.getUserInfoByUsername(username);
        JSONObject userInfo = allUserInfo.getJSONObject("userInfo");
        for (DesignFormAuth auth : entityList) {
            if (!c.a(auth, allUserInfo)) continue;
            SuperQueryItem queryItem = null;
            String field = auth.getAuthField();
            String val = auth.getAuthValue();
            val = QueryGenerator.getSqlRuleValue((String)val);
            boolean findIt = false;
            for (SuperQueryItem temp : superQuery.getQueryItems()) {
                if (!field.equals(temp.getField())) continue;
                queryItem = temp;
                findIt = true;
                break;
            }
            if (queryItem == null) {
                JSONObject json = new JSONObject();
                json.put("field", (Object)field);
                json.put("rule", (Object)auth.getAuthType());
                json.put("val", (Object)val);
                String type = auth.getAuthValueType();
                if (oConvertUtils.isEmpty((Object)type)) {
                    type = "string";
                }
                json.put("type", (Object)type);
                queryItem = new SuperQueryItem(json);
            }
            if (findIt) continue;
            superQuery.add(queryItem);
        }
    }

    @Override
    public DesformSuperQuery queryAuthData(String desformCode, String username) {
        LambdaQueryWrapper getQueryWrapper = new LambdaQueryWrapper();
        getQueryWrapper.eq(DesignFormAuth::getPermissionType, (Object)PermissionTypeEnum.DATA.getValue());
        getQueryWrapper.eq(DesignFormAuth::getDesformCode, (Object)desformCode);
        getQueryWrapper.eq(DesignFormAuth::getStatus, (Object)org.jeecg.modules.online.desform.constant.b.i);
        List entityList = super.list((Wrapper)getQueryWrapper);
        JSONObject allUserInfo = this.getUserInfoByUsername(username);
        DesformSuperQuery superQuery = new DesformSuperQuery();
        superQuery.setMatchType(MatchTypeEnum.AND);
        for (DesignFormAuth auth : entityList) {
            if (!c.a(auth, allUserInfo)) continue;
            String type = auth.getAuthValueType();
            if (oConvertUtils.isEmpty((Object)type)) {
                type = "string";
            }
            String field = auth.getAuthField();
            String val = auth.getAuthValue();
            val = QueryGenerator.getSqlRuleValue((String)val);
            String authType = auth.getAuthType();
            QueryRuleEnum rule = QueryRuleEnum.getByValue((String)authType);
            if (rule == null) {
                a.warn("\u9047\u5230\u4e0d\u8bc6\u522b\u7684\u89c4\u5219\u7c7b\u578b\uff1a{}", (Object)authType);
                continue;
            }
            SuperQueryItem queryItem = new SuperQueryItem(type, field, val, rule);
            queryItem.setCustomSetTimestamp();
            superQuery.add(queryItem);
        }
        return superQuery;
    }

    @Override
    public Result<?> buildResultByPermissionType(String authScopeField, String authScopeCode, DesignFormAuth designFormAuth, String permissionType, String desformCode, HttpServletRequest request) {
        PermissionTypeEnum perType = PermissionTypeEnum.getByValue(permissionType);
        if (perType != null) {
            designFormAuth.setDesformCode(null);
            designFormAuth.setPermissionType(null);
            QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)designFormAuth, (Map)request.getParameterMap());
            queryWrapper.eq((Object)"desform_code", (Object)desformCode);
            queryWrapper.eq((Object)"permission_type", (Object)permissionType);
            queryWrapper.ne((Object)"auth_scope_is_all", (Object)"Y");
            if (PermissionTypeEnum.DATA == perType || PermissionTypeEnum.FIELD == perType) {
                return this.buildDataFieldResult((QueryWrapper<DesignFormAuth>)queryWrapper, authScopeField, authScopeCode, perType);
            }
            if (PermissionTypeEnum.BUTTON == perType) {
                return this.buildButtonResult((QueryWrapper<DesignFormAuth>)queryWrapper, authScopeField, authScopeCode);
            }
        }
        return Result.error((String)("\u4e0d\u8bc6\u522b\u7684permissionType\u503c\uff1a" + permissionType));
    }

    @Override
    public Result<?> buildDataFieldResult(QueryWrapper<DesignFormAuth> queryWrapper, String authScopeField, String authScopeCode, PermissionTypeEnum perType) {
        queryWrapper.eq((Object)"status", (Object)1);
        List allList = super.list(queryWrapper);
        queryWrapper.and(i2 -> this.spliceAuthScopeWrapper((QueryWrapper<DesignFormAuth>)i2, authScopeField, authScopeCode));
        List list = super.list(queryWrapper);
        JSONArray records = new JSONArray();
        for (DesignFormAuth auth : allList) {
            JSONObject temp = new JSONObject(3);
            temp.put("key", (Object)auth.getId());
            Object title = auth.getAuthTitle();
            if (auth.getSubTable() != null && auth.getSubTable().booleanValue()) {
                title = auth.getSubTitle() + "#" + (String)title;
            }
            if (PermissionTypeEnum.FIELD == perType) {
                title = "1".equals(auth.getAuthType()) ? (String)title + "\uff08\u53ef\u89c1\uff09" : ("2".equals(auth.getAuthType()) ? (String)title + "\uff08\u53ef\u7f16\u8f91\uff09" : ("3".equals(auth.getAuthType()) ? (String)title + "\uff08\u5217\u8868\u53ef\u89c1\uff09" : (String)title + "\uff08\u672a\u77e5\uff09"));
            }
            temp.put("title", title);
            temp.put("authField", (Object)auth.getAuthField());
            if ("auth_scope_roles_val".equals(authScopeField)) {
                temp.put("scopeValue", (Object)auth.getAuthScopeRolesVal());
            } else if ("auth_scope_departs_val".equals(authScopeField)) {
                temp.put("scopeValue", (Object)auth.getAuthScopeDepartsVal());
            } else if ("auth_scope_users_val".equals(authScopeField)) {
                temp.put("scopeValue", (Object)auth.getAuthScopeUsersVal());
            }
            temp.put("authScopeIsAll", (Object)auth.getAuthScopeIsAll());
            records.add((Object)temp);
        }
        records.sort((o1, o2) -> {
            String field1 = ((JSONObject)o1).getString("authField");
            String field2 = ((JSONObject)o2).getString("authField");
            return field1.compareTo(field2);
        });
        JSONObject result = new JSONObject(2);
        result.put("records", (Object)records);
        result.put("targetKeys", list.stream().map(DesignFormAuth::getId).collect(Collectors.toList()));
        return Result.ok((Object)result);
    }

    @Override
    public Result<?> buildButtonResult(QueryWrapper<DesignFormAuth> queryWrapper, String authScopeField, String authScopeCode) {
        List allDbList = super.list(queryWrapper);
        List<DesignFormAuth> allButtonList = c.getNewButtonList();
        List<DesignFormAuth> assignButtonList = c.a(allButtonList, allDbList);
        queryWrapper.and(i2 -> this.spliceAuthScopeWrapper((QueryWrapper<DesignFormAuth>)i2, authScopeField, authScopeCode));
        List list = super.list(queryWrapper);
        JSONArray records = new JSONArray();
        assignButtonList.forEach(auth -> {
            if (auth.getStatus() == 1 && !"Y".equals(auth.getAuthScopeIsAll())) {
                JSONObject temp = new JSONObject(5);
                temp.put("key", (Object)auth.getId());
                temp.put("title", (Object)auth.getAuthTitle());
                temp.put("authField", (Object)auth.getAuthField());
                temp.put("scopeValue", (Object)auth.getAuthScopeRolesVal());
                temp.put("authScopeIsAll", (Object)auth.getAuthScopeIsAll());
                records.add((Object)temp);
            }
        });
        JSONObject result = new JSONObject(2);
        result.put("records", (Object)records);
        result.put("targetKeys", list.stream().map(DesignFormAuth::getId).collect(Collectors.toList()));
        return Result.ok((Object)result);
    }

    @Override
    public QueryWrapper<DesignFormAuth> spliceAuthScopeWrapper(QueryWrapper<DesignFormAuth> i2, String fieldName, String code) {
        return (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)i2.eq((Object)fieldName, (Object)code)).or()).like((Object)fieldName, (Object)("," + code + ","))).or()).likeLeft((Object)fieldName, (Object)("," + code))).or()).likeRight((Object)fieldName, (Object)(code + ","));
    }

    @Override
    public boolean removeByCode(String desformCode) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DesignFormAuth::getDesformCode, (Object)desformCode);
        return super.remove((Wrapper)queryWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int cleanAuthData(String desformCode) {
        DesignForm designForm = this.designFormService.getByCode(desformCode);
        if (designForm == null) {
            return 0;
        }
        HashSet validKeys = new HashSet();
        h.a(designForm, (WidgetTypes type, JSONObject item, JSONObject parent) -> {
            String key = item.getString("key");
            if (oConvertUtils.isNotEmpty((Object)key)) {
                validKeys.add(key);
            }
        });
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)qw.select(new SFunction[]{DesignFormAuth::getAuthComKey}).eq(DesignFormAuth::getDesformCode, (Object)desformCode)).groupBy(DesignFormAuth::getAuthComKey);
        List authList = super.list((Wrapper)qw);
        HashSet<String> removeKeys = new HashSet<String>();
        for (DesignFormAuth auth : authList) {
            String comKey = auth.getAuthComKey();
            if (oConvertUtils.isEmpty((Object)comKey) || validKeys.contains(comKey)) continue;
            removeKeys.add(auth.getAuthComKey());
        }
        if (!removeKeys.isEmpty()) {
            LambdaQueryWrapper removeWrapper = new LambdaQueryWrapper();
            removeWrapper.eq(DesignFormAuth::getDesformCode, (Object)desformCode);
            removeWrapper.in(DesignFormAuth::getAuthComKey, removeKeys);
            boolean ok = super.remove((Wrapper)removeWrapper);
            if (ok) {
                return removeKeys.size();
            }
            return 0;
        }
        return 0;
    }

    private static /* synthetic */ Object a(SerializedLambda lambda) {
        switch (lambda.getImplMethodName()) {
            case "getAuthType": {
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormAuth") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return DesignFormAuth::getAuthType;
                }
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormAuth") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return DesignFormAuth::getAuthType;
            }
            case "getAuthComKey": {
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormAuth") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return DesignFormAuth::getAuthComKey;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormAuth") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return DesignFormAuth::getAuthComKey;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormAuth") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return DesignFormAuth::getAuthComKey;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormAuth") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return DesignFormAuth::getAuthComKey;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormAuth") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return DesignFormAuth::getAuthComKey;
                }
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormAuth") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return DesignFormAuth::getAuthComKey;
            }
            case "getAuthField": {
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormAuth") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return DesignFormAuth::getAuthField;
                }
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormAuth") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return DesignFormAuth::getAuthField;
            }
            case "getDesformId": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormAuth") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return DesignFormAuth::getDesformId;
            }
            case "getDesformCode": {
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormAuth") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return DesignFormAuth::getDesformCode;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormAuth") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return DesignFormAuth::getDesformCode;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormAuth") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return DesignFormAuth::getDesformCode;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormAuth") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return DesignFormAuth::getDesformCode;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormAuth") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return DesignFormAuth::getDesformCode;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormAuth") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return DesignFormAuth::getDesformCode;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormAuth") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return DesignFormAuth::getDesformCode;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormAuth") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return DesignFormAuth::getDesformCode;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormAuth") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return DesignFormAuth::getDesformCode;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormAuth") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return DesignFormAuth::getDesformCode;
                }
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormAuth") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return DesignFormAuth::getDesformCode;
            }
            case "getId": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormAuth") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return DesignFormAuth::getId;
            }
            case "getStatus": {
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormAuth") && lambda.getImplMethodSignature().equals("()Ljava/lang/Integer;")) {
                    return DesignFormAuth::getStatus;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormAuth") && lambda.getImplMethodSignature().equals("()Ljava/lang/Integer;")) {
                    return DesignFormAuth::getStatus;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormAuth") && lambda.getImplMethodSignature().equals("()Ljava/lang/Integer;")) {
                    return DesignFormAuth::getStatus;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormAuth") && lambda.getImplMethodSignature().equals("()Ljava/lang/Integer;")) {
                    return DesignFormAuth::getStatus;
                }
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormAuth") || !lambda.getImplMethodSignature().equals("()Ljava/lang/Integer;")) break;
                return DesignFormAuth::getStatus;
            }
            case "getPermissionType": {
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormAuth") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return DesignFormAuth::getPermissionType;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormAuth") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return DesignFormAuth::getPermissionType;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormAuth") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return DesignFormAuth::getPermissionType;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormAuth") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return DesignFormAuth::getPermissionType;
                }
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormAuth") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return DesignFormAuth::getPermissionType;
            }
        }
        throw new IllegalArgumentException("Invalid lambda deserialization");
    }
}

