/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.desform.vo.query;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import lombok.Generated;
import org.jeecg.common.constant.enums.DateRangeEnum;
import org.jeecg.common.system.query.QueryRuleEnum;
import org.jeecg.common.util.DateRangeUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.online.desform.vo.query.LinkageVal;

public class SuperQueryItem {
    private String type;
    private String field;
    private String val;
    private LinkageVal linkageVal;
    private String beginVal;
    private String endVal;
    private QueryRuleEnum rule;
    private Boolean isSystemField;
    private JSONObject originalJson;

    public SuperQueryItem(JSONObject originalJson) {
        this.rule = QueryRuleEnum.getByValue((String)originalJson.getString("rule"));
        this.type = originalJson.getString("type");
        this.field = originalJson.getString("field");
        if (this.rule == QueryRuleEnum.LINKAGE) {
            this.val = "";
            this.linkageVal = LinkageVal.of(this.field, originalJson.getJSONObject("val"));
        } else {
            Object temp = originalJson.get((Object)"val");
            if (temp == null) {
                this.val = "";
            } else if (temp instanceof ArrayList) {
                ArrayList list = (ArrayList)temp;
                this.val = String.join((CharSequence)",", list);
            } else {
                this.val = temp.toString();
            }
        }
        Object begin = originalJson.get((Object)"beginVal");
        this.beginVal = begin == null ? "" : begin.toString();
        Object end = originalJson.get((Object)"endVal");
        this.endVal = end == null ? "" : end.toString();
        this.originalJson = originalJson;
        this.handleSpecialFormat();
    }

    public SuperQueryItem(String type, String field, String val, QueryRuleEnum rule) {
        this.type = type;
        this.field = field;
        this.val = val;
        this.rule = rule;
        this.originalJson = new JSONObject();
        this.originalJson.put("type", (Object)type);
        this.originalJson.put("field", (Object)field);
        this.originalJson.put("val", (Object)val);
        this.originalJson.put("rule", (Object)rule.getValue());
        this.handleSpecialFormat();
    }

    public String getFormatStr() {
        return this.originalJson.getString("formatStr");
    }

    private void handleSpecialFormat() {
        if ("date".equalsIgnoreCase(this.type)) {
            this.addFormatStr("yyyy-MM-dd");
            this.handleDateRange();
        } else if ("datetime".equalsIgnoreCase(this.type)) {
            this.addFormatStr("yyyy-MM-dd HH:mm:ss");
            this.handleDateRange();
        } else if ("area-linkage".equalsIgnoreCase(this.type)) {
            this.handleAreaLinkage();
        }
    }

    private void handleDateRange() {
        DateRangeEnum rangeEnum;
        if (oConvertUtils.isEmpty((Object)this.val)) {
            return;
        }
        try {
            rangeEnum = DateRangeEnum.valueOf((String)this.val);
        }
        catch (Exception e2) {
            return;
        }
        Date[] ranges = DateRangeUtils.getDateRangeByEnum((DateRangeEnum)rangeEnum);
        if (ranges == null) {
            return;
        }
        this.rule = QueryRuleEnum.EQ.equals((Object)this.rule) ? QueryRuleEnum.RANGE : QueryRuleEnum.NOT_RANGE;
        this.val = ranges[0].getTime() + "," + ranges[1].getTime();
    }

    public void addFormatStr(String format) {
        this.originalJson.put("formatStr", (Object)format);
    }

    private void handleAreaLinkage() {
        String[] vals;
        if (oConvertUtils.isEmpty((Object)this.val)) {
            return;
        }
        if (this.val.startsWith("LIKE_") && (vals = this.val.split("_")).length == 3) {
            try {
                int endIndex;
                int level = Integer.parseInt(vals[1]);
                int n2 = level == 1 ? 2 : (endIndex = level == 2 ? 4 : -1);
                if (endIndex != -1) {
                    this.val = vals[2].substring(0, endIndex);
                    this.rule = QueryRuleEnum.EQ.equals((Object)this.rule) ? QueryRuleEnum.RIGHT_LIKE : QueryRuleEnum.NOT_RIGHT_LIKE;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setCustomSetTimestamp() {
        if (this.originalJson == null) {
            this.originalJson = new JSONObject();
        }
        this.originalJson.put("timestamp", (Object)true);
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getField() {
        return this.field;
    }

    @Generated
    public String getVal() {
        return this.val;
    }

    @Generated
    public LinkageVal getLinkageVal() {
        return this.linkageVal;
    }

    @Generated
    public String getBeginVal() {
        return this.beginVal;
    }

    @Generated
    public String getEndVal() {
        return this.endVal;
    }

    @Generated
    public QueryRuleEnum getRule() {
        return this.rule;
    }

    @Generated
    public Boolean getIsSystemField() {
        return this.isSystemField;
    }

    @Generated
    public JSONObject getOriginalJson() {
        return this.originalJson;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setField(String field) {
        this.field = field;
    }

    @Generated
    public void setVal(String val) {
        this.val = val;
    }

    @Generated
    public void setLinkageVal(LinkageVal linkageVal) {
        this.linkageVal = linkageVal;
    }

    @Generated
    public void setBeginVal(String beginVal) {
        this.beginVal = beginVal;
    }

    @Generated
    public void setEndVal(String endVal) {
        this.endVal = endVal;
    }

    @Generated
    public void setRule(QueryRuleEnum rule) {
        this.rule = rule;
    }

    @Generated
    public void setIsSystemField(Boolean isSystemField) {
        this.isSystemField = isSystemField;
    }

    @Generated
    public void setOriginalJson(JSONObject originalJson) {
        this.originalJson = originalJson;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof SuperQueryItem)) {
            return false;
        }
        SuperQueryItem other = (SuperQueryItem)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isSystemField = this.getIsSystemField();
        Boolean other$isSystemField = other.getIsSystemField();
        if (this$isSystemField == null ? other$isSystemField != null : !((Object)this$isSystemField).equals(other$isSystemField)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$field = this.getField();
        String other$field = other.getField();
        if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
            return false;
        }
        String this$val = this.getVal();
        String other$val = other.getVal();
        if (this$val == null ? other$val != null : !this$val.equals(other$val)) {
            return false;
        }
        LinkageVal this$linkageVal = this.getLinkageVal();
        LinkageVal other$linkageVal = other.getLinkageVal();
        if (this$linkageVal == null ? other$linkageVal != null : !((Object)this$linkageVal).equals(other$linkageVal)) {
            return false;
        }
        String this$beginVal = this.getBeginVal();
        String other$beginVal = other.getBeginVal();
        if (this$beginVal == null ? other$beginVal != null : !this$beginVal.equals(other$beginVal)) {
            return false;
        }
        String this$endVal = this.getEndVal();
        String other$endVal = other.getEndVal();
        if (this$endVal == null ? other$endVal != null : !this$endVal.equals(other$endVal)) {
            return false;
        }
        QueryRuleEnum this$rule = this.getRule();
        QueryRuleEnum other$rule = other.getRule();
        if (this$rule == null ? other$rule != null : !this$rule.equals(other$rule)) {
            return false;
        }
        JSONObject this$originalJson = this.getOriginalJson();
        JSONObject other$originalJson = other.getOriginalJson();
        return !(this$originalJson == null ? other$originalJson != null : !this$originalJson.equals(other$originalJson));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SuperQueryItem;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isSystemField = this.getIsSystemField();
        result = result * 59 + ($isSystemField == null ? 43 : ((Object)$isSystemField).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        String $val = this.getVal();
        result = result * 59 + ($val == null ? 43 : $val.hashCode());
        LinkageVal $linkageVal = this.getLinkageVal();
        result = result * 59 + ($linkageVal == null ? 43 : ((Object)$linkageVal).hashCode());
        String $beginVal = this.getBeginVal();
        result = result * 59 + ($beginVal == null ? 43 : $beginVal.hashCode());
        String $endVal = this.getEndVal();
        result = result * 59 + ($endVal == null ? 43 : $endVal.hashCode());
        QueryRuleEnum $rule = this.getRule();
        result = result * 59 + ($rule == null ? 43 : $rule.hashCode());
        JSONObject $originalJson = this.getOriginalJson();
        result = result * 59 + ($originalJson == null ? 43 : $originalJson.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SuperQueryItem(type=" + this.getType() + ", field=" + this.getField() + ", val=" + this.getVal() + ", linkageVal=" + this.getLinkageVal() + ", beginVal=" + this.getBeginVal() + ", endVal=" + this.getEndVal() + ", rule=" + this.getRule() + ", isSystemField=" + this.getIsSystemField() + ", originalJson=" + this.getOriginalJson() + ")";
    }
}

