/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.desform.mongo.service.a;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.lowapp.api.ILowAppBaseApi;
import org.jeecg.common.lowapp.model.LowAppFormAuthRecordModel;
import org.jeecg.common.online.api.IOnlineBaseExtApi;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.online.desform.datafactory.inter.dao.IDesformSettingDao;
import org.jeecg.modules.online.desform.mongo.constant.DesformSettingCode;
import org.jeecg.modules.online.desform.mongo.constant.a;
import org.jeecg.modules.online.desform.mongo.model.DesformSetting;
import org.jeecg.modules.online.desform.mongo.service.IDesignFormSettingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service(value="designFormSettingServiceImpl")
public class i
implements IDesignFormSettingService {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(i.class);
    @Autowired
    IDesformSettingDao settingDao;
    @Lazy
    @Autowired
    IOnlineBaseExtApi onlineBaseExtApi;
    @Autowired
    @Lazy
    ILowAppBaseApi lowAppBaseApi;

    @Override
    public List<DesformSetting> listByDesformCode(String desformCode) {
        return this.settingDao.selectList(desformCode);
    }

    @Override
    public List<DesformSetting> listWithDefault(String desformCode) {
        List<DesformSetting> settingList = this.listByDesformCode(desformCode);
        for (DesformSettingCode code : DesformSettingCode.values()) {
            boolean isExists = settingList.stream().anyMatch(i2 -> code.equals((Object)i2.getCode()));
            if (isExists) continue;
            settingList.add(this.a(code, desformCode));
        }
        return settingList;
    }

    private DesformSetting a(DesformSettingCode code, String desformCode) {
        DesformSetting setting = new DesformSetting();
        setting.setCode(code);
        setting.setDesformCode(desformCode);
        setting.setEnabled(true);
        setting.setUserAuth(org.jeecg.modules.online.desform.mongo.constant.a.a);
        setting.setViewAuth(org.jeecg.modules.online.desform.mongo.constant.a.c);
        setting.setViewIds(new ArrayList<String>());
        setting.setCreateTime(new Date());
        return setting;
    }

    private DesformSetting a(DesformSetting settingData) {
        if (oConvertUtils.isEmpty((Object)settingData.get_id())) {
            settingData.set_id(IdWorker.getIdStr());
        } else {
            settingData.setUpdateTime(new Date());
        }
        DesformSetting def = this.a(settingData.getCode(), settingData.getDesformCode());
        if (settingData.getEnabled() == null) {
            settingData.setEnabled(def.getEnabled());
        }
        if (settingData.getUserAuth() == null) {
            settingData.setUserAuth(def.getUserAuth());
        }
        if (settingData.getViewAuth() == null) {
            settingData.setViewAuth(def.getViewAuth());
        }
        if (settingData.getViewIds() == null) {
            settingData.setViewIds(def.getViewIds());
        }
        return settingData;
    }

    @Override
    public DesformSetting saveOrUpdate(DesformSetting settingData) {
        if (settingData.getCode() == null) {
            throw new JeecgBootException("code\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (oConvertUtils.isEmpty((Object)settingData.getDesformCode())) {
            throw new JeecgBootException("desformCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.settingDao.save(this.a(settingData));
        return settingData;
    }

    @Override
    public List<DesformSetting> saveBatch(List<DesformSetting> settingList) {
        ArrayList<DesformSetting> saveList = new ArrayList<DesformSetting>(settingList.size());
        for (DesformSetting settingData : settingList) {
            if (settingData.getCode() == null) {
                throw new JeecgBootException("code\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (oConvertUtils.isEmpty((Object)settingData.getDesformCode())) {
                throw new JeecgBootException("desformCode\u4e0d\u80fd\u4e3a\u7a7a");
            }
            saveList.add(this.a(settingData));
        }
        this.settingDao.saveAll(saveList);
        return saveList;
    }

    @Override
    public boolean removeByDesformCode(String desformCode) {
        List<DesformSetting> settingList = this.listByDesformCode(desformCode);
        this.settingDao.deleteAll(settingList);
        return true;
    }

    @Override
    public List<String> queryAllowFuncByCode(String desformCode, String viewId, String userId, String appId) {
        List<DesformSetting> settingList = this.listWithDefault(desformCode);
        ArrayList<String> allowFunc = new ArrayList<String>();
        for (DesformSetting setting : settingList) {
            if (!setting.getEnabled().booleanValue()) continue;
            if (org.jeecg.modules.online.desform.mongo.constant.a.b.equals(setting.getUserAuth())) {
                boolean isAppAdmin = false;
                LowAppFormAuthRecordModel authRecordModel = this.lowAppBaseApi.getLowAppReadAuth(userId, appId, desformCode, null);
                if (authRecordModel != null) {
                    isAppAdmin = authRecordModel.isHasAdmin();
                }
                if (!isAppAdmin) continue;
            }
            if (org.jeecg.modules.online.desform.mongo.constant.a.d.equals(setting.getViewAuth()) && !setting.getViewIds().contains(viewId)) continue;
            allowFunc.add(setting.getCode().name());
        }
        return allowFunc;
    }
}

