/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.process.adapter.delegate.datahandle;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.JavaDelegate;
import org.jeecg.common.util.DateUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.extbpm.process.adapter.delegate.datahandle.base.BaseDataDelegate;
import org.jeecg.modules.extbpm.process.common.WorkFlowGlobals;
import org.jeecg.modules.minides.enums.FormTableTypeEnums;
import org.jeecg.modules.minides.enums.GetDataTypeEnums;
import org.jeecg.modules.minides.enums.SystemVariableEnums;
import org.jeecg.modules.online.desform.constant.WidgetTypes;
import org.jeecg.modules.online.desform.entity.DesignFormData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Scope(value="prototype")
@Component(value="updateRecordDelegate")
public class UpdateRecordDelegate
extends BaseDataDelegate
implements JavaDelegate {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UpdateRecordDelegate.class);

    public void execute(DelegateExecution delegateExecution) {
        log.info("---------\u8fdb\u5165\u66f4\u65b0\u8bb0\u5f55-\u670d\u52a1\u8282\u70b9 UpdateRecordDelegate-----------");
        try {
            boolean init = this.init(delegateExecution);
            if (init) {
                String dataId;
                String formTableCode = this.childAttr.getFormTableCode();
                String formTableSourceTaskId = this.childAttr.getFormTableSourceTaskId();
                String formTableSourceNodeType = this.childAttr.getFormTableSourceNodeType();
                List<String> dataIds = new ArrayList<String>();
                if (FormTableTypeEnums.table.name().equals(formTableSourceNodeType)) {
                    dataId = (String)delegateExecution.getVariable(WorkFlowGlobals.BPM_DATA_ID, String.class);
                    if (StringUtil.isNotEmpty((String)dataId)) {
                        dataIds.add(dataId);
                    }
                } else if (FormTableTypeEnums.plus.name().equals(formTableSourceNodeType)) {
                    formDataSourceKey = MessageFormat.format("flow:task:form_data:{0}:{1}", this.processInstanceId, formTableSourceTaskId);
                    dataId2 = (String)delegateExecution.getVariable(formDataSourceKey, String.class);
                    if (StringUtil.isNotEmpty((String)dataId2)) {
                        dataIds.add(dataId2);
                    }
                } else if (FormTableTypeEnums.search.name().equals(formTableSourceNodeType)) {
                    formDataSourceKey = MessageFormat.format("flow:task:get_data:{0}:{1}", this.processInstanceId, formTableSourceTaskId);
                    dataId2 = (String)delegateExecution.getVariable(formDataSourceKey, String.class);
                    if (StringUtil.isNotEmpty((String)dataId2)) {
                        dataIds.add(dataId2);
                    }
                } else if (FormTableTypeEnums.getMore.name().equals(formTableSourceNodeType)) {
                    List records;
                    String dataKey;
                    Integer getDataType = this.childAttr.getFormTableSourceGetDataType();
                    String formDataSourceKey = MessageFormat.format("flow:task:get_data:{0}:{1}", this.processInstanceId, formTableSourceTaskId);
                    if (GetDataTypeEnums.from_redis.getType().equals(getDataType) && StringUtil.isNotEmpty((String)(dataKey = (String)delegateExecution.getVariable(formDataSourceKey, String.class))) && ObjectUtils.isNotEmpty((Object)(records = (List)this.redisUtil.get(dataKey)))) {
                        dataIds = records.stream().map(DesignFormData::getId).collect(Collectors.toList());
                    }
                    if (GetDataTypeEnums.from_db.getType().equals(getDataType)) {
                        dataIds = (List)delegateExecution.getVariable(formDataSourceKey, List.class);
                    }
                } else if (FormTableTypeEnums.subEvent.name().equals(formTableSourceNodeType) && StringUtil.isNotEmpty((String)(dataId = (String)delegateExecution.getVariable(WorkFlowGlobals.BPM_DATA_ID, String.class)))) {
                    dataIds.add(dataId);
                }
                if (ObjectUtils.isNotEmpty(dataIds)) {
                    log.info("---\u3010\u6d41\u7a0b\u6570\u636e\u8282\u70b9# \u4fee\u6539\u8bb0\u5f55\u3011---------\u9700\u8981\u66f4\u65b0\u7684dataIds = {} ---", dataIds);
                    for (String dataId2 : dataIds) {
                        DesignFormData designFormData = this.designFormDataService.getById(formTableCode, dataId2);
                        this.updateData(designFormData, dataId2, formTableCode);
                    }
                }
            }
        }
        catch (Exception exception) {
            log.error("\u6d41\u7a0b\u9519\u8bef", (Throwable)exception);
            super.handleException(exception);
        }
    }

    private void updateData(DesignFormData designFormData, String dataId, String formTableCode) {
        if (ObjectUtils.isNotEmpty((Object)designFormData)) {
            JSONArray jsonArray;
            JSONObject desFormData = designFormData.getDesformData();
            String updateFields = this.childAttr.getUpdateFields();
            if (ObjectUtils.isNotEmpty((Object)desFormData) && ObjectUtils.isNotEmpty((Object)(jsonArray = JSONArray.parseArray((String)updateFields)))) {
                DesignFormData updateObj = new DesignFormData();
                JSONObject dataJson = new JSONObject();
                dataJson.putAll((Map)desFormData);
                for (Object obj : jsonArray) {
                    String optType;
                    JSONObject jsonObject = (JSONObject)obj;
                    String fieldName = jsonObject.getString("field");
                    String type = jsonObject.getString("fieldType");
                    Object fieldValue = jsonObject.get((Object)"val");
                    if (fieldValue instanceof JSONObject) {
                        JSONObject valueObject = (JSONObject)fieldValue;
                        String funText = valueObject.getString("funText");
                        if (oConvertUtils.isNotEmpty((Object)funText)) {
                            fieldValue = this.getComplexValText(valueObject);
                        } else {
                            String formNodeType = valueObject.getString("formNodeType");
                            if (StringUtil.isNotEmpty((String)formNodeType)) {
                                if (formNodeType.equals("system")) {
                                    variableValue = valueObject.getString("variableValue");
                                    if (variableValue.equals(SystemVariableEnums.nowDate.name())) {
                                        fieldValue = DateUtils.formatDate((Date)DateUtils.getDate(), (String)"yyyy-MM-dd HH:mm:ss");
                                    }
                                    if (variableValue.equals(SystemVariableEnums.nowTime.name())) {
                                        fieldValue = DateUtils.formatDate((Date)DateUtils.getDate(), (String)"yyyy-MM-dd HH:mm:ss");
                                    }
                                    if (variableValue.equals(SystemVariableEnums.second.name())) {
                                        fieldValue = DateUtils.getDate().getTime();
                                    }
                                    if (variableValue.equals(SystemVariableEnums.millisecond.name())) {
                                        fieldValue = System.currentTimeMillis();
                                    }
                                    if (variableValue.equals(SystemVariableEnums.dataSourceId.name())) {
                                        fieldValue = this.delegateExecution.getVariable(WorkFlowGlobals.BPM_DATA_ID, String.class);
                                    }
                                    if (variableValue.equals(SystemVariableEnums.executeId.name())) {
                                        fieldValue = this.executeId;
                                    }
                                } else if (formNodeType.equals("variable")) {
                                    variableValue = valueObject.getString("variableValue");
                                    fieldValue = this.delegateExecution.getVariable(variableValue);
                                } else {
                                    fieldValue = this.getFormFieldValue(valueObject, null);
                                }
                            }
                        }
                    }
                    if ((optType = jsonObject.getString("optType")).equals("1")) {
                        dataJson.put(fieldName, fieldValue);
                        continue;
                    }
                    String oldValueStr = null;
                    Object oldValue = desFormData.get((Object)fieldName);
                    if (oldValue instanceof JSONArray) {
                        JSONArray newValArray = new JSONArray();
                        if (fieldValue instanceof String) {
                            if (fieldValue.toString().contains(",")) {
                                newValArray.addAll(Arrays.asList(fieldValue.toString().split(",")));
                            } else {
                                newValArray.add(fieldValue);
                            }
                        } else {
                            newValArray.addAll((Collection)((JSONArray)fieldValue));
                        }
                        Object updateVal = this.getUpdateValueArray(optType, type, newValArray, (JSONArray)oldValue);
                        dataJson.put(fieldName, updateVal);
                        continue;
                    }
                    oldValueStr = oldValue.toString();
                    Object updateVal = this.getUpdateValue(optType, type, fieldValue, oldValueStr);
                    dataJson.put(fieldName, updateVal);
                }
                updateObj.setId(dataId);
                updateObj.setDesformCode(formTableCode);
                updateObj.setDesformDataJson(JSONObject.toJSONString((Object)dataJson));
                if ("0".equals(this.triggerOtherProcess)) {
                    updateObj.setTriggerProcess(false);
                }
                super.setLinkFieldValue(updateObj);
                this.designFormDataService.editOne(updateObj);
                log.info("---\u3010\u6d41\u7a0b\u6570\u636e\u8282\u70b9# \u4fee\u6539\u8bb0\u5f55\u3011---------\u66f4\u65b0dataId: {}\uff0c\u6570\u636e\u5185\u5bb9updateObj\uff1a{}", (Object)dataId, (Object)updateObj.toString());
            }
        }
    }

    private Object getUpdateValue(String optType, String type, Object fieldValue, String oldValue) {
        if (StringUtil.isNotEmpty((String)type)) {
            if (type.equals("money")) {
                BigDecimal value = new BigDecimal(oConvertUtils.getString((Object)fieldValue, (String)"0"));
                BigDecimal old = new BigDecimal(oConvertUtils.getString((String)oldValue, (String)"0"));
                if (optType.equals("2")) {
                    return value.add(old);
                }
                if (optType.equals("3")) {
                    return old.subtract(value);
                }
            } else if (type.equals("integer") || type.equals("number")) {
                Integer value = oConvertUtils.getInt((Object)fieldValue, (int)0);
                Integer old = oConvertUtils.getInt((String)oldValue, (int)0);
                if (optType.equals("2")) {
                    return old + value;
                }
                if (optType.equals("3")) {
                    return old - value;
                }
            } else if (WidgetTypes.SELECT_USER.getType().equals(type) || WidgetTypes.SELECT_DEPART.getType().equals(type) || WidgetTypes.ORG_ROLE.getType().equals(type) || WidgetTypes.CHECKBOX.getType().equals(type) || WidgetTypes.SELECT.getType().equals(type) || WidgetTypes.SWITCH.getType().equals(type)) {
                List<String> newValList = Arrays.asList(oConvertUtils.getString((Object)fieldValue).split(","));
                JSONArray newValArray = new JSONArray(newValList);
                List<String> oldValueList = Arrays.asList(oConvertUtils.getString((String)oldValue).split(","));
                JSONArray oldValueArray = new JSONArray(oldValueList);
                if (optType.equals("2")) {
                    for (Object o : newValArray) {
                        if (oldValueArray.contains(o)) continue;
                        oldValueArray.add(o);
                    }
                }
                if (optType.equals("3")) {
                    Iterator it_b = oldValueArray.iterator();
                    while (it_b.hasNext()) {
                        Object val = it_b.next();
                        if (!newValArray.contains(val)) continue;
                        it_b.remove();
                    }
                }
                return oldValueArray;
            }
        }
        return null;
    }

    private Object getUpdateValueArray(String optType, String type, JSONArray fieldValue, JSONArray oldValue) {
        if (oldValue == null) {
            oldValue = new JSONArray();
        }
        if (fieldValue == null && fieldValue.size() == 0) {
            return oldValue;
        }
        if (StringUtil.isNotEmpty((String)type)) {
            if (optType.equals("2")) {
                for (Object o : fieldValue) {
                    if (oldValue.contains(o)) continue;
                    oldValue.add(o);
                }
            }
            if (optType.equals("3")) {
                Iterator it_b = oldValue.iterator();
                while (it_b.hasNext()) {
                    Object val = it_b.next();
                    if (!fieldValue.contains(val)) continue;
                    it_b.remove();
                }
            }
            return oldValue;
        }
        return null;
    }
}

