/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.minides.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.Date;
import lombok.Generated;
import org.apache.commons.lang.StringUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.ExecutionListener;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.jeecg.common.util.DateUtils;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.extbpm.process.common.WorkFlowGlobals;
import org.jeecg.modules.extbpm.process.entity.ExtActProcess;
import org.jeecg.modules.extbpm.process.entity.ExtActProcessNodeDeployment;
import org.jeecg.modules.extbpm.service.ProcessUtils;
import org.jeecg.modules.minides.enums.FormTableTypeEnums;
import org.jeecg.modules.minides.enums.SubProcessGetDataTypeEnums;
import org.jeecg.modules.minides.enums.SystemVariableEnums;
import org.jeecg.modules.online.desform.entity.DesignFormData;
import org.jeecg.modules.online.desform.service.IDesignFormDataService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class MiniSubProcessStartListener
implements ExecutionListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MiniSubProcessStartListener.class);
    private static final long serialVersionUID = 1L;
    private ProcessUtils processUtils;
    private RedisUtil redisUtil;
    private RuntimeService runtimeService;
    private String executionId;
    private String processInstanceId;
    @Autowired
    private IDesignFormDataService designFormDataService;

    public void notify(DelegateExecution execution) {
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        if (this.runtimeService == null) {
            this.runtimeService = (RuntimeService)SpringContextUtils.getBean(RuntimeService.class);
        }
        if (this.processUtils == null) {
            this.processUtils = (ProcessUtils)SpringContextUtils.getBean((String)"processUtils");
        }
        if (this.redisUtil == null) {
            this.redisUtil = (RedisUtil)SpringContextUtils.getBean((String)"redisUtil");
        }
        this.executionId = execution.getId();
        this.processInstanceId = execution.getProcessInstanceId();
        String mainProcessId = oConvertUtils.getString((Object)execution.getVariable(WorkFlowGlobals.JG_SUB_MAIN_PROCESS_ID));
        log.info("------------\u4e3b\u6d41\u7a0b\u7684ID--------------[" + mainProcessId + "]");
        if (oConvertUtils.isNotEmpty((Object)mainProcessId)) {
            String nodeConfig;
            JSONObject childAttr;
            String bizTitle = oConvertUtils.getString((Object)this.runtimeService.getVariable(mainProcessId, WorkFlowGlobals.BPM_BIZ_TITLE));
            String processInstanceId = executionEntity.getProcessInstanceId();
            String inHandleDataId = null;
            execution.setVariable(WorkFlowGlobals.BPM_BIZ_TITLE, (Object)bizTitle);
            execution.setVariable(WorkFlowGlobals.APPLY_USER_ID, this.runtimeService.getVariable(mainProcessId, WorkFlowGlobals.BPM_DATA_ID));
            if (execution.hasVariable("handleDataId") && oConvertUtils.isNotEmpty((Object)execution.getVariable("handleDataId"))) {
                inHandleDataId = oConvertUtils.getString((Object)execution.getVariable("handleDataId"));
                log.info("----------\u4f20\u5165\u5b50\u6d41\u7a0b\u7684\uff0c\u6570\u636eID--------------[" + inHandleDataId + "]");
                execution.setVariable(WorkFlowGlobals.BPM_DATA_ID, (Object)inHandleDataId);
            } else {
                inHandleDataId = oConvertUtils.getString((Object)this.runtimeService.getVariable(mainProcessId, WorkFlowGlobals.BPM_DATA_ID));
                execution.setVariable(WorkFlowGlobals.BPM_DATA_ID, (Object)inHandleDataId);
            }
            String processDefinitionKey = executionEntity.getProcessDefinitionKey();
            ExtActProcess extActProcess = this.processUtils.getExtActProcessByProcessKey(processDefinitionKey);
            ExtActProcessNodeDeployment extActProcessNode = this.processUtils.getExtActProcessNodeDeployment(extActProcess.getId(), "start");
            if (ObjectUtils.isNotEmpty((Object)extActProcessNode) && ObjectUtils.isNotEmpty((Object)(childAttr = JSON.parseObject((String)(nodeConfig = extActProcessNode.getNodeConfigJson()))))) {
                JSONObject subFormTableObject = childAttr.getJSONObject("subFormTableObject");
                String formTableSourceTaskId = subFormTableObject.getString("nodeId");
                String formTableCode = subFormTableObject.getString("formTableCode");
                execution.setVariable(WorkFlowGlobals.BPM_FORM_KEY, (Object)formTableCode);
                String variableList = childAttr.getString("variableList");
                if (ObjectUtils.isNotEmpty((Object)variableList)) {
                    JSONArray jsonArray = JSONArray.parseArray((String)variableList);
                    for (Object object : jsonArray) {
                        JSONObject jsonObject = (JSONObject)object;
                        String field = jsonObject.getString("field");
                        Object value = this.getValue(jsonObject);
                        execution.setVariable(field, value);
                    }
                }
                if (ObjectUtils.isNotEmpty((Object)subFormTableObject)) {
                    String subFormDataSourceKey;
                    String nodeType = subFormTableObject.getString("nodeTypeMain");
                    String rootProcessInstanceId = executionEntity.getRootProcessInstanceId();
                    if (SubProcessGetDataTypeEnums.search.name().equals(nodeType)) {
                        String formDataSourceKey = MessageFormat.format("flow:task:get_data:{0}:{1}", rootProcessInstanceId, formTableSourceTaskId);
                        String dataId = (String)this.runtimeService.getVariable(rootProcessInstanceId, formDataSourceKey, String.class);
                        subFormDataSourceKey = MessageFormat.format("flow:task:get_data:{0}:{1}", processInstanceId, formTableSourceTaskId);
                        executionEntity.setVariable(subFormDataSourceKey, (Object)dataId);
                    }
                    if (SubProcessGetDataTypeEnums.getMoreUserDeptRole.name().equals(nodeType)) {
                        String handleDataId = (String)this.runtimeService.getVariable(processInstanceId, "handleDataId", String.class);
                        String subFormDataSourceKey2 = MessageFormat.format("flow:task:get_data:{0}:{1}", processInstanceId, formTableSourceTaskId);
                        executionEntity.setVariable(subFormDataSourceKey2, (Object)handleDataId);
                    }
                    if (SubProcessGetDataTypeEnums.getMore.name().equals(nodeType)) {
                        Integer getDataType = subFormTableObject.getInteger("getDataType");
                        String handleDataId = (String)this.runtimeService.getVariable(processInstanceId, "handleDataId", String.class);
                        subFormDataSourceKey = MessageFormat.format("flow:task:get_data:{0}:{1}", processInstanceId, formTableSourceTaskId);
                        executionEntity.setVariable(subFormDataSourceKey, (Object)handleDataId);
                    }
                }
            }
            this.runtimeService.updateBusinessKey(processInstanceId, inHandleDataId);
        }
    }

    public Object getValue(JSONObject jsonObject) {
        String formNodeId = jsonObject.getString("formNodeId");
        String formNodeType = jsonObject.getString("formNodeType");
        String formTableCode = jsonObject.getString("formTableCode");
        String variableValue = jsonObject.getString("variableValue");
        if (formNodeType.equals("system")) {
            Object val = this.getVariableValue(jsonObject);
            return val;
        }
        if (StringUtil.isNotEmpty((String)formNodeType)) {
            String dataId;
            String formDataSourceKey;
            DesignFormData designFormData = null;
            if (FormTableTypeEnums.table.name().equals(formNodeType)) {
                String dataId2 = (String)this.runtimeService.getVariable(this.executionId, WorkFlowGlobals.BPM_DATA_ID, String.class);
                designFormData = this.designFormDataService.getById(formTableCode, dataId2);
            }
            if (FormTableTypeEnums.search.name().equals(formNodeType)) {
                formDataSourceKey = MessageFormat.format("flow:task:get_data:{0}:{1}", this.processInstanceId, formNodeId);
                dataId = (String)this.runtimeService.getVariable(this.executionId, formDataSourceKey, String.class);
                designFormData = this.designFormDataService.getById(formTableCode, dataId);
            }
            if (FormTableTypeEnums.plus.name().equals(formNodeType)) {
                formDataSourceKey = MessageFormat.format("flow:task:form_data:{0}:{1}", this.processInstanceId, formNodeId);
                dataId = (String)this.runtimeService.getVariable(this.executionId, formDataSourceKey, String.class);
                designFormData = this.designFormDataService.getById(formTableCode, dataId);
            }
            if (ObjectUtils.isNotEmpty(designFormData)) {
                JSONObject sourceJsonObject = designFormData.getDesformData();
                return sourceJsonObject.get((Object)variableValue);
            }
        }
        return null;
    }

    private Object getVariableValue(JSONObject jsonObject) {
        Object result = "";
        String variableValue = jsonObject.getString("variableValue");
        if (variableValue.equals(SystemVariableEnums.nowDate.name())) {
            result = DateUtils.formatDate((Date)DateUtils.getDate(), (String)"yyyy-MM-dd");
        }
        if (variableValue.equals(SystemVariableEnums.nowTime.name())) {
            result = DateUtils.formatDate((Date)DateUtils.getDate(), (String)"yyyy-MM-dd HH:mm:ss");
        }
        if (variableValue.equals(SystemVariableEnums.second.name())) {
            result = DateUtils.getDate().getTime();
        }
        if (variableValue.equals(SystemVariableEnums.millisecond.name())) {
            result = System.currentTimeMillis();
        }
        if (variableValue.equals(SystemVariableEnums.executeId.name())) {
            result = this.executionId;
        }
        return result;
    }
}

