/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.process.adapter.delegate.datahandle.base;

import cn.hutool.core.util.ArrayUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang.StringUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Gateway;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.ServiceTask;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.jeecg.common.api.dto.message.MessageDTO;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.constant.enums.MessageTypeEnum;
import org.jeecg.common.desform.vo.DesignFormDataVo;
import org.jeecg.common.lowapp.model.FunExpression;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.query.MatchTypeEnum;
import org.jeecg.common.system.query.QueryCondition;
import org.jeecg.common.system.query.QueryRuleEnum;
import org.jeecg.common.system.vo.UserAccountInfo;
import org.jeecg.common.util.DateUtils;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.extbpm.process.adapter.entity.ChildAttr;
import org.jeecg.modules.extbpm.process.adapter.mq.utils.MinFlowUtils;
import org.jeecg.modules.extbpm.process.adapter.mq.utils.condition.a;
import org.jeecg.modules.extbpm.process.adapter.mq.utils.date.DateRangeUtils;
import org.jeecg.modules.extbpm.process.common.WorkFlowGlobals;
import org.jeecg.modules.extbpm.process.entity.ExtActProcess;
import org.jeecg.modules.extbpm.process.entity.ExtActProcessNodeDeployment;
import org.jeecg.modules.extbpm.service.ProcessUtils;
import org.jeecg.modules.minides.enums.FormTableTypeEnums;
import org.jeecg.modules.minides.enums.SystemDateRangeEnums;
import org.jeecg.modules.minides.enums.SystemVariableEnums;
import org.jeecg.modules.online.desform.entity.DesignFormData;
import org.jeecg.modules.online.desform.function.util.FunctionUtil;
import org.jeecg.modules.online.desform.service.IDesignFormDataService;
import org.jeecg.modules.online.desform.vo.query.DesformSuperQuery;
import org.jeecg.modules.online.desform.vo.query.SuperQueryItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseDataDelegate {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseDataDelegate.class);
    public String processInstanceId;
    public String processKey;
    public String processId;
    public ExtActProcess extActProcess;
    public String activityId;
    public String executeId;
    public String triggerOtherProcess;
    public ExtActProcessNodeDeployment extActProcessNode;
    public ChildAttr childAttr;
    public String deploymentId;
    public DelegateExecution delegateExecution;
    public ProcessUtils processUtils;
    public MinFlowUtils minFlowUtils;
    @Autowired
    public IDesignFormDataService designFormDataService;
    @Autowired
    public RedisUtil redisUtil;
    @Autowired
    private ISysBaseAPI baseApi;

    public String toString() {
        return "BaseDataDelegate{processInstanceId='" + this.processInstanceId + "', processKey='" + this.processKey + "', processId='" + this.processId + "', extActProcess=" + this.extActProcess + ", activityId='" + this.activityId + "', executeId='" + this.executeId + "', triggerOtherProcess='" + this.triggerOtherProcess + "', extActProcessNode=" + this.extActProcessNode + ", childAttr=" + this.childAttr + ", deploymentId='" + this.deploymentId + "'}";
    }

    public Boolean init(DelegateExecution delegateExecution) {
        ExecutionEntity executionEntity = (ExecutionEntity)delegateExecution;
        this.delegateExecution = delegateExecution;
        this.processInstanceId = delegateExecution.getProcessInstanceId();
        this.processUtils = (ProcessUtils)SpringContextUtils.getBean((String)"processUtils");
        this.minFlowUtils = (MinFlowUtils)SpringContextUtils.getBean((String)"minFlowUtils");
        this.processKey = executionEntity.getProcessDefinitionKey();
        this.executeId = delegateExecution.getId();
        this.extActProcess = this.processUtils.getExtActProcessByProcessKey(this.processKey);
        this.triggerOtherProcess = ObjectUtils.isEmpty((Object)this.extActProcess.getTriggerOtherProcess()) ? "0" : this.extActProcess.getTriggerOtherProcess();
        this.deploymentId = executionEntity.getDeploymentId();
        if (ObjectUtils.isNotEmpty((Object)this.extActProcess)) {
            String nodeConfig;
            this.processId = this.extActProcess.getId();
            this.activityId = executionEntity.getActivityId();
            this.extActProcessNode = this.processUtils.getExtActProcessNodeDeployment(this.processId, this.deploymentId, this.activityId);
            log.info("\u8282\u70b9code:{}\uff0c\u8282\u70b9\u540d\u79f0\uff1a{}", (Object)this.extActProcessNode.getProcessNodeCode(), (Object)this.extActProcessNode.getProcessNodeName());
            if (ObjectUtils.isNotEmpty((Object)this.extActProcessNode) && StringUtil.isNotEmpty((String)(nodeConfig = this.extActProcessNode.getNodeConfigJson()))) {
                this.childAttr = (ChildAttr)JSON.parseObject((String)nodeConfig, ChildAttr.class);
                return true;
            }
        }
        log.info(" BaseDataDelegate \u521d\u59cb\u5316\u53c2\u6570\uff1a " + this.toString());
        return false;
    }

    public void executeFormOneDataAdd(String dataKey) {
        if (ObjectUtils.isNotEmpty((Object)this.childAttr)) {
            String formModel = this.childAttr.getFormModel();
            String formTableCode = this.childAttr.getFormTableCode();
            if (StringUtil.isNotEmpty((String)formTableCode)) {
                DesignFormData designFormData = new DesignFormData();
                designFormData.setDesformCode(formTableCode);
                JSONObject formData = JSON.parseObject((String)formModel);
                this.replaceVariable(formData, null);
                designFormData.setDesformData(formData);
                if ("0".equals(this.triggerOtherProcess)) {
                    designFormData.setTriggerProcess(false);
                }
                this.setLinkFieldValue(designFormData);
                this.designFormDataService.handlerSubTableDataByBatchInsert(designFormData);
                Result result = this.designFormDataService.addOne(designFormData);
                log.info("---------\u3010\u6d41\u7a0b\u6570\u636e\u8282\u70b9# \u6dfb\u52a0\u8bb0\u5f55\u3011---\u6267\u884c\u5355\u6761\u6570\u636e\u63d2\u5165\u64cd\u4f5c\uff0cformTableCode={}\uff0cdesignFormData= {}", (Object)formTableCode, (Object)designFormData.toString());
                if (result.isSuccess()) {
                    JSONObject object = (JSONObject)result.getResult();
                    String processVariableKey = null;
                    processVariableKey = oConvertUtils.isNotEmpty((Object)dataKey) ? MessageFormat.format(dataKey, this.processInstanceId, this.activityId) : MessageFormat.format("flow:task:form_data:{0}:{1}", this.processInstanceId, this.activityId);
                    String dataId = object.getString("dataId");
                    this.delegateExecution.setVariable(processVariableKey, (Object)dataId);
                    log.info("---------\u3010\u6d41\u7a0b\u6570\u636e\u8282\u70b9# \u6dfb\u52a0\u8bb0\u5f55\u3011---\u5c06\u6dfb\u52a0\u7684\u5355\u6761\u6570\u636eid\u5b58\u50a8\u5230\u6d41\u7a0b\u53d8\u91cf\u4e2d\uff0cprocessVariableKey= {}\uff0cdataId= {}", (Object)processVariableKey, (Object)dataId);
                }
            }
        }
    }

    public void setLinkFieldValue(DesignFormData designFormData) {
        List funList = this.designFormDataService.handlerLinkFieldValue(designFormData, null);
        if (funList != null && funList.size() > 0) {
            for (FunExpression fun : funList) {
                Object decimal = FunctionUtil.getExpressionNumVal((String)fun.getExpression(), (Map)fun.getEnv());
                if (decimal == null) continue;
                String field = fun.getField();
                if (decimal instanceof BigDecimal) {
                    designFormData.getDesformData().put(field, (Object)((BigDecimal)decimal).doubleValue());
                    continue;
                }
                designFormData.getDesformData().put(field, (Object)decimal.toString());
            }
        }
    }

    public DesformSuperQuery initFormSuperQuery() {
        List queryItems;
        DesformSuperQuery desformSuperQuery = this.minFlowUtils.a(this.childAttr.getSearchFieldGroup());
        MatchTypeEnum matchType = ObjectUtils.isEmpty((Object)desformSuperQuery.getMatchType()) ? MatchTypeEnum.AND : desformSuperQuery.getMatchType();
        desformSuperQuery.setMatchType(matchType);
        if (ObjectUtils.isNotEmpty((Object)desformSuperQuery) && ObjectUtils.isNotEmpty((Object)(queryItems = desformSuperQuery.getQueryItems()))) {
            for (SuperQueryItem queryItem : queryItems) {
                try {
                    JSONObject jsonObject = JSONObject.parseObject((String)queryItem.getVal());
                    if (QueryRuleEnum.RANGE == queryItem.getRule()) {
                        String endVal;
                        String beginVal = queryItem.getBeginVal();
                        if (oConvertUtils.isNotEmpty((Object)beginVal)) {
                            JSONObject json = JSONObject.parseObject((String)beginVal);
                            this.initItemVal(json, queryItem, "beginVal");
                        }
                        if (oConvertUtils.isNotEmpty((Object)(endVal = queryItem.getEndVal()))) {
                            JSONObject json = JSONObject.parseObject((String)endVal);
                            this.initItemVal(json, queryItem, "endVal");
                        }
                    } else {
                        this.initItemVal(jsonObject, queryItem, "");
                    }
                }
                catch (Exception e2) {
                    log.info("\u503c\u7c7b\u578b\u4e3aString");
                }
                String beginVal = queryItem.getBeginVal();
                String endVal = queryItem.getEndVal();
                if (!oConvertUtils.isNotEmpty((Object)beginVal) && !oConvertUtils.isNotEmpty((Object)endVal)) continue;
                Object valStr = "";
                if (oConvertUtils.isNotEmpty((Object)beginVal)) {
                    valStr = (String)valStr + beginVal;
                }
                valStr = (String)valStr + ",";
                if (oConvertUtils.isNotEmpty((Object)endVal)) {
                    valStr = (String)valStr + endVal;
                }
                queryItem.setVal((String)valStr);
            }
        }
        return desformSuperQuery;
    }

    public void initItemVal(JSONObject jsonObject, SuperQueryItem queryItem, String valKey) {
        if (ObjectUtils.isNotEmpty((Object)jsonObject)) {
            String formNodeType = jsonObject.getString("formNodeType");
            if (formNodeType.equals("system")) {
                String variableValue = jsonObject.getString("variableValue");
                if (SystemDateRangeEnums.exist(variableValue)) {
                    DateRangeUtils.a(variableValue, queryItem);
                    return;
                }
                Object val = this.getSystemVariableValue(jsonObject);
                if (ObjectUtils.isNotEmpty((Object)val)) {
                    if ("beginVal".equals(valKey)) {
                        queryItem.setBeginVal(val.toString());
                    } else if ("endVal".equals(valKey)) {
                        queryItem.setEndVal(val.toString());
                    } else {
                        queryItem.setVal(val.toString());
                    }
                }
            } else if (formNodeType.equals("variable")) {
                String variableValue = jsonObject.getString("variableValue");
                Object val = this.delegateExecution.getVariable(variableValue);
                String valStr = "";
                if (ObjectUtils.isNotEmpty((Object)val)) {
                    valStr = val.toString();
                }
                if ("beginVal".equals(valKey)) {
                    queryItem.setBeginVal(valStr);
                } else if ("endVal".equals(valKey)) {
                    queryItem.setEndVal(valStr);
                } else {
                    queryItem.setVal(valStr);
                }
            } else {
                Object value = this.getFormFieldValue(jsonObject, null);
                if (ObjectUtils.isNotEmpty((Object)value)) {
                    if (value instanceof JSONArray) {
                        JSONArray valArray = (JSONArray)value;
                        queryItem.setVal(StringUtils.join((Iterable)valArray, (String)","));
                    } else if ("beginVal".equals(valKey)) {
                        queryItem.setBeginVal(value.toString());
                    } else if ("endVal".equals(valKey)) {
                        queryItem.setEndVal(value.toString());
                    } else {
                        queryItem.setVal(value.toString());
                    }
                } else if ("beginVal".equals(valKey)) {
                    queryItem.setBeginVal("");
                } else if ("endVal".equals(valKey)) {
                    queryItem.setEndVal("");
                } else {
                    queryItem.setVal("");
                }
            }
        }
    }

    public List<DesignFormData> queryOneFromMultiDataNode(List<String> dataIds) {
        String formTableCode;
        if (ObjectUtils.isNotEmpty((Object)this.childAttr) && oConvertUtils.isNotEmpty((Object)(formTableCode = this.childAttr.getFormTableCode()))) {
            Long limitNum;
            DesformSuperQuery desformSuperQuery = this.initFormSuperQuery();
            desformSuperQuery.setIdList(dataIds);
            Boolean ignoreSortRule = this.childAttr.getIgnoreSortRule();
            Page page = new Page();
            if (ignoreSortRule == null || ignoreSortRule.equals(false)) {
                String sortField = this.childAttr.getSortField();
                if (oConvertUtils.isEmpty((Object)sortField)) {
                    List<OrderItem> orderItems = BaseDataDelegate.getQueryOrderByUpdateTime();
                    page.setOrders(orderItems);
                } else {
                    String sortType = this.childAttr.getSortType();
                    List<OrderItem> orderItems = BaseDataDelegate.getQueryConditionOrders(sortField, sortType);
                    page.setOrders(orderItems);
                }
            }
            if (ObjectUtils.isNotEmpty((Object)(limitNum = Long.valueOf(ObjectUtils.isEmpty((Object)this.childAttr.getLimitNum()) ? 100L : this.childAttr.getLimitNum())))) {
                page.setSize(limitNum.longValue());
            }
            Result pageList = this.designFormDataService.pageList(formTableCode, page, desformSuperQuery);
            IPage result = (IPage)pageList.getResult();
            return result.getRecords();
        }
        return null;
    }

    public List<DesignFormData> queryFormDataBySuperQuery() {
        String formTableCode;
        if (ObjectUtils.isNotEmpty((Object)this.childAttr) && StringUtil.isNotEmpty((String)(formTableCode = this.childAttr.getFormTableCode()))) {
            DesformSuperQuery desformSuperQuery = this.initFormSuperQuery();
            Page page = new Page();
            String sortField = this.childAttr.getSortField();
            String sortType = this.childAttr.getSortType();
            Boolean ignoreSortRule = this.childAttr.getIgnoreSortRule();
            if (StringUtil.isNotEmpty((String)sortField) && !ignoreSortRule.booleanValue()) {
                orderItems = BaseDataDelegate.getQueryConditionOrders(sortField, sortType);
                page.setOrders(orderItems);
            } else {
                orderItems = BaseDataDelegate.getQueryOrderByUpdateTime();
                page.setOrders(orderItems);
            }
            Long limitNum = ObjectUtils.isEmpty((Object)this.childAttr.getLimitNum()) ? 100L : this.childAttr.getLimitNum();
            if (ObjectUtils.isNotEmpty((Object)limitNum)) {
                page.setSize(limitNum.longValue());
            }
            Result pageList = this.designFormDataService.pageList(formTableCode, page, desformSuperQuery);
            IPage result = (IPage)pageList.getResult();
            return result.getRecords();
        }
        return null;
    }

    public static List<OrderItem> getQueryConditionOrders(String sortField, String sortType) {
        ArrayList<OrderItem> list = new ArrayList<OrderItem>();
        if ("desc".equals(sortType)) {
            list.add(OrderItem.desc((String)sortField));
        } else {
            list.add(OrderItem.asc((String)sortField));
        }
        return list;
    }

    public static List<OrderItem> getQueryOrderByUpdateTime() {
        ArrayList<OrderItem> list = new ArrayList<OrderItem>();
        list.add(OrderItem.desc((String)"update_time"));
        return list;
    }

    public static List<OrderItem> getQueryConditionOrders(ChildAttr childAttr) {
        String sortField = childAttr.getSortField();
        String sortType = childAttr.getSortType();
        Boolean ignoreSortRule = childAttr.getIgnoreSortRule();
        if (StringUtil.isNotEmpty((String)sortField) && !ignoreSortRule.booleanValue()) {
            return BaseDataDelegate.getQueryConditionOrders(sortField, sortType);
        }
        return BaseDataDelegate.getQueryOrderByUpdateTime();
    }

    public List<DesignFormData> queryRedisData(String formDataSourceKey) {
        List<DesignFormData> records;
        String dataIdKey = (String)this.delegateExecution.getVariable(formDataSourceKey, String.class);
        if (StringUtil.isNotEmpty((String)dataIdKey) && ObjectUtils.isNotEmpty((Object)(records = (List<DesignFormData>)this.redisUtil.get(dataIdKey)))) {
            Long limitNum = ObjectUtils.isEmpty((Object)this.childAttr.getLimitNum()) ? 100L : this.childAttr.getLimitNum();
            if (records.size() > limitNum.intValue()) {
                records = records.subList(0, limitNum.intValue());
            }
            String sortField = this.childAttr.getSortField();
            String sortType = this.childAttr.getSortType();
            if (StringUtil.isNotEmpty((String)sortField)) {
                records.sort((o1, o2) -> {
                    String object2 = o2.getDesformData().getString(sortField);
                    String object1 = o1.getDesformData().getString(sortField);
                    if (StringUtil.isNotEmpty((String)object2) && StringUtil.isNotEmpty((String)object1)) {
                        if ("desc".equals(sortType)) {
                            return object2.compareTo(object1);
                        }
                        return object1.compareTo(object2);
                    }
                    return -1;
                });
            }
            return this.filterRecords(records);
        }
        return null;
    }

    public List<DesignFormData> filterRecords(List<DesignFormData> records) {
        String searchFieldGroupStr = this.childAttr.getSearchFieldGroup();
        if (oConvertUtils.isEmpty((Object)searchFieldGroupStr)) {
            return records;
        }
        DesformSuperQuery superQuery = this.initFormSuperQuery();
        MatchTypeEnum match = superQuery.getMatchType();
        List queryItems = superQuery.getQueryItems();
        if (queryItems == null || queryItems.size() == 0) {
            return records;
        }
        ArrayList<DesignFormData> result = new ArrayList<DesignFormData>();
        Class<a> clazz = a.class;
        for (DesignFormData data : records) {
            JSONObject jsonObject = data.getDesformData();
            boolean conditionFlag = MatchTypeEnum.AND.equals((Object)match);
            for (SuperQueryItem query : queryItems) {
                String field = query.getField();
                Object fieldValue = jsonObject.get((Object)field);
                String conditionValue = query.getVal();
                QueryRuleEnum rule = query.getRule();
                String methodName = oConvertUtils.camelName((String)rule.getCondition());
                try {
                    log.info("-------\u4ece\u591a\u6761\u8bb0\u5f55\u83b7\u53d6\u5355\u6761\u8bb0\u5f55 redis\u4e2d\u8fc7\u6ee4\u6570\u636e\uff0c\u8c03\u7528\u65b9\u6cd5ConditionUtil.{},\u65b9\u6cd5\u53c2\u6570\uff1a[{}], [{}]------", new Object[]{methodName, fieldValue, conditionValue});
                    Method method = clazz.getMethod(methodName, Object.class, String.class);
                    Boolean temp = (Boolean)method.invoke(null, fieldValue, conditionValue);
                    if (!(MatchTypeEnum.AND.equals((Object)match) ? !(conditionFlag = temp != false && conditionFlag) : (conditionFlag = temp != false || conditionFlag))) continue;
                    break;
                }
                catch (NoSuchMethodException e2) {
                    e2.printStackTrace();
                }
                catch (IllegalAccessException e3) {
                    e3.printStackTrace();
                }
                catch (InvocationTargetException e4) {
                    e4.printStackTrace();
                }
            }
            if (!conditionFlag) continue;
            result.add(data);
        }
        return result;
    }

    public void replaceVariable(JSONObject formData, DesignFormData record) {
        if (ObjectUtils.isNotEmpty((Object)formData)) {
            for (Map.Entry entry : formData.entrySet()) {
                Object val;
                JSONObject jsonObject;
                Object fieldObj = entry.getValue();
                String fieldKey = (String)entry.getKey();
                if (!(fieldObj instanceof JSONObject) || !ObjectUtils.isNotEmpty((Object)(jsonObject = (JSONObject)fieldObj))) continue;
                String funText = jsonObject.getString("funText");
                if (oConvertUtils.isNotEmpty((Object)funText)) {
                    funText = this.getComplexValText(jsonObject, record);
                    log.info("\u8ba1\u7b97\u53ef\u62fc\u63a5\u591a\u5b57\u6bb5\u8f93\u5165\u6846\u8868\u8fbe\u5f0f\u7684\u503c\uff0cfieldKey={}\uff0cComplexValText fieldVal:{}", (Object)fieldKey, (Object)funText);
                    formData.put(fieldKey, (Object)funText);
                    continue;
                }
                String formNodeType = jsonObject.getString("formNodeType");
                String variableValue = jsonObject.getString("variableValue");
                if ("system".equals(formNodeType)) {
                    val = this.getSystemVariableValue(jsonObject);
                    formData.put(fieldKey, val);
                    continue;
                }
                if ("variable".equals(formNodeType) || WorkFlowGlobals.APPLY_USER_ID.equals(variableValue)) {
                    val = this.delegateExecution.getVariable(variableValue);
                    formData.put(fieldKey, val);
                    continue;
                }
                Object value = this.getFormFieldValue(jsonObject, record);
                String fieldType = jsonObject.getString("fieldType");
                if (ObjectUtils.isNotEmpty((Object)fieldType) && fieldType.equals("link-record")) {
                    if (value instanceof JSONArray) {
                        formData.put(fieldKey, value);
                        continue;
                    }
                    JSONArray array = new JSONArray();
                    array.add(value);
                    formData.put(fieldKey, value);
                    continue;
                }
                formData.put(fieldKey, value);
            }
        }
    }

    public Object getFormFieldValue(JSONObject jsonObject, DesignFormData record) {
        return this.getFormFieldValue(jsonObject, record, false);
    }

    public Object getFormFieldValue(JSONObject jsonObject, DesignFormData record, boolean getDictText) {
        String formNodeId = jsonObject.getString("formNodeId");
        String formNodeType = jsonObject.getString("formNodeType");
        String formTableCode = jsonObject.getString("formTableCode");
        String variableValue = jsonObject.getString("variableValue");
        if (StringUtil.isNotEmpty((String)formNodeType)) {
            String dataId;
            JSONObject user;
            String dataId2;
            String formDataSourceKey;
            Object object;
            String code;
            String formDataSourceKey2;
            Object object2;
            if (FormTableTypeEnums.function.name().equals(formNodeType) && (object2 = this.delegateExecution.getVariable(formDataSourceKey2 = MessageFormat.format("flow:task:get_data:{0}:{1}", this.processInstanceId, formNodeId))) != null) {
                return object2.toString();
            }
            DesignFormData designFormData = null;
            if (ObjectUtils.isNotEmpty((Object)record) && (formTableCode.equals(code = record.getDesformCode()) || FormTableTypeEnums.getMoreUserDeptRole.name().equals(code))) {
                designFormData = record;
            }
            if (FormTableTypeEnums.getUserDeptRole.name().equals(formNodeType) && ObjectUtils.isNotEmpty((Object)(object = (JSONObject)this.delegateExecution.getVariable(formDataSourceKey = MessageFormat.format("flow:task:get_data:{0}:{1}", this.processInstanceId, formNodeId), JSONObject.class)))) {
                return object.get((Object)variableValue);
            }
            if (FormTableTypeEnums.getMoreUserDeptRole.name().equals(formNodeType) && ObjectUtils.isEmpty((Object)designFormData) && oConvertUtils.isNotEmpty((Object)(dataId2 = (String)this.delegateExecution.getVariable(formDataSourceKey = MessageFormat.format("flow:task:get_data:{0}:{1}", this.processInstanceId, formNodeId), String.class)))) {
                if ("sys_user".equalsIgnoreCase(formTableCode)) {
                    JSONObject userJson = this.baseApi.queryUserById(dataId2);
                    if (userJson != null) {
                        String username;
                        List departIds;
                        if ("depart".equals(variableValue) && (departIds = this.baseApi.getDepartIdsByUsername(username = userJson.getString("username"))) != null && departIds.size() > 0) {
                            userJson.put("depart", (Object)oConvertUtils.list2JSONArray((List)departIds));
                        }
                        designFormData = new DesignFormData();
                        designFormData.setDesformData(userJson);
                    }
                } else if ("sys_depart".equalsIgnoreCase(formTableCode)) {
                    List departs = this.baseApi.queryDepartsByIds(dataId2);
                    if (departs != null && departs.size() > 0) {
                        designFormData = new DesignFormData();
                        designFormData.setDesformData((JSONObject)departs.get(0));
                    }
                } else if ("sys_role".equalsIgnoreCase(formTableCode)) {
                    ArrayList<QueryCondition> conditions = new ArrayList<QueryCondition>();
                    QueryCondition superQueryItem = new QueryCondition("id", "input", null, QueryRuleEnum.EQ.getValue(), dataId2);
                    conditions.add(superQueryItem);
                    try {
                        String superQueryParams = URLEncoder.encode(JSONObject.toJSONString(conditions), "UTF-8");
                        List roles = this.baseApi.queryRoleBySuperQuery(superQueryParams, "and");
                        if (roles != null && roles.size() > 0) {
                            designFormData = new DesignFormData();
                            designFormData.setDesformData((JSONObject)roles.get(0));
                        }
                    }
                    catch (UnsupportedEncodingException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            if (FormTableTypeEnums.userEvent.name().equals(formNodeType) && ObjectUtils.isNotEmpty((Object)(user = this.baseApi.queryUserById(dataId = (String)this.delegateExecution.getVariable(WorkFlowGlobals.BPM_DATA_ID, String.class))))) {
                return user.get((Object)variableValue);
            }
            if (FormTableTypeEnums.table.name().equals(formNodeType) && ObjectUtils.isEmpty((Object)designFormData)) {
                designFormData = this.getStartDesFormData(formTableCode);
            }
            if (FormTableTypeEnums.search.name().equals(formNodeType) && ObjectUtils.isEmpty((Object)designFormData)) {
                formDataSourceKey = MessageFormat.format("flow:task:get_data:{0}:{1}", this.processInstanceId, formNodeId);
                dataId2 = (String)this.delegateExecution.getVariable(formDataSourceKey, String.class);
                designFormData = this.designFormDataService.getDataWithDictText(formTableCode, dataId2);
            }
            if (FormTableTypeEnums.plus.name().equals(formNodeType) && ObjectUtils.isEmpty((Object)designFormData)) {
                formDataSourceKey = MessageFormat.format("flow:task:form_data:{0}:{1}", this.processInstanceId, formNodeId);
                dataId2 = (String)this.delegateExecution.getVariable(formDataSourceKey, String.class);
                designFormData = this.designFormDataService.getDataWithDictText(formTableCode, dataId2);
            }
            if (FormTableTypeEnums.getMore.name().equals(formNodeType) && ObjectUtils.isEmpty((Object)designFormData)) {
                formDataSourceKey = MessageFormat.format("flow:task:get_data:{0}:{1}", this.processInstanceId, formNodeId);
                dataId2 = (String)this.delegateExecution.getVariable(formDataSourceKey, String.class);
                List<DesignFormData> records = this.queryRedisData(formDataSourceKey);
                designFormData = records != null && records.size() > 0 ? records.get(0) : this.designFormDataService.getDataWithDictText(formTableCode, dataId2);
            }
            if (FormTableTypeEnums.function.name().equals(formNodeType) && (object = this.delegateExecution.getVariable(formDataSourceKey = MessageFormat.format("flow:task:get_data:{0}:{1}", this.processInstanceId, formNodeId))) != null) {
                BigDecimal decimal = new BigDecimal(object.toString());
                return decimal;
            }
            if (ObjectUtils.isNotEmpty((Object)designFormData)) {
                JSONObject sourceJsonObject = designFormData.getDesformData();
                if (getDictText) {
                    String dictKey = variableValue + "_dictText";
                    if (sourceJsonObject.containsKey((Object)dictKey)) {
                        return sourceJsonObject.get((Object)dictKey);
                    }
                    return sourceJsonObject.get((Object)variableValue);
                }
                return sourceJsonObject.get((Object)variableValue);
            }
        }
        return null;
    }

    private boolean compareRuleValue(Object conditionValue, Object fieldValue, String type, QueryRuleEnum rule) {
        if (ObjectUtils.isNotEmpty((Object)fieldValue)) {
            if (QueryRuleEnum.EQ.equals((Object)rule) && (fieldValue.equals(conditionValue) || fieldValue.toString().equals(conditionValue))) {
                return true;
            }
            if (QueryRuleEnum.NE.equals((Object)rule) && !fieldValue.equals(conditionValue)) {
                return true;
            }
            if (QueryRuleEnum.LIKE.equals((Object)rule) && ObjectUtils.isNotEmpty((Object)conditionValue) && fieldValue.toString().indexOf(conditionValue.toString()) != -1) {
                return true;
            }
            if (QueryRuleEnum.LEFT_LIKE.equals((Object)rule) && ObjectUtils.isNotEmpty((Object)conditionValue) && fieldValue.toString().endsWith(conditionValue.toString())) {
                return true;
            }
            if (QueryRuleEnum.RIGHT_LIKE.equals((Object)rule) && ObjectUtils.isNotEmpty((Object)conditionValue) && fieldValue.toString().startsWith(conditionValue.toString())) {
                return true;
            }
            if (QueryRuleEnum.IN.equals((Object)rule) && ObjectUtils.isNotEmpty((Object)conditionValue)) {
                String[] conditionValueArray = conditionValue.toString().split(",");
                if (fieldValue instanceof String[] || fieldValue instanceof Array) {
                    return oConvertUtils.isArrayIn((String[])((String[])fieldValue), (String[])conditionValueArray);
                }
                if (fieldValue instanceof JSONArray) {
                    return oConvertUtils.isJsonArrayIn((JSONArray)((JSONArray)fieldValue), (String[])conditionValueArray);
                }
                if (conditionValue.toString().contains(fieldValue.toString())) {
                    return true;
                }
            }
            if (QueryRuleEnum.NOT_EMPTY.equals((Object)rule)) {
                return true;
            }
            if (ArrayUtil.contains((Object[])org.jeecg.modules.minides.a.a.q, (Object)type) && ObjectUtils.isNotEmpty((Object)conditionValue)) {
                if ("number".equals(type) || "integer".equals(type)) {
                    Integer conditionValueNum = Integer.parseInt(conditionValue.toString());
                    Integer fieldValueNum = Integer.parseInt(fieldValue.toString());
                    if (QueryRuleEnum.GT.equals((Object)rule)) {
                        return fieldValueNum > conditionValueNum;
                    }
                    if (QueryRuleEnum.GE.equals((Object)rule)) {
                        return fieldValueNum >= conditionValueNum;
                    }
                    if (QueryRuleEnum.LT.equals((Object)rule)) {
                        return fieldValueNum < conditionValueNum;
                    }
                    if (QueryRuleEnum.LE.equals((Object)rule)) {
                        return fieldValueNum <= conditionValueNum;
                    }
                }
                if ("money".equals(type)) {
                    BigDecimal conditionValueMoney = new BigDecimal(conditionValue.toString());
                    BigDecimal fieldValueMoney = new BigDecimal(fieldValue.toString());
                    if (QueryRuleEnum.GT.equals((Object)rule)) {
                        return fieldValueMoney.compareTo(conditionValueMoney) == 1;
                    }
                    if (QueryRuleEnum.GE.equals((Object)rule)) {
                        return fieldValueMoney.compareTo(conditionValueMoney) >= 0;
                    }
                    if (QueryRuleEnum.LT.equals((Object)rule)) {
                        return fieldValueMoney.compareTo(conditionValueMoney) == -1;
                    }
                    if (QueryRuleEnum.LE.equals((Object)rule)) {
                        return fieldValueMoney.compareTo(conditionValueMoney) <= 0;
                    }
                }
            }
        } else if (QueryRuleEnum.EMPTY.equals((Object)rule)) {
            return true;
        }
        return false;
    }

    public DesignFormData getStartDesFormData(String formTableCode) {
        DesignFormData designFormData = null;
        JSONObject data = (JSONObject)this.delegateExecution.getVariable("BPM_DELETE_DATA", JSONObject.class);
        if (data != null) {
            DesignFormDataVo designFormDataVo = (DesignFormDataVo)JSONObject.toJavaObject((JSON)data, DesignFormDataVo.class);
            designFormData = new DesignFormData();
            BeanUtils.copyProperties((Object)designFormDataVo, (Object)designFormData);
        } else {
            String dataId = (String)this.delegateExecution.getVariable(WorkFlowGlobals.BPM_DATA_ID, String.class);
            designFormData = this.designFormDataService.getDataWithDictText(formTableCode, dataId);
        }
        return designFormData;
    }

    private Object getSystemVariableValue(JSONObject jsonObject) {
        Object result = "";
        String variableValue = jsonObject.getString("variableValue");
        if (variableValue.equals(SystemVariableEnums.nowDate.name())) {
            result = DateUtils.formatDate((Date)DateUtils.getDate(), (String)"yyyy-MM-dd");
        }
        if (variableValue.equals(SystemVariableEnums.nowTime.name())) {
            result = DateUtils.formatDate((Date)DateUtils.getDate(), (String)"yyyy-MM-dd HH:mm:ss");
        }
        if (variableValue.equals(SystemVariableEnums.second.name())) {
            result = DateUtils.getDate().getTime();
        }
        if (variableValue.equals(SystemVariableEnums.millisecond.name())) {
            result = System.currentTimeMillis();
        }
        if (variableValue.equals(SystemVariableEnums.dataSourceId.name())) {
            result = this.delegateExecution.getVariable(WorkFlowGlobals.BPM_DATA_ID, String.class);
        }
        if (variableValue.equals(SystemVariableEnums.executeId.name())) {
            result = this.executeId;
        }
        return result;
    }

    public void noDataExecute() {
        Integer noDataType = this.childAttr.getNoDataType();
        if (noDataType.equals(2)) {
            this.executeFormOneDataAdd("flow:task:get_data:{0}:{1}");
        }
        if (noDataType.equals(3)) {
            String name;
            ServiceTask flowElement = (ServiceTask)this.delegateExecution.getCurrentFlowElement();
            SequenceFlow sequenceFlow = (SequenceFlow)flowElement.getOutgoingFlows().get(0);
            FlowElement targetFlowElement = sequenceFlow.getTargetFlowElement();
            boolean canStop = true;
            if (targetFlowElement instanceof Gateway && StringUtil.isNotEmpty((String)(name = targetFlowElement.getName())) && name.equals("\u6570\u636e\u5206\u652f")) {
                canStop = false;
            }
            if (canStop) {
                this.processUtils.stopProcessInstanceById(this.delegateExecution.getProcessInstanceId(), this.delegateExecution.getId());
                this.delegateExecution.setVariable(WorkFlowGlobals.BPM_STATUS, (Object)WorkFlowGlobals.BPM_BUS_STATUS_3);
                this.sendMessage(this.delegateExecution);
            }
        }
    }

    public void sendMessage(DelegateExecution delegateExecution) {
        ISysBaseAPI iSysBaseAPI = (ISysBaseAPI)SpringContextUtils.getBean(ISysBaseAPI.class);
        String node = this.extActProcessNode.getProcessNodeName();
        String process = this.extActProcess.getProcessName();
        String templateContext = "\u4ece\u5de5\u4f5c\u8868\u83b7\u53d6,\u67e5\u627e\u7ed3\u679c\u65e0\u6570\u636e,\u5de5\u4f5c\u6d41\u3010" + process + "\u3011,\u8282\u70b9\u3010" + node + "\u3011";
        String applyUserId = (String)delegateExecution.getVariable("applyUserId", String.class);
        if (StringUtil.isNotEmpty((String)applyUserId)) {
            String title = "\u6d41\u7a0b\u7ed3\u675f\u901a\u77e5";
            MessageDTO messageDTO = new MessageDTO();
            messageDTO.setToAll(Boolean.valueOf(false));
            messageDTO.setToUser(applyUserId);
            messageDTO.setTitle(title);
            messageDTO.setType(MessageTypeEnum.XT.getType());
            messageDTO.setIsMarkdown(false);
            messageDTO.setFromUser("system");
            messageDTO.setContent(templateContext);
            log.info("------------\u6d88\u606f\u53d1\u9001\u5bf9\u8c61:{}--------------", (Object)JSON.toJSONString((Object)messageDTO));
            iSysBaseAPI.sendTemplateMessage(messageDTO);
        }
    }

    public String getComplexValText(JSONObject jsonObject) {
        return this.getComplexValText(jsonObject, null);
    }

    public String getComplexValText(JSONObject jsonObject, DesignFormData record) {
        String funText = jsonObject.getString("funText");
        String funContextString = jsonObject.getString("funContext");
        log.info("\u8ba1\u7b97\u53ef\u62fc\u63a5\u591a\u5b57\u6bb5\u8f93\u5165\u6846\u8868\u8fbe\u5f0f\u7684\u503c\uff0cfunText:{} ,funContextString:{}", (Object)funText, (Object)funContextString);
        return this.getComplexValText(funText, funContextString, record);
    }

    public String getComplexValText(String funText, String funContextString, DesignFormData record) {
        JSONObject funContext = JSON.parseObject((String)funContextString);
        for (String key : funContext.keySet()) {
            try {
                Pattern p;
                Matcher matcher;
                String str = URLDecoder.decode(funContext.getString(key), "UTF-8");
                log.info("json\u53c2\u6570: " + str);
                JSONObject params = JSON.parseObject((String)str);
                MinFlowUtils.a(params, this.extActProcess);
                if (funText.indexOf(key) < 0 || !(matcher = (p = Pattern.compile("\\{\\{" + key + "\\.\\w+\\}\\}")).matcher(funText)).find()) continue;
                String exp = matcher.group();
                Object value = this.getVariableValue(params, record, true);
                if (value == null) {
                    value = "";
                }
                funText = funText.replace(exp, value.toString());
            }
            catch (UnsupportedEncodingException e2) {
                log.error("\u89e3\u6790\u53d8\u91cf\u51fa\u9519", (Throwable)e2);
            }
        }
        return funText;
    }

    public Object getVariableValue(JSONObject params, DesignFormData record, boolean getDictText) {
        MinFlowUtils.a(params, this.extActProcess);
        String formNodeType = params.getString("formNodeType");
        String field = params.getString("variableValue");
        Object fieldValue = null;
        if ("system".equals(formNodeType)) {
            if (field.equals(SystemVariableEnums.nowDate.name())) {
                fieldValue = DateUtils.formatDate((Date)DateUtils.getDate(), (String)"yyyy-MM-dd");
            }
            if (field.equals(SystemVariableEnums.nowTime.name())) {
                fieldValue = DateUtils.formatDate((Date)DateUtils.getDate(), (String)"yyyy-MM-dd HH:mm:ss");
            }
            if (field.equals(SystemVariableEnums.second.name())) {
                fieldValue = DateUtils.getDate().getTime();
            }
            if (field.equals(SystemVariableEnums.millisecond.name())) {
                fieldValue = System.currentTimeMillis();
            }
            if (field.equals(SystemVariableEnums.dataSourceId.name())) {
                fieldValue = this.delegateExecution.getVariable(WorkFlowGlobals.BPM_DATA_ID, String.class);
            }
            if (field.equals(SystemVariableEnums.executeId.name())) {
                fieldValue = this.executeId;
            }
        } else {
            fieldValue = "variable".equals(formNodeType) ? this.delegateExecution.getVariable(field) : this.getFormFieldValue(params, record, getDictText);
        }
        return fieldValue;
    }

    public void handleException(Exception e2) {
        JSONObject json;
        JSONArray arr;
        String msg = e2.getMessage();
        if (oConvertUtils.isEmpty((Object)msg)) {
            msg = "\u7a7a";
        }
        String errorTitle = "\u5de5\u4f5c\u6d41 \u201c" + this.extActProcess.getProcessName() + "\u201d\uff0c\u6267\u884c\u5230\u8282\u70b9 \u201c" + this.extActProcessNode.getProcessNodeName() + "\u201d\uff0c\u51fa\u73b0\u7a0b\u5e8f\u9519\u8bef\uff01";
        log.warn("\u3010\u7b80\u6d41\u3011\u7cfb\u7edf\u9519\u8bef\u901a\u77e5\uff01ERROR: {}", (Object)(errorTitle + e2.getMessage()), (Object)e2);
        String str = this.extActProcess.getErrorNoticeUserIds();
        if (oConvertUtils.isNotEmpty((Object)str) && (arr = (json = JSONObject.parseObject((String)str)).getJSONArray("toUserIds")).size() > 0) {
            String users = this.getErrorNodeToUsers(arr);
            String redisKey = this.processKey + this.extActProcessNode.getId() + "_nodeError";
            log.info("redisKey:" + redisKey);
            boolean sendFlag = false;
            String repeat = this.extActProcess.getErrorNoticeRepeat();
            long time = 0L;
            if (oConvertUtils.isEmpty((Object)repeat) || "0".equals(repeat)) {
                sendFlag = true;
            } else {
                Object redisVal = this.redisUtil.get(redisKey);
                if (redisVal == null) {
                    sendFlag = true;
                }
                time = (long)Integer.parseInt(repeat) * 60L;
            }
            if (sendFlag) {
                MessageDTO messageDTO = new MessageDTO();
                messageDTO.setType(MessageTypeEnum.XT.getType());
                messageDTO.setToAll(Boolean.valueOf(false));
                messageDTO.setToUser(users);
                messageDTO.setTitle(errorTitle);
                messageDTO.setFromUser("system");
                HashMap data = new HashMap();
                messageDTO.setData(data);
                messageDTO.setContent("\u9519\u8bef\u4fe1\u606f\uff1a" + msg);
                this.baseApi.sendTemplateMessage(messageDTO);
                if (time > 0L) {
                    this.redisUtil.set(redisKey, (Object)1, time);
                }
            } else {
                log.error(errorTitle);
            }
            this.processUtils.stopProcessInstanceById(this.processInstanceId, this.executeId);
        }
    }

    public String getErrorNodeToUsers(JSONArray userArray) {
        String[] ids;
        List list;
        List tempUserIdList;
        HashSet<String> usernames = new HashSet<String>();
        ArrayList<String> roleCodes = new ArrayList<String>();
        ArrayList<String> deptIds = new ArrayList<String>();
        HashSet userIds = new HashSet();
        for (Object str : userArray) {
            String user = str.toString();
            String[] array = user.split("\\.");
            String type = array[0];
            if ("user".equals(type)) {
                usernames.add(array[1]);
                continue;
            }
            if ("role".equals(type)) {
                roleCodes.add(array[1]);
                continue;
            }
            if ("dept".equals(type)) {
                deptIds.add(array[1]);
                continue;
            }
            usernames.add(type);
        }
        if (roleCodes.size() > 0) {
            tempUserIdList = this.baseApi.queryUserIdsByRoleds(roleCodes);
            userIds.addAll(tempUserIdList);
        }
        if (deptIds.size() > 0) {
            tempUserIdList = this.baseApi.queryUserIdsByDeptIds(deptIds);
            userIds.addAll(tempUserIdList);
        }
        if (userIds.size() > 0 && (list = this.baseApi.queryAllUserByIds(ids = userIds.toArray(new String[userIds.size()]))) != null && list.size() > 0) {
            for (UserAccountInfo u : list) {
                usernames.add(u.getUsername());
            }
        }
        if (usernames.size() > 0) {
            String result = String.join((CharSequence)",", usernames);
            return result;
        }
        return null;
    }
}

