/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.process.adapter.delegate.datahandle;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.JavaDelegate;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.query.MatchTypeEnum;
import org.jeecg.common.system.query.QueryCondition;
import org.jeecg.common.system.query.QueryRuleEnum;
import org.jeecg.common.system.vo.SysDepartModel;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.extbpm.process.adapter.delegate.datahandle.base.BaseDataDelegate;
import org.jeecg.modules.extbpm.process.common.WorkFlowGlobals;
import org.jeecg.modules.minides.enums.FormTableTypeEnums;
import org.jeecg.modules.minides.enums.GetDataTypeEnums;
import org.jeecg.modules.online.desform.entity.DesignFormData;
import org.jeecg.modules.online.desform.vo.query.DesformSuperQuery;
import org.jeecg.modules.online.desform.vo.query.SuperQueryItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Scope(value="prototype")
@Component(value="getUserDeptRoleOneDelegate")
public class GetUserDeptRoleOneDelegate
extends BaseDataDelegate
implements JavaDelegate {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GetUserDeptRoleOneDelegate.class);
    @Autowired
    private ISysBaseAPI sysBaseAPI;

    public void execute(DelegateExecution delegateExecution) {
        log.info("---------\u8fdb\u5165\u3010\u6d41\u7a0b\u6570\u636e\u8282\u70b9# \u83b7\u53d6\u5355\u4e2a\u7528\u6237/\u89d2\u8272/\u90e8\u95e8\u3011 GetUserDeptRoleOneDelegate-----------");
        try {
            boolean init = this.init(delegateExecution);
            if (init) {
                List<String> dataIds = new ArrayList<String>();
                String formTableSourceTaskId = this.childAttr.getFormTableSourceTaskId();
                String formTableSourceNodeType = this.childAttr.getFormTableSourceNodeType();
                Integer selectType = oConvertUtils.getInt((Object)this.childAttr.getSelectType(), (int)1);
                String tenantId = this.childAttr.getTenantId();
                Boolean hasData = false;
                if (StringUtils.isNotEmpty((CharSequence)formTableSourceNodeType) && (selectType.equals(1) || selectType.equals(2) || selectType.equals(3))) {
                    String dataId;
                    if (FormTableTypeEnums.table.name().equals(formTableSourceNodeType)) {
                        dataId = (String)delegateExecution.getVariable(WorkFlowGlobals.BPM_DATA_ID, String.class);
                        if (StringUtil.isNotEmpty((String)dataId)) {
                            dataIds.add(dataId);
                        }
                    } else if (FormTableTypeEnums.plus.name().equals(formTableSourceNodeType)) {
                        formDataSourceKey = MessageFormat.format("flow:task:form_data:{0}:{1}", this.processInstanceId, formTableSourceTaskId);
                        String dataId2 = (String)delegateExecution.getVariable(formDataSourceKey, String.class);
                        if (StringUtil.isNotEmpty((String)dataId2)) {
                            dataIds.add(dataId2);
                        }
                    } else if (FormTableTypeEnums.search.name().equals(formTableSourceNodeType)) {
                        formDataSourceKey = MessageFormat.format("flow:task:get_data:{0}:{1}", this.processInstanceId, formTableSourceTaskId);
                        String dataId3 = (String)delegateExecution.getVariable(formDataSourceKey, String.class);
                        if (StringUtil.isNotEmpty((String)dataId3)) {
                            dataIds.add(dataId3);
                        }
                    } else if (FormTableTypeEnums.getMore.name().equals(formTableSourceNodeType)) {
                        List records;
                        String dataKey;
                        Integer getDataType = this.childAttr.getFormTableSourceGetDataType();
                        String formDataSourceKey = MessageFormat.format("flow:task:get_data:{0}:{1}", this.processInstanceId, formTableSourceTaskId);
                        if (GetDataTypeEnums.from_redis.getType().equals(getDataType) && StringUtil.isNotEmpty((String)(dataKey = (String)delegateExecution.getVariable(formDataSourceKey, String.class))) && ObjectUtils.isNotEmpty((Object)(records = (List)this.redisUtil.get(dataKey)))) {
                            dataIds = records.stream().map(DesignFormData::getId).collect(Collectors.toList());
                        }
                        if (GetDataTypeEnums.from_db.getType().equals(getDataType)) {
                            dataIds = (List)delegateExecution.getVariable(formDataSourceKey, List.class);
                        }
                    } else if (FormTableTypeEnums.subEvent.name().equals(formTableSourceNodeType) && StringUtil.isNotEmpty((String)(dataId = (String)delegateExecution.getVariable(WorkFlowGlobals.BPM_DATA_ID, String.class)))) {
                        dataIds.add(dataId);
                    }
                    if (ObjectUtils.isNotEmpty(dataIds)) {
                        String formTableCode = this.childAttr.getFormTableCode();
                        if (selectType.equals(1)) {
                            hasData = this.getUserData(formTableCode, dataIds);
                        }
                        if (selectType.equals(2)) {
                            hasData = this.getDeptData(formTableCode, dataIds, tenantId);
                        }
                        if (selectType.equals(3)) {
                            hasData = this.getRoleData(formTableCode, dataIds, tenantId);
                        }
                    }
                } else {
                    if (selectType.equals(4)) {
                        hasData = this.getUserData(tenantId);
                    }
                    if (selectType.equals(5)) {
                        hasData = this.getDepartList(null, tenantId);
                    }
                    if (selectType.equals(6)) {
                        hasData = this.getRoleList(null, tenantId);
                    }
                }
                if (!hasData.booleanValue()) {
                    log.info("---\u3010\u6d41\u7a0b\u6570\u636e\u8282\u70b9# \u83b7\u53d6\u5355\u4e2a\u7528\u6237/\u89d2\u8272/\u90e8\u95e8\u3011---------\u672a\u83b7\u53d6\u5230\u6570\u636e--------------");
                    delegateExecution.setVariable("flow_has_data", (Object)0);
                    this.noDataExecute();
                }
            }
        }
        catch (Exception exception) {
            log.error("\u6d41\u7a0b\u9519\u8bef", (Throwable)exception);
            super.handleException(exception);
        }
    }

    private Boolean getUserData(String formTableCode, List<String> dataIds) {
        Boolean hasData = false;
        String[] userFormTableField = this.childAttr.getUserFormTableField();
        ArrayList<String> userNames = new ArrayList();
        if (ObjectUtils.isNotEmpty((Object)userFormTableField)) {
            for (String dataId : dataIds) {
                DesignFormData designFormData = this.designFormDataService.getById(formTableCode, dataId);
                if (!ObjectUtils.isNotEmpty((Object)designFormData)) continue;
                JSONObject jsonObject = designFormData.getDesformData();
                for (String field : userFormTableField) {
                    Object object = jsonObject.get((Object)field);
                    if (object instanceof JSONArray) {
                        JSONArray jsonArray = (JSONArray)object;
                        List ids = jsonArray.toJavaList(String.class);
                        userNames.addAll(ids);
                        continue;
                    }
                    userNames.add(object.toString());
                }
            }
            if (ObjectUtils.isNotEmpty(userNames)) {
                userNames = userNames.stream().distinct().collect(Collectors.toList());
                hasData = this.getUserList(userNames, null);
            }
        }
        return hasData;
    }

    private Boolean getDeptData(String formTableCode, List<String> dataIds, String tenantId) {
        Boolean hasData = false;
        String[] deptFormTableField = this.childAttr.getDeptFormTableField();
        ArrayList<String> deptIds = new ArrayList();
        if (ObjectUtils.isNotEmpty((Object)deptFormTableField)) {
            for (String dataId : dataIds) {
                DesignFormData designFormData = this.designFormDataService.getById(formTableCode, dataId);
                if (!ObjectUtils.isNotEmpty((Object)designFormData)) continue;
                JSONObject jsonObject = designFormData.getDesformData();
                for (String field : deptFormTableField) {
                    Object object = jsonObject.get((Object)field);
                    if (!(object instanceof JSONArray)) continue;
                    JSONArray jsonArray = (JSONArray)object;
                    List ids = jsonArray.toJavaList(String.class);
                    deptIds.addAll(ids);
                }
            }
            if (ObjectUtils.isNotEmpty(deptIds)) {
                deptIds = deptIds.stream().distinct().collect(Collectors.toList());
                hasData = this.getDepartList(deptIds, tenantId);
            }
        }
        return hasData;
    }

    private Boolean getRoleData(String formTableCode, List<String> dataIds, String tenantId) {
        Boolean hasData = false;
        String[] deptFormTableField = this.childAttr.getRoleFormTableField();
        ArrayList<String> roleCodes = new ArrayList();
        if (ObjectUtils.isNotEmpty((Object)deptFormTableField)) {
            for (String dataId : dataIds) {
                DesignFormData designFormData = this.designFormDataService.getById(formTableCode, dataId);
                if (!ObjectUtils.isNotEmpty((Object)designFormData)) continue;
                JSONObject jsonObject = designFormData.getDesformData();
                for (String field : deptFormTableField) {
                    Object object = jsonObject.get((Object)field);
                    if (!(object instanceof JSONArray)) continue;
                    JSONArray jsonArray = (JSONArray)object;
                    List ids = jsonArray.toJavaList(String.class);
                    roleCodes.addAll(ids);
                }
            }
            if (ObjectUtils.isNotEmpty(roleCodes)) {
                roleCodes = roleCodes.stream().distinct().collect(Collectors.toList());
                hasData = this.getRoleList(roleCodes, tenantId);
            }
        }
        return hasData;
    }

    private Boolean getUserData(String tenantId) {
        List userIds = this.sysBaseAPI.selectUserIdByTenantId(tenantId);
        return this.getUserList(null, userIds);
    }

    private Boolean getRoleList(List<String> roleCodes, String tenantId) {
        QueryCondition superQueryItem;
        boolean hasData = false;
        DesformSuperQuery desformSuperQuery = this.initFormSuperQuery();
        MatchTypeEnum matchType = ObjectUtils.isEmpty((Object)desformSuperQuery.getMatchType()) ? MatchTypeEnum.AND : desformSuperQuery.getMatchType();
        ArrayList<QueryCondition> conditions = new ArrayList<QueryCondition>();
        for (SuperQueryItem item : desformSuperQuery.getQueryItems()) {
            QueryCondition superQueryItem2 = new QueryCondition(item.getField(), item.getType(), null, item.getRule().getValue(), item.getVal());
            conditions.add(superQueryItem2);
        }
        if (ObjectUtils.isNotEmpty(roleCodes)) {
            superQueryItem = new QueryCondition("roleCode", "input", null, QueryRuleEnum.IN.getValue(), StringUtils.join(roleCodes, (String)","));
            conditions.add(superQueryItem);
        }
        if (ObjectUtils.isNotEmpty((Object)tenantId)) {
            superQueryItem = new QueryCondition("tenantId", "input", null, QueryRuleEnum.EQ.getValue(), tenantId);
            conditions.add(superQueryItem);
        }
        try {
            String superQueryParams = URLEncoder.encode(JSONObject.toJSONString(conditions), "UTF-8");
            List list = this.sysBaseAPI.queryRoleBySuperQuery(superQueryParams, matchType.getValue());
            if (ObjectUtils.isNotEmpty((Object)list)) {
                hasData = true;
                JSONObject roleJSON = (JSONObject)list.get(0);
                String processVariableKey = MessageFormat.format("flow:task:get_data:{0}:{1}", this.processInstanceId, this.activityId);
                this.delegateExecution.setVariable(processVariableKey, (Object)roleJSON);
                this.delegateExecution.setVariable("flow_has_data", (Object)1);
                log.info("---\u3010\u6d41\u7a0b\u6570\u636e\u8282\u70b9# \u83b7\u53d6\u5355\u4e2a\u89d2\u8272\u3011---------\u89d2\u8272\u4fe1\u606f\u5b58\u50a8\u5230\u6d41\u7a0b\u53d8\u91cf\uff0cprocessVariableKey={}\uff0croleJSON={} ", (Object)processVariableKey, (Object)roleJSON);
            }
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException(e2);
        }
        return hasData;
    }

    private Boolean getDepartList(List<String> deptIds, String tenantId) {
        QueryCondition superQueryItem;
        boolean hasData = false;
        DesformSuperQuery desformSuperQuery = this.initFormSuperQuery();
        MatchTypeEnum matchType = ObjectUtils.isEmpty((Object)desformSuperQuery.getMatchType()) ? MatchTypeEnum.AND : desformSuperQuery.getMatchType();
        ArrayList<QueryCondition> conditions = new ArrayList<QueryCondition>();
        for (SuperQueryItem item : desformSuperQuery.getQueryItems()) {
            QueryCondition superQueryItem2 = new QueryCondition(item.getField(), item.getType(), null, item.getRule().getValue(), item.getVal());
            conditions.add(superQueryItem2);
        }
        if (ObjectUtils.isNotEmpty(deptIds)) {
            superQueryItem = new QueryCondition("id", "input", null, QueryRuleEnum.IN.getValue(), StringUtils.join(deptIds, (String)","));
            conditions.add(superQueryItem);
        }
        superQueryItem = new QueryCondition("tenantId", "input", null, QueryRuleEnum.EQ.getValue(), tenantId);
        conditions.add(superQueryItem);
        try {
            String superQueryParams = URLEncoder.encode(JSONObject.toJSONString(conditions), "UTF-8");
            List list = this.sysBaseAPI.queryDeptBySuperQuery(superQueryParams, matchType.getValue());
            if (ObjectUtils.isNotEmpty((Object)list)) {
                hasData = true;
                JSONObject departamentJSON = (JSONObject)list.get(0);
                this.addDepartUsers(departamentJSON);
                String processVariableKey = MessageFormat.format("flow:task:get_data:{0}:{1}", this.processInstanceId, this.activityId);
                this.delegateExecution.setVariable(processVariableKey, (Object)departamentJSON);
                this.delegateExecution.setVariable("flow_has_data", (Object)1);
                log.info("---\u3010\u6d41\u7a0b\u6570\u636e\u8282\u70b9# \u83b7\u53d6\u5355\u4e2a\u90e8\u95e8\u3011---------\u90e8\u95e8\u4fe1\u606f\u5b58\u50a8\u6d41\u7a0b\u53d8\u91cf\uff0cprocessVariableKey={}\uff0cdepartamentJSON={}", (Object)processVariableKey, (Object)departamentJSON);
            }
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException(e2);
        }
        return hasData;
    }

    private void addDepartUsers(JSONObject departamentJSON) {
        String orgId = departamentJSON.getString("id");
        if (oConvertUtils.isNotEmpty((Object)orgId)) {
            String userIds;
            List userList;
            ArrayList<String> orgIdList = new ArrayList<String>();
            orgIdList.add(orgId);
            List userIdList = this.sysBaseAPI.queryUserIdsByDeptIds(orgIdList);
            if (userIdList != null && userIdList.size() > 0 && (userList = this.sysBaseAPI.queryUsersByIds(userIds = String.join((CharSequence)",", userIdList))) != null && userList.size() > 0) {
                List orgPerson = userList.stream().map(item -> item.getString("username")).collect(Collectors.toList());
                departamentJSON.put("orgPerson", orgPerson);
            }
            List deptHeaderUserNames = this.sysBaseAPI.getDeptHeadByDepId(orgId);
            departamentJSON.put("departHeaders", (Object)deptHeaderUserNames);
            SysDepartModel sysDepartModel = this.sysBaseAPI.selectAllById(orgId);
            if (sysDepartModel != null) {
                List orgAndSubPerson = this.sysBaseAPI.getUserAccountsByDepCode(sysDepartModel.getOrgCode());
                departamentJSON.put("orgAndSubPerson", (Object)orgAndSubPerson);
            }
        }
    }

    private Boolean getUserList(List<String> userNames, List<String> userIds) {
        QueryCondition superQueryItem;
        boolean hasData = false;
        DesformSuperQuery desformSuperQuery = this.initFormSuperQuery();
        ArrayList<QueryCondition> conditions = new ArrayList<QueryCondition>();
        MatchTypeEnum matchType = ObjectUtils.isEmpty((Object)desformSuperQuery.getMatchType()) ? MatchTypeEnum.AND : desformSuperQuery.getMatchType();
        for (SuperQueryItem item : desformSuperQuery.getQueryItems()) {
            QueryCondition superQueryItem2 = new QueryCondition(item.getField(), item.getType(), null, item.getRule().getValue(), item.getVal());
            conditions.add(superQueryItem2);
        }
        if (ObjectUtils.isNotEmpty(userNames)) {
            superQueryItem = new QueryCondition("username", "input", null, QueryRuleEnum.IN.getValue(), StringUtils.join(userNames, (String)","));
            conditions.add(superQueryItem);
        }
        if (ObjectUtils.isNotEmpty(userIds)) {
            superQueryItem = new QueryCondition("id", "input", null, QueryRuleEnum.IN.getValue(), StringUtils.join(userIds, (String)","));
            conditions.add(superQueryItem);
        }
        try {
            String superQueryParams = URLEncoder.encode(JSONObject.toJSONString(conditions), "UTF-8");
            List list = this.sysBaseAPI.queryUserBySuperQuery(superQueryParams, matchType.getValue());
            if (ObjectUtils.isNotEmpty((Object)list)) {
                hasData = true;
                JSONObject userInfoJSON = (JSONObject)list.get(0);
                String processVariableKey = MessageFormat.format("flow:task:get_data:{0}:{1}", this.processInstanceId, this.activityId);
                this.delegateExecution.setVariable(processVariableKey, (Object)userInfoJSON);
                this.delegateExecution.setVariable("flow_has_data", (Object)1);
                log.info("---\u3010\u6d41\u7a0b\u6570\u636e\u8282\u70b9# \u83b7\u53d6\u5355\u4e2a\u7528\u6237\u3011---------\u7528\u6237\u4fe1\u606f\u5b58\u50a8\u5230\u6d41\u7a0b\u53d8\u91cf\uff0cprocessVariableKey={}\uff0cuserInfoJSON = {}", (Object)processVariableKey, (Object)userInfoJSON);
            }
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException(e2);
        }
        return hasData;
    }
}

