/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.util;

import java.io.InputStream;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang.StreamUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.Execution;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.bpm.service.ActivitiService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="countersignCheckUtils")
public class c {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(c.class);
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired
    protected RuntimeService runtimeService;
    @Autowired
    private ActivitiService activitiService;
    @Autowired
    protected TaskService taskService;

    public boolean a(String taskId) {
        try {
            Task task = this.activitiService.getTask(taskId);
            String processInstanceId = task.getProcessInstanceId();
            boolean isCurrentNodeMultiInstance = this.b(taskId);
            if (isCurrentNodeMultiInstance) {
                if (this.a(processInstanceId, task.getTaskDefinitionKey(), taskId)) {
                    a.info("\u3010\u4f1a\u7b7e\u68c0\u67e5\u3011\u5f53\u524d\u662f\u4f1a\u7b7e\u8282\u70b9\u7684\u6700\u540e\u4e00\u4e2a\u5b9e\u4f8b\uff0c\u9700\u8981\u63d0\u793a\u7528\u6237\u9009\u62e9\u4f1a\u7b7e\u4eba\u5458\uff01");
                    return true;
                }
                a.info("\u3010\u4f1a\u7b7e\u68c0\u67e5\u3011\u4f1a\u7b7e\u8282\u70b9\u4e2d\u95f4\u5b9e\u4f8b\uff0c\u8df3\u8fc7\u4e0b\u4e00\u8282\u70b9\u68c0\u67e5");
            }
            return false;
        }
        catch (Exception e2) {
            a.error("\u3010\u4f1a\u7b7e\u9a8c\u8bc1\u3011\u68c0\u67e5\u4f1a\u7b7e\u8282\u70b9\u5904\u7406\u4eba\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e2);
            return false;
        }
    }

    private boolean a(String processInstanceId, String activityId, String currentTaskId) {
        try {
            List execs = this.runtimeService.createExecutionQuery().processInstanceId(processInstanceId).activityId(activityId).list();
            if (execs == null || execs.isEmpty()) {
                a.info("\u3010\u4f1a\u7b7e\u68c0\u67e5\u3011\u672a\u627e\u5230\u6d3b\u52a8\u6267\u884c activityId={}", (Object)activityId);
                return false;
            }
            Execution any = (Execution)execs.get(0);
            Execution parent = any.getParentId() == null ? null : (Execution)this.runtimeService.createExecutionQuery().executionId(any.getParentId()).singleResult();
            String varScopeExecId = parent != null ? parent.getId() : any.getId();
            Integer nrOfInstances = this.c(varScopeExecId, "nrOfInstances");
            Integer nrOfActiveInstances = this.c(varScopeExecId, "nrOfActiveInstances");
            Integer nrOfCompletedInstances = this.c(varScopeExecId, "nrOfCompletedInstances");
            List activeTasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).taskDefinitionKey(activityId)).list();
            int otherActiveCount = (int)activeTasks.stream().filter(t -> !t.getId().equals(currentTaskId)).count();
            int afterActive = nrOfActiveInstances == null ? -1 : nrOfActiveInstances - 1;
            boolean lastByActiveZero = afterActive == 0;
            double threshold = this.b(processInstanceId, activityId);
            if (threshold <= 0.0 || threshold > 1.0) {
                threshold = 1.0;
            }
            boolean ratioReach = false;
            if (nrOfInstances != null && nrOfCompletedInstances != null && nrOfInstances > 0) {
                double afterRatio = ((double)nrOfCompletedInstances.intValue() + 1.0) / (double)nrOfInstances.intValue();
                ratioReach = afterRatio >= threshold;
            }
            boolean lastByQuery = otherActiveCount == 0;
            boolean isLast = lastByActiveZero || ratioReach || lastByQuery;
            a.info("\u3010\u4f1a\u7b7e\u68c0\u67e5\u3011activityId={} \u603b={} \u6d3b\u8dc3={} \u5b8c\u6210={} afterActive={} \u9608\u503c={} ratioReach={} otherActive={} \u5224\u5b9a={}", new Object[]{activityId, nrOfInstances, nrOfActiveInstances, nrOfCompletedInstances, afterActive, threshold, ratioReach, otherActiveCount, isLast});
            return isLast;
        }
        catch (Exception e2) {
            a.error("\u3010\u4f1a\u7b7e\u68c0\u67e5\u3011\u5224\u5b9a\u6700\u540e\u4e00\u4e2a\u4f1a\u7b7e\u5b9e\u4f8b\u5f02\u5e38\uff0c\u8fd4\u56de false", (Throwable)e2);
            return false;
        }
    }

    private double b(String processInstanceId, String activityId) {
        try {
            ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            if (pi == null) {
                return 1.0;
            }
            BpmnModel model = this.repositoryService.getBpmnModel(pi.getProcessDefinitionId());
            FlowElement fe = model.getMainProcess().getFlowElement(activityId, true);
            if (!(fe instanceof UserTask)) {
                return 1.0;
            }
            UserTask ut = (UserTask)fe;
            if (ut.getLoopCharacteristics() == null || ut.getLoopCharacteristics().getCompletionCondition() == null) {
                return 1.0;
            }
            String completionCondition = ut.getLoopCharacteristics().getCompletionCondition();
            String expr = null;
            if (completionCondition instanceof Expression) {
                expr = ((Expression)completionCondition).getExpressionText();
            } else if (completionCondition instanceof String) {
                expr = completionCondition;
            }
            if (expr == null) {
                return 1.0;
            }
            String normalized = expr.replaceAll("\\s+", "");
            Matcher m2 = Pattern.compile("nrOfCompletedInstances/nrOfInstances(>=|>)([0-9]*\\.?[0-9]+)").matcher(normalized);
            if (m2.find()) {
                return Double.parseDouble(m2.group(2));
            }
            m2 = Pattern.compile("nrOfCompletedInstances(>=|>)nrOfInstances\\*([0-9]*\\.?[0-9]+)").matcher(normalized);
            if (m2.find()) {
                return Double.parseDouble(m2.group(2));
            }
            return 1.0;
        }
        catch (Exception e2) {
            a.warn("\u3010\u4f1a\u7b7e\u68c0\u67e5\u3011\u89e3\u6790 completionCondition \u5931\u8d25\uff0c\u4f7f\u7528\u9ed8\u8ba4 1", (Throwable)e2);
            return 1.0;
        }
    }

    private Integer c(String execId, String varName) {
        Object v = this.runtimeService.getVariable(execId, varName);
        if (v instanceof Number) {
            return ((Number)v).intValue();
        }
        try {
            return v == null ? null : Integer.valueOf(Integer.parseInt(v.toString()));
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public boolean b(String taskId) {
        if (oConvertUtils.isEmpty((Object)taskId)) {
            return false;
        }
        Task task = this.activitiService.getTask(taskId);
        String processkey = task.getProcessDefinitionId();
        ProcessDefinition pd = this.repositoryService.getProcessDefinition(processkey);
        InputStream resourceAsStream = this.repositoryService.getResourceAsStream(pd.getDeploymentId(), pd.getResourceName());
        String xmlString = StreamUtils.InputStreamTOString((InputStream)resourceAsStream);
        return org.jeecg.modules.bpm.c.c.a(xmlString, task.getTaskDefinitionKey());
    }

    public boolean a(String processDefinitionId, String nodeKey) {
        if (oConvertUtils.isEmpty((Object)nodeKey)) {
            return false;
        }
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
        if (bpmnModel == null) {
            return false;
        }
        FlowElement fe = bpmnModel.getMainProcess().getFlowElement(nodeKey, true);
        if (fe == null) {
            return false;
        }
        return !(fe instanceof UserTask);
    }
}

