/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.listener.task;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.delegate.TaskListener;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.service.delegate.DelegateTask;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.modules.bpm.service.ActivitiService;
import org.jeecg.modules.extbpm.process.entity.ExtActBpmLog;
import org.jeecg.modules.extbpm.process.service.IExtActBpmLogService;

public class TaskCreatedAutoSubmitListener
implements TaskListener {
    private static final long serialVersionUID = 1L;
    private static ISysBaseAPI sysBaseAPI = (ISysBaseAPI)SpringContextUtils.getBean(ISysBaseAPI.class);
    private static IExtActBpmLogService extActBpmLogService = (IExtActBpmLogService)SpringContextUtils.getBean(IExtActBpmLogService.class);
    protected static RuntimeService runtimeService = (RuntimeService)SpringContextUtils.getBean(RuntimeService.class);
    private static ActivitiService activitiService = (ActivitiService)SpringContextUtils.getBean(ActivitiService.class);
    private static TaskService taskService = (TaskService)SpringContextUtils.getBean(TaskService.class);

    public void notify(DelegateTask delegateTask) {
        try {
            this.onCreate(delegateTask);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void onCreate(DelegateTask delegateTask) throws Exception {
        FlowElement firstElement = this.findFirstFlowElement(delegateTask);
        if (!firstElement.getId().equals(delegateTask.getTaskDefinitionKey())) {
            return;
        }
        List<Map<String, Object>> histListNode = activitiService.getHistTaskNodeList(delegateTask.getProcessInstanceId());
        if (histListNode != null && histListNode.size() > 0) {
            return;
        }
        String applyUserId = (String)delegateTask.getVariable("applyUserId");
        taskService.setAssignee(delegateTask.getId(), applyUserId);
        taskService.complete(delegateTask.getId(), delegateTask.getVariables());
        String username = JwtUtil.getUserNameByToken((HttpServletRequest)SpringContextUtils.getHttpServletRequest());
        LoginUser user = sysBaseAPI.getUserByName(username);
        String processInstanceId = delegateTask.getProcessInstanceId();
        ProcessInstance processInstance = (ProcessInstance)runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        ExtActBpmLog bpmlog = new ExtActBpmLog();
        if (processInstance != null) {
            bpmlog.setBusinessKey(processInstance.getBusinessKey());
            bpmlog.setProcName(processInstance.getName());
        }
        bpmlog.setOpTime(new Date());
        bpmlog.setOpUserId(username);
        if (user != null) {
            bpmlog.setOpUserName(user.getRealname());
        }
        bpmlog.setProcInstId(processInstanceId);
        bpmlog.setRemarks("\u7cfb\u7edf\u81ea\u52a8\u5b8c\u6210");
        bpmlog.setTaskDefKey(delegateTask.getTaskDefinitionKey());
        bpmlog.setTaskId(delegateTask.getId());
        bpmlog.setTaskName(delegateTask.getName());
        extActBpmLogService.save(bpmlog);
    }

    public RepositoryService getRepositoryService() {
        return (RepositoryService)SpringContextUtils.getBean(RepositoryService.class);
    }

    private FlowElement findFirstFlowElement(DelegateTask taskEntity) {
        RepositoryService repositoryService = (RepositoryService)SpringContextUtils.getBean(RepositoryService.class);
        BpmnModel bpmnModel = repositoryService.getBpmnModel(taskEntity.getProcessDefinitionId());
        for (FlowElement flowElement : ((Process)bpmnModel.getProcesses().get(0)).getFlowElements()) {
            if (!(flowElement instanceof StartEvent)) continue;
            return bpmnModel.getFlowElement(((SequenceFlow)((StartEvent)flowElement).getOutgoingFlows().get(0)).getTargetRef());
        }
        return null;
    }
}

