/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.listener.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import lombok.Generated;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.JavaDelegate;
import org.jeecg.common.util.RestUtil;
import org.jeecg.modules.extbpm.listener.service.util.VariableParseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;

public class ApiServiceTaskDelegate
implements JavaDelegate {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiServiceTaskDelegate.class);
    public static final String API_SERVICE_TASK_CONFIG = "apiServiceTaskConfig";

    public void execute(DelegateExecution execution) {
        block30: {
            log.info("ApiServiceTaskDelegate \u5df2\u7ecf\u6267\u884c\u5df2\u7ecf\u6267\u884c\uff01");
            try {
                FlowElement flowElement = execution.getCurrentFlowElement();
                JSONObject json = VariableParseUtil.parseTaskExtendJson(flowElement, API_SERVICE_TASK_CONFIG);
                log.info("ApiServiceTaskDelegate \u89e3\u6790\u5230\u7684JSON\u914d\u7f6e\uff1a" + json);
                if (json != null) {
                    Object url = json.getString("apiUrl");
                    String method = json.getString("method");
                    int timeout = json.getIntValue("timeout");
                    int retryCount = json.getIntValue("retryCount");
                    JSONArray inputParamsList = json.getJSONArray("inputParamsList");
                    JSONObject inputParams = new JSONObject();
                    if (inputParamsList != null) {
                        for (int i2 = 0; i2 < inputParamsList.size(); ++i2) {
                            JSONObject param = inputParamsList.getJSONObject(i2);
                            String key = param.getString("key");
                            String value = param.getString("value");
                            Object actualValue = VariableParseUtil.parseVariableValue(value, execution);
                            inputParams.put(key, actualValue != null ? actualValue : "");
                        }
                    }
                    JSONArray headersList = json.getJSONArray("headersList");
                    JSONObject headersJson = new JSONObject();
                    if (headersList != null) {
                        for (int i3 = 0; i3 < headersList.size(); ++i3) {
                            JSONObject header = headersList.getJSONObject(i3);
                            String key = header.getString("key");
                            String value = header.getString("value");
                            Object actualValue = VariableParseUtil.parseVariableValue(value, execution);
                            headersJson.put(key, (Object)(actualValue != null ? actualValue.toString() : ""));
                        }
                    }
                    if (url != null && !((String)url).isEmpty() && !((String)url).startsWith("http")) {
                        Object timestampValue;
                        Object tokenValue;
                        url = ((String)url).startsWith("/") ? RestUtil.getBaseUrl() + (String)url : RestUtil.getBaseUrl() + "/" + (String)url;
                        if (headersJson == null) {
                            headersJson = new JSONObject();
                        }
                        if (!headersJson.containsKey((Object)"X-Access-Token") && (tokenValue = VariableParseUtil.getSystemContextValue("x-access-token")) != null) {
                            headersJson.put("X-Access-Token", (Object)tokenValue.toString());
                            log.info("\u5185\u90e8\u8fde\u63a5\u81ea\u52a8\u6dfb\u52a0\u8bf7\u6c42\u5934: {} = {}", (Object)"X-Access-Token", tokenValue);
                        }
                        if (!headersJson.containsKey((Object)"X-TIMESTAMP") && (timestampValue = VariableParseUtil.getSystemContextValue("x-timestamp")) != null) {
                            headersJson.put("X-TIMESTAMP", (Object)timestampValue.toString());
                            log.info("\u5185\u90e8\u8fde\u63a5\u81ea\u52a8\u6dfb\u52a0\u8bf7\u6c42\u5934: {} = {}", (Object)"X-TIMESTAMP", timestampValue);
                        }
                    }
                    if (url != null && !((String)url).isEmpty()) {
                        JSONArray outputParamsList;
                        boolean apiSuccess = false;
                        String responseBody = "";
                        int responseCode = 0;
                        for (int attempt = 1; attempt <= Math.max(1, retryCount); ++attempt) {
                            try {
                                log.info("API\u8c03\u7528\u5c1d\u8bd5\u7b2c {} \u6b21\uff0cURL: {}", (Object)attempt, url);
                                HttpHeaders headers = new HttpHeaders();
                                if (!headersJson.isEmpty()) {
                                    for (String key : headersJson.keySet()) {
                                        headers.add(key, headersJson.getString(key));
                                    }
                                }
                                HttpMethod httpMethod = HttpMethod.valueOf((String)(method != null ? method.toUpperCase() : "GET"));
                                JSONObject urlParams = null;
                                JSONObject requestBodyParams = null;
                                if ("GET".equals(method) && !inputParams.isEmpty()) {
                                    urlParams = inputParams;
                                } else if (!inputParams.isEmpty() && ("POST".equals(method) || "PUT".equals(method) || "PATCH".equals(method))) {
                                    requestBodyParams = inputParams;
                                }
                                ResponseEntity response = RestUtil.request((String)url, (HttpMethod)httpMethod, (HttpHeaders)headers, (JSONObject)urlParams, (Object)requestBodyParams, String.class, (int)(timeout > 0 ? timeout : 0));
                                responseCode = response.getStatusCodeValue();
                                String responseStr = (String)response.getBody();
                                responseBody = responseStr != null ? responseStr : "";
                                log.info("API\u54cd\u5e94\u72b6\u6001\u7801: {}", (Object)responseCode);
                                log.info("API\u54cd\u5e94\u5185\u5bb9: {}", (Object)responseBody);
                                if (responseCode < 200 || responseCode >= 300) continue;
                                apiSuccess = true;
                                break;
                            }
                            catch (Exception apiEx) {
                                log.error("API\u8c03\u7528\u7b2c {} \u6b21\u5931\u8d25: {}", (Object)attempt, (Object)apiEx.getMessage());
                                if (attempt != Math.max(1, retryCount)) continue;
                                execution.setVariable("apiError", (Object)apiEx.getMessage());
                            }
                        }
                        if ((outputParamsList = json.getJSONArray("outputParamsList")) == null || !apiSuccess) break block30;
                        try {
                            JSONObject responseJson = null;
                            try {
                                responseJson = JSONObject.parseObject((String)responseBody);
                            }
                            catch (Exception jsonEx) {
                                log.warn("\u54cd\u5e94\u4e0d\u662fJSON\u683c\u5f0f\uff0c\u5c06\u4f5c\u4e3a\u666e\u901a\u6587\u672c\u5904\u7406: {}", (Object)jsonEx.getMessage());
                            }
                            for (int i4 = 0; i4 < outputParamsList.size(); ++i4) {
                                JSONObject outputParam = outputParamsList.getJSONObject(i4);
                                String returnApiField = outputParam.getString("key");
                                String inVariableField = outputParam.getString("value");
                                Object extractedValue = null;
                                if (responseJson != null) {
                                    extractedValue = VariableParseUtil.extractJsonFieldValue(responseJson, returnApiField);
                                } else if ("response".equals(returnApiField) || "body".equals(returnApiField) || "responseBody".equals(returnApiField)) {
                                    extractedValue = responseBody;
                                } else if ("status".equals(returnApiField) || "code".equals(returnApiField) || "responseCode".equals(returnApiField)) {
                                    extractedValue = responseCode;
                                }
                                if (extractedValue == null) continue;
                                execution.setVariable(inVariableField, extractedValue);
                                log.info("\u5b58\u5230\u6d41\u7a0b\u53d8\u91cf\u4e2d\u53c2\u6570 -> {} = {}", (Object)inVariableField, extractedValue);
                            }
                            break block30;
                        }
                        catch (Exception parseEx) {
                            log.warn("\u6620\u5c04\u8f93\u51fa\u53c2\u6570\u5931\u8d25: {}", (Object)parseEx.getMessage());
                            break block30;
                        }
                    }
                    log.warn("API URL\u914d\u7f6e\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u63a5\u53e3\u8c03\u7528");
                    break block30;
                }
                log.warn("\u672a\u627e\u5230API\u670d\u52a1\u4efb\u52a1\u914d\u7f6e\uff0c\u8df3\u8fc7\u63a5\u53e3\u8c03\u7528");
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }
}

