/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.desform.vo.excel;

import java.util.List;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.online.desform.vo.widget.DesformCheckRule;
import org.jeecg.modules.online.desform.vo.widget.DesformWidget;

public class ValidateRule {
    public static final String NOT_NULL = "_NOT_NULL";
    public static final String NUM = "_NUM";
    private String pattern;
    private String msg;

    public static ValidateRule notNull(DesformWidget widget) {
        ValidateRule validateRule = new ValidateRule();
        validateRule.setPattern(NOT_NULL);
        validateRule.setMsg(ValidateRule.getWidgetName(widget) + "\u5fc5\u987b\u586b\u5199");
        return validateRule;
    }

    public static ValidateRule getRuleByPattern(String pattern, DesformWidget widget) {
        ValidateRule validateRule = new ValidateRule();
        validateRule.setPattern(pattern);
        List<DesformCheckRule> list = widget.getRules();
        for (DesformCheckRule desformCheckRule : list) {
            if (!pattern.equals(desformCheckRule.getPattern())) continue;
            validateRule.setMsg(ValidateRule.getErrorTip(widget, desformCheckRule.getMessage()));
            break;
        }
        return validateRule;
    }

    public static ValidateRule getNumberRule(DesformWidget widget) {
        ValidateRule validateRule = new ValidateRule();
        validateRule.setPattern(NUM);
        validateRule.setMsg(ValidateRule.getWidgetName(widget) + "\u5fc5\u987b\u662f\u6570\u503c\u7c7b\u578b");
        return validateRule;
    }

    private static String getWidgetName(DesformWidget widget) {
        return "[" + widget.getName() + "]";
    }

    private static String getErrorTip(DesformWidget widget, String message) {
        String string = ValidateRule.getWidgetName(widget);
        if (oConvertUtils.isEmpty((Object)message)) {
            return string + "\u683c\u5f0f\u4e0d\u5339\u914d";
        }
        if (message.indexOf("${title}") >= 0) {
            return message.replace("${title}", string);
        }
        return string + message;
    }

    public boolean isNotNull() {
        return NOT_NULL.equals(this.pattern);
    }

    public boolean isNum() {
        return NUM.equals(this.pattern);
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof ValidateRule)) {
            return false;
        }
        ValidateRule validateRule = (ValidateRule)o2;
        if (!validateRule.canEqual(this)) {
            return false;
        }
        String string = this.getPattern();
        String string2 = validateRule.getPattern();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        String string3 = this.getMsg();
        String string4 = validateRule.getMsg();
        return !(string3 == null ? string4 != null : !string3.equals(string4));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ValidateRule;
    }

    public int hashCode() {
        int n2 = 59;
        int n3 = 1;
        String string = this.getPattern();
        n3 = n3 * 59 + (string == null ? 43 : string.hashCode());
        String string2 = this.getMsg();
        n3 = n3 * 59 + (string2 == null ? 43 : string2.hashCode());
        return n3;
    }

    public String toString() {
        return "ValidateRule(pattern=" + this.getPattern() + ", msg=" + this.getMsg() + ")";
    }
}

