/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.low.c;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.TokenUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.online.low.entity.LowApp;
import org.jeecg.modules.online.low.entity.LowAppBackup;
import org.jeecg.modules.online.low.service.IExportLowAppService;
import org.jeecg.modules.online.low.service.ILowAppBackupService;
import org.jeecg.modules.online.low.service.ILowAppGroupService;
import org.jeecg.modules.online.low.service.ILowAppMenuService;
import org.jeecg.modules.online.low.service.ILowAppService;
import org.jeecg.modules.online.low.vo.JeecgLicVo;
import org.jeecg.modules.online.low.vo.LowAppAndOwnerInfo;
import org.jeecg.modules.online.low.vo.LowAppMenuVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Tag(name="low_app")
@RestController(value="lowAppController")
@RequestMapping(value={"/online/lowApp"})
public class c
extends JeecgController<LowApp, ILowAppService> {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(c.class);
    @Autowired
    private ILowAppService lowAppService;
    @Autowired
    private ILowAppMenuService lowAppMenuService;
    @Autowired
    private ILowAppGroupService lowAppGroupService;
    @Autowired
    private ILowAppBackupService lowAppBackupService;
    @Autowired
    public RedisTemplate redisTemplate;
    @Autowired
    public IExportLowAppService exportLowAppService;

    @GetMapping(value={"/list"})
    public Result a(LowApp lowApp, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)lowApp, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.lowAppService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.OK((Object)pageList);
    }

    @GetMapping(value={"/listByGroup"})
    public Result a(LowApp lowApp, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)lowApp, (Map)req.getParameterMap());
        queryWrapper.orderByDesc((Object)"app_label");
        queryWrapper.orderByAsc((Object)"order_num");
        queryWrapper.orderByDesc((Object)"create_time");
        List list = this.lowAppService.list((Wrapper)queryWrapper);
        ArrayList<LowApp> noneChildren = new ArrayList<LowApp>();
        HashMap map = new HashMap(5);
        for (LowApp data : list) {
            String appLabel = data.getAppLabel();
            if (oConvertUtils.isNotEmpty((Object)appLabel)) {
                if (map.containsKey(appLabel)) {
                    ((List)map.get(appLabel)).add(data);
                    continue;
                }
                ArrayList<LowApp> children = new ArrayList<LowApp>();
                children.add(data);
                map.put(appLabel, children);
                continue;
            }
            noneChildren.add(data);
        }
        JSONArray groupList = new JSONArray();
        JSONArray labelList = new JSONArray();
        for (String key : map.keySet()) {
            labelList.add((Object)key);
            JSONObject groupItem = new JSONObject();
            groupItem.put("label", (Object)key);
            groupItem.put("list", map.get(key));
            groupList.add((Object)groupItem);
        }
        if (noneChildren.size() > 0) {
            JSONObject groupItem = new JSONObject();
            groupItem.put("label", (Object)"\u65e0\u5206\u7ec4");
            groupItem.put("list", noneChildren);
            groupList.add((Object)groupItem);
        }
        JSONObject res = new JSONObject();
        res.put("groupList", (Object)groupList);
        res.put("labelList", (Object)labelList);
        return Result.OK((Object)res);
    }

    @PostMapping(value={"/add"})
    public Result a(@RequestBody LowApp lowApp) {
        String id = this.lowAppService.createApp(lowApp);
        Result res = Result.OK((String)"\u6dfb\u52a0\u6210\u529f\uff01");
        res.setResult((Object)id);
        return res;
    }

    @PutMapping(value={"/edit"})
    public Result b(@RequestBody LowApp lowApp) {
        this.lowAppService.updateById(lowApp);
        return Result.OK((String)"\u7f16\u8f91\u6210\u529f!");
    }

    @PutMapping(value={"/editNameAndIcon"})
    public Result c(@RequestBody LowApp lowApp) {
        String id = lowApp.getId();
        LowApp data = (LowApp)this.lowAppService.getById((Serializable)((Object)id));
        if (data != null) {
            data.setAppName(lowApp.getAppName());
            data.setIconType(lowApp.getIconType());
            this.lowAppService.updateById(data);
        }
        return Result.OK((String)"\u7f16\u8f91\u6210\u529f!");
    }

    @PutMapping(value={"/groupRename"})
    public Result a(@RequestBody JSONObject payload) {
        String newLabel = payload.getString("newLabel");
        String oldLabel = payload.getString("oldLabel");
        if (oConvertUtils.isEmpty((Object)newLabel) || oConvertUtils.isEmpty((Object)newLabel)) {
            return Result.error((String)"\u5206\u7ec4\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(LowApp::getAppLabel, (Object)oldLabel);
        LowApp lowApp = new LowApp();
        lowApp.setAppLabel(newLabel);
        this.lowAppService.update(lowApp, (Wrapper)queryWrapper);
        return Result.OK((String)"\u91cd\u547d\u540d\u6210\u529f");
    }

    @PostMapping(value={"/moveToGroup"})
    public Result d(@RequestBody LowApp lowApp) {
        this.lowAppService.moveToGroup(lowApp);
        return Result.OK((String)"\u79fb\u52a8\u6210\u529f\uff01");
    }

    @PutMapping(value={"/editBatch"})
    public Result a(@RequestBody List<LowApp> lowAppList) {
        this.lowAppService.updateBatchById(lowAppList);
        return Result.OK((String)"\u6279\u91cf\u7f16\u8f91\u6210\u529f\uff01");
    }

    @AutoLog(value="low_app-\u901a\u8fc7id\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result a(@RequestParam(name="id") String id) {
        LowApp lowApp = (LowApp)this.lowAppService.getById((Serializable)((Object)id));
        if (lowApp == null) {
            return Result.error((String)"\u5e94\u7528\u4e0d\u5b58\u5728\uff01");
        }
        String ownerId = lowApp.getOwnerId();
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        if (!user.getId().equals(ownerId)) {
            return Result.error((String)"\u8be5\u5e94\u7528\u62e5\u6709\u8005\u4e0d\u662f\u5f53\u524d\u60a8,\u65e0\u6743\u5220\u9664\uff01");
        }
        try {
            lowApp.setDeleteInfo(user.getUsername());
            this.lowAppService.deleteLowAppLogically(lowApp);
        }
        catch (Exception e2) {
            a.error(e2.getMessage());
            return Result.error((String)"\u5220\u9664\u5931\u8d25");
        }
        return Result.OK((String)"\u5220\u9664\u6210\u529f!");
    }

    @AutoLog(value="low_app-\u901a\u8fc7id\u4ece\u56de\u6536\u7ad9\u6062\u590d\u6570\u636e")
    @GetMapping(value={"/restore"})
    public Result b(@RequestParam(name="id") String id) {
        LowApp lowApp = (LowApp)this.lowAppService.getById((Serializable)((Object)id));
        if (lowApp == null) {
            return Result.error((String)"\u5e94\u7528\u4e0d\u5b58\u5728\uff01");
        }
        lowApp.setDelFlag(0);
        this.lowAppService.updateById(lowApp);
        return Result.OK((String)"\u64cd\u4f5c\u6210\u529f!");
    }

    @AutoLog(value="low_app-\u901a\u8fc7id\u4ece\u5f7b\u5e95\u5220\u9664\u5e94\u7528")
    @DeleteMapping(value={"/deleteCompletely"})
    public Result<?> c(@RequestParam(name="id") String id) throws Exception {
        LowApp lowApp = (LowApp)this.lowAppService.getById((Serializable)((Object)id));
        if (lowApp == null) {
            return Result.error((String)"\u5e94\u7528\u4e0d\u5b58\u5728\uff01");
        }
        String ownerId = lowApp.getOwnerId();
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        if (!user.getId().equals(ownerId)) {
            return Result.error((String)"\u8be5\u5e94\u7528\u62e5\u6709\u8005\u4e0d\u662f\u5f53\u524d\u60a8\uff0c\u65e0\u6743\u5220\u9664\uff01");
        }
        this.lowAppService.deleteLowApp(lowApp);
        return Result.OK((String)"\u64cd\u4f5c\u6210\u529f!");
    }

    @AutoLog(value="low_app-\u6279\u91cf\u5220\u9664")
    @DeleteMapping(value={"/deleteBatch"})
    public Result d(@RequestParam(name="ids") String ids) {
        this.lowAppService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK((String)"\u6279\u91cf\u5220\u9664\u6210\u529f!");
    }

    @GetMapping(value={"/queryById"})
    public Result e(@RequestParam(name="id") String id) {
        LowApp lowApp = (LowApp)this.lowAppService.getById((Serializable)((Object)id));
        if (lowApp == null) {
            return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e");
        }
        return Result.OK((Object)lowApp);
    }

    @GetMapping(value={"/queryDetail"})
    public Result<?> f(@RequestParam(name="id") String id) {
        String keyString = String.format("sys:cache:lowapp:app_info::%s", id);
        if (this.redisTemplate.hasKey((Object)keyString).booleanValue()) {
            a.info("[LowAppp Redis] \u901a\u8fc7Redis\u7f13\u5b58\u67e5\u8be2\u5e94\u7528\u7684\u914d\u7f6e\uff0cid={}", (Object)id);
            JSONObject json = (JSONObject)this.redisTemplate.opsForValue().get((Object)keyString);
            return Result.OK((Object)json);
        }
        a.info("[LowAppp DB] \u901a\u8fc7\u6570\u636e\u5e93\u67e5\u8be2\u5e94\u7528\u7684\u914d\u7f6e\uff0cid={}", (Object)id);
        LowApp lowApp = (LowApp)this.lowAppService.getById((Serializable)((Object)id));
        if (lowApp == null) {
            return Result.error((int)404, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e");
        }
        List<LowAppMenuVo> menuList = this.lowAppMenuService.listAndChildren(id);
        JSONObject json = new JSONObject();
        json.put("record", (Object)lowApp);
        json.put("menuList", menuList);
        this.redisTemplate.opsForValue().set((Object)keyString, (Object)json, 10L, TimeUnit.SECONDS);
        return Result.OK((Object)json);
    }

    @GetMapping(value={"/queryDetailForShare"})
    public Result<?> g(@RequestParam(name="id") String id) {
        LowApp lowApp = this.lowAppService.getByIdForShare(id);
        if (lowApp == null) {
            return Result.error((int)404, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e");
        }
        int shareTenantId = lowApp.getTenantId();
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String[] arr = sysUser.getRelTenantIds().split(",");
        if (!oConvertUtils.isIn((String)String.valueOf(shareTenantId), (String[])arr)) {
            return Result.error((int)40001, (String)"\u60a8\u4e0d\u5728\u8be5\u79df\u6237\u5185\uff0c\u65e0\u6cd5\u67e5\u770b\u5e94\u7528\uff01");
        }
        List<LowAppMenuVo> menuList = this.lowAppMenuService.listAndChildren(id);
        JSONObject json = new JSONObject();
        json.put("record", (Object)lowApp);
        json.put("menuList", menuList);
        json.put("shareTenantId", (Object)shareTenantId);
        return Result.OK((Object)json);
    }

    @RequestMapping(value={"/exportXls"})
    public ModelAndView a(HttpServletRequest request, LowApp lowApp) {
        return super.exportXls(request, (Object)lowApp, LowApp.class, "low_app");
    }

    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result a(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, LowApp.class);
    }

    @RequestMapping(value={"/checkAuth"}, method={RequestMethod.POST})
    public Result<?> a(@RequestBody JeecgLicVo jeecgLic) {
        String licenceId = jeecgLic.getLicenceId();
        String licenceKey = jeecgLic.getLicenceKey();
        if (licenceId == null || licenceKey == null) {
            return Result.error((String)"\u8bf7\u586b\u5199\u6388\u6743\u7801");
        }
        if ("jeecg".equals(licenceId) && "1111111111".equals(licenceKey)) {
            return Result.OK((String)"\u6388\u6743\u901a\u8fc7");
        }
        return Result.error((String)"\u6388\u6743\u7801\u65e0\u6548");
    }

    @GetMapping(value={"/copy"})
    public Result a(@RequestParam(name="id") String id, @RequestParam(name="tenantId", required=false) String tenantId, @RequestParam(name="originalTenantId", required=false) String originalTenantId) {
        String copyId = "";
        copyId = oConvertUtils.isNotEmpty((Object)tenantId) ? this.lowAppService.copyWithTenantId(id, tenantId, originalTenantId) : this.lowAppService.copy(id);
        Result res = Result.OK((String)"\u5e94\u7528\u590d\u5236\u6210\u529f\uff01");
        res.setResult((Object)copyId);
        return res;
    }

    @GetMapping(value={"/templateCopy"})
    public Result b(@RequestParam(name="id") String id, @RequestParam(name="tenantId", required=false) String tenantId, @RequestParam(name="originalTenantId", required=false) String originalTenantId) {
        String copyId = "";
        if (!oConvertUtils.isNotEmpty((Object)tenantId) || CommonConstant.TENANT_ID_DEFAULT_VALUE.toString().equals(tenantId)) {
            return Result.error((String)"\u6a21\u677f\u590d\u5236\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u7ec4\u7ec7\uff01");
        }
        copyId = this.lowAppService.copyWithTenantId(id, tenantId, originalTenantId);
        Result res = Result.OK((String)"\u6a21\u677f\u590d\u5236\u6210\u529f\uff01");
        res.setResult((Object)copyId);
        return res;
    }

    @GetMapping(value={"/queryList"})
    public Result<?> a(@RequestParam(name="tenantId") Integer tenantId) {
        Map<String, Object> map = this.lowAppGroupService.queryAppList(tenantId);
        return Result.ok(map);
    }

    @GetMapping(value={"/allStarAppList"})
    public Result<?> a() {
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        List<LowApp> list = this.lowAppGroupService.queryStarAppList(sysUser.getId());
        return Result.ok(list);
    }

    @PutMapping(value={"/updateAppStar"})
    public Result e(@RequestBody LowApp lowApp) {
        this.lowAppGroupService.updateAppStar(lowApp.getStarStatus(), lowApp.getId());
        return Result.OK((String)"\u7f16\u8f91\u6210\u529f\uff01");
    }

    @PostMapping(value={"/resetAppOrderNum"})
    public Result<?> a(@RequestBody JSONObject json, HttpServletRequest request) {
        String tenantId = TokenUtils.getTenantIdByRequest((HttpServletRequest)request);
        this.lowAppService.resetAppOrderNum(json, tenantId);
        return Result.ok();
    }

    @GetMapping(value={"/tenantAppList"})
    public Result<List<LowAppAndOwnerInfo>> a(LowAppAndOwnerInfo info) {
        List<LowAppAndOwnerInfo> list = this.lowAppService.getLowAppListWithOwnerInfo(info);
        return Result.ok(list);
    }

    @PutMapping(value={"/changeOwner"})
    public Result<?> f(@RequestBody LowApp lowApp) {
        this.lowAppService.changeOwner(lowApp);
        return Result.ok();
    }

    @GetMapping(value={"/doBackup"})
    public Result a(LowAppBackup lowAppBackup) {
        this.lowAppService.backupApp(lowAppBackup);
        return Result.ok((String)"\u5907\u4efd\u6210\u529f\uff01");
    }

    @GetMapping(value={"/backupList"})
    public Result<IPage<LowAppBackup>> a(LowAppBackup lowAppBackup, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)lowAppBackup, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.lowAppBackupService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.OK((Object)pageList);
    }

    @PutMapping(value={"/coverByBackup"})
    public Result<?> b(@RequestBody LowAppBackup lowAppBackup) {
        this.lowAppService.coverByBackup(lowAppBackup);
        return Result.ok((String)"\u8fd8\u539f\u6210\u529f!");
    }

    @DeleteMapping(value={"/deleteBackup"})
    public Result h(@RequestParam(name="id") String id) {
        this.lowAppService.deleteBackup(id);
        return Result.OK((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @GetMapping(value={"/getTenantIdByAppId"})
    public String a(@RequestParam(name="appId") String appId, @RequestParam(name="type") String type, HttpServletRequest request) {
        String token = TokenUtils.getTokenByRequest((HttpServletRequest)request);
        return this.lowAppService.getTenantIdByLowId(appId, token, type);
    }

    @GetMapping(value={"/exportLowApp"})
    public void a(@RequestParam(name="id") String id, @RequestParam(name="export") String export, HttpServletRequest request, HttpServletResponse response) {
        String tenantId = TokenUtils.getTenantIdByRequest((HttpServletRequest)request);
        this.exportLowAppService.exportLowApp(id, tenantId, response, export);
    }

    @PostMapping(value={"/importLowApp"})
    public Result<String> a(@RequestParam(value="file") MultipartFile file, HttpServletRequest request) {
        String tenantId = TokenUtils.getTenantIdByRequest((HttpServletRequest)request);
        String importAppKey = request.getParameter("importAppKey");
        this.exportLowAppService.importLowApp(file, tenantId, importAppKey);
        this.exportLowAppService.setImportStatus(importAppKey, "isExportAll", "ok");
        return Result.ok((String)"\u5bfc\u5165\u6210\u529f!");
    }

    @GetMapping(value={"/getImportStatus"})
    public Result<List<Map<String, String>>> i(@RequestParam(name="id") String id) {
        List<Map<String, String>> importLowAppMap = org.jeecg.modules.online.low.d.c.a(id);
        String isExportAll = "isExportAll";
        if (CollectionUtil.isNotEmpty(importLowAppMap)) {
            List list = importLowAppMap.stream().filter(item -> ((String)item.get("name")).equals(isExportAll)).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(list)) {
                org.jeecg.modules.online.low.d.c.b(id);
            }
        } else {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", isExportAll);
            map.put("value", "ok");
            importLowAppMap = new ArrayList<Map<String, String>>();
            importLowAppMap.add(map);
        }
        return Result.ok(importLowAppMap);
    }

    @GetMapping(value={"/batchExportLowApp"})
    public void a(@RequestParam(name="exportData") String exportData, HttpServletRequest request, HttpServletResponse response) {
        String tenantId = TokenUtils.getTenantIdByRequest((HttpServletRequest)request);
        this.exportLowAppService.batchExportLowApp(exportData, tenantId, response);
    }

    @PostMapping(value={"/batchImportLowApp"})
    public Result<String> b(@RequestParam(value="file") MultipartFile file, HttpServletRequest request) {
        String tenantId = TokenUtils.getTenantIdByRequest((HttpServletRequest)request);
        String importAppKey = request.getParameter("importAppKey");
        this.exportLowAppService.importBatchLowApp(file, tenantId, importAppKey);
        org.jeecg.modules.online.low.d.c.b(importAppKey);
        return Result.ok((String)"\u5bfc\u5165\u6210\u529f!");
    }

    private static /* synthetic */ Object a(SerializedLambda lambda) {
        switch (lambda.getImplMethodName()) {
            case "getAppLabel": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowApp") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return LowApp::getAppLabel;
            }
        }
        throw new IllegalArgumentException("Invalid lambda deserialization");
    }
}

