/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.low.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.io.IoUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import lombok.Generated;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.bson.types.ObjectId;
import org.jeecg.common.bpm.api.IBpmBaseExtApi;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.desform.api.IDesformBaseApi;
import org.jeecg.common.drag.api.IDragBaseApi;
import org.jeecg.common.exception.JeecgBootBizTipException;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.online.low.d.c;
import org.jeecg.modules.online.low.entity.LowApp;
import org.jeecg.modules.online.low.entity.LowAppAuthField;
import org.jeecg.modules.online.low.entity.LowAppAuthForm;
import org.jeecg.modules.online.low.entity.LowAppAuthOperation;
import org.jeecg.modules.online.low.entity.LowAppAuthRecord;
import org.jeecg.modules.online.low.entity.LowAppAuthRole;
import org.jeecg.modules.online.low.entity.LowAppAuthRoleUser;
import org.jeecg.modules.online.low.entity.LowAppMenu;
import org.jeecg.modules.online.low.mapper.ExportLowAppMapper;
import org.jeecg.modules.online.low.mapper.LowAppMapper;
import org.jeecg.modules.online.low.mapper.LowAppMenuMapper;
import org.jeecg.modules.online.low.service.IExportLowAppService;
import org.jeecg.modules.online.low.service.ILowAppAuthFieldService;
import org.jeecg.modules.online.low.service.ILowAppAuthFormService;
import org.jeecg.modules.online.low.service.ILowAppAuthOperationService;
import org.jeecg.modules.online.low.service.ILowAppAuthRecordService;
import org.jeecg.modules.online.low.service.ILowAppAuthRoleService;
import org.jeecg.modules.online.low.service.ILowAppAuthRoleUserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

@Service(value="exportLowAppService")
public class b
implements IExportLowAppService {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(b.class);
    @Autowired
    private LowAppMapper lowAppMapper;
    @Autowired
    private ILowAppAuthRoleService lowAppAuthRoleService;
    @Autowired
    private ExportLowAppMapper exportLowAppMapper;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private LowAppMenuMapper lowAppMenuMapper;
    @Lazy
    @Autowired
    IDesformBaseApi desformBaseApi;
    @Lazy
    @Autowired
    IDragBaseApi dragBaseApi;
    @Autowired
    private ILowAppAuthRoleUserService lowAppAuthRoleUserService;
    @Autowired
    private ILowAppAuthFormService lowAppAuthFormService;
    @Autowired
    private ILowAppAuthFieldService lowAppAuthFieldService;
    @Autowired
    private ILowAppAuthOperationService lowAppAuthOperationService;
    @Autowired
    private ILowAppAuthRecordService lowAppAuthRecordService;
    @Lazy
    @Autowired
    private IBpmBaseExtApi bpmBaseExtApi;
    private static final ExecutorService b = new ThreadPoolExecutor(0, 1024, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());

    @Override
    public void exportLowApp(String id, String tenantId, HttpServletResponse response) {
        LowApp lowApp = this.exportLowAppMapper.selectByIdAndDelFlag(id);
        if (null == lowApp) {
            throw new JeecgBootBizTipException("\u5bfc\u51fa\u5e94\u7528\u5931\u8d25\uff0c\u5f53\u524d\u5e94\u7528\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01");
        }
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        List<LowAppAuthRole> userRoleList = this.lowAppAuthRoleService.getUserRoleList(sysUser.getId(), lowApp.getId());
        if (CollectionUtil.isEmpty(userRoleList)) {
            throw new JeecgBootBizTipException("\u5bfc\u51fa\u5e94\u7528\u5931\u8d25\uff0c\u5f53\u524d\u767b\u5f55\u7528\u6237\u4e0d\u5728\u6b64\u5e94\u7528\u4e2d\uff01");
        }
        Map<String, Object> tableData = this.a(lowApp.getId());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(tableData);
        map.put("lowApp", lowApp);
        String json = JSON.toJSONString(map);
        try {
            String encrypt = org.jeecg.modules.online.low.d.b.a(json);
            a.info("\u52a0\u5bc6\u540e\u7684\u5bfc\u51fa\u6570\u636e:" + encrypt);
            if (StringUtils.isNotEmpty((String)encrypt)) {
                String fileName = URLEncoder.encode(lowApp.getAppName() + ".qqy", "UTF-8").replaceAll("\\+", "%20");
                response.reset();
                response.setCharacterEncoding("utf-8");
                response.setContentType("application/force-download");
                response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName);
                response.getWriter().write(encrypt);
                response.flushBuffer();
            }
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    private Map<String, Object> a(String id) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        List<LowAppMenu> appMenuByAppId = this.exportLowAppMapper.getAppMenuByAppId(id);
        map.put("appMenu", appMenuByAppId);
        List<Map<String, Object>> designForm = this.exportLowAppMapper.getDesignFormByAppId(id);
        map.put("designForm", designForm);
        List<Map<String, Object>> flowList = this.exportLowAppMapper.getFlowListByAppId(id);
        this.b(flowList);
        map.put("flowList", flowList);
        List<Map<String, Object>> flowNodeList = this.exportLowAppMapper.getFlowNodeListByAppId(id);
        map.put("flowNodeList", flowNodeList);
        List<Map<String, Object>> flowFormList = this.exportLowAppMapper.getFlowFormListByAppId(id);
        map.put("flowFormList", flowFormList);
        List<Map<String, Object>> flowNodeAuthList = this.exportLowAppMapper.getFlowNodeAuthListByAppId(id);
        map.put("flowNodeAuthList", flowNodeAuthList);
        List<Map<String, Object>> flowNodeDeployList = this.exportLowAppMapper.getFlowNodeDeployListByAppId(id);
        map.put("flowNodeDeployList", flowNodeDeployList);
        List<Map<String, Object>> dragList = this.exportLowAppMapper.getDragListByAppId(id);
        map.put("dragList", dragList);
        List<Map<String, Object>> dragComponentList = this.exportLowAppMapper.getDragComponentListByAppId(id);
        List<Map<String, Object>> dictList = this.exportLowAppMapper.getDictListByAppId(id);
        map.put("dictList", dictList);
        List<Map<String, Object>> dictItem = this.exportLowAppMapper.getDictItemByAppId(id);
        map.put("dictItem", dictItem);
        Map<String, Object> tableDataByMongodb = this.a(designForm, dragComponentList);
        map.put("dragComponentList", dragComponentList);
        map.putAll(tableDataByMongodb);
        this.a(id, map);
        return map;
    }

    private void b(List<Map<String, Object>> flowList) {
        if (CollectionUtil.isNotEmpty(flowList)) {
            for (Map<String, Object> map : flowList) {
                if (!map.containsKey("process_xml")) continue;
                try {
                    map.put("process_xml", new String((byte[])map.get("process_xml"), "UTF-8"));
                }
                catch (UnsupportedEncodingException e2) {
                    throw new RuntimeException(e2);
                }
            }
        }
    }

    private Map<String, Object> a(List<Map<String, Object>> designFormList, List<Map<String, Object>> dragComponentList) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List desformCodeList = designFormList.stream().map(item -> item.get("desform_code").toString()).collect(Collectors.toList());
        List listView = this.mongoTemplate.find(new Query((CriteriaDefinition)Criteria.where((String)"desform_code").in(desformCodeList)), Map.class, "design_form_list_view");
        this.a(listView);
        map.put("designFormListView", listView);
        List listViewButton = this.mongoTemplate.find(new Query((CriteriaDefinition)Criteria.where((String)"designFormCode").in(desformCodeList)), Map.class, "design_form_list_view_button");
        this.a(listViewButton);
        map.put("designFormListViewButton", listViewButton);
        List setting = this.mongoTemplate.find(new Query((CriteriaDefinition)Criteria.where((String)"desformCode").in(desformCodeList)), Map.class, "design_form_setting");
        this.a(setting);
        map.put("designFormSetting", setting);
        List listSuperQuery = this.mongoTemplate.find(new Query((CriteriaDefinition)Criteria.where((String)"code").in(desformCodeList)), Map.class, "design_form_list_super_query");
        this.a(listSuperQuery);
        map.put("designFormListSuperQuery", listSuperQuery);
        List listChartConfig = this.mongoTemplate.find(new Query((CriteriaDefinition)Criteria.where((String)"designFormCode").in(desformCodeList)), Map.class, "design_form_list_chart_config");
        this.a(listChartConfig);
        this.b(listChartConfig, dragComponentList);
        map.put("designFormListChartConfig", listChartConfig);
        List tableDefVal = this.mongoTemplate.find(new Query((CriteriaDefinition)Criteria.where((String)"desformCode").in(desformCodeList)), Map.class, "design_form_ref_table_def_val");
        this.a(tableDefVal);
        map.put("designFormRefTableDefVal", tableDefVal);
        return map;
    }

    private void b(List<Map> listChartConfig, List<Map<String, Object>> dragComponentList) {
        List<String> dragCompIdList = listChartConfig.stream().map(item -> item.get("chartId").toString()).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(dragCompIdList)) {
            return;
        }
        List<Map<String, Object>> dragComponentListByDragIds = this.exportLowAppMapper.getDragComponentListByDragCompIdList(dragCompIdList);
        dragComponentList.addAll(dragComponentListByDragIds);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void importLowApp(MultipartFile file, String tenantId, String importAppKey) {
        try {
            byte[] data = file.getBytes();
            this.a(data, tenantId, importAppKey);
        }
        catch (IOException e2) {
            c.b(importAppKey);
            throw new JeecgBootBizTipException((Throwable)e2);
        }
    }

    private void a(byte[] data, String tenantId, String importAppKey) {
        String content = new String(data, StandardCharsets.UTF_8);
        if (StringUtils.isNotEmpty((String)content)) {
            content = org.jeecg.modules.online.low.d.b.b(content);
            JsonFactory jsonFactory = new JsonFactory();
            try (JsonParser jsonParser = jsonFactory.createParser(content);){
                ObjectMapper objectMapper = new ObjectMapper();
                while (jsonParser.nextToken() != null) {
                    jsonParser.nextToken();
                    Map map = (Map)objectMapper.readValue(jsonParser, Map.class);
                    LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
                    if (map == null) continue;
                    int tenantIdInt = oConvertUtils.getInt((String)tenantId);
                    this.a(map, tenantIdInt, sysUser, importAppKey);
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
    }

    private Map<String, String> a(Map map, String lowAppId, Integer tenantId, LoginUser sysUser, String importAppKey) {
        a.info("======================\u5b57\u5178\u5bfc\u5165\u5f00\u59cb==================");
        this.a(importAppKey, "dict", "import");
        HashMap<String, String> dictCodeMapping = new HashMap<String, String>();
        if (map.containsKey("dictList")) {
            List dictItemList;
            List dictList = (List)map.get("dictList");
            if (CollectionUtil.isNotEmpty((Collection)dictList)) {
                for (Map dict : dictList) {
                    dict.put("create_time", new Date());
                    dict.put("create_by", sysUser.getUsername());
                    dict.put("tenant_id", tenantId);
                    dict.put("low_app_id", lowAppId);
                }
                try {
                    this.exportLowAppMapper.insertDictBatch(dictList);
                }
                catch (Exception e2) {
                    a.warn("\u6279\u91cf\u63d2\u5165\u5b57\u5178\u5931\u8d25\uff1a" + e2.getMessage());
                    this.a(dictList, map, sysUser.getUsername(), tenantId, lowAppId);
                }
            }
            if (map.containsKey("dictItem") && CollectionUtil.isNotEmpty((Collection)(dictItemList = (List)map.get("dictItem")))) {
                for (Map dictItem : dictItemList) {
                    dictItem.put("create_time", new Date());
                    dictItem.put("create_by", sysUser.getUsername());
                }
                this.exportLowAppMapper.insertDictItemBatch(dictItemList);
            }
        }
        this.a(importAppKey, "dict", "success");
        a.info("======================\u5b57\u5178\u5bfc\u5165\u7ed3\u675f==================");
        return dictCodeMapping;
    }

    private void a(List<Map<String, Object>> dictList, Map map, String username, Integer tenantId, String lowAppId) {
        List<Map> dictItemListMap = null;
        if (map.containsKey("dictItem")) {
            dictItemListMap = (List<Map>)map.get("dictItem");
        }
        for (Map<String, Object> dict : dictList) {
            String id = dict.get("id").toString();
            long count = this.exportLowAppMapper.selectDictCountByDictId(id);
            if (count == 0L) {
                dict.put("create_time", new Date());
                dict.put("create_by", username);
                dict.put("tenant_id", tenantId);
                dict.put("low_app_id", lowAppId);
                this.exportLowAppMapper.insertDict(dict);
                continue;
            }
            if (!map.containsKey("dictItem") || !CollectionUtil.isNotEmpty((Collection)dictItemListMap)) continue;
            dictItemListMap = dictItemListMap.stream().filter(item -> !item.get("dict_id").toString().equals(id)).toList();
        }
        map.put("dictItem", dictItemListMap);
    }

    private void b(Map map, String lowAppId, Integer tenantId, LoginUser sysUser, String importAppKey) {
        a.info("============================\u6d41\u7a0b\u5bfc\u5165\u5f00\u59cb=========================");
        this.a(importAppKey, "flow", "import");
        Object flow = map.get("flowList");
        if (null != flow) {
            List flowList = (List)flow;
            a.info("=====================\u5f53\u524d\u5bfc\u5165\u8868 ext_act_process =========================");
            if (CollectionUtil.isNotEmpty((Collection)flowList)) {
                for (Map flowMap : flowList) {
                    flowMap.put("tenant_id", tenantId);
                    flowMap.put("low_app_id", lowAppId);
                    flowMap.put("create_by", sysUser.getUsername());
                    flowMap.put("create_time", new Date());
                    try {
                        Object processXml = flowMap.get("process_xml");
                        if (processXml != null) {
                            flowMap.put("process_xml", processXml.toString().getBytes("UTF-8"));
                        }
                    }
                    catch (UnsupportedEncodingException e2) {
                        throw new RuntimeException(e2);
                    }
                    Object processDeployTime = flowMap.get("process_deploy_time");
                    if (null == processDeployTime || !(processDeployTime instanceof Long)) continue;
                    flowMap.put("process_deploy_time", new Date((Long)processDeployTime));
                }
                this.exportLowAppMapper.insertFlowBatch(flowList);
            }
            if (map.containsKey("flowNodeList")) {
                List flowNodeList = (List)map.get("flowNodeList");
                a.info("=====================\u5f53\u524d\u5bfc\u5165\u8868 ext_act_process_node =========================");
                if (CollectionUtil.isNotEmpty((Collection)flowNodeList)) {
                    flowNodeList.forEach(item -> item.put("create_time", new Date()));
                    this.exportLowAppMapper.insertFlowNodeBatch(flowNodeList);
                }
            }
            if (map.containsKey("flowFormList")) {
                List flowFormList = (List)map.get("flowFormList");
                a.info("=====================\u5f53\u524d\u5bfc\u5165\u8868 ext_act_process_form =========================");
                if (CollectionUtil.isNotEmpty((Collection)flowFormList)) {
                    flowFormList.forEach(item -> item.put("create_time", new Date()));
                    this.exportLowAppMapper.insertFlowFormBatch(flowFormList);
                }
            }
            if (map.containsKey("flowNodeAuthList")) {
                List flowNodeAuthList = (List)map.get("flowNodeAuthList");
                a.info("=====================\u5f53\u524d\u5bfc\u5165\u8868 ext_act_process_node_auth =========================");
                if (CollectionUtil.isNotEmpty((Collection)flowNodeAuthList)) {
                    flowNodeAuthList.forEach(item -> item.put("create_time", new Date()));
                    this.exportLowAppMapper.insertFlowNodeAuth(flowNodeAuthList);
                }
            }
            if (map.containsKey("flowNodeDeployList")) {
                List flowNodeDeployList = (List)map.get("flowNodeDeployList");
                a.info("=====================\u5f53\u524d\u5bfc\u5165\u8868 ext_act_process_node_deploy =========================");
                if (CollectionUtil.isNotEmpty((Collection)flowNodeDeployList)) {
                    flowNodeDeployList.forEach(item -> item.put("create_time", new Date()));
                    this.exportLowAppMapper.insertFlowNodeDeploy(flowNodeDeployList);
                }
            }
        }
        this.a(importAppKey, "flow", "success");
        a.info("============================\u6d41\u7a0b\u5bfc\u51fa\u7ed3\u675f=========================");
    }

    private void a(Map map, Integer tenantId, LoginUser sysUser, String importAppKey) {
        a.info("======================\u5e94\u7528\u5bfc\u5165\u5f00\u59cb==================");
        a.info("======================\u5f53\u524d\u5bfc\u5165\u8868 low_app ==================");
        Object lowApp = map.get("lowApp");
        LowApp app = (LowApp)JSONObject.parseObject((String)JSONObject.toJSONString(lowApp), LowApp.class);
        String id = app.getId();
        Integer tenantIdByLowId = this.lowAppMapper.getTenantIdByLowId(app.getId());
        if (null != tenantIdByLowId) {
            throw new JeecgBootBizTipException("\u5e94\u7528 " + app.getAppName() + " \u5df2\u5b58\u5728\uff0c\u5bfc\u5165\u5931\u8d25\uff01");
        }
        this.a(importAppKey, "appName", app.getAppName());
        this.a(importAppKey, "appId", app.getId());
        this.a(importAppKey, "app", "import");
        app.setTenantId(tenantId);
        app.setCreateBy(sysUser.getUsername());
        app.setCreateTime(new Date());
        app.setOrderNum(CommonConstant.DEL_FLAG_0);
        app.setOwnerId(sysUser.getId());
        app.clearDefaultField();
        app.setDelFlag(CommonConstant.DEL_FLAG_0);
        app.setId(id);
        a.info("\u5e94\u7528\u5bfc\u5165\u6570\u636e{}", (Object)app);
        this.lowAppMapper.insert(app);
        a.info("======================\u5f53\u524d\u5bfc\u5165\u8868 low_app_auth ==================");
        a.info("======================\u5e94\u7528\u5bfc\u5165\u5f00\u59cb==================");
        this.a(importAppKey, "app", "success");
        this.a(map, id, tenantId, sysUser, importAppKey);
        if (map.containsKey("appMenu")) {
            List menuList = JSONObject.parseArray((String)JSONObject.toJSONString(map.get("appMenu")), LowAppMenu.class);
            this.a(menuList, id, importAppKey);
            this.a(map, id, tenantId, importAppKey);
            this.a(sysUser, tenantId, id, map, importAppKey);
            this.b(map, app.getId(), tenantId, sysUser, importAppKey);
            this.c(map, app.getId(), tenantId, sysUser, importAppKey);
        }
        HttpServletRequest request = SpringContextUtils.getHttpServletRequest();
        b.execute(() -> {
            try {
                ServletRequestAttributes attributes = new ServletRequestAttributes(request);
                RequestContextHolder.setRequestAttributes((RequestAttributes)attributes);
                this.bpmBaseExtApi.batchActivateProcessByAppId(id);
                this.lowAppMapper.updateDeployTimeByAppId(new Date(), id);
            }
            catch (Exception e2) {
                a.info(e2.getMessage());
                a.error("\u5e94\u7528\uff1a" + app.getAppName() + " \u4e2d\u7684\u6d41\u7a0b\u542f\u52a8\u5931\u8d25");
            }
        });
    }

    private void a(LoginUser sysUser, Integer tenantId, String appId, Map map, String importAppKey) {
        a.info("============================\u4eea\u8868\u76d8\u5bfc\u5165\u5f00\u59cb=========================");
        List dragList = (List)map.get("dragList");
        this.a(importAppKey, "drag", "import");
        if (CollectionUtil.isNotEmpty((Collection)dragList)) {
            for (Map drag : dragList) {
                drag.put("create_time", new Date());
                drag.put("create_by", sysUser.getUsername());
                drag.put("low_app_id", appId);
                drag.put("tenant_id", tenantId);
            }
            a.info("=====================\u5f53\u524d\u5bfc\u5165\u8868 onl_drag_page =========================");
            this.exportLowAppMapper.insertDragBatch(dragList);
        }
        if (map.containsKey("dragComponentList")) {
            List dragComponentList = (List)map.get("dragComponentList");
            a.info("=====================\u5f53\u524d\u5bfc\u5165\u8868 onl_drag_page_comp =========================");
            if (CollectionUtil.isNotEmpty((Collection)dragComponentList)) {
                for (Map dragComponent : dragComponentList) {
                    dragComponent.put("create_time", new Date());
                    dragComponent.put("create_by", sysUser.getUsername());
                }
                this.exportLowAppMapper.insertDragComponentBatch(dragComponentList);
            }
        }
        this.a(importAppKey, "drag", "success");
        a.info("============================\u4eea\u8868\u76d8\u5bfc\u5165\u7ed3\u675f=========================");
    }

    private void a(List<LowAppMenu> menuList, String appId, String importAppKey) {
        a.info("======================\u83dc\u5355\u5bfc\u5165\u5f00\u59cb==================");
        a.info("======================\u5f53\u524d\u5bfc\u5165\u8868 low_app_menu ==================");
        this.a(importAppKey, "menu", "import");
        for (LowAppMenu menu : menuList) {
            menu.setAppId(appId);
            this.lowAppMenuMapper.insert(menu);
        }
        this.a(importAppKey, "menu", "success");
        a.info("======================\u83dc\u5355\u5bfc\u5165\u7ed3\u675f==================");
    }

    private void a(Map map, String lowAppId, Integer tenantId, String importAppKey) {
        a.info("======================\u8868\u5355\u5bfc\u5165\u5f00\u59cb==================");
        Object designForm = map.get("designForm");
        this.a(importAppKey, "form", "import");
        if (null != designForm) {
            LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
            List designFormList = (List)designForm;
            a.info("=====================\u5f53\u524d\u5bfc\u5165\u8868 design_form =========================");
            if (CollectionUtil.isNotEmpty((Collection)designFormList)) {
                for (Map form : designFormList) {
                    form.put("low_app_id", lowAppId);
                    form.put("tenant_id", tenantId);
                    form.put("create_time", new Date());
                    form.put("create_by", sysUser.getUsername());
                }
                this.exportLowAppMapper.insertDesignForm(designFormList);
            }
            if (map.containsKey("designFormListView")) {
                List designFormListView = (List)map.get("designFormListView");
                a.info("=====================\u5f53\u524d\u5bfc\u5165mongodb\u8868 design_form_list_view =========================");
                if (CollectionUtil.isNotEmpty((Collection)designFormListView)) {
                    for (Map formView : designFormListView) {
                        if (formView.get("_id") instanceof ObjectId) {
                            formView.put("_id", new ObjectId(formView.get("_id").toString()));
                        } else {
                            formView.put("_id", formView.get("_id").toString());
                        }
                        formView.put("createTime", System.currentTimeMillis());
                        this.mongoTemplate.insert((Object)formView, "design_form_list_view");
                    }
                }
            }
            if (map.containsKey("designFormListViewButton")) {
                List designFormListViewButton = (List)map.get("designFormListViewButton");
                a.info("=====================\u5f53\u524d\u5bfc\u5165mongodb\u8868 design_form_list_view_button =========================");
                if (CollectionUtil.isNotEmpty((Collection)designFormListViewButton)) {
                    for (Map formViewButton : designFormListViewButton) {
                        formViewButton.put("_id", formViewButton.get("_id"));
                        formViewButton.put("_class", "org.jeecg.modules.online.desform.mongo.model.ButtonInfo");
                        formViewButton.put("createBy", sysUser.getUsername());
                        formViewButton.put("createTime", System.currentTimeMillis());
                        this.mongoTemplate.insert((Object)formViewButton, "design_form_list_view_button");
                    }
                }
            }
            if (map.containsKey("designFormSetting")) {
                List designFormSettingList = (List)map.get("designFormSetting");
                a.info("=====================\u5f53\u524d\u5bfc\u5165mongodb\u8868 design_form_setting =========================");
                if (CollectionUtil.isNotEmpty((Collection)designFormSettingList)) {
                    for (Map formSetting : designFormSettingList) {
                        formSetting.put("_id", formSetting.get("_id").toString());
                        formSetting.put("_class", "org.jeecg.modules.online.desform.mongo.model.DesformSetting");
                        formSetting.put("createTime", System.currentTimeMillis());
                        this.mongoTemplate.insert((Object)formSetting, "design_form_setting");
                    }
                }
            }
            if (map.containsKey("designFormListSuperQuery")) {
                List designFormListSuperQuery = (List)map.get("designFormListSuperQuery");
                a.info("=====================\u5f53\u524d\u5bfc\u5165mongodb\u8868 design_form_list_super_query =========================");
                if (CollectionUtil.isNotEmpty((Collection)designFormListSuperQuery)) {
                    for (Map superQuery : designFormListSuperQuery) {
                        superQuery.put("_id", superQuery.get("_id").toString());
                        superQuery.put("_class", "org.jeecg.modules.online.desform.mongo.model.SuperQuery");
                        superQuery.put("createBy", sysUser.getUsername());
                        superQuery.put("createTime", System.currentTimeMillis());
                        this.mongoTemplate.insert((Object)superQuery, "design_form_list_super_query");
                    }
                }
            }
            if (map.containsKey("designFormListChartConfig")) {
                List designFormListChartConfig = (List)map.get("designFormListChartConfig");
                a.info("=====================\u5f53\u524d\u5bfc\u5165mongodb\u8868 design_form_list_chart_config =========================");
                if (CollectionUtil.isNotEmpty((Collection)designFormListChartConfig)) {
                    for (Map chartConfig : designFormListChartConfig) {
                        chartConfig.put("_id", chartConfig.get("_id").toString());
                        chartConfig.put("_class", "org.jeecg.modules.online.desform.mongo.model.DesignFormListChartConfig");
                        chartConfig.put("createBy", sysUser.getUsername());
                        chartConfig.put("createTime", System.currentTimeMillis());
                        this.mongoTemplate.insert((Object)chartConfig, "design_form_list_chart_config");
                    }
                }
            }
            if (map.containsKey("designFormRefTableDefVal")) {
                List designFormRefTableDefVal = (List)map.get("designFormRefTableDefVal");
                a.info("=====================\u5f53\u524d\u5bfc\u5165mongodb\u8868 design_form_ref_table_def_val =========================");
                if (CollectionUtil.isNotEmpty((Collection)designFormRefTableDefVal)) {
                    for (Map tableVal : designFormRefTableDefVal) {
                        tableVal.put("_id", tableVal.get("_id").toString());
                        tableVal.put("_class", "org.jeecg.modules.online.desform.mongo.model.DesignFormRefTableDefVal");
                        tableVal.put("createTime", System.currentTimeMillis());
                        this.mongoTemplate.insert((Object)tableVal, "design_form_ref_table_def_val");
                    }
                }
            }
        }
        this.a(importAppKey, "form", "success");
        a.info("======================\u8868\u5355\u5bfc\u5165\u7ed3\u675f==================");
    }

    public void a(String importAppKey, String name, String value) {
        HashMap<String, String> importLowApp = new HashMap<String, String>();
        if (!value.equals("success")) {
            importLowApp.put("name", name);
            importLowApp.put("value", value);
            c.a(importAppKey, importLowApp);
        } else {
            importLowApp.put("name", name);
            importLowApp.put("value", value);
            c.a(importAppKey, name, importLowApp);
        }
    }

    public void a(List<Map> list) {
        if (CollectionUtil.isNotEmpty(list)) {
            for (Map map : list) {
                Object id = map.get("_id");
                if (id instanceof String) {
                    map.put("_id", map.get("_id").toString());
                    continue;
                }
                ObjectId objectId = (ObjectId)id;
                map.put("_id", objectId.toString());
            }
        }
    }

    private void a(String id, Map<String, Object> map) {
        List<LowAppAuthRole> lowAppAuthRole = this.exportLowAppMapper.getLowAppAuthRole(id);
        map.put("lowAppAuthRoleList", lowAppAuthRole);
        List<LowAppAuthRoleUser> lowAppUserRole = this.exportLowAppMapper.getLowAppAuthUserRole(id);
        map.put("lowAppAuthUserRoleList", lowAppUserRole);
        List<LowAppAuthForm> lowAppAuthForm = this.exportLowAppMapper.getLowAppAuthForm(id);
        map.put("lowAppAuthFormList", lowAppAuthForm);
        List<LowAppAuthField> lowAppAuthFormField = this.exportLowAppMapper.getLowAppAuthFormField(id);
        map.put("lowAppAuthFormFieldList", lowAppAuthFormField);
        List<LowAppAuthOperation> lowAppAuthFormOperation = this.exportLowAppMapper.getLowAppAuthFormOperation(id);
        map.put("lowAppAuthFormOperationList", lowAppAuthFormOperation);
        List<LowAppAuthRecord> lowAppAuthFormRecord = this.exportLowAppMapper.getLowAppAuthFormRecord(id);
        map.put("lowAppAuthFormRecordList", lowAppAuthFormRecord);
    }

    private void c(Map map, String appId, Integer tenantId, LoginUser sysUser, String importAppKey) {
        a.info("============================\u5e94\u7528\u89d2\u8272\u5bfc\u5165\u5f00\u59cb=========================");
        if (map.containsKey("lowAppAuthRoleList")) {
            Object lowAppAuthRoleList = map.get("lowAppAuthRoleList");
            if (null != lowAppAuthRoleList) {
                List list = JSONObject.parseArray((String)JSONObject.toJSONString(map.get("lowAppAuthRoleList")), LowAppAuthRole.class);
                if (CollectionUtil.isNotEmpty((Collection)list)) {
                    String roleId = "";
                    for (LowAppAuthRole lowAppAuthRole : list) {
                        lowAppAuthRole.setTenantId(tenantId);
                        lowAppAuthRole.setAppId(appId);
                        lowAppAuthRole.setCreateBy(sysUser.getUsername());
                        if (!"admin".equals(lowAppAuthRole.getCode())) continue;
                        roleId = lowAppAuthRole.getId();
                    }
                    this.lowAppAuthRoleService.saveBatch(list);
                    if (map.containsKey("lowAppAuthUserRoleList")) {
                        Object lowAppAuthUserRoleList = map.get("lowAppAuthUserRoleList");
                        boolean isExitUserRole = false;
                        if (null != lowAppAuthUserRoleList) {
                            List lowAppAuthUserRole = JSONObject.parseArray((String)JSONObject.toJSONString(map.get("lowAppAuthUserRoleList")), LowAppAuthRoleUser.class);
                            for (LowAppAuthRoleUser appAuthRoleUser : lowAppAuthUserRole) {
                                appAuthRoleUser.setAppId(appId);
                                appAuthRoleUser.setCreateBy(sysUser.getUsername());
                                if (!appAuthRoleUser.getRelationId().equals(sysUser.getId())) continue;
                                isExitUserRole = true;
                            }
                            this.lowAppAuthRoleUserService.saveBatch(lowAppAuthUserRole);
                            if (!isExitUserRole) {
                                LowAppAuthRoleUser lowAppAuthRoleUser = new LowAppAuthRoleUser(roleId, "sys_user", sysUser.getId(), appId);
                                this.lowAppAuthRoleUserService.save(lowAppAuthRoleUser);
                            }
                        }
                    } else {
                        LowAppAuthRoleUser lowAppAuthRoleUser = new LowAppAuthRoleUser(roleId, "sys_user", sysUser.getId(), appId);
                        this.lowAppAuthRoleUserService.save(lowAppAuthRoleUser);
                    }
                    this.a(map, sysUser);
                } else {
                    this.lowAppAuthRoleService.createDefaultRoles(appId);
                    this.lowAppAuthRoleService.addUser2AdminRole(sysUser, appId);
                }
            }
        } else {
            this.lowAppAuthRoleService.createDefaultRoles(appId);
            this.lowAppAuthRoleService.addUser2AdminRole(sysUser, appId);
        }
        a.info("============================\u5e94\u7528\u89d2\u8272\u5bfc\u5165\u7ed3\u675f=========================");
    }

    private void a(Map map, LoginUser sysUser) {
        List lowAppAuthRecord;
        Object lowAppAuthFormRecordList;
        List lowAppAuthFormOperation;
        Object lowAppAuthFormOperationList;
        List lowAppAuthFormField;
        Object lowAppAuthFormFieldList;
        List lowAppAuthForm;
        Object lowAppAuthFormList;
        if (map.containsKey("lowAppAuthFormList") && null != (lowAppAuthFormList = map.get("lowAppAuthFormList")) && CollectionUtil.isNotEmpty((Collection)(lowAppAuthForm = JSONObject.parseArray((String)JSONObject.toJSONString(lowAppAuthFormList), LowAppAuthForm.class)))) {
            lowAppAuthForm.forEach(item -> item.setCreateBy(sysUser.getUsername()));
            this.lowAppAuthFormService.saveBatch(lowAppAuthForm);
        }
        if (map.containsKey("lowAppAuthFormFieldList") && null != (lowAppAuthFormFieldList = map.get("lowAppAuthFormFieldList")) && CollectionUtil.isNotEmpty((Collection)(lowAppAuthFormField = JSONObject.parseArray((String)JSONObject.toJSONString(lowAppAuthFormFieldList), LowAppAuthField.class)))) {
            lowAppAuthFormField.forEach(item -> item.setCreateBy(sysUser.getUsername()));
            this.lowAppAuthFieldService.saveBatch(lowAppAuthFormField);
        }
        if (map.containsKey("lowAppAuthFormOperationList") && null != (lowAppAuthFormOperationList = map.get("lowAppAuthFormOperationList")) && CollectionUtil.isNotEmpty((Collection)(lowAppAuthFormOperation = JSONObject.parseArray((String)JSONObject.toJSONString(lowAppAuthFormOperationList), LowAppAuthOperation.class)))) {
            lowAppAuthFormOperation.forEach(item -> item.setCreateBy(sysUser.getUsername()));
            this.lowAppAuthOperationService.saveBatch(lowAppAuthFormOperation);
        }
        if (map.containsKey("lowAppAuthFormRecordList") && null != (lowAppAuthFormRecordList = map.get("lowAppAuthFormRecordList")) && CollectionUtil.isNotEmpty((Collection)(lowAppAuthRecord = JSONObject.parseArray((String)JSONObject.toJSONString(lowAppAuthFormRecordList), LowAppAuthRecord.class)))) {
            lowAppAuthRecord.forEach(item -> item.setCreateBy(sysUser.getUsername()));
            this.lowAppAuthRecordService.saveBatch(lowAppAuthRecord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batchExportLowApp(String ids, String tenantId, HttpServletResponse response) {
        block13: {
            response.reset();
            response.setCharacterEncoding("utf-8");
            response.setContentType("application/force-download");
            try {
                String[] appIds = ids.split(",");
                String fileName = URLEncoder.encode("\u6279\u91cf\u5bfc\u51fa" + new Date().getTime() + ".zip", "UTF-8").replaceAll("\\+", "%20");
                response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName);
                if (appIds.length <= 0) break block13;
                ZipArchiveOutputStream zous = null;
                zous = new ZipArchiveOutputStream((OutputStream)response.getOutputStream());
                zous.setUseZip64(Zip64Mode.AsNeeded);
                for (String id : appIds) {
                    LowApp lowApp = this.exportLowAppMapper.selectByIdAndDelFlag(id);
                    if (null == lowApp) {
                        throw new JeecgBootBizTipException("\u5bfc\u51fa\u5e94\u7528\u5931\u8d25\uff0c\u5f53\u524d\u5e94\u7528\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01");
                    }
                    LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
                    List<LowAppAuthRole> userRoleList = this.lowAppAuthRoleService.getUserRoleList(sysUser.getId(), lowApp.getId());
                    if (CollectionUtil.isEmpty(userRoleList)) {
                        throw new JeecgBootBizTipException("\u5bfc\u51fa\u5e94\u7528\u5931\u8d25\uff0c\u5f53\u524d\u767b\u5f55\u7528\u6237\u4e0d\u5728\u6b64\u5e94\u7528\u4e2d\uff01");
                    }
                    Map<String, Object> tableData = this.a(lowApp.getId());
                    LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(tableData);
                    map.put("lowApp", lowApp);
                    String json = JSON.toJSONString(map);
                    String encrypt = org.jeecg.modules.online.low.d.b.a(json);
                    ZipArchiveEntry entry = new ZipArchiveEntry(lowApp.getAppName() + ".qqy");
                    zous.putArchiveEntry(entry);
                    byte[] strBytes = null;
                    if (encrypt != null) {
                        strBytes = encrypt.getBytes();
                    }
                    ByteArrayInputStream inputStream = null;
                    if (strBytes != null) {
                        inputStream = new ByteArrayInputStream(strBytes);
                    }
                    try {
                        byte[] bytes = new byte[1024];
                        if (inputStream != null) {
                            int len;
                            while ((len = inputStream.read(bytes)) != -1) {
                                zous.write(bytes, 0, len);
                            }
                        }
                    }
                    finally {
                        IoUtil.close((Closeable)inputStream);
                    }
                    zous.closeArchiveEntry();
                    zous.flush();
                }
                response.flushBuffer();
                zous.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            catch (Exception e3) {
                throw new RuntimeException(e3);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void importBatchLowApp(MultipartFile file, String tenantId, String importAppKey) {
        String originalFilename = file.getOriginalFilename();
        String[] parts = null;
        String part = "";
        if (originalFilename != null) {
            parts = originalFilename.split("\\.");
            part = parts.length > 1 ? parts[parts.length - 1] : parts[0];
        }
        if (oConvertUtils.isEmpty((Object)part) || !part.equals("zip") && !part.equals("qqy")) {
            throw new JeecgBootBizTipException("\u8bf7\u4e0a\u4f20zip\u6216\u8005qqy\u540e\u7f00\u7684\u6587\u4ef6");
        }
        if ("qqy".equals(part)) {
            this.importLowApp(file, tenantId, importAppKey);
        } else {
            try (InputStream inputStream = file.getInputStream();
                 ZipInputStream zis = new ZipInputStream(inputStream, Charset.forName("GBK"));){
                ZipEntry zipEntry;
                while ((zipEntry = zis.getNextEntry()) != null) {
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    if (!zipEntry.isDirectory()) {
                        int len;
                        byte[] buffer = new byte[1024];
                        while ((len = zis.read(buffer)) > 0) {
                            outputStream.write(buffer, 0, len);
                        }
                        this.a(outputStream.toByteArray(), tenantId, importAppKey);
                    }
                    zis.closeEntry();
                }
            }
            catch (IOException e2) {
                c.b(importAppKey);
                e2.printStackTrace();
            }
        }
    }
}

