/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.low.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.dto.DragRelIdsDTO;
import org.jeecg.common.bpm.api.IBpmBaseExtApi;
import org.jeecg.common.config.TenantContext;
import org.jeecg.common.desform.api.IDesformBaseApi;
import org.jeecg.common.drag.api.IDragBaseApi;
import org.jeecg.common.lowapp.model.LowAppCopyMenu;
import org.jeecg.common.lowapp.utils.LowAppCopyUtil;
import org.jeecg.common.miniflow.ISignalProcessStartApi;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.DateUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.online.low.entity.LowApp;
import org.jeecg.modules.online.low.entity.LowAppAuthField;
import org.jeecg.modules.online.low.entity.LowAppAuthForm;
import org.jeecg.modules.online.low.entity.LowAppAuthOperation;
import org.jeecg.modules.online.low.entity.LowAppAuthRecord;
import org.jeecg.modules.online.low.entity.LowAppAuthRole;
import org.jeecg.modules.online.low.entity.LowAppAuthRoleUser;
import org.jeecg.modules.online.low.entity.LowAppBackup;
import org.jeecg.modules.online.low.entity.LowAppGroupRelation;
import org.jeecg.modules.online.low.entity.LowAppMenu;
import org.jeecg.modules.online.low.enums.AuthRoleUserTypeEnum;
import org.jeecg.modules.online.low.mapper.LowAppAuthRoleMapper;
import org.jeecg.modules.online.low.mapper.LowAppAuthRoleUserMapper;
import org.jeecg.modules.online.low.mapper.LowAppBackupMapper;
import org.jeecg.modules.online.low.mapper.LowAppGroupRelationMapper;
import org.jeecg.modules.online.low.mapper.LowAppMapper;
import org.jeecg.modules.online.low.mapper.LowAppMenuMapper;
import org.jeecg.modules.online.low.mapper.LowAppRecycleMapper;
import org.jeecg.modules.online.low.service.ILowAppAuthFieldService;
import org.jeecg.modules.online.low.service.ILowAppAuthFormService;
import org.jeecg.modules.online.low.service.ILowAppAuthOperationService;
import org.jeecg.modules.online.low.service.ILowAppAuthRecordService;
import org.jeecg.modules.online.low.service.ILowAppAuthRoleService;
import org.jeecg.modules.online.low.service.ILowAppAuthRoleUserService;
import org.jeecg.modules.online.low.service.ILowAppGroupService;
import org.jeecg.modules.online.low.service.ILowAppService;
import org.jeecg.modules.online.low.vo.LowAppAndOwnerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="lowAppServiceImpl")
public class l
extends ServiceImpl<LowAppMapper, LowApp>
implements ILowAppService {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(l.class);
    @Autowired
    ILowAppAuthRoleService lowAppAuthRoleService;
    @Autowired
    ILowAppAuthRoleUserService lowAppAuthRoleUserService;
    @Autowired
    LowAppMenuMapper lowAppMenuMapper;
    @Lazy
    @Autowired
    IDesformBaseApi desformBaseApi;
    @Lazy
    @Autowired
    IDragBaseApi dragBaseApi;
    @Lazy
    @Autowired
    ISignalProcessStartApi signalProcessStartApi;
    @Autowired
    ILowAppAuthRecordService lowAppAuthRecordService;
    @Autowired
    ILowAppAuthOperationService lowAppAuthOperationService;
    @Autowired
    ILowAppAuthFormService lowAppAuthFormService;
    @Autowired
    ILowAppAuthFieldService lowAppAuthFieldService;
    @Autowired
    ILowAppGroupService lowAppGroupService;
    @Autowired
    LowAppRecycleMapper lowAppRecycleMapper;
    @Autowired
    LowAppGroupRelationMapper lowAppGroupRelationMapper;
    @Autowired
    IBpmBaseExtApi bpmBaseExtApi;
    @Lazy
    @Autowired
    private ISysBaseAPI sysBaseAPI;
    @Autowired
    LowAppBackupMapper lowAppBackupMapper;
    @Autowired
    private LowAppAuthRoleUserMapper lowAppAuthRoleUserMapper;
    @Autowired
    private LowAppAuthRoleMapper lowAppAuthRoleMapper;
    @Autowired
    private RedisTemplate redisTemplate;

    @Override
    public String createApp(LowApp lowApp) {
        lowApp.setAppLabel("");
        Integer maxOrderNum = ((LowAppMapper)this.baseMapper).selectLabelMaxOrderNum("");
        if (maxOrderNum == null) {
            lowApp.setOrderNum(0);
        } else {
            lowApp.setOrderNum(maxOrderNum + 1);
        }
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String userId = user.getId();
        lowApp.setOwnerId(userId);
        lowApp.initCreateValue();
        super.save((Object)lowApp);
        String appId = lowApp.getId();
        String adminRoleId = this.lowAppAuthRoleService.createDefaultRoles(appId);
        LowAppAuthRoleUser roleUser = new LowAppAuthRoleUser(adminRoleId, AuthRoleUserTypeEnum.USER.getTable(), userId, appId);
        this.lowAppAuthRoleUserService.save(roleUser);
        return lowApp.getId();
    }

    @Override
    public boolean moveToGroup(LowApp lowApp) {
        Integer maxOrderNum = ((LowAppMapper)this.baseMapper).selectLabelMaxOrderNum(lowApp.getAppLabel());
        if (maxOrderNum == null) {
            lowApp.setOrderNum(0);
        } else {
            lowApp.setOrderNum(maxOrderNum + 1);
        }
        return super.updateById((Object)lowApp);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String copy(String id) {
        LowApp app = (LowApp)((LowAppMapper)this.baseMapper).selectById((Serializable)((Object)id));
        if (app != null) {
            LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
            app.clearDefaultField();
            app.setAppName(app.getAppName() + "-\u590d\u5236");
            app.setOwnerId(user.getId());
            super.save((Object)app);
            String appId = app.getId();
            a.info("-------\u590d\u5236\u5e94\u7528ID:{}\uff0c\u590d\u5236\u540e:{}---------", (Object)id, (Object)appId);
            LambdaQueryWrapper groupRelationQuery = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppGroupRelation::getAppId, (Object)id);
            List groupRelationList = this.lowAppGroupRelationMapper.selectList((Wrapper)groupRelationQuery);
            if (groupRelationList != null && groupRelationList.size() > 0) {
                for (LowAppGroupRelation relation : groupRelationList) {
                    relation.setAppId(appId);
                    relation.setId(null);
                    this.lowAppGroupRelationMapper.insert(relation);
                }
            }
            LambdaQueryWrapper menuQuery = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppMenu::getAppId, (Object)id);
            List menuList = this.lowAppMenuMapper.selectList((Wrapper)menuQuery);
            HashMap<String, String> viewIdMapping = new HashMap<String, String>();
            HashMap<String, String> formCodeMapping = new HashMap<String, String>();
            HashMap<String, String> formIdMapping = new HashMap<String, String>();
            Map<Object, Object> dragIdMapping = new HashMap();
            Map<String, String> menuGroupIdMapping = null;
            if (menuList != null && menuList.size() > 0) {
                menuGroupIdMapping = this.a(menuList, appId);
                this.a(null, menuList, appId, viewIdMapping, formIdMapping, formCodeMapping, menuGroupIdMapping, null, null);
                dragIdMapping = this.a(null, menuList, appId, formCodeMapping, menuGroupIdMapping);
            }
            LambdaQueryWrapper roleQuery = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppAuthRole::getAppId, (Object)id);
            List roleList = this.lowAppAuthRoleService.list((Wrapper)roleQuery);
            String adminRoleId = null;
            if (roleList != null && roleList.size() > 0) {
                for (LowAppAuthRole role : roleList) {
                    if (role == null) continue;
                    String newRoleId = this.a(null, role, appId, viewIdMapping, formCodeMapping);
                    if (!"admin".equals(role.getCode())) continue;
                    adminRoleId = newRoleId;
                }
            }
            LowAppAuthRoleUser roleUser = new LowAppAuthRoleUser(adminRoleId, AuthRoleUserTypeEnum.USER.getTable(), user.getId(), appId);
            this.lowAppAuthRoleUserService.save(roleUser);
            ArrayList designFormCodeList = new ArrayList(formCodeMapping.values());
            LowAppCopyMenu lowAppCopyMenu = new LowAppCopyMenu();
            lowAppCopyMenu.setFormCodeMapping(formCodeMapping);
            lowAppCopyMenu.setFormIdMapping(formIdMapping);
            lowAppCopyMenu.setDragIdMapping(dragIdMapping);
            lowAppCopyMenu.setViewIdMapping(viewIdMapping);
            lowAppCopyMenu.setAppId(id);
            lowAppCopyMenu.setNewAppId(appId);
            Map processIdMap = this.signalProcessStartApi.copyAppProcess(lowAppCopyMenu, Boolean.valueOf(false));
            lowAppCopyMenu.setDesignFormCodeList(designFormCodeList);
            lowAppCopyMenu.setProcessIdMapping(processIdMap);
            this.desformBaseApi.updateLowAppButtonProcessId(lowAppCopyMenu);
            this.desformBaseApi.copyLowAppChart(lowAppCopyMenu);
            DragRelIdsDTO dragRelIdsDTO = new DragRelIdsDTO(null, formCodeMapping, formIdMapping, dragIdMapping, viewIdMapping, processIdMap, null);
            this.dragBaseApi.replacePageRelIdsCrossApp(dragRelIdsDTO);
            return appId;
        }
        return null;
    }

    @Override
    public String copyWithTenantId(String id, String tenantId, String originalTenantId) {
        LowApp app;
        String loginTenantId = TenantContext.getTenant();
        if (oConvertUtils.isNotEmpty((Object)originalTenantId) && !loginTenantId.equals(originalTenantId)) {
            TenantContext.setTenant((String)originalTenantId);
        }
        if ((app = (LowApp)((LowAppMapper)this.baseMapper).selectById((Serializable)((Object)id))) != null) {
            Integer tid = Integer.parseInt(tenantId);
            LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
            app.clearDefaultField();
            app.setAppName(app.getAppName() + "-\u590d\u5236");
            app.setOwnerId(user.getId());
            app.setTenantId(tid);
            super.save((Object)app);
            String appId = app.getId();
            a.info("-------\u590d\u5236\u5e94\u7528 :: \u539f\u5e94\u7528ID:{}\uff0c\u590d\u5236\u540e\u65b0\u5e94\u7528ID:{}---------", (Object)id, (Object)appId);
            HashMap<String, String> appIdMapping = new HashMap<String, String>();
            appIdMapping.put(id, appId);
            Map dictCodeMapping = this.sysBaseAPI.copyLowAppDict(id, appId, tenantId);
            LambdaQueryWrapper menuQuery = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppMenu::getAppId, (Object)id);
            List menuList = this.lowAppMenuMapper.selectList((Wrapper)menuQuery);
            HashMap<String, String> viewIdMapping = new HashMap<String, String>();
            HashMap<String, String> formCodeMapping = new HashMap<String, String>();
            HashMap<String, String> formIdMapping = new HashMap<String, String>();
            Map<Object, Object> dragIdMapping = new HashMap();
            Map<String, String> menuGroupIdMapping = null;
            if (menuList != null && menuList.size() > 0) {
                menuGroupIdMapping = this.a(menuList, appId);
                this.a(tid, menuList, appId, viewIdMapping, formIdMapping, formCodeMapping, menuGroupIdMapping, appIdMapping, dictCodeMapping);
                dragIdMapping = this.a(tid, menuList, appId, formCodeMapping, menuGroupIdMapping);
            }
            LambdaQueryWrapper roleQuery = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppAuthRole::getAppId, (Object)id);
            List roleList = this.lowAppAuthRoleService.list((Wrapper)roleQuery);
            String adminRoleId = null;
            if (roleList != null && roleList.size() > 0) {
                for (LowAppAuthRole role : roleList) {
                    if (role == null) continue;
                    String newRoleId = this.a(tid, role, appId, viewIdMapping, formCodeMapping);
                    if (!"admin".equals(role.getCode())) continue;
                    adminRoleId = newRoleId;
                }
            }
            LowAppAuthRoleUser roleUser = new LowAppAuthRoleUser(adminRoleId, AuthRoleUserTypeEnum.USER.getTable(), user.getId(), appId);
            this.lowAppAuthRoleUserService.save(roleUser);
            ArrayList designFormCodeList = new ArrayList(formCodeMapping.values());
            LowAppCopyMenu lowAppCopyMenu = new LowAppCopyMenu();
            lowAppCopyMenu.setFormCodeMapping(formCodeMapping);
            lowAppCopyMenu.setFormIdMapping(formIdMapping);
            lowAppCopyMenu.setDragIdMapping(dragIdMapping);
            lowAppCopyMenu.setViewIdMapping(viewIdMapping);
            lowAppCopyMenu.setDictCodeMapping(dictCodeMapping);
            lowAppCopyMenu.setTenantId(tid);
            lowAppCopyMenu.setAppId(id);
            lowAppCopyMenu.setNewAppId(appId);
            Map processIdMap = this.signalProcessStartApi.copyAppProcess(lowAppCopyMenu, Boolean.valueOf(!oConvertUtils.isEqual((Object)tenantId, (Object)originalTenantId)));
            lowAppCopyMenu.setDesignFormCodeList(designFormCodeList);
            lowAppCopyMenu.setProcessIdMapping(processIdMap);
            this.desformBaseApi.updateLowAppButtonProcessId(lowAppCopyMenu);
            this.desformBaseApi.copyLowAppChart(lowAppCopyMenu);
            DragRelIdsDTO dragRelIdsDTO = new DragRelIdsDTO(null, formCodeMapping, formIdMapping, dragIdMapping, viewIdMapping, processIdMap, dictCodeMapping);
            this.dragBaseApi.replacePageRelIdsCrossApp(dragRelIdsDTO);
            if (oConvertUtils.isNotEmpty((Object)originalTenantId) && !loginTenantId.equals(originalTenantId)) {
                TenantContext.setTenant((String)loginTenantId);
            }
            return appId;
        }
        return null;
    }

    private String a(Integer tenantId, LowAppAuthRole role, String appId, Map<String, String> viewIdMapping, Map<String, String> formCodeMapping) {
        LambdaQueryWrapper authFieldQuery;
        List authFieldList;
        LambdaQueryWrapper authOperationQuery;
        List authOperationList;
        LambdaQueryWrapper authRecordQuery;
        List authRecordList;
        String originRoleId = role.getId();
        role.setAppId(appId);
        role.clearDefaultField();
        if (tenantId != null) {
            role.setTenantId(tenantId);
        }
        this.lowAppAuthRoleService.save(role);
        String roleId = role.getId();
        LambdaQueryWrapper authFormQuery = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppAuthForm::getAppRoleId, (Object)originRoleId);
        List authFormList = this.lowAppAuthFormService.list((Wrapper)authFormQuery);
        if (authFormList != null && authFormList.size() > 0) {
            for (LowAppAuthForm authForm : authFormList) {
                String oldViewId;
                authForm.setAppRoleId(roleId);
                authForm.clearDefaultField();
                String oldCode = authForm.getDesignFormCode();
                if (oConvertUtils.isNotEmpty((Object)oldCode)) {
                    String newFormCode = formCodeMapping.get(oldCode);
                    if (oConvertUtils.isEmpty((Object)newFormCode)) {
                        a.error("app\u590d\u5236\uff0c\u6388\u6743\u89d2\u8272\u590d\u5236\u65f6\uff0cLowAppAuthForm \u8868\u5355\u7f16\u7801:{} \u914d\u7f6e\u6ca1\u627e\u5230", (Object)authForm.getDesignFormCode());
                        continue;
                    }
                    authForm.setDesignFormCode(newFormCode);
                }
                if (!oConvertUtils.isNotEmpty((Object)(oldViewId = authForm.getViewId()))) continue;
                String newViewId = viewIdMapping.get(oldViewId);
                if (oConvertUtils.isEmpty((Object)newViewId)) {
                    a.error("app\u590d\u5236\uff0c\u6388\u6743\u89d2\u8272\u590d\u5236\u65f6\uff0cLowAppAuthForm \u89c6\u56feID:{} \u914d\u7f6e\u6ca1\u627e\u5230", (Object)authForm.getViewId());
                    continue;
                }
                authForm.setViewId(newViewId);
            }
            this.lowAppAuthFormService.saveBatch(authFormList);
        }
        if ((authRecordList = this.lowAppAuthRecordService.list((Wrapper)(authRecordQuery = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppAuthRecord::getAppRoleId, (Object)originRoleId)))) != null && authRecordList.size() > 0) {
            for (LowAppAuthRecord authRecord : authRecordList) {
                authRecord.setAppRoleId(roleId);
                authRecord.clearDefaultField();
                String oldCode = authRecord.getDesignFormCode();
                if (!oConvertUtils.isNotEmpty((Object)oldCode)) continue;
                String newFormCode = formCodeMapping.get(oldCode);
                if (oConvertUtils.isEmpty((Object)newFormCode)) {
                    a.error("app\u590d\u5236\uff0c\u6388\u6743\u89d2\u8272\u590d\u5236\u65f6\uff0cLowAppAuthRecord \u8868\u5355\u7f16\u7801:{} \u914d\u7f6e\u6ca1\u627e\u5230", (Object)authRecord.getDesignFormCode());
                    continue;
                }
                authRecord.setDesignFormCode(newFormCode);
            }
            this.lowAppAuthRecordService.saveBatch(authRecordList);
        }
        if ((authOperationList = this.lowAppAuthOperationService.list((Wrapper)(authOperationQuery = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppAuthOperation::getAppRoleId, (Object)originRoleId)))) != null && authOperationList.size() > 0) {
            for (LowAppAuthOperation authOperation : authOperationList) {
                authOperation.setAppRoleId(roleId);
                authOperation.clearDefaultField();
                String oldCode = authOperation.getDesignFormCode();
                if (!oConvertUtils.isNotEmpty((Object)oldCode)) continue;
                String newFormCode = formCodeMapping.get(oldCode);
                if (oConvertUtils.isEmpty((Object)newFormCode)) {
                    a.error("app\u590d\u5236\uff0c\u6388\u6743\u89d2\u8272\u590d\u5236\u65f6\uff0cLowAppAuthOperation \u8868\u5355\u7f16\u7801:{} \u914d\u7f6e\u6ca1\u627e\u5230", (Object)authOperation.getDesignFormCode());
                    continue;
                }
                authOperation.setDesignFormCode(newFormCode);
            }
            this.lowAppAuthOperationService.saveBatch(authOperationList);
        }
        if ((authFieldList = this.lowAppAuthFieldService.list((Wrapper)(authFieldQuery = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppAuthField::getAppRoleId, (Object)originRoleId)))) != null && authFieldList.size() > 0) {
            for (LowAppAuthField authField : authFieldList) {
                authField.setAppRoleId(roleId);
                authField.clearDefaultField();
                String oldCode = authField.getDesignFormCode();
                if (!oConvertUtils.isNotEmpty((Object)oldCode)) continue;
                String newFormCode = formCodeMapping.get(oldCode);
                if (oConvertUtils.isEmpty((Object)newFormCode)) {
                    a.error("app\u590d\u5236\uff0c\u6388\u6743\u89d2\u8272\u590d\u5236\u65f6\uff0cLowAppAuthField \u8868\u5355\u7f16\u7801:{} \u914d\u7f6e\u6ca1\u627e\u5230", (Object)authField.getDesignFormCode());
                    continue;
                }
                authField.setDesignFormCode(newFormCode);
            }
            this.lowAppAuthFieldService.saveBatch(authFieldList);
        }
        return roleId;
    }

    private Map<String, String> a(List<LowAppMenu> menuList, String appId) {
        HashMap<String, String> menuGroupIdMapping = new HashMap<String, String>();
        for (LowAppMenu menu : menuList) {
            if (!"group".equals(menu.getType())) continue;
            String originMenuGroupId = menu.getId();
            menu.clearDefaultField();
            menu.setAppId(appId);
            this.lowAppMenuMapper.insert(menu);
            menuGroupIdMapping.put(originMenuGroupId, menu.getId());
        }
        return menuGroupIdMapping;
    }

    private void a(Integer tenantId, List<LowAppMenu> menuList, String appId, Map<String, String> viewIdMapping, Map<String, String> formIdMapping, Map<String, String> formCodeMapping, Map<String, String> menuGroupIdMapping, Map<String, String> appIdMapping, Map<String, String> dictCodeMapping) {
        for (LowAppMenu menu : menuList) {
            boolean isIdForm = "form".equals(menu.getType());
            if (!"desform".equals(menu.getType()) && !isIdForm) continue;
            menu.setAppId(appId);
            menu.clearDefaultField();
            String menuUrl = menu.getMenuUrl();
            LowAppCopyMenu copyMenu = new LowAppCopyMenu(menuUrl, "app");
            copyMenu.setAppId(appId);
            copyMenu.setIdForm(isIdForm);
            copyMenu.setTenantId(tenantId);
            LowAppCopyMenu copyMenuResult = this.desformBaseApi.copyDesignForm(copyMenu);
            copyMenuResult.addView(viewIdMapping);
            formCodeMapping.put(copyMenuResult.getOldFormCode(), copyMenuResult.getNewFormCode());
            formIdMapping.put(copyMenuResult.getOldFormId(), copyMenuResult.getNewFormId());
            if (isIdForm) {
                menu.setMenuUrl(copyMenuResult.getNewFormId());
                menu.setDesformCode(copyMenuResult.getNewFormCode());
            } else {
                menu.setMenuUrl(copyMenuResult.getNewFormCode());
            }
            String pid = menu.getParentId();
            if (oConvertUtils.isNotEmpty((Object)pid)) {
                String newPid = menuGroupIdMapping.get(pid);
                menu.setParentId(newPid);
            }
            this.lowAppMenuMapper.insert(menu);
        }
        LowAppCopyMenu copyMenu = new LowAppCopyMenu();
        copyMenu.setFormCodeMapping(formCodeMapping);
        copyMenu.setAppIdMapping(appIdMapping);
        copyMenu.setDictCodeMapping(dictCodeMapping);
        this.desformBaseApi.updateDesignFormJson(copyMenu);
        copyMenu.setTenantId(tenantId);
        this.desformBaseApi.batchDisabledOtherTenantLinkRecords(copyMenu);
    }

    private Map<String, String> a(Integer tenantId, List<LowAppMenu> menuList, String appId, Map<String, String> formCodeMapping, Map<String, String> menuGroupIdMapping) {
        HashMap<String, String> dragIdMapping = new HashMap<String, String>();
        for (LowAppMenu menu : menuList) {
            if (!"drag".equals(menu.getType())) continue;
            menu.setAppId(appId);
            menu.clearDefaultField();
            String menuUrl = menu.getMenuUrl();
            String newDragId = this.dragBaseApi.copyDragPage(menuUrl, tenantId);
            if (newDragId == null) continue;
            a.info("\u9700\u8981\u66f4\u65b0\u7684\u4eea\u8868\u76d8\u6570\u636e\uff1a" + menu.toString());
            menu.setMenuUrl(newDragId);
            this.lowAppMenuMapper.updateDragAppId(menu);
            a.info("\u66f4\u65b0\u4eea\u8868\u76d8\u4e4b\u540e\u7684\u5e94\u7528id\uff1a" + menu.getAppId());
            formCodeMapping.put(menuUrl, newDragId);
            String pid = menu.getParentId();
            if (oConvertUtils.isNotEmpty((Object)pid)) {
                String newPid = menuGroupIdMapping.get(pid);
                menu.setParentId(newPid);
            }
            this.lowAppMenuMapper.insert(menu);
            dragIdMapping.put(menuUrl, newDragId);
        }
        return dragIdMapping;
    }

    @Override
    public void resetAppOrderNum(JSONObject json, String tenantId) {
        JSONArray array = json.getJSONArray("list");
        Boolean isStar = json.getBoolean("star");
        LoginUser loginUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String cacheKey = "sys:user:lowapp:dragappsort:" + tenantId + "_" + loginUser.getId();
        if (isStar.booleanValue()) {
            Object redisData = this.redisTemplate.opsForValue().get((Object)cacheKey);
            if (redisData != null) {
                HashMap<Object, Integer> map = new HashMap<Object, Integer>();
                for (int i2 = 0; i2 < array.size(); ++i2) {
                    String id = array.getJSONObject(i2).getString("id");
                    Integer orderNum = array.getJSONObject(i2).getInteger("orderNum");
                    map.put(id, orderNum);
                }
                List lowApps = JSONArray.parseArray((String)redisData.toString(), LowApp.class);
                for (LowApp app : lowApps) {
                    if (!map.containsKey(app.getId())) continue;
                    app.setStarOrderNum((Integer)map.get(app.getId()));
                }
                array = JSONArray.parseArray((String)JSON.toJSONString((Object)lowApps));
            } else {
                for (int i3 = 0; i3 < array.size(); ++i3) {
                    String id = array.getJSONObject(i3).getString("id");
                    Integer orderNum = array.getJSONObject(i3).getInteger("orderNum");
                    LowApp lowApp = new LowApp();
                    lowApp.setId(id);
                    lowApp.setStarOrderNum(orderNum);
                    array.set(i3, (Object)lowApp);
                }
            }
        }
        this.redisTemplate.opsForValue().set((Object)cacheKey, (Object)array.toJSONString());
    }

    @Override
    public List<LowAppAndOwnerInfo> getLowAppListWithOwnerInfo(LowAppAndOwnerInfo info) {
        info.initDelFlag();
        List<LowAppAndOwnerInfo> list = ((LowAppMapper)this.baseMapper).getLowAppListWithOwnerInfo(info);
        if (list != null && list.size() > 0) {
            List<String> appIdList = list.stream().map(i2 -> i2.getId()).collect(Collectors.toList());
            List<LowAppMenu> menuList = this.lowAppMenuMapper.queryFormCountGroupByApp(appIdList);
            block0: for (LowAppAndOwnerInfo app : list) {
                for (LowAppMenu menu : menuList) {
                    if (!app.getId().equals(menu.getAppId())) continue;
                    app.setFormCount(menu.getCount());
                    continue block0;
                }
            }
        }
        return list;
    }

    @Override
    public void changeOwner(LowApp lowApp) {
        String id = lowApp.getId();
        String ownerId = lowApp.getOwnerId();
        LowApp app = (LowApp)((LowAppMapper)this.baseMapper).selectById((Serializable)((Object)id));
        if (app != null) {
            app.setOwnerId(ownerId);
            ((LowAppMapper)this.baseMapper).updateById(app);
            LambdaQueryWrapper query1 = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppAuthRole::getAppId, (Object)id)).eq(LowAppAuthRole::getCode, (Object)"admin");
            LowAppAuthRole adminRole = (LowAppAuthRole)this.lowAppAuthRoleService.getOne((Wrapper)query1);
            if (adminRole != null) {
                String adminRoleId = adminRole.getId();
                LambdaQueryWrapper query2 = ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppAuthRoleUser::getAppId, (Object)id)).eq(LowAppAuthRoleUser::getRelationId, (Object)ownerId)).eq(LowAppAuthRoleUser::getType, (Object)AuthRoleUserTypeEnum.USER.getTable())).eq(LowAppAuthRoleUser::getAuthRoleId, (Object)adminRoleId)).select(new SFunction[]{LowAppAuthRoleUser::getId});
                LowAppAuthRoleUser relation = (LowAppAuthRoleUser)this.lowAppAuthRoleUserService.getOne((Wrapper)query2);
                if (relation == null || relation.getId() == null) {
                    LowAppAuthRoleUser roleUser = new LowAppAuthRoleUser(adminRoleId, AuthRoleUserTypeEnum.USER.getTable(), ownerId, id);
                    this.lowAppAuthRoleUserService.save(roleUser);
                }
            }
        }
    }

    @Override
    public List<LowApp> queryDeleteAppList() {
        return this.lowAppRecycleMapper.queryDeleteAppList();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteLowApp(LowApp lowApp) throws Exception {
        LambdaQueryWrapper groupQuery;
        List groupRelations;
        String appId = lowApp.getId();
        List<String> roleIdList = this.lowAppRecycleMapper.getAppAuthRoleIdList(appId);
        if (roleIdList != null && roleIdList.size() > 0) {
            this.lowAppRecycleMapper.deleteAuthFormField(roleIdList);
            this.lowAppRecycleMapper.deleteAuthOperation(roleIdList);
            this.lowAppRecycleMapper.deleteAuthRecord(roleIdList);
            this.lowAppRecycleMapper.deleteAuthForm(roleIdList);
            this.lowAppRecycleMapper.deleteAppAuthRoleUser(appId);
            this.lowAppRecycleMapper.deleteAppAuthRole(appId);
        }
        if ((groupRelations = this.lowAppGroupRelationMapper.selectList((Wrapper)(groupQuery = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppGroupRelation::getAppId, (Object)appId)))) != null && groupRelations.size() > 0) {
            List groupIdList = groupRelations.stream().map(i2 -> i2.getGroupId()).collect(Collectors.toList());
            this.lowAppGroupRelationMapper.delete((Wrapper)groupQuery);
        }
        this.a(appId);
        this.bpmBaseExtApi.batchDeleteProcessByAppId(appId);
        this.lowAppRecycleMapper.deleteApp(appId);
        this.lowAppRecycleMapper.deleteAppDictItem(appId);
        this.lowAppRecycleMapper.deleteAppDict(appId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteLowAppLogically(LowApp lowApp) throws Exception {
        this.updateById(lowApp);
        this.bpmBaseExtApi.batchCloseProcessByAppId(lowApp.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void backupApp(LowAppBackup lowAppBackup) {
        String originAppId = lowAppBackup.getOriginAppId();
        LowApp app = (LowApp)((LowAppMapper)this.baseMapper).selectById((Serializable)((Object)originAppId));
        if (app != null) {
            List<LowAppAuthRoleUser> roleUserList;
            LambdaQueryWrapper roleQuery;
            List roleList;
            LambdaQueryWrapper menuQuery;
            List menuList;
            LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
            BeanUtils.copyProperties((Object)app, (Object)lowAppBackup);
            lowAppBackup.setBackupBy(user.getRealname());
            lowAppBackup.setBackupTime(new Date());
            String backupKey = "_bak" + ((SimpleDateFormat)DateUtils.yyyymmddhhmmss.get()).format(new Date());
            String backupId = LowAppCopyUtil.getBackupValue((String)originAppId, (String)backupKey);
            lowAppBackup.setBackupKey(backupKey);
            lowAppBackup.setId(backupId);
            this.lowAppBackupMapper.insert(lowAppBackup);
            LambdaQueryWrapper groupRelationQuery = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppGroupRelation::getAppId, (Object)originAppId);
            List groupRelationList = this.lowAppGroupRelationMapper.selectList((Wrapper)groupRelationQuery);
            if (groupRelationList != null && groupRelationList.size() > 0) {
                for (LowAppGroupRelation relation : groupRelationList) {
                    relation.setAppId(backupId);
                    String relationBackupId = LowAppCopyUtil.getBackupValue((String)relation.getId(), (String)backupKey);
                    relation.setId(relationBackupId);
                    String groupId = LowAppCopyUtil.getBackupValue((String)relation.getGroupId(), (String)backupKey);
                    relation.setGroupId(groupId);
                    this.lowAppGroupRelationMapper.insert(relation);
                }
            }
            if ((menuList = this.lowAppMenuMapper.selectList((Wrapper)(menuQuery = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppMenu::getAppId, (Object)originAppId)))) != null && menuList.size() > 0) {
                for (LowAppMenu menu : menuList) {
                    String menuUrl;
                    menu.setAppId(backupId);
                    String newMenuId = LowAppCopyUtil.getBackupValue((String)menu.getId(), (String)backupKey);
                    menu.setId(newMenuId);
                    String pid = menu.getParentId();
                    if (oConvertUtils.isNotEmpty((Object)pid)) {
                        String newPid = LowAppCopyUtil.getBackupValue((String)pid, (String)backupKey);
                        menu.setParentId(newPid);
                    }
                    if (oConvertUtils.isNotEmpty((Object)(menuUrl = menu.getMenuUrl()))) {
                        String newUrl = LowAppCopyUtil.getBackupValue((String)menuUrl, (String)backupKey);
                        menu.setMenuUrl(newUrl);
                        String menuType = menu.getType();
                        LowAppCopyMenu copyMenu = new LowAppCopyMenu(menuUrl, "backup");
                        copyMenu.setBackupKey(backupKey);
                        boolean isIdForm = "form".equals(menuType);
                        copyMenu.setIdForm(isIdForm);
                        if ("desform".equals(menuType) || isIdForm) {
                            this.desformBaseApi.copyDesignForm(copyMenu);
                        } else if ("drag".equals(menuType)) {
                            this.dragBaseApi.backupsPageCrossApp(menuUrl, backupKey);
                        }
                    }
                    this.lowAppMenuMapper.insert(menu);
                }
            }
            if ((roleList = this.lowAppAuthRoleService.list((Wrapper)(roleQuery = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppAuthRole::getAppId, (Object)originAppId)))) != null && roleList.size() > 0) {
                for (LowAppAuthRole role : roleList) {
                    if (role == null) continue;
                    this.a(role, backupId, backupKey);
                }
            }
            if ((roleUserList = this.lowAppAuthRoleUserService.queryList(originAppId)) != null && roleUserList.size() > 0) {
                for (LowAppAuthRoleUser roleUser : roleUserList) {
                    if (roleUser == null) continue;
                    String newRoleId = LowAppCopyUtil.getBackupValue((String)roleUser.getAuthRoleId(), (String)backupKey);
                    roleUser.setAuthRoleId(newRoleId);
                    roleUser.setAppId(backupId);
                    roleUser.setId(null);
                }
                this.lowAppAuthRoleUserService.saveBatch(roleUserList);
            }
            this.signalProcessStartApi.backupAppProcess(originAppId, backupKey);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void coverByBackup(LowAppBackup lowAppBackup) {
        String backupId = lowAppBackup.getId();
        if ((lowAppBackup = (LowAppBackup)this.lowAppBackupMapper.selectById((Serializable)((Object)backupId))) != null) {
            String appId = lowAppBackup.getOriginAppId();
            String backupKey = lowAppBackup.getBackupKey();
            LowApp lowApp = (LowApp)this.getById((Serializable)((Object)appId));
            BeanUtils.copyProperties((Object)lowAppBackup, (Object)lowApp);
            lowApp.setId(appId);
            this.updateById(lowApp);
            LambdaQueryWrapper deleteQuery = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppGroupRelation::getAppId, (Object)appId);
            this.lowAppGroupRelationMapper.delete((Wrapper)deleteQuery);
            LambdaQueryWrapper groupRelationQuery = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppGroupRelation::getAppId, (Object)backupId);
            List groupRelationList = this.lowAppGroupRelationMapper.selectList((Wrapper)groupRelationQuery);
            if (groupRelationList != null && groupRelationList.size() > 0) {
                for (LowAppGroupRelation relation : groupRelationList) {
                    relation.setAppId(appId);
                    String relationId = LowAppCopyUtil.getOriginValue((String)relation.getId(), (String)backupKey);
                    relation.setId(relationId);
                    String groupId = LowAppCopyUtil.getOriginValue((String)relation.getGroupId(), (String)backupKey);
                    relation.setGroupId(groupId);
                    this.lowAppGroupRelationMapper.insert(relation);
                }
            }
            this.a(appId, false);
            LambdaQueryWrapper menuQuery2 = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppMenu::getAppId, (Object)backupId);
            List menuList = this.lowAppMenuMapper.selectList((Wrapper)menuQuery2);
            if (menuList != null && menuList.size() > 0) {
                for (LowAppMenu menu : menuList) {
                    menu.setAppId(appId);
                    String newId = LowAppCopyUtil.getOriginValue((String)menu.getId(), (String)backupKey);
                    menu.setId(newId);
                    String pid = menu.getParentId();
                    String newPid = LowAppCopyUtil.getOriginValue((String)pid, (String)backupKey);
                    menu.setParentId(newPid);
                    String menuUrl = menu.getMenuUrl();
                    if (oConvertUtils.isNotEmpty((Object)menuUrl)) {
                        String newUrl = LowAppCopyUtil.getOriginValue((String)menuUrl, (String)backupKey);
                        menu.setMenuUrl(newUrl);
                        String menuType = menu.getType();
                        LowAppCopyMenu copyMenu = new LowAppCopyMenu(newUrl, "cover");
                        copyMenu.setBackupKey(backupKey);
                        boolean isIdForm = "form".equals(menuType);
                        copyMenu.setIdForm(isIdForm);
                        if ("desform".equals(menuType) || isIdForm) {
                            copyMenu.setOriginFormCode(menuUrl);
                            this.desformBaseApi.coverDesignForm(copyMenu);
                        } else if ("drag".equals(menuType)) {
                            this.dragBaseApi.revertPageCrossApp(menuUrl, backupKey);
                        }
                    }
                    this.lowAppMenuMapper.insert(menu);
                }
            }
            LambdaQueryWrapper roleDeleteQuery = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppAuthRole::getAppId, (Object)appId);
            this.lowAppAuthRoleService.remove((Wrapper)roleDeleteQuery);
            LambdaQueryWrapper roleQuery = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppAuthRole::getAppId, (Object)backupId);
            List roleList = this.lowAppAuthRoleService.list((Wrapper)roleQuery);
            if (roleList != null && roleList.size() > 0) {
                for (LowAppAuthRole role : roleList) {
                    if (role == null) continue;
                    this.a(backupKey, appId, role);
                }
            }
            LambdaQueryWrapper roleUserDeleteQuery = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppAuthRoleUser::getAppId, (Object)appId);
            this.lowAppAuthRoleUserService.remove((Wrapper)roleUserDeleteQuery);
            List<LowAppAuthRoleUser> roleUserList = this.lowAppAuthRoleUserService.queryList(backupId);
            if (roleUserList != null && roleUserList.size() > 0) {
                for (LowAppAuthRoleUser roleUser : roleUserList) {
                    if (roleUser == null) continue;
                    String newRoleId = LowAppCopyUtil.getOriginValue((String)roleUser.getAuthRoleId(), (String)backupKey);
                    roleUser.setAuthRoleId(newRoleId);
                    roleUser.setAppId(appId);
                    roleUser.setId(null);
                }
                this.lowAppAuthRoleUserService.saveBatch(roleUserList);
            }
            this.signalProcessStartApi.coverAppProcess(backupId, backupKey);
        }
    }

    private void a(LowAppAuthRole role, String appId, String backupKey) {
        LambdaQueryWrapper authFieldQuery;
        List authFieldList;
        LambdaQueryWrapper authOperationQuery;
        List authOperationList;
        LambdaQueryWrapper authRecordQuery;
        List authRecordList;
        String originRoleId = role.getId();
        role.setAppId(appId);
        role.clearDefaultField();
        String newRoleId = LowAppCopyUtil.getBackupValue((String)originRoleId, (String)backupKey);
        role.setId(newRoleId);
        this.lowAppAuthRoleService.save(role);
        String roleId = role.getId();
        LambdaQueryWrapper authFormQuery = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppAuthForm::getAppRoleId, (Object)originRoleId);
        List authFormList = this.lowAppAuthFormService.list((Wrapper)authFormQuery);
        if (authFormList != null && authFormList.size() > 0) {
            for (LowAppAuthForm authForm : authFormList) {
                authForm.setAppRoleId(roleId);
                authForm.clearDefaultField();
                String newFormCode = LowAppCopyUtil.getBackupValue((String)authForm.getDesignFormCode(), (String)backupKey);
                authForm.setDesignFormCode(newFormCode);
                String newViewId = LowAppCopyUtil.getBackupValue((String)authForm.getViewId(), (String)backupKey);
                authForm.setViewId(newViewId);
            }
            this.lowAppAuthFormService.saveBatch(authFormList);
        }
        if ((authRecordList = this.lowAppAuthRecordService.list((Wrapper)(authRecordQuery = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppAuthRecord::getAppRoleId, (Object)originRoleId)))) != null && authRecordList.size() > 0) {
            for (LowAppAuthRecord authRecord : authRecordList) {
                authRecord.setAppRoleId(roleId);
                authRecord.clearDefaultField();
                String newFormCode = LowAppCopyUtil.getBackupValue((String)authRecord.getDesignFormCode(), (String)backupKey);
                authRecord.setDesignFormCode(newFormCode);
            }
            this.lowAppAuthRecordService.saveBatch(authRecordList);
        }
        if ((authOperationList = this.lowAppAuthOperationService.list((Wrapper)(authOperationQuery = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppAuthOperation::getAppRoleId, (Object)originRoleId)))) != null && authOperationList.size() > 0) {
            for (LowAppAuthOperation authOperation : authOperationList) {
                authOperation.setAppRoleId(roleId);
                authOperation.clearDefaultField();
                String newFormCode = LowAppCopyUtil.getBackupValue((String)authOperation.getDesignFormCode(), (String)backupKey);
                authOperation.setDesignFormCode(newFormCode);
            }
            this.lowAppAuthOperationService.saveBatch(authOperationList);
        }
        if ((authFieldList = this.lowAppAuthFieldService.list((Wrapper)(authFieldQuery = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppAuthField::getAppRoleId, (Object)originRoleId)))) != null && authFieldList.size() > 0) {
            for (LowAppAuthField authField : authFieldList) {
                authField.setAppRoleId(roleId);
                authField.clearDefaultField();
                String newFormCode = LowAppCopyUtil.getBackupValue((String)authField.getDesignFormCode(), (String)backupKey);
                authField.setDesignFormCode(newFormCode);
            }
            this.lowAppAuthFieldService.saveBatch(authFieldList);
        }
    }

    private void a(String backupKey, String appId, LowAppAuthRole role) {
        String roleId = role.getId();
        String originRoleId = LowAppCopyUtil.getOriginValue((String)roleId, (String)backupKey);
        role.setAppId(appId);
        role.setId(originRoleId);
        this.lowAppAuthRoleService.save(role);
        LambdaQueryWrapper authFormDeleteQuery = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppAuthForm::getAppRoleId, (Object)originRoleId);
        this.lowAppAuthFormService.remove((Wrapper)authFormDeleteQuery);
        LambdaQueryWrapper authFormQuery = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppAuthForm::getAppRoleId, (Object)roleId);
        List authFormList = this.lowAppAuthFormService.list((Wrapper)authFormQuery);
        if (authFormList != null && authFormList.size() > 0) {
            for (LowAppAuthForm authForm : authFormList) {
                authForm.setAppRoleId(originRoleId);
                String newFormCode = LowAppCopyUtil.getOriginValue((String)authForm.getDesignFormCode(), (String)backupKey);
                authForm.setDesignFormCode(newFormCode);
                String newViewId = LowAppCopyUtil.getOriginValue((String)authForm.getViewId(), (String)backupKey);
                authForm.setViewId(newViewId);
                authForm.setId(null);
            }
            this.lowAppAuthFormService.saveBatch(authFormList);
        }
        LambdaQueryWrapper authRecordDeleteQuery = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppAuthRecord::getAppRoleId, (Object)originRoleId);
        this.lowAppAuthRecordService.remove((Wrapper)authRecordDeleteQuery);
        LambdaQueryWrapper authRecordQuery = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppAuthRecord::getAppRoleId, (Object)roleId);
        List authRecordList = this.lowAppAuthRecordService.list((Wrapper)authRecordQuery);
        if (authRecordList != null && authRecordList.size() > 0) {
            for (LowAppAuthRecord authRecord : authRecordList) {
                authRecord.setAppRoleId(originRoleId);
                String newFormCode = LowAppCopyUtil.getOriginValue((String)authRecord.getDesignFormCode(), (String)backupKey);
                authRecord.setDesignFormCode(newFormCode);
                authRecord.setId(null);
            }
            this.lowAppAuthRecordService.saveBatch(authRecordList);
        }
        LambdaQueryWrapper authOperationDeleteQuery = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppAuthOperation::getAppRoleId, (Object)originRoleId);
        this.lowAppAuthOperationService.remove((Wrapper)authOperationDeleteQuery);
        LambdaQueryWrapper authOperationQuery = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppAuthOperation::getAppRoleId, (Object)roleId);
        List authOperationList = this.lowAppAuthOperationService.list((Wrapper)authOperationQuery);
        if (authOperationList != null && authOperationList.size() > 0) {
            for (LowAppAuthOperation authOperation : authOperationList) {
                authOperation.setAppRoleId(originRoleId);
                String newFormCode = LowAppCopyUtil.getOriginValue((String)authOperation.getDesignFormCode(), (String)backupKey);
                authOperation.setDesignFormCode(newFormCode);
                authOperation.setId(null);
            }
            this.lowAppAuthOperationService.saveBatch(authOperationList);
        }
        LambdaQueryWrapper authFieldDeleteQuery = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppAuthField::getAppRoleId, (Object)originRoleId);
        this.lowAppAuthFieldService.remove((Wrapper)authFieldDeleteQuery);
        LambdaQueryWrapper authFieldQuery = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppAuthField::getAppRoleId, (Object)roleId);
        List authFieldList = this.lowAppAuthFieldService.list((Wrapper)authFieldQuery);
        if (authFieldList != null && authFieldList.size() > 0) {
            for (LowAppAuthField authField : authFieldList) {
                authField.setAppRoleId(originRoleId);
                String newFormCode = LowAppCopyUtil.getOriginValue((String)authField.getDesignFormCode(), (String)backupKey);
                authField.setDesignFormCode(newFormCode);
                authField.setId(null);
            }
            this.lowAppAuthFieldService.saveBatch(authFieldList);
        }
    }

    private void a(String appId) {
        List<LowAppMenu> menuList = this.lowAppRecycleMapper.queryAppMenus(appId);
        if (menuList != null && menuList.size() > 0) {
            for (LowAppMenu menu : menuList) {
                if (menu == null) continue;
                String menuType = menu.getType();
                if ("desform".equals(menuType)) {
                    this.desformBaseApi.deleteDesignForm(menu.getMenuUrl());
                    continue;
                }
                if ("form".equals(menuType)) {
                    this.desformBaseApi.deleteDesignForm(menu.getDesformCode());
                    continue;
                }
                if (!"drag".equals(menuType)) continue;
                try {
                    this.dragBaseApi.deleteDragPage(menu.getMenuUrl());
                }
                catch (Exception e2) {
                    a.error(e2.getMessage());
                }
            }
            this.lowAppRecycleMapper.deleteAppMenus(appId);
        }
    }

    @Override
    public LowApp getByIdForShare(String id) {
        return ((LowAppMapper)this.baseMapper).getByIdForShare(id);
    }

    @Override
    public void deleteBackup(String appId) {
        LowAppBackup backup = (LowAppBackup)this.lowAppBackupMapper.selectById((Serializable)((Object)appId));
        if (backup == null) {
            return;
        }
        LambdaQueryWrapper deleteQuery = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppGroupRelation::getAppId, (Object)appId);
        this.lowAppGroupRelationMapper.delete((Wrapper)deleteQuery);
        this.a(appId, true);
        LambdaQueryWrapper roleQuery = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppAuthRole::getAppId, (Object)appId);
        List roleList = this.lowAppAuthRoleService.list((Wrapper)roleQuery);
        if (roleList != null && roleList.size() > 0) {
            for (LowAppAuthRole role : roleList) {
                if (role == null) continue;
                String originRoleId = role.getId();
                LambdaQueryWrapper authFormDeleteQuery = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppAuthForm::getAppRoleId, (Object)originRoleId);
                this.lowAppAuthFormService.remove((Wrapper)authFormDeleteQuery);
                LambdaQueryWrapper authRecordDeleteQuery = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppAuthRecord::getAppRoleId, (Object)originRoleId);
                this.lowAppAuthRecordService.remove((Wrapper)authRecordDeleteQuery);
                LambdaQueryWrapper authOperationDeleteQuery = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppAuthOperation::getAppRoleId, (Object)originRoleId);
                this.lowAppAuthOperationService.remove((Wrapper)authOperationDeleteQuery);
                LambdaQueryWrapper authFieldDeleteQuery = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppAuthField::getAppRoleId, (Object)originRoleId);
                this.lowAppAuthFieldService.remove((Wrapper)authFieldDeleteQuery);
                this.lowAppAuthRoleService.removeById((Serializable)((Object)originRoleId));
            }
        }
        LambdaQueryWrapper roleUserDeleteQuery = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppAuthRoleUser::getAppId, (Object)appId);
        this.lowAppAuthRoleUserService.remove((Wrapper)roleUserDeleteQuery);
        this.signalProcessStartApi.deleteAppProcess(appId);
        this.lowAppBackupMapper.deleteById((Serializable)((Object)appId));
    }

    private void a(String appId, boolean deleteMongo) {
        LambdaQueryWrapper menuQuery2 = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppMenu::getAppId, (Object)appId);
        List menuList = this.lowAppMenuMapper.selectList((Wrapper)menuQuery2);
        if (menuList != null && menuList.size() > 0) {
            for (LowAppMenu menu : menuList) {
                String menuId = menu.getId();
                String menuType = menu.getType();
                boolean isIdForm = "form".equals(menuType);
                if ("desform".equals(menuType) || isIdForm) {
                    this.desformBaseApi.deleteDesignFormForAppCopy(menu.getMenuUrl(), Boolean.valueOf(deleteMongo));
                } else if ("drag".equals(menuType)) {
                    this.dragBaseApi.deleteDragPage(menu.getMenuUrl());
                }
                this.lowAppMenuMapper.deleteAppMenuById(menuId);
            }
        }
    }

    @Override
    public String getTenantIdByLowId(String appId, String token, String type) {
        List adminRoleList;
        String username = JwtUtil.getUsername((String)token);
        if (oConvertUtils.isEmpty((Object)username)) {
            return "";
        }
        LoginUser userByName = this.sysBaseAPI.getUserByName(username);
        if (null == userByName) {
            return "";
        }
        String userId = userByName.getId();
        List<LowAppAuthRole> userRoleList = this.lowAppAuthRoleService.getUserRoleList(userId, appId);
        if (CollectionUtil.isEmpty(userRoleList)) {
            return "";
        }
        if ("workflow".equals(type) && CollectionUtil.isEmpty(adminRoleList = userRoleList.stream().filter(item -> oConvertUtils.isNotEmpty((Object)item.getCode()) && "admin".equals(item.getCode())).collect(Collectors.toList()))) {
            return "";
        }
        Integer tenantIdByLowId = ((LowAppMapper)this.baseMapper).getTenantIdByLowId(appId);
        return oConvertUtils.getString((Object)tenantIdByLowId);
    }

    private static /* synthetic */ Object a(SerializedLambda lambda) {
        switch (lambda.getImplMethodName()) {
            case "getRelationId": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthRoleUser") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return LowAppAuthRoleUser::getRelationId;
            }
            case "getType": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthRoleUser") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return LowAppAuthRoleUser::getType;
            }
            case "getAuthRoleId": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthRoleUser") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return LowAppAuthRoleUser::getAuthRoleId;
            }
            case "getAppRoleId": {
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthForm") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppAuthForm::getAppRoleId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthRecord") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppAuthRecord::getAppRoleId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthOperation") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppAuthOperation::getAppRoleId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthField") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppAuthField::getAppRoleId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthForm") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppAuthForm::getAppRoleId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthRecord") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppAuthRecord::getAppRoleId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthOperation") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppAuthOperation::getAppRoleId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthField") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppAuthField::getAppRoleId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthForm") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppAuthForm::getAppRoleId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthForm") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppAuthForm::getAppRoleId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthRecord") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppAuthRecord::getAppRoleId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthRecord") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppAuthRecord::getAppRoleId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthOperation") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppAuthOperation::getAppRoleId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthOperation") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppAuthOperation::getAppRoleId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthField") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppAuthField::getAppRoleId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthField") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppAuthField::getAppRoleId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthForm") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppAuthForm::getAppRoleId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthRecord") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppAuthRecord::getAppRoleId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthOperation") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppAuthOperation::getAppRoleId;
                }
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthField") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return LowAppAuthField::getAppRoleId;
            }
            case "getId": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthRoleUser") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return LowAppAuthRoleUser::getId;
            }
            case "getCode": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthRole") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return LowAppAuthRole::getCode;
            }
            case "getAppId": {
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppGroupRelation") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppGroupRelation::getAppId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppMenu::getAppId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthRole") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppAuthRole::getAppId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppMenu::getAppId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthRole") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppAuthRole::getAppId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthRole") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppAuthRole::getAppId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthRoleUser") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppAuthRoleUser::getAppId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppGroupRelation") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppGroupRelation::getAppId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppGroupRelation") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppGroupRelation::getAppId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppMenu::getAppId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthRole") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppAuthRole::getAppId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppGroupRelation") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppGroupRelation::getAppId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppGroupRelation") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppGroupRelation::getAppId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppMenu::getAppId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthRole") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppAuthRole::getAppId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthRole") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppAuthRole::getAppId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthRoleUser") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppAuthRoleUser::getAppId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppGroupRelation") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppGroupRelation::getAppId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthRole") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppAuthRole::getAppId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthRoleUser") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppAuthRoleUser::getAppId;
                }
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return LowAppMenu::getAppId;
            }
        }
        throw new IllegalArgumentException("Invalid lambda deserialization");
    }
}

