/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.openapi.util.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.cdo.CommonDataObject;
import com.kingdee.bos.cdo.CommonEnumObject;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.ObjectSingleKey;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.json.JsonContext;
import com.kingdee.bos.json.Kson;
import com.kingdee.bos.json.adapter.BOSUuidTypeAdapter;
import com.kingdee.bos.json.adapter.CommonDataObjectTypeAdapter;
import com.kingdee.bos.json.adapter.CommonEnumObjectTypeAdapter;
import com.kingdee.bos.json.adapter.DateTypeAdapter;
import com.kingdee.bos.json.adapter.EnumDTOTypeAdapter;
import com.kingdee.bos.json.adapter.EnumTypeAdapter;
import com.kingdee.bos.openapi.util.json.adapter.BosObjectCollectionTypeAdapter;
import com.kingdee.bos.openapi.util.json.adapter.BosObjectTypeAdapter;
import com.kingdee.bos.openapi.util.json.adapter.ByteArrayTypeAdapter;
import com.kingdee.bos.openapi.util.json.adapter.EnumTypeWithDeserializerAdapter;
import com.kingdee.bos.openapi.util.json.adapter.ObjectSingleKeyTypeAdapter;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.enums.Enum;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class JSONUtils {
    protected static Logger logger = Logger.getLogger(JSONUtils.class);
    protected static final String QUOTES_PREFIX = "${quote_2312415321232}";
    protected static final String LEFT_BRACKETS_PREFIX = "${leftbracket_2312415321232}";
    protected static final String RIGHT_BRACKETS_PREFIX = "${rightbracket_2312415321232}";
    private static volatile Gson gson = JSONUtils.initGson();

    private static Gson initGson() {
        return new GsonBuilder().serializeNulls().serializeSpecialFloatingPointValues().registerTypeHierarchyAdapter(Date.class, (Object)new DateTypeAdapter()).registerTypeHierarchyAdapter(Timestamp.class, (Object)new DateTypeAdapter()).registerTypeHierarchyAdapter(Enum.class, (Object)new EnumTypeWithDeserializerAdapter()).registerTypeHierarchyAdapter(BOSUuid.class, (Object)new BOSUuidTypeAdapter()).registerTypeHierarchyAdapter(CoreBaseInfo.class, (Object)new BosObjectTypeAdapter()).registerTypeHierarchyAdapter(IObjectCollection.class, (Object)new BosObjectCollectionTypeAdapter()).registerTypeHierarchyAdapter(BizEnumValueDTO.class, (Object)new EnumDTOTypeAdapter()).registerTypeHierarchyAdapter(java.lang.Enum.class, (Object)new EnumTypeAdapter()).registerTypeHierarchyAdapter(CommonDataObject.class, (Object)new CommonDataObjectTypeAdapter()).registerTypeHierarchyAdapter(CommonEnumObject.class, (Object)new CommonEnumObjectTypeAdapter()).registerTypeHierarchyAdapter(ObjectSingleKey.class, (Object)new ObjectSingleKeyTypeAdapter()).registerTypeHierarchyAdapter(byte[].class, (Object)new ByteArrayTypeAdapter()).create();
    }

    public static String convertObjectToJson(Object object) {
        if (object == null || object.equals("")) {
            return "\"\"";
        }
        String result = gson.toJson(object);
        if (result == null) {
            return "\"\"";
        }
        result = JSONUtils.processJsonResult(result);
        return result;
    }

    public static String processJsonResult(String result) {
        result = result.replace(QUOTES_PREFIX, "\"");
        result = result.replace("\"${leftbracket_2312415321232}", "{");
        result = result.replace(LEFT_BRACKETS_PREFIX, "{");
        result = result.replace("${rightbracket_2312415321232}\"", "}");
        result = result.replace(RIGHT_BRACKETS_PREFIX, "}");
        return result;
    }

    public static <T> T convertJsonToObject(String json, Class<T> clz) throws BOSException {
        return (T)gson.fromJson(json, clz);
    }

    public static HashMap<?, ?> convertJsonToObject(String json) throws BOSException {
        return JSONUtils.convertJsonToObject(json, HashMap.class);
    }

    public static <T> T convertJsonToObject(Context ctx, String json, Class<T> classOfT) throws BOSException {
        return JSONUtils.convertJsonToObject(ctx, json, classOfT, gson);
    }

    public static String convertObjectToJson(Context ctx, Object object) throws BOSException {
        return JSONUtils.convertObjectToJson(ctx, object, gson);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertObjectToJson(Context ctx, Object object, Gson gson) throws BOSException {
        if (object == null) {
            return "\"\"";
        }
        Kson.begin((JsonContext)JSONUtils.newJsonContext(ctx));
        String result = null;
        try {
            result = gson.toJson(object);
        }
        finally {
            Kson.end();
        }
        if (result == null) {
            return "\"\"";
        }
        if (object instanceof String && result.startsWith("\"") && result.endsWith("\"")) {
            result = result.substring(1, result.length() - 1);
        }
        result = JSONUtils.processJsonResult(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T convertJsonToObject(Context ctx, String json, Type typeOfT, Gson gson) throws BOSException {
        Kson.begin((JsonContext)JSONUtils.newJsonContext(ctx));
        try {
            Object object = gson.fromJson(json, typeOfT);
            return (T)object;
        }
        finally {
            Kson.end();
        }
    }

    static JsonContext newJsonContext(Context ctx) {
        return new JsonContext(ctx);
    }
}

