/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.openapi.app.core.processor;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.openapi.OpenApiCollection;
import com.kingdee.bos.openapi.OpenApiDockingAppInfo;
import com.kingdee.bos.openapi.OpenApiFactory;
import com.kingdee.bos.openapi.OpenApiInfo;
import com.kingdee.bos.openapi.OpenApiLogInfo;
import com.kingdee.bos.openapi.OpenApiParamCollection;
import com.kingdee.bos.openapi.OpenApiTreeInfo;
import com.kingdee.bos.openapi.app.core.AbstractProcessor;
import com.kingdee.bos.openapi.app.core.IOpenAPIMonitor;
import com.kingdee.bos.openapi.app.core.IOpenApiExtHandler;
import com.kingdee.bos.openapi.app.core.OpenApiMonitor;
import com.kingdee.bos.openapi.app.core.cache.SessionUtil;
import com.kingdee.bos.openapi.app.core.gateway.OpenApiGW;
import com.kingdee.bos.openapi.common.bo.OpenApiDataInfo;
import com.kingdee.bos.openapi.common.bo.ResultInfo;
import com.kingdee.bos.openapi.util.OpenApiBOUtils;
import com.kingdee.bos.openapi.util.ThrowableHelper;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.license.ILicenseSrv;
import com.kingdee.eas.base.license.agent.LicenseSrvFactory;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.ThreadLocalCache;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class OpenApiProcessor
extends AbstractProcessor {
    private static final Logger logger = Logger.getLogger(OpenApiProcessor.class);
    private static Cache<String, Cache<String, OpenApiInfo>> apiCache = null;
    private static Cache<String, Cache<String, Boolean>> filterCache = null;
    protected String appid = null;
    private static boolean isCloudPulic = false;
    private static boolean isInitGW = false;
    private static List<IOpenAPIMonitor> monitorListeners = new ArrayList<IOpenAPIMonitor>();

    public static void initIsCloudPublic() {
        Class<?> EASCloudEnumClazz = null;
        Method getRemoteEASCloudVersion = null;
        try {
            EASCloudEnumClazz = Class.forName("com.kingdee.eas.base.license.EASCloudEnum");
            getRemoteEASCloudVersion = ILicenseSrv.class.getMethod("getRemoteEASCloudVersion", new Class[0]);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (EASCloudEnumClazz != null && EASCloudEnumClazz.isEnum() && getRemoteEASCloudVersion != null) {
            Enum[] enumConstants;
            for (Enum enum1 : enumConstants = (Enum[])EASCloudEnumClazz.getEnumConstants()) {
                if (!enum1.name().equals("CLOUD_PUBLIC")) continue;
                Enum CLOUD_PUBLIC = enum1;
                try {
                    ILicenseSrv srv = LicenseSrvFactory.getInstance();
                    isCloudPulic = CLOUD_PUBLIC.equals(getRemoteEASCloudVersion.invoke((Object)srv, new Object[0]));
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
                break;
            }
        }
    }

    @Override
    public String getTargetURI() {
        return "/api";
    }

    protected static void initCache() {
        filterCache = CacheBuilder.newBuilder().initialCapacity(5).maximumSize(20L).expireAfterAccess(3L, TimeUnit.HOURS).build();
        apiCache = CacheBuilder.newBuilder().initialCapacity(5).maximumSize(20L).build();
    }

    public static void clearCache(Context ctx) {
        filterCache.invalidate((Object)ctx.getAIS());
        apiCache.invalidate((Object)ctx.getAIS());
    }

    public static void clearAllCache() {
        filterCache.invalidateAll();
        apiCache.invalidateAll();
    }

    private static void initMonitor() {
        OpenApiProcessor.registerMonitorListener(new OpenApiMonitor());
    }

    public static void registerMonitorListener(IOpenAPIMonitor l) {
        monitorListeners.add(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultInfo process(Map<String, Object> params, Object reqBody) throws Exception {
        if (!this.checkGW()) {
            return new ResultInfo(500, 500, "request must come from the gateway");
        }
        String token = null;
        if (params != null) {
            token = (String)params.get("token");
        }
        if (this.ctx == null) {
            this.ctx = this.initContext(token);
        }
        if (this.ctx == null) {
            return ResultInfo.STATUS_NOT_LOGIN;
        }
        ThreadLocalCache.detroyRegion((String)"openapi.objectCache");
        ResultInfo resultInfo = new ResultInfo();
        OpenApiLogInfo logInfo = new OpenApiLogInfo();
        String data = null;
        try {
            com.kingdee.bos.openapi.third.OpenApiInfo reqInfo = this.dataType.parse2Object(null, (String)reqBody, com.kingdee.bos.openapi.third.OpenApiInfo.class);
            data = this._process(reqInfo, logInfo);
            resultInfo.setData(data);
            resultInfo.setErrCode(0);
            resultInfo.setErrMsg("\u6267\u884c\u6210\u529f");
        }
        catch (Throwable t) {
            try {
                logger.error((Object)"openapi error", t);
                resultInfo.setErrCode(500);
                resultInfo.setErrStackTrace(ThrowableHelper.toString(t));
                String errMsg = t.getMessage();
                if (StringUtils.isEmpty((String)errMsg)) {
                    errMsg = "OpenApi process error";
                }
                resultInfo.setErrMsg(errMsg);
            }
            catch (Throwable throwable) {
                logInfo.setRequestObj((String)reqBody);
                logInfo.setClientIp(this.clientIp);
                logInfo.setStatus(resultInfo.getErrCode() == 0);
                logInfo.setInstanceid(Configuration.serviceInstanceIdGenerator().getInstanceId());
                logInfo.setMessage(resultInfo.getErrMsg());
                logInfo.setException(resultInfo.getErrStackTrace());
                this.handleMonitor(logInfo);
                BOSObjectFactory.setContextToThread(null);
                throw throwable;
            }
            logInfo.setRequestObj((String)reqBody);
            logInfo.setClientIp(this.clientIp);
            logInfo.setStatus(resultInfo.getErrCode() == 0);
            logInfo.setInstanceid(Configuration.serviceInstanceIdGenerator().getInstanceId());
            logInfo.setMessage(resultInfo.getErrMsg());
            logInfo.setException(resultInfo.getErrStackTrace());
            this.handleMonitor(logInfo);
            BOSObjectFactory.setContextToThread(null);
        }
        logInfo.setRequestObj((String)reqBody);
        logInfo.setClientIp(this.clientIp);
        logInfo.setStatus(resultInfo.getErrCode() == 0);
        logInfo.setInstanceid(Configuration.serviceInstanceIdGenerator().getInstanceId());
        logInfo.setMessage(resultInfo.getErrMsg());
        logInfo.setException(resultInfo.getErrStackTrace());
        this.handleMonitor(logInfo);
        BOSObjectFactory.setContextToThread(null);
        return resultInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String _process(com.kingdee.bos.openapi.third.OpenApiInfo reqInfo, OpenApiLogInfo logInfo) throws BOSException, Exception {
        Object[] params;
        String sql;
        IRowSet rs;
        long startTime = System.currentTimeMillis();
        String taskId = null;
        String data = null;
        String api = null;
        OpenApiDataInfo dataInfo = new OpenApiDataInfo();
        String ret = null;
        OpenApiInfo openApiInfo = null;
        try {
            if (reqInfo != null) {
                taskId = reqInfo.getTaskId();
                data = reqInfo.getData();
                api = reqInfo.getApi();
            }
            dataInfo.setTaskId(taskId);
            openApiInfo = OpenApiProcessor.getOpenApiFromCache(this.ctx, api);
            if (StringUtils.isEmpty((String)api) || openApiInfo == null) {
                throw new Exception("openApi error.please check your parameters api!");
            }
            if (!this.filterApi(this.ctx, openApiInfo, this.appid)) {
                throw new Exception("openApi error.please check your api parameter appid!");
            }
            Object resultObject = null;
            try {
                resultObject = this.callMethod(this.ctx, openApiInfo, data);
            }
            catch (Throwable e) {
                String message = null;
                if (e.getCause() != null) {
                    message = e.getCause().getMessage();
                }
                if (message == null || message.trim().length() == 0) {
                    message = "openApi error.Fail to invoke method ";
                }
                throw new Exception(message, e);
            }
            dataInfo.setResult(resultObject);
            ret = this.handleReturn(this.ctx, dataInfo);
        }
        catch (Throwable throwable) {
            Object[] params2;
            String sql2;
            IRowSet rs2;
            logInfo.setTaskId(taskId);
            if (openApiInfo != null) {
                logInfo.setApiId(openApiInfo);
            }
            if (!StringUtils.isEmpty((String)this.appid) && (rs2 = DbUtil.executeQuery((Context)this.ctx, (String)(sql2 = "select top 1 fid \"id\" from T_API_OpenApiDockingApp where fnumber = ?"), (Object[])(params2 = new Object[]{this.appid}))).next()) {
                String id = rs2.getString("id");
                OpenApiDockingAppInfo info = new OpenApiDockingAppInfo();
                info.setId(BOSUuid.read((String)id));
                logInfo.setDockingApp(info);
            }
            logInfo.setResponseObj(ret);
            logInfo.setUser(this.ctx == null ? null : BOSUuid.read((String)this.ctx.getCaller().toString()));
            logInfo.setStratTime(new Timestamp(startTime));
            logInfo.setFinishTime(new Timestamp(System.currentTimeMillis()));
            throw throwable;
        }
        logInfo.setTaskId(taskId);
        if (openApiInfo != null) {
            logInfo.setApiId(openApiInfo);
        }
        if (!StringUtils.isEmpty((String)this.appid) && (rs = DbUtil.executeQuery((Context)this.ctx, (String)(sql = "select top 1 fid \"id\" from T_API_OpenApiDockingApp where fnumber = ?"), (Object[])(params = new Object[]{this.appid}))).next()) {
            String id = rs.getString("id");
            OpenApiDockingAppInfo info = new OpenApiDockingAppInfo();
            info.setId(BOSUuid.read((String)id));
            logInfo.setDockingApp(info);
        }
        logInfo.setResponseObj(ret);
        logInfo.setUser(this.ctx == null ? null : BOSUuid.read((String)this.ctx.getCaller().toString()));
        logInfo.setStratTime(new Timestamp(startTime));
        logInfo.setFinishTime(new Timestamp(System.currentTimeMillis()));
        return ret;
    }

    public Object callMethod(Context ctx, OpenApiInfo apiInfo, String data) throws Throwable {
        if (ctx == null || apiInfo == null) {
            throw new Exception("openApi error.callmethod args are invalid ! ctx:" + ctx + " apiInfo: " + apiInfo);
        }
        BOSObjectType bosType = BOSObjectType.create((String)apiInfo.getBosObjectType());
        BusinessObjectInfo bo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getBusinessObject(bosType);
        if (bo == null) {
            throw new Exception("openApi error.Fail to find metadata.BusinessObjectInfo: " + bo);
        }
        MethodInfo method = this.getMethodInfoFromEntryInfo(ctx, apiInfo, bo);
        ParameterCollection pc = method.getParameters();
        Object[] args = null;
        String handlerString = apiInfo.getHandler();
        List<IOpenApiExtHandler> handlers = null;
        if (!StringUtils.isEmpty((String)handlerString)) {
            handlers = this.getApiMethodHandlers(handlerString);
            for (IOpenApiExtHandler handler : handlers) {
                args = handler.converToParamObjects(ctx, bosType, method, data);
            }
        }
        if (args == null) {
            args = this.innerPrepareArgs(ctx, apiInfo, data, pc);
        }
        if (handlers != null) {
            for (IOpenApiExtHandler handler : handlers) {
                handler.fireBeforeMethod(ctx, bosType, method, args);
            }
        }
        Object resultValue = OpenApiBOUtils.callMethod(ctx, bosType, method, args);
        if (handlers != null) {
            for (IOpenApiExtHandler handler : handlers) {
                handler.fireAfterMethod(ctx, bosType, method, args, resultValue);
            }
        }
        return resultValue;
    }

    private Object[] innerPrepareArgs(Context ctx, OpenApiInfo apiInfo, String dataStr, ParameterCollection pc) throws ClassNotFoundException, Exception, BOSException {
        OpenApiParamCollection params = apiInfo.getEntry();
        if (params.size() != pc.size()) {
            throw new Exception("params is wrong,please check your api config");
        }
        String[] clazzs = new String[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            clazzs[i] = params.get(i).getCustomEntity();
        }
        try {
            Object[] args = this.dataType.handleStr2Param(ctx, dataStr, pc, clazzs);
            return args;
        }
        catch (Exception e) {
            throw new Exception("Openapi error,fail to process args", e);
        }
    }

    private static OpenApiInfo getOpenApiFromCache(Context ctx, String api) throws Exception {
        Context final_ctx;
        String final_api;
        if (ctx == null || StringUtils.isEmpty((String)api)) {
            return null;
        }
        Cache aisApiCache = (Cache)apiCache.get((Object)ctx.getAIS(), (Callable)new Callable<Cache<String, OpenApiInfo>>(){

            @Override
            public Cache<String, OpenApiInfo> call() throws Exception {
                return CacheBuilder.newBuilder().initialCapacity(100).maximumSize(10000L).build();
            }
        });
        OpenApiInfo info = (OpenApiInfo)aisApiCache.get((Object)(final_api = api), (Callable)new Callable<OpenApiInfo>(final_ctx = ctx){
            final /* synthetic */ Context val$final_ctx;
            {
                this.val$final_ctx = context;
            }

            @Override
            public OpenApiInfo call() throws Exception {
                EntityViewInfo view = new EntityViewInfo();
                view.setTopCount(1);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)final_api));
                view.setFilter(filter);
                FilterInfo entryFilter = new FilterInfo();
                entryFilter.setEntryName("entry");
                entryFilter.getFilterItems().add(new FilterItemInfo("type", (Object)0));
                view.getEntryFilters().add(entryFilter);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                sic.add(new SelectorItemInfo("treeid.start"));
                sic.add(new SelectorItemInfo("treeid.open"));
                sic.add(new SelectorItemInfo("treeid.log"));
                sic.add(new SelectorItemInfo("entry.*"));
                view.setSelector(sic);
                OpenApiCollection collection = OpenApiFactory.getLocalInstance(this.val$final_ctx).getOpenApiCollection(view);
                OpenApiInfo info = null;
                info = collection.size() > 0 ? collection.get(0) : new OpenApiInfo();
                return info;
            }
        });
        if (info.getId() == null) {
            info = null;
        }
        return info;
    }

    private boolean filterApi(Context ctx, OpenApiInfo apiInfo, String appid) throws Exception {
        OpenApiTreeInfo apiTreeInfo = apiInfo.getTreeid();
        if (apiTreeInfo == null) {
            return true;
        }
        if (!apiTreeInfo.isStart()) {
            throw new Exception("openApi error.please check your paramer,  api solution is disabled!");
        }
        if (apiTreeInfo.isOpen()) {
            return true;
        }
        Cache aisFilterCache = (Cache)filterCache.get((Object)ctx.getAIS(), (Callable)new Callable<Cache<String, Boolean>>(){

            @Override
            public Cache<String, Boolean> call() throws Exception {
                return CacheBuilder.newBuilder().initialCapacity(100).maximumSize(10000L).build();
            }
        });
        String treeId = apiInfo.getTreeid().getId().toString();
        String key = treeId + appid;
        final String key_treeId = treeId;
        final String key_appid = appid;
        final Context key_ctx = ctx;
        Boolean ret = null;
        try {
            ret = (Boolean)aisFilterCache.get((Object)key, (Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    String sql = "select top 1 a.FID from T_API_OpenApiPermissionMapping a left join T_API_OpenApiDockingApp b on a.FDOCKINGAPPID = b.fid where b.FNUMBER  = ? and a.FAPITREEID = ?";
                    Object[] params = new Object[]{key_appid, key_treeId};
                    IRowSet rs = DbUtil.executeQuery((Context)key_ctx, (String)sql, (Object[])params);
                    if (rs.next()) {
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (ExecutionException e) {
            logger.error((Object)"openapi error", (Throwable)e);
        }
        if (ret == null) {
            ret = false;
        }
        return ret;
    }

    private MethodInfo getMethodInfoFromEntryInfo(Context ctx, OpenApiInfo apiInfo, BusinessObjectInfo bo) throws Exception {
        MethodInfo methodInfo = null;
        String method = apiInfo.getMethod();
        if (apiInfo.getMethodInfo() == null) {
            MethodCollection mc = bo.getAllMethodsRuntime();
            for (int i = 0; i < mc.size(); ++i) {
                MethodInfo mi = mc.get(i);
                if (!mi.toString().trim().equals(method.trim())) continue;
                methodInfo = mi;
                break;
            }
            apiInfo.setMethodInfo(methodInfo);
        } else {
            methodInfo = apiInfo.getMethodInfo();
        }
        if (methodInfo == null) {
            throw new Exception("openApi error.Fail to find the method on metadata.BusinessObjectInfo: " + bo + " method: " + method);
        }
        return methodInfo;
    }

    private List<IOpenApiExtHandler> getApiMethodHandlers(String handlerString) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String[] handlers;
        ArrayList<IOpenApiExtHandler> list = new ArrayList<IOpenApiExtHandler>();
        for (String s : handlers = handlerString.split(",")) {
            Class<?> c = Class.forName(s);
            if (!IOpenApiExtHandler.class.isAssignableFrom(c)) continue;
            IOpenApiExtHandler handler = (IOpenApiExtHandler)c.newInstance();
            list.add(handler);
        }
        return list;
    }

    private void handleMonitor(OpenApiLogInfo logInfo) {
        for (IOpenAPIMonitor l : monitorListeners) {
            try {
                l.handle(this.ctx, logInfo);
            }
            catch (Throwable t) {
                logger.error((Object)"openApi error.Fail to callMethod", t);
            }
        }
    }

    protected String handleReturn(Context ctx, OpenApiDataInfo callbackObj) throws BOSException {
        return this.dataType.parse2String(ctx, callbackObj);
    }

    protected Context initContext(String token) throws BOSException {
        Context context = null;
        if (token != null) {
            context = SessionUtil.getContextByToken(token);
            this.appid = SessionUtil.getAppidByToken(token);
        }
        if (context != null) {
            BOSObjectFactory.setContextToThread((Context)context);
            WebContextUtil.initRpcConfig((Context)context);
        }
        return context;
    }

    protected boolean checkGW() throws Exception {
        if (!isInitGW) {
            OpenApiProcessor.initIsCloudPublic();
        }
        boolean flag = true;
        if (isCloudPulic) {
            String gwSign = this.getRequest().getHeader("X-Gw-Sign");
            String gwTime = this.getRequest().getHeader("X-Gw-Time");
            flag = OpenApiGW.checkFomGateWay(gwSign, gwTime);
        }
        return flag;
    }

    static {
        OpenApiProcessor.initCache();
        OpenApiProcessor.initMonitor();
    }
}

