/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test;

import org.springframework.boot.context.embedded.EmbeddedServletContainerInitializedEvent;
import org.springframework.boot.context.embedded.EmbeddedWebApplicationContext;
import org.springframework.boot.test.EnvironmentTestUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.StringUtils;

public class ServerPortInfoApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    public void initialize(ConfigurableApplicationContext applicationContext) {
        applicationContext.addApplicationListener((ApplicationListener)new ApplicationListener<EmbeddedServletContainerInitializedEvent>(){

            public void onApplicationEvent(EmbeddedServletContainerInitializedEvent event) {
                ServerPortInfoApplicationContextInitializer.this.onApplicationEvent(event);
            }
        });
    }

    protected void onApplicationEvent(EmbeddedServletContainerInitializedEvent event) {
        String propertyName = this.getPropertyName(event.getApplicationContext());
        this.setPortProperty((ApplicationContext)event.getApplicationContext(), propertyName, event.getEmbeddedServletContainer().getPort());
    }

    protected String getPropertyName(EmbeddedWebApplicationContext context) {
        String name = context.getNamespace();
        if (StringUtils.isEmpty((Object)name)) {
            name = "server";
        }
        return "local." + name + ".port";
    }

    private void setPortProperty(ApplicationContext context, String propertyName, int port) {
        if (context instanceof ConfigurableApplicationContext) {
            EnvironmentTestUtils.addEnvironment((ConfigurableApplicationContext)context, propertyName + ":" + port);
        }
        if (context.getParent() != null) {
            this.setPortProperty(context.getParent(), propertyName, port);
        }
    }
}

