/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.util.ContextInitializer;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.slf4j.impl.StaticLoggerBinder;
import org.springframework.boot.logging.AbstractLoggingSystem;
import org.springframework.boot.logging.LogLevel;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.SystemPropertyUtils;

public class LogbackLoggingSystem
extends AbstractLoggingSystem {
    private static final Map<LogLevel, Level> LEVELS;

    public LogbackLoggingSystem(ClassLoader classLoader) {
        super(classLoader, "logback-test.groovy", "logback-test.xml", "logback.groovy", "logback.xml");
    }

    @Override
    public void beforeInitialize() {
        block4: {
            super.beforeInitialize();
            try {
                if (!ClassUtils.isPresent((String)"org.slf4j.bridge.SLF4JBridgeHandler", (ClassLoader)this.getClassLoader())) break block4;
                try {
                    SLF4JBridgeHandler.removeHandlersForRootLogger();
                }
                catch (NoSuchMethodError ex) {
                    SLF4JBridgeHandler.uninstall();
                }
                SLF4JBridgeHandler.install();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void initialize(String configLocation) {
        Assert.notNull((Object)configLocation, (String)"ConfigLocation must not be null");
        String resolvedLocation = SystemPropertyUtils.resolvePlaceholders((String)configLocation);
        ILoggerFactory factory = StaticLoggerBinder.getSingleton().getLoggerFactory();
        Assert.isInstanceOf(LoggerContext.class, (Object)factory, (String)("LoggerFactory is not a Logback LoggerContext but Logback is on the classpath. Either remove Logback or the competing implementation (" + factory.getClass() + ")"));
        LoggerContext context = (LoggerContext)factory;
        context.stop();
        try {
            URL url = ResourceUtils.getURL((String)resolvedLocation);
            new ContextInitializer(context).configureByResource(url);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not initialize logging from " + configLocation, ex);
        }
    }

    @Override
    public void setLogLevel(String loggerName, LogLevel level) {
        ILoggerFactory factory = StaticLoggerBinder.getSingleton().getLoggerFactory();
        Logger logger = factory.getLogger(StringUtils.isEmpty((Object)loggerName) ? "ROOT" : loggerName);
        ((ch.qos.logback.classic.Logger)logger).setLevel(LEVELS.get((Object)level));
    }

    static {
        HashMap<LogLevel, Level> levels = new HashMap<LogLevel, Level>();
        levels.put(LogLevel.TRACE, Level.TRACE);
        levels.put(LogLevel.DEBUG, Level.DEBUG);
        levels.put(LogLevel.INFO, Level.INFO);
        levels.put(LogLevel.WARN, Level.WARN);
        levels.put(LogLevel.ERROR, Level.ERROR);
        levels.put(LogLevel.FATAL, Level.ERROR);
        levels.put(LogLevel.OFF, Level.OFF);
        LEVELS = Collections.unmodifiableMap(levels);
    }
}

