/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded.tomcat;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import javax.naming.directory.DirContext;
import javax.servlet.ServletContext;
import org.apache.catalina.Context;
import org.apache.catalina.core.StandardContext;
import org.apache.naming.resources.FileDirContext;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

abstract class TomcatResources {
    private final Context context;

    public TomcatResources(Context context) {
        this.context = context;
    }

    public void addClasspathResources() {
        ClassLoader loader = this.getClass().getClassLoader();
        if (loader instanceof URLClassLoader) {
            for (URL url : ((URLClassLoader)loader).getURLs()) {
                String dir;
                String file = url.getFile();
                if (file.endsWith(".jar") || file.endsWith(".jar!/")) {
                    String jar = url.toString();
                    if (!jar.startsWith("jar:")) {
                        jar = "jar:" + jar + "!/";
                    }
                    this.addJar(jar);
                    continue;
                }
                if (!url.toString().startsWith("file:") || !new File(dir = url.toString().substring("file:".length())).isDirectory()) continue;
                this.addDir(dir, url);
            }
        }
    }

    protected final Context getContext() {
        return this.context;
    }

    protected abstract void addJar(String var1);

    protected abstract void addDir(String var1, URL var2);

    public static TomcatResources get(Context context) {
        if (ClassUtils.isPresent((String)"org.apache.catalina.deploy.ErrorPage", null)) {
            return new Tomcat7Resources(context);
        }
        return new Tomcat8Resources(context);
    }

    static class Tomcat8Resources
    extends TomcatResources {
        private Object resources;
        private Method createWebResourceSetMethod;
        private Enum<?> resourceJarEnum;

        public Tomcat8Resources(Context context) {
            super(context);
            try {
                this.resources = ReflectionUtils.findMethod(context.getClass(), (String)"getResources").invoke((Object)context, new Object[0]);
                Class resourceSetType = ClassUtils.resolveClassName((String)"org.apache.catalina.WebResourceRoot.ResourceSetType", null);
                this.createWebResourceSetMethod = ReflectionUtils.findMethod(this.resources.getClass(), (String)"createWebResourceSet", (Class[])new Class[]{resourceSetType, String.class, URL.class, String.class});
                this.resourceJarEnum = Enum.valueOf(resourceSetType, "RESOURCE_JAR");
            }
            catch (Exception ex) {
                throw new IllegalStateException("Tomcat 8 reflection failed", ex);
            }
        }

        @Override
        protected void addJar(String jar) {
            this.addResourceSet(jar);
        }

        @Override
        protected void addDir(String dir, URL url) {
            this.addResourceSet(url.toString());
        }

        private void addResourceSet(String resource) {
            try {
                if (this.isInsideNestedJar(resource)) {
                    resource = resource.substring(0, resource.length() - 2);
                }
                URL url = new URL(resource);
                String path = "/META-INF/resources";
                this.createWebResourceSet("/", url, path);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private boolean isInsideNestedJar(String dir) {
            return dir.indexOf("!/") < dir.lastIndexOf("!/");
        }

        private void createWebResourceSet(String webAppMount, URL url, String path) throws Exception {
            this.createWebResourceSetMethod.invoke(this.resources, this.resourceJarEnum, webAppMount, url, path);
        }
    }

    private static class Tomcat7Resources
    extends TomcatResources {
        public Tomcat7Resources(Context context) {
            super(context);
        }

        @Override
        protected void addJar(String jar) {
            try {
                this.getContext().addResourceJarUrl(new URL(jar));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }

        @Override
        protected void addDir(String dir, URL url) {
            if (this.getContext() instanceof ServletContext) {
                FileDirContext files = new FileDirContext();
                files.setDocBase(dir);
                ((StandardContext)this.getContext()).addResourcesDirContext((DirContext)files);
            }
        }
    }
}

