/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.bind;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.util.StringUtils;

public final class RelaxedNames
implements Iterable<String> {
    private final String name;
    private final Set<String> values = new LinkedHashSet<String>();

    public RelaxedNames(String name) {
        this.name = name == null ? "" : name;
        this.initialize(this.name, this.values);
    }

    @Override
    public Iterator<String> iterator() {
        return this.values.iterator();
    }

    private void initialize(String name, Set<String> values) {
        if (values.contains(name)) {
            return;
        }
        for (Variation variation : Variation.values()) {
            for (Manipulation manipulation : Manipulation.values()) {
                String result = name;
                result = manipulation.apply(result);
                result = variation.apply(result);
                values.add(result);
                this.initialize(result, values);
            }
        }
    }

    static enum Manipulation {
        NONE{

            @Override
            public String apply(String value) {
                return value;
            }
        }
        ,
        HYPHEN_TO_UNDERSCORE{

            @Override
            public String apply(String value) {
                return value.replace("-", "_");
            }
        }
        ,
        UNDERSCORE_TO_PERIOD{

            @Override
            public String apply(String value) {
                return value.replace("_", ".");
            }
        }
        ,
        PERIOD_TO_UNDERSCORE{

            @Override
            public String apply(String value) {
                return value.replace(".", "_");
            }
        }
        ,
        CAMELCASE_TO_UNDERSCORE{

            @Override
            public String apply(String value) {
                value = value.replaceAll("([^A-Z-])([A-Z])", "$1_$2");
                StringBuilder builder = new StringBuilder();
                for (String field : value.split("_")) {
                    if (builder.length() == 0) {
                        builder.append(field);
                        continue;
                    }
                    builder.append("_").append(StringUtils.uncapitalize((String)field));
                }
                return builder.toString();
            }
        }
        ,
        SEPARATED_TO_CAMELCASE{

            @Override
            public String apply(String value) {
                StringBuilder builder = new StringBuilder();
                for (String field : value.split("[_\\-.]")) {
                    builder.append(builder.length() == 0 ? field : StringUtils.capitalize((String)field));
                }
                for (String suffix : new String[]{"_", "-", "."}) {
                    if (!value.endsWith(suffix)) continue;
                    builder.append(suffix);
                }
                return builder.toString();
            }
        };


        public abstract String apply(String var1);
    }

    static enum Variation {
        NONE{

            @Override
            public String apply(String value) {
                return value;
            }
        }
        ,
        LOWERCASE{

            @Override
            public String apply(String value) {
                return value.toLowerCase();
            }
        }
        ,
        UPPERCASE{

            @Override
            public String apply(String value) {
                return value.toUpperCase();
            }
        };


        public abstract String apply(String var1);
    }
}

