/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.starter.cloud.util;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.fastjson.JSONObject;
import jakarta.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

public class HttpUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);
    private static final String COMMA = ",";

    public static SortedMap<String, String> getAllParams(HttpServletRequest request) throws IOException {
        TreeMap<String, String> result = new TreeMap<String, String>();
        String pathVariable = request.getRequestURI().substring(request.getRequestURI().lastIndexOf("/") + 1);
        if (pathVariable.contains(COMMA)) {
            log.info(" pathVariable: {}", (Object)pathVariable);
            String deString = URLDecoder.decode(pathVariable, "UTF-8");
            log.info(" pathVariable decode: {}", (Object)deString);
            result.put("x-path-variable", deString);
        }
        Map<String, String> urlParams = HttpUtils.getUrlParams(request);
        for (Map.Entry<String, String> entry : urlParams.entrySet()) {
            result.put(entry.getKey(), entry.getValue());
        }
        Map<Object, Object> allRequestParam = new HashMap(16);
        if (!HttpMethod.GET.name().equals(request.getMethod())) {
            allRequestParam = HttpUtils.getAllRequestParam(request);
        }
        if (allRequestParam != null) {
            for (Map.Entry<Object, Object> entry : allRequestParam.entrySet()) {
                result.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return result;
    }

    public static SortedMap<String, String> getAllParams(String url, String queryString, byte[] body, String method) throws IOException {
        TreeMap<String, String> result = new TreeMap<String, String>();
        String pathVariable = url.substring(url.lastIndexOf("/") + 1);
        if (pathVariable.contains(COMMA)) {
            log.info(" pathVariable: {}", (Object)pathVariable);
            String deString = URLDecoder.decode(pathVariable, "UTF-8");
            log.info(" pathVariable decode: {}", (Object)deString);
            result.put("x-path-variable", deString);
        }
        Map<String, String> urlParams = HttpUtils.getUrlParams(queryString);
        for (Map.Entry<String, String> entry : urlParams.entrySet()) {
            result.put(entry.getKey(), entry.getValue());
        }
        Map<Object, Object> allRequestParam = new HashMap(16);
        if (!HttpMethod.GET.name().equals(method)) {
            allRequestParam = HttpUtils.getAllRequestParam(body);
        }
        if (allRequestParam != null) {
            for (Map.Entry<Object, Object> entry : allRequestParam.entrySet()) {
                result.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return result;
    }

    public static Map<String, String> getAllRequestParam(HttpServletRequest request) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()));
        String str = "";
        StringBuilder wholeStr = new StringBuilder();
        while ((str = reader.readLine()) != null) {
            wholeStr.append(str);
        }
        return (Map)JSONObject.parseObject((String)wholeStr.toString(), Map.class);
    }

    public static Map<String, String> getAllRequestParam(byte[] body) throws IOException {
        if (body == null) {
            return null;
        }
        String wholeStr = new String(body);
        return (Map)JSONObject.parseObject((String)wholeStr.toString(), Map.class);
    }

    public static Map<String, String> getUrlParams(HttpServletRequest request) {
        String[] params;
        HashMap<String, String> result = new HashMap<String, String>(16);
        if (StringUtils.isEmpty((CharSequence)request.getQueryString())) {
            return result;
        }
        String param = "";
        try {
            param = URLDecoder.decode(request.getQueryString(), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        for (String s : params = param.split("&")) {
            int index = s.indexOf("=");
            if (index == -1) continue;
            result.put(s.substring(0, index), s.substring(index + 1));
        }
        return result;
    }

    public static Map<String, String> getUrlParams(String queryString) {
        String[] params;
        HashMap<String, String> result = new HashMap<String, String>(16);
        if (StringUtils.isEmpty((CharSequence)queryString)) {
            return result;
        }
        String param = "";
        try {
            param = URLDecoder.decode(queryString, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        for (String s : params = param.split("&")) {
            int index = s.indexOf("=");
            if (index == -1) continue;
            result.put(s.substring(0, index), s.substring(index + 1));
        }
        return result;
    }
}

