/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.config.firewall.interceptor.enums;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public enum ShareUrlEnum {
    GET_QUERY_INFO("report", "/jmreport/getQueryInfo"),
    SHARE_VERIFICATION("report", "/jmreport/share/verification"),
    ADD_VIEW_COUNT("report", "/jmreport/addViewCount/{id}"),
    SHOW_DATA("report", "/jmreport/show"),
    EXPORT_PDF_STREAM("report", "/jmreport/exportPdfStream"),
    EXPORT_ALL_EXCEL_STREAM("report", "/jmreport/exportAllExcelStream"),
    EXPORT_WORD_STREAM("report", "/jmreport/export/word"),
    CHECK_PARAM("report", "/jmreport/checkParam/{id}"),
    QUERYMAP_BY_CODE("report", "/jmreport/map/queryMapByCode"),
    QUREST_SQL("report", "/jmreport/qurestSql"),
    QUREST_API("report", "/jmreport/qurestApi"),
    DICTCODE_SEARCH("report", "/jmreport/dictCodeSearch"),
    MULTIPLE_INIT_VALUE("report", "/jmreport/query/multiple/initValue"),
    GET_CHAR_DATA("report", "/jmreport/getCharData"),
    FORM_REPEAT_CHECK("report", "/jmreport/form/repeat/check/{reportId}/{field}/{value}"),
    FORM_REPEAT_SUBMIT("report", "/jmreport/form/submit"),
    DRAG_SHARE_VIEW("drag", "/drag/share/view/**"),
    DRAG_PAGE_QUERY("drag", "/drag/page/queryById"),
    DRAG_PAGE_ADDNUM("drag", "/drag/page/addVisitsNumber"),
    DRAG_PAGE_TEMPLATE_LIST("drag", "/drag/page/queryTemplateList"),
    DRAG_QUERY_CHART_DATA("drag", "/drag/onlDragDatasetHead/getAllChartData"),
    DRAG_QUERY_TOTAL_DATA("drag", "/drag/onlDragDatasetHead/getTotalData"),
    DRAG_QUERY_DICT_CODES("drag", "/drag/onlDragDatasetHead/getDictByCodes"),
    DRAG_MOCK_JSON("drag", "/drag/mock/json/**"),
    DRAG_GET_IMAGE_BASE64("drag", "/drag/getImageBase64/**"),
    DRAG_GET_MAP_DATA_BY_CODE("drag", "/drag/onlDragDatasetHead/getMapDataByCode"),
    DRAG_VIEW("drag", "/drag/view"),
    JIMUBI_VIEW("drag", "/jimubi/view"),
    JIMUBI_SHARE_VIEW("drag", "/jimubi/share/view/**");

    private String type;
    private final String value;

    private ShareUrlEnum(String type, String value) {
        this.type = type;
        this.value = value;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public static List<String> getShareUrls() {
        return Arrays.stream(ShareUrlEnum.values()).filter(shareUrlEnum -> "report".equalsIgnoreCase(shareUrlEnum.getType())).map(ShareUrlEnum::getValue).collect(Collectors.toList());
    }

    public static List<String> getDragShareUrls() {
        return Arrays.stream(ShareUrlEnum.values()).filter(shareUrlEnum -> "drag".equalsIgnoreCase(shareUrlEnum.getType())).map(ShareUrlEnum::getValue).collect(Collectors.toList());
    }
}

