/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.low.job;

import java.util.Date;
import java.util.List;
import org.jeecg.modules.online.low.entity.LowApp;
import org.jeecg.modules.online.low.service.ILowAppService;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class LowAppDataClearJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(LowAppDataClearJob.class);
    private static long MAX_DIFF = 604800000L;
    @Autowired
    private ILowAppService lowAppService;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        log.info("------------------------\u5e94\u7528\u56de\u6536\u7ad9\u6570\u636e\u6e05\u7a7a \u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb---------------------- ");
        List<LowApp> list = this.lowAppService.queryDeleteAppList();
        long l2 = System.currentTimeMillis();
        if (list != null && list.size() > 0) {
            for (LowApp lowApp : list) {
                long l3;
                long l4;
                Date date = lowApp.getDeleteTime();
                if (date == null || (l4 = l2 - (l3 = date.getTime())) <= MAX_DIFF) continue;
                try {
                    this.lowAppService.deleteLowApp(lowApp);
                    log.info("\u5e94\u7528 {} \u6570\u636e\u6e05\u9664\u6210\u529f", (Object)lowApp.getAppName());
                }
                catch (Exception exception) {
                    log.error("\u5220\u9664\u5e94\u7528\u51fa\u9519\uff0c" + exception.getMessage());
                }
            }
        }
        log.info("------------------------\u5e94\u7528\u56de\u6536\u7ad9\u6570\u636e\u6e05\u7a7a \u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f---------------------- ");
    }
}

