/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.desform.mongo.model.query;

import java.util.LinkedHashMap;
import java.util.Map;
import org.bson.Document;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.mongodb.core.geo.GeoJson;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.GeoCommand;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class JCriteria
extends Criteria {
    @Nullable
    private String key;
    private final LinkedHashMap<String, Object> criteria = new LinkedHashMap();
    private static final Object NOT_SET = new Object();
    @Nullable
    private final Object isValue = NOT_SET;

    public JCriteria custom(String key, Object value) {
        this.criteria.put(key, value);
        return this;
    }

    public JCriteria expr(Object value) {
        this.criteria.put("$expr", value);
        return this;
    }

    @NotNull
    public Document getCriteriaObject() {
        return this.getSingleCriteriaObject();
    }

    private static boolean requiresGeoJsonFormat(Object value) {
        return value instanceof GeoJson || value instanceof GeoCommand && ((GeoCommand)value).getShape() instanceof GeoJson;
    }

    @NotNull
    protected Document getSingleCriteriaObject() {
        Document document = new Document();
        boolean not = false;
        for (Map.Entry<String, Object> entry : this.criteria.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (JCriteria.requiresGeoJsonFormat(value)) {
                value = new Document("$geometry", value);
            }
            if (not) {
                Document notDocument = new Document();
                notDocument.put(key, value);
                document.put("$not", (Object)notDocument);
                not = false;
                continue;
            }
            if ("$not".equals(key) && value == null) {
                not = true;
                continue;
            }
            document.put(key, value);
        }
        if (!StringUtils.hasText((String)this.key)) {
            if (not) {
                return new Document("$not", (Object)document);
            }
            return document;
        }
        Document queryCriteria = new Document();
        if (!NOT_SET.equals(this.isValue)) {
            queryCriteria.put(this.key, this.isValue);
            queryCriteria.putAll((Map)document);
        } else {
            queryCriteria.put(this.key, (Object)document);
        }
        return queryCriteria;
    }
}

