/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.process.adapter.delegate.datahandle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.JavaDelegate;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.extbpm.process.adapter.delegate.datahandle.base.BaseDataDelegate;
import org.jeecg.modules.minides.enums.GetDataTypeEnums;
import org.jeecg.modules.online.desform.function.util.FunctionUtil;
import org.jeecg.modules.online.desform.vo.query.DesformSuperQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Scope(value="prototype")
@Component(value="functionDelegate")
public class FunctionDelegate
extends BaseDataDelegate
implements JavaDelegate {
    private static final Logger log = LoggerFactory.getLogger(FunctionDelegate.class);
    public static final String FUN_TYPE_NUM = "number";
    public static final String FUN_TYPE_RECORD = "record";
    public static final String FUN_TYPE_FUN = "fun";
    public static final String FUN_TYPE_DATE = "date";
    public static final String FUN_TYPE_DATE_DIFF = "date-diff";

    public void execute(DelegateExecution delegateExecution) {
        log.info("---------\u8fdb\u5165\u8fd0\u7b97\u5904\u7406-\u670d\u52a1\u8282\u70b9 functionDelegate-----------");
        try {
            boolean bl = this.init(delegateExecution);
            if (bl) {
                String string = this.childAttr.getFunText();
                String string2 = this.childAttr.getFunContext();
                String string3 = this.childAttr.getFunType();
                Object object = null;
                if (FUN_TYPE_NUM.equals(string3)) {
                    object = this.getNumberResult(string, string2);
                } else if (FUN_TYPE_RECORD.equals(string3)) {
                    object = this.getRecordSize(string2);
                } else if (FUN_TYPE_FUN.equals(string3)) {
                    object = this.getFunCalcResult(string, string2);
                } else if (FUN_TYPE_DATE.equals(string3)) {
                    object = this.getDateResult();
                } else if (FUN_TYPE_DATE_DIFF.equals(string3)) {
                    object = this.getDateDiffResult();
                }
                String string4 = MessageFormat.format("flow:task:get_data:{0}:{1}", this.processInstanceId, this.activityId);
                delegateExecution.setVariable(string4, object);
            }
        }
        catch (Exception exception) {
            log.error("\u6d41\u7a0b\u9519\u8bef", (Throwable)exception);
            super.handleException(exception);
        }
    }

    private int getRecordSize(String funContextString) {
        JSONObject jSONObject = JSON.parseObject((String)funContextString);
        String string = jSONObject.getString("nodeId");
        String string2 = MessageFormat.format("flow:task:get_data:{0}:{1}", this.processInstanceId, string);
        String string3 = jSONObject.getString("formTableCode");
        if ("sys_user".equalsIgnoreCase(string3) || "sys_depart".equalsIgnoreCase(string3) || "sys_role".equalsIgnoreCase(string3)) {
            Object object = this.delegateExecution.getVariable(string2);
            if (object != null && object instanceof List) {
                List list = (List)object;
                return list.size();
            }
        } else {
            Object object;
            Integer n = jSONObject.getInteger("getDataType");
            if (GetDataTypeEnums.from_redis.getType().equals(n)) {
                Object object2;
                String string4 = (String)this.delegateExecution.getVariable(string2, String.class);
                if (string4 != null && (object2 = this.redisUtil.get(string4)) != null) {
                    List list = (List)object2;
                    return list.size();
                }
            } else if (GetDataTypeEnums.from_db.getType().equals(n) && (object = this.delegateExecution.getVariable(string2)) != null) {
                List list = (List)object;
                DesformSuperQuery desformSuperQuery = new DesformSuperQuery();
                desformSuperQuery.setIdList(list);
                List list2 = this.designFormDataService.list(string3, desformSuperQuery);
                if (list2 != null) {
                    return list2.size();
                }
            }
        }
        return 0;
    }

    private Object getNumberResult(String funText, String funContextString) {
        HashMap<CallSite, BigDecimal> hashMap = new HashMap<CallSite, BigDecimal>();
        JSONObject jSONObject = JSON.parseObject((String)funContextString);
        for (String string : jSONObject.keySet()) {
            try {
                Pattern pattern;
                Matcher matcher;
                String string2 = URLDecoder.decode(jSONObject.getString(string), "UTF-8");
                System.out.println("json\u53c2\u6570: " + string2);
                JSONObject jSONObject2 = JSON.parseObject((String)string2);
                if (funText.indexOf(string) < 0 || !(matcher = (pattern = Pattern.compile("\\{\\{" + string + "\\.\\w+\\}\\}")).matcher(funText)).find()) continue;
                String string3 = matcher.group();
                String string4 = "a" + string3.replace("{{", "").replace("}}", "").replace(".", "_");
                funText = funText.replace(string3, string4);
                Object object = this.getVariableValue(jSONObject2, null, false);
                if (object != null) {
                    hashMap.put((CallSite)((Object)string4), new BigDecimal(object.toString()));
                    continue;
                }
                hashMap.put((CallSite)((Object)string4), (BigDecimal)null);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        Object object = FunctionUtil.getExpressionVal((String)funText, hashMap);
        return object;
    }

    private Object getFunCalcResult(String funText, String funContextString) {
        HashMap<CallSite, Object> hashMap = new HashMap<CallSite, Object>();
        JSONObject jSONObject = JSON.parseObject((String)funContextString);
        for (String string : jSONObject.keySet()) {
            try {
                Pattern pattern;
                Matcher matcher;
                String string2 = URLDecoder.decode(jSONObject.getString(string), "UTF-8");
                System.out.println("json\u53c2\u6570: " + string2);
                JSONObject jSONObject2 = JSON.parseObject((String)string2);
                if (funText.indexOf(string) < 0 || !(matcher = (pattern = Pattern.compile("\\{\\{" + string + "\\.\\w+\\}\\}")).matcher(funText)).find()) continue;
                String string3 = matcher.group();
                String string4 = "a" + string3.replace("{{", "").replace("}}", "").replace(".", "_");
                funText = funText.replace(string3, string4);
                Object object = this.getVariableValue(jSONObject2, null, true);
                if (object != null) {
                    object = this.getValueString(object);
                }
                hashMap.put((CallSite)((Object)string4), object);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        Object object = FunctionUtil.getExpressionStringVal((String)funText, hashMap);
        return object;
    }

    private Object getDateDiffResult() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string = this.childAttr.getDateFieldVal();
        String string2 = this.childAttr.getDateFieldEndVal();
        String string3 = this.childAttr.getDateFunctionFormat();
        if (oConvertUtils.isEmpty((Object)string)) {
            return null;
        }
        if (oConvertUtils.isEmpty((Object)string2)) {
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            object4 = JSONObject.parseObject((String)string);
            object3 = this.getVariableValue((JSONObject)object4, null, false);
            hashMap.put("arg1", object3);
        }
        catch (Exception exception) {
            hashMap.put("arg1", string);
        }
        try {
            object4 = JSONObject.parseObject((String)string2);
            object3 = this.getVariableValue((JSONObject)object4, null, false);
            hashMap.put("arg2", object3);
        }
        catch (Exception exception) {
            hashMap.put("arg2", string2);
        }
        object4 = "2";
        object3 = "d";
        if (oConvertUtils.isEmpty((Object)string3)) {
            hashMap.put("arg3", object4);
            hashMap.put("arg4", object3);
        } else {
            object2 = JSONObject.parseObject((String)string3);
            object = object2.getString("end");
            String string4 = object2.getString("out");
            hashMap.put("arg3", oConvertUtils.getString((String)object, (String)object4));
            hashMap.put("arg4", oConvertUtils.getString((String)string4, (String)object3));
        }
        object2 = "DATEIF(arg1, arg2, arg3, arg4)";
        object = FunctionUtil.getExpressionStringVal((String)object2, hashMap);
        return object;
    }

    private Object getDateResult() {
        Object object;
        String string;
        Object object2;
        Object object3;
        String string2 = this.childAttr.getFunText();
        String string3 = this.childAttr.getFunContext();
        String string4 = this.childAttr.getDateFieldVal();
        String string5 = this.childAttr.getDateFunctionFormat();
        if (oConvertUtils.isEmpty((Object)string4)) {
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            object3 = JSONObject.parseObject((String)string4);
            object2 = this.getVariableValue((JSONObject)object3, null, false);
            hashMap.put("arg1", object2);
        }
        catch (Exception exception) {
            hashMap.put("arg1", string4);
        }
        object3 = "datetime";
        if (oConvertUtils.isEmpty((Object)string5)) {
            hashMap.put("arg2", object3);
            hashMap.put("arg4", object3);
        } else {
            object2 = JSONObject.parseObject((String)string5);
            string = object2.getString("argument");
            object = object2.getString("result");
            hashMap.put("arg2", oConvertUtils.getString((String)string, (String)object3));
            hashMap.put("arg4", oConvertUtils.getString((String)object, (String)object3));
        }
        object2 = this.getComplexValText(string2, string3, null);
        if (oConvertUtils.isEmpty((Object)object2)) {
            hashMap.put("arg3", "");
        } else {
            hashMap.put("arg3", object2);
        }
        string = "DATEADD2(arg1, arg2, arg3, arg4)";
        object = FunctionUtil.getExpressionStringVal((String)string, hashMap);
        return object;
    }

    private Object getValueString(Object value) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (value instanceof JSONArray) {
            JSONArray jSONArray = (JSONArray)value;
            for (int k = 0; k < jSONArray.size(); ++k) {
                arrayList.add(jSONArray.getString(k));
            }
        } else {
            String string = value.toString();
            if (string.startsWith("[") && string.endsWith("]")) {
                JSONArray jSONArray = JSONArray.parseArray((String)string);
                for (int k = 0; k < jSONArray.size(); ++k) {
                    arrayList.add(jSONArray.getString(k));
                }
            }
        }
        if (arrayList.size() > 0) {
            return String.join((CharSequence)",", arrayList);
        }
        if (value instanceof Integer || value instanceof BigDecimal || value instanceof Double) {
            return value;
        }
        return value.toString();
    }
}

