/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.process.common.expression;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="flowNodeExpression")
public class FlowNodeExpression {
    private static final Logger log = LoggerFactory.getLogger(FlowNodeExpression.class);
    @Lazy
    @Autowired
    private ISysBaseAPI sysbase;

    public List<String> getDepartLeaders(String applyUserId) {
        log.info("getDepartLeaders called with applyUserId={}", (Object)applyUserId);
        List list = this.sysbase.getDepartIdsByUsername(applyUserId);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        List list2 = this.sysbase.getDeptHeadByDepId(StringUtils.join((Collection)list, (String)","));
        return list2;
    }

    public List<String> getLevel1DepartLeaders(String applyUserId) {
        Set set = this.sysbase.getDepartParentIdsByUsername(applyUserId);
        if (CollectionUtils.isEmpty((Collection)set)) {
            return null;
        }
        List list = this.sysbase.getDeptHeadByDepId(StringUtils.join((Collection)set, (String)","));
        return list;
    }

    public List<String> getLevel2DepartLeaders(String applyUserId) {
        Set set = this.sysbase.getDepartParentIdsByUsername(applyUserId);
        log.info("level1DepParentIds = {}", (Object)set);
        if (CollectionUtils.isEmpty((Collection)set)) {
            return null;
        }
        Set set2 = this.sysbase.getDepartParentIdsByDepIds(set);
        log.info("level2DepParentIds = {}", (Object)set2);
        if (CollectionUtils.isEmpty((Collection)set2)) {
            return null;
        }
        List list = this.sysbase.getDeptHeadByDepId(StringUtils.join((Collection)set2, (String)","));
        log.info("users = {}", (Object)list);
        return list;
    }

    public List<String> getLevel3DepartLeaders(String applyUserId) {
        Set set = this.sysbase.getDepartParentIdsByUsername(applyUserId);
        log.info("level1DepParentIds = {}", (Object)set);
        if (CollectionUtils.isEmpty((Collection)set)) {
            return null;
        }
        Set set2 = this.sysbase.getDepartParentIdsByDepIds(set);
        log.info("level2DepParentIds = {}", (Object)set2);
        if (CollectionUtils.isEmpty((Collection)set2)) {
            return null;
        }
        Set set3 = this.sysbase.getDepartParentIdsByDepIds(set2);
        log.info("level3DepParentIds = {}", (Object)set3);
        if (CollectionUtils.isEmpty((Collection)set3)) {
            return null;
        }
        List list = this.sysbase.getDeptHeadByDepId(StringUtils.join((Collection)set3, (String)","));
        log.info("users = {}", (Object)list);
        return list;
    }
}

