/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.bpm.job;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Process;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.cmd.StartProcessInstanceCmd;
import org.flowable.engine.impl.jobexecutor.TimerEventHandler;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.impl.util.ProcessInstanceHelper;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.job.service.JobHandler;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.variable.api.delegate.VariableScope;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.extbpm.process.common.b;
import org.jeecg.modules.extbpm.process.service.IExtActFormDataService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="customTimeStartJobEventHandler")
public class CustomTimeStartJobEventHandler
extends TimerEventHandler
implements JobHandler {
    private static final Logger log = LoggerFactory.getLogger(CustomTimeStartJobEventHandler.class);
    public static final String TYPE = "timer-start-event-custom";
    private IExtActFormDataService extActFormDataService;

    public String getType() {
        return TYPE;
    }

    public void execute(JobEntity job, String configuration, VariableScope variableScope, CommandContext commandContext) {
        log.info("============\u6267\u884c\u81ea\u5b9a\u4e49 \u5b9a\u65f6\u542f\u52a8\u6d41\u7a0b \u5904\u7406\u5668============");
        log.info("\u5b9a\u65f6\u4efb\u52a1\u8be6\u60c5 = {}", (Object)JSON.toJSONString((Object)job));
        if (this.extActFormDataService == null) {
            this.extActFormDataService = (IExtActFormDataService)SpringContextUtils.getBean(IExtActFormDataService.class);
        }
        String string = job.getJobHandlerConfiguration();
        JSONObject jSONObject = JSONObject.parseObject((String)string);
        ProcessDefinitionEntity processDefinitionEntity = ProcessDefinitionUtil.getProcessDefinitionFromDatabase((String)job.getProcessDefinitionId());
        if (processDefinitionEntity == null) {
            throw new FlowableException("Could not find process definition needed for timer start event");
        }
        try {
            if (!processDefinitionEntity.isSuspended()) {
                ProcessEngineConfigurationImpl processEngineConfigurationImpl = CommandContextUtil.getProcessEngineConfiguration((CommandContext)commandContext);
                FlowableEventDispatcher flowableEventDispatcher = processEngineConfigurationImpl.getEventDispatcher();
                if (flowableEventDispatcher != null && flowableEventDispatcher.isEnabled()) {
                    flowableEventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent((FlowableEngineEventType)FlowableEngineEventType.TIMER_FIRED, (Object)job), processEngineConfigurationImpl.getEngineCfgKey());
                }
                Process process = ProcessDefinitionUtil.getProcess((String)job.getProcessDefinitionId());
                String string2 = TimerEventHandler.getActivityIdFromConfiguration((String)configuration);
                if (string2 != null) {
                    FlowElement flowElement = process.getFlowElement(string2, true);
                    if (flowElement == null) {
                        throw new FlowableException("Could not find matching FlowElement for activityId " + string2);
                    }
                    ProcessInstanceHelper processInstanceHelper = processEngineConfigurationImpl.getProcessInstanceHelper();
                    String string3 = oConvertUtils.getString((Object)jSONObject.get((Object)b.h));
                    String string4 = oConvertUtils.getString((Object)jSONObject.get((Object)b.m));
                    Map<String, Object> map = this.extActFormDataService.getJsonDataById(string3, string4);
                    log.debug("---\u65e5\u671f\u5b9a\u65f6\u542f\u52a8\u5668\uff0c\u52a0\u8f7d\u521d\u59cb\u5316\u6570\u636e\uff1a{}", map);
                    if (map == null) {
                        map = new HashMap<String, Object>();
                        map.put(b.s, string4);
                        map.put(b.r, string3);
                    }
                    map.put(b.s, string4);
                    map.put(b.r, string3);
                    map.put(b.m, string4);
                    map.put(b.z, "2");
                    map.put(b.h, string3);
                    String string5 = "{{DOMAIN_URL}}/desform/detail/" + string3 + "/" + string4 + "?token={{TOKEN}}&taskId={{TASKID}}";
                    String string6 = "{{DOMAIN_URL}}/desform/detail/" + string3 + "/" + string4 + "?token={{TOKEN}}&taskId={{TASKID}}";
                    map.put(b.u, string5);
                    map.put(b.v, string6);
                    map.put(b.q, jSONObject.get((Object)b.q));
                    processInstanceHelper.createAndStartProcessInstanceWithInitialFlowElement((ProcessDefinition)processDefinitionEntity, (String)null, (String)null, (String)null, flowElement, process, map, (Map)null, null, null, true);
                } else {
                    new StartProcessInstanceCmd(processDefinitionEntity.getKey(), (String)null, (String)null, (Map)null, job.getTenantId()).execute(commandContext);
                }
            } else {
                log.debug("ignoring timer of suspended process definition {}", (Object)processDefinitionEntity.getName());
            }
        }
        catch (RuntimeException runtimeException) {
            log.error("exception during timer execution", (Throwable)runtimeException);
            throw runtimeException;
        }
        catch (Exception exception) {
            log.error("exception during timer execution", (Throwable)exception);
            throw new FlowableException("exception during timer execution: " + exception.getMessage(), (Throwable)exception);
        }
    }
}

