/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.process.adapter.delegate.datahandle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.JavaDelegate;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.extbpm.process.adapter.delegate.datahandle.base.BaseDataDelegate;
import org.jeecg.modules.minides.enums.GetDataTypeEnums;
import org.jeecg.modules.online.desform.function.util.FunctionUtil;
import org.jeecg.modules.online.desform.vo.query.DesformSuperQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Scope(value="prototype")
@Component(value="functionDelegate")
public class FunctionDelegate
extends BaseDataDelegate
implements JavaDelegate {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FunctionDelegate.class);
    public static final String FUN_TYPE_NUM = "number";
    public static final String FUN_TYPE_RECORD = "record";
    public static final String FUN_TYPE_FUN = "fun";
    public static final String FUN_TYPE_DATE = "date";
    public static final String FUN_TYPE_DATE_DIFF = "date-diff";

    public void execute(DelegateExecution delegateExecution) {
        log.info("---------\u8fdb\u5165\u8fd0\u7b97\u5904\u7406-\u670d\u52a1\u8282\u70b9 functionDelegate-----------");
        try {
            boolean init = this.init(delegateExecution);
            if (init) {
                String funText = this.childAttr.getFunText();
                String funContextString = this.childAttr.getFunContext();
                String type = this.childAttr.getFunType();
                Object obj = null;
                if (FUN_TYPE_NUM.equals(type)) {
                    obj = this.getNumberResult(funText, funContextString);
                } else if (FUN_TYPE_RECORD.equals(type)) {
                    obj = this.getRecordSize(funContextString);
                } else if (FUN_TYPE_FUN.equals(type)) {
                    obj = this.getFunCalcResult(funText, funContextString);
                } else if (FUN_TYPE_DATE.equals(type)) {
                    obj = this.getDateResult();
                } else if (FUN_TYPE_DATE_DIFF.equals(type)) {
                    obj = this.getDateDiffResult();
                }
                String processVariableKey = MessageFormat.format("flow:task:get_data:{0}:{1}", this.processInstanceId, this.activityId);
                delegateExecution.setVariable(processVariableKey, obj);
            }
        }
        catch (Exception exception) {
            log.error("\u6d41\u7a0b\u9519\u8bef", (Throwable)exception);
            super.handleException(exception);
        }
    }

    private int getRecordSize(String funContextString) {
        JSONObject funContext = JSON.parseObject((String)funContextString);
        String formNodeId = funContext.getString("nodeId");
        String formDataSourceKey = MessageFormat.format("flow:task:get_data:{0}:{1}", this.processInstanceId, formNodeId);
        String formTableCode = funContext.getString("formTableCode");
        if ("sys_user".equalsIgnoreCase(formTableCode) || "sys_depart".equalsIgnoreCase(formTableCode) || "sys_role".equalsIgnoreCase(formTableCode)) {
            Object obj = this.delegateExecution.getVariable(formDataSourceKey);
            if (obj != null && obj instanceof List) {
                List list = (List)obj;
                return list.size();
            }
        } else {
            Object obj;
            Integer getDataType = funContext.getInteger("getDataType");
            if (GetDataTypeEnums.from_redis.getType().equals(getDataType)) {
                Object obj2;
                String redisKey = (String)this.delegateExecution.getVariable(formDataSourceKey, String.class);
                if (redisKey != null && (obj2 = this.redisUtil.get(redisKey)) != null) {
                    List records = (List)obj2;
                    return records.size();
                }
            } else if (GetDataTypeEnums.from_db.getType().equals(getDataType) && (obj = this.delegateExecution.getVariable(formDataSourceKey)) != null) {
                List dataIds = (List)obj;
                DesformSuperQuery superQuery = new DesformSuperQuery();
                superQuery.setIdList(dataIds);
                List records = this.designFormDataService.list(formTableCode, superQuery);
                if (records != null) {
                    return records.size();
                }
            }
        }
        return 0;
    }

    private Object getNumberResult(String funText, String funContextString) {
        HashMap<CallSite, BigDecimal> env = new HashMap<CallSite, BigDecimal>();
        JSONObject funContext = JSON.parseObject((String)funContextString);
        for (String key : funContext.keySet()) {
            try {
                Pattern p;
                Matcher matcher;
                String str = URLDecoder.decode(funContext.getString(key), "UTF-8");
                System.out.println("json\u53c2\u6570: " + str);
                JSONObject params = JSON.parseObject((String)str);
                if (funText.indexOf(key) < 0 || !(matcher = (p = Pattern.compile("\\{\\{" + key + "\\.\\w+\\}\\}")).matcher(funText)).find()) continue;
                String exp = matcher.group();
                String envKey = "a" + exp.replace("{{", "").replace("}}", "").replace(".", "_");
                funText = funText.replace(exp, envKey);
                Object value = this.getVariableValue(params, null, false);
                if (value != null) {
                    env.put((CallSite)((Object)envKey), new BigDecimal(value.toString()));
                    continue;
                }
                env.put((CallSite)((Object)envKey), (BigDecimal)null);
            }
            catch (UnsupportedEncodingException e2) {
                e2.printStackTrace();
            }
        }
        Object obj = FunctionUtil.getExpressionVal((String)funText, env);
        return obj;
    }

    private Object getFunCalcResult(String funText, String funContextString) {
        HashMap<CallSite, Object> env = new HashMap<CallSite, Object>();
        JSONObject funContext = JSON.parseObject((String)funContextString);
        for (String key : funContext.keySet()) {
            try {
                Pattern p;
                Matcher matcher;
                String str = URLDecoder.decode(funContext.getString(key), "UTF-8");
                System.out.println("json\u53c2\u6570: " + str);
                JSONObject params = JSON.parseObject((String)str);
                if (funText.indexOf(key) < 0 || !(matcher = (p = Pattern.compile("\\{\\{" + key + "\\.\\w+\\}\\}")).matcher(funText)).find()) continue;
                String exp = matcher.group();
                String envKey = "a" + exp.replace("{{", "").replace("}}", "").replace(".", "_");
                funText = funText.replace(exp, envKey);
                Object value = this.getVariableValue(params, null, true);
                if (value != null) {
                    value = this.getValueString(value);
                }
                env.put((CallSite)((Object)envKey), value);
            }
            catch (UnsupportedEncodingException e2) {
                e2.printStackTrace();
            }
        }
        Object obj = FunctionUtil.getExpressionStringVal((String)funText, env);
        return obj;
    }

    private Object getDateDiffResult() {
        String beginVal = this.childAttr.getDateFieldVal();
        String endVal = this.childAttr.getDateFieldEndVal();
        String dateFunctionFormat = this.childAttr.getDateFunctionFormat();
        if (oConvertUtils.isEmpty((Object)beginVal)) {
            return null;
        }
        if (oConvertUtils.isEmpty((Object)endVal)) {
            return null;
        }
        HashMap<String, Object> env = new HashMap<String, Object>();
        try {
            JSONObject params1 = JSONObject.parseObject((String)beginVal);
            Object value1 = this.getVariableValue(params1, null, false);
            env.put("arg1", value1);
        }
        catch (Exception e2) {
            env.put("arg1", beginVal);
        }
        try {
            JSONObject params2 = JSONObject.parseObject((String)endVal);
            Object value2 = this.getVariableValue(params2, null, false);
            env.put("arg2", value2);
        }
        catch (Exception e3) {
            env.put("arg2", endVal);
        }
        String defEndFormat = "2";
        String defOutFormat = "d";
        if (oConvertUtils.isEmpty((Object)dateFunctionFormat)) {
            env.put("arg3", defEndFormat);
            env.put("arg4", defOutFormat);
        } else {
            JSONObject formatObj = JSONObject.parseObject((String)dateFunctionFormat);
            String endFormat = formatObj.getString("end");
            String outFormat = formatObj.getString("out");
            env.put("arg3", oConvertUtils.getString((String)endFormat, (String)defEndFormat));
            env.put("arg4", oConvertUtils.getString((String)outFormat, (String)defOutFormat));
        }
        String expression = "DATEIF(arg1, arg2, arg3, arg4)";
        Object obj = FunctionUtil.getExpressionStringVal((String)expression, env);
        return obj;
    }

    private Object getDateResult() {
        String funText = this.childAttr.getFunText();
        String funContextString = this.childAttr.getFunContext();
        String valStr = this.childAttr.getDateFieldVal();
        String dateFunctionFormat = this.childAttr.getDateFunctionFormat();
        if (oConvertUtils.isEmpty((Object)valStr)) {
            return null;
        }
        HashMap<String, Object> env = new HashMap<String, Object>();
        try {
            JSONObject params = JSONObject.parseObject((String)valStr);
            Object value = this.getVariableValue(params, null, false);
            env.put("arg1", value);
        }
        catch (Exception e2) {
            env.put("arg1", valStr);
        }
        String datetime = "datetime";
        if (oConvertUtils.isEmpty((Object)dateFunctionFormat)) {
            env.put("arg2", datetime);
            env.put("arg4", datetime);
        } else {
            JSONObject formatObj = JSONObject.parseObject((String)dateFunctionFormat);
            String argFormat = formatObj.getString("argument");
            String resFormat = formatObj.getString("result");
            env.put("arg2", oConvertUtils.getString((String)argFormat, (String)datetime));
            env.put("arg4", oConvertUtils.getString((String)resFormat, (String)datetime));
        }
        String how2do = this.getComplexValText(funText, funContextString, null);
        if (oConvertUtils.isEmpty((Object)how2do)) {
            env.put("arg3", "");
        } else {
            env.put("arg3", how2do);
        }
        String expression = "DATEADD2(arg1, arg2, arg3, arg4)";
        Object obj = FunctionUtil.getExpressionStringVal((String)expression, env);
        return obj;
    }

    private Object getValueString(Object value) {
        ArrayList<String> list = new ArrayList<String>();
        if (value instanceof JSONArray) {
            JSONArray array = (JSONArray)value;
            for (int i2 = 0; i2 < array.size(); ++i2) {
                list.add(array.getString(i2));
            }
        } else {
            String str = value.toString();
            if (str.startsWith("[") && str.endsWith("]")) {
                JSONArray array = JSONArray.parseArray((String)str);
                for (int i3 = 0; i3 < array.size(); ++i3) {
                    list.add(array.getString(i3));
                }
            }
        }
        if (list.size() > 0) {
            return String.join((CharSequence)",", list);
        }
        if (value instanceof Integer || value instanceof BigDecimal || value instanceof Double) {
            return value;
        }
        return value.toString();
    }
}

