/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.process.common.expression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.jeecg.common.constant.enums.PositionLevelEnum;
import org.jeecg.modules.extbpm.process.mapper.ExtSystemOaMapper;
import org.jeecg.modules.extbpm.process.pojo.OaDepInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="oaFlowExpression")
public class OaFlowExpression {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OaFlowExpression.class);
    @Autowired
    private ExtSystemOaMapper extSystemOaMapper;

    public List<String> getApplyUserDeptPositionLevel(String applySysOrgCode, String applyUserId, String targetPositionId) {
        log.info("getApplyUserDeptPositionLevel called with applySysOrgCode={}, applyUserId={}, targetPositionId={}", new Object[]{applySysOrgCode, applyUserId, targetPositionId});
        List<String> result = new ArrayList<String>();
        if (StringUtils.isEmpty((String)targetPositionId) || StringUtils.isEmpty((String)applyUserId) || StringUtils.isEmpty((String)applySysOrgCode)) {
            return result;
        }
        try {
            boolean targetIsLeader;
            String initiatorPositionName = this.extSystemOaMapper.getUserMainPositionNameByUsername(applyUserId);
            if (StringUtils.isEmpty((String)initiatorPositionName)) {
                log.warn("\u53d1\u8d77\u4eba\u4e3b\u5c97\u4f4d\u7684\u804c\u7ea7\uff0c\u662f\u7a7a\u7684 ==> applyUserId={}", (Object)applyUserId);
                return result;
            }
            String targetPositionName = this.extSystemOaMapper.getPositionNameById(targetPositionId);
            if (StringUtils.isEmpty((String)targetPositionName)) {
                log.warn("\u7528\u6237\u8282\u70b9\u9009\u62e9\u7684\u804c\u7ea7\uff0c\u662f\u7a7a\u7684 ==> targetPositionId={}", (Object)targetPositionId);
                return result;
            }
            PositionLevelEnum initiatorPosition = PositionLevelEnum.getByName((String)initiatorPositionName);
            PositionLevelEnum targetPosition = PositionLevelEnum.getByName((String)targetPositionName);
            if (initiatorPosition == null || targetPosition == null) {
                return result;
            }
            boolean initiatorIsStaff = initiatorPosition.getType() == PositionLevelEnum.PositionType.STAFF;
            boolean initiatorIsLeader = initiatorPosition.getType() == PositionLevelEnum.PositionType.LEADER;
            boolean targetIsStaff = targetPosition.getType() == PositionLevelEnum.PositionType.STAFF;
            boolean bl = targetIsLeader = targetPosition.getType() == PositionLevelEnum.PositionType.LEADER;
            if (initiatorIsStaff && targetIsStaff) {
                result = this.getUsersInCurrentDept(applySysOrgCode, Collections.singletonList(targetPositionName));
                if (result.isEmpty()) {
                    log.warn("\u89c4\u52191: \u53d1\u8d77\u4eba\u662f\u804c\u5458\u5c42\u7ea7\uff0c\u76ee\u6807\u4e5f\u662f\u804c\u5458\u5c42\u7ea7\uff0c\u67e5\u627e\u53d1\u8d77\u4eba\u6240\u5728\u90e8\u95e8,\u4f46\u662f\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u804c\u7ea7\u4eba\u5458 ==> applySysOrgCode={}, initiatorPositionName={}", (Object)applySysOrgCode, (Object)initiatorPositionName);
                } else {
                    log.info("\u89c4\u52191: \u53d1\u8d77\u4eba\u662f\u804c\u5458\u5c42\u7ea7\uff0c\u76ee\u6807\u4e5f\u662f\u804c\u5458\u5c42\u7ea7\uff0c\u67e5\u627e\u53d1\u8d77\u4eba\u6240\u5728\u90e8\u95e8,\u627e\u5230\u5bf9\u5e94\u804c\u7ea7\u4eba\u5458 ==> applySysOrgCode={}, initiatorPositionName={}, result={}", new Object[]{applySysOrgCode, initiatorPositionName, result});
                }
            } else if (initiatorIsStaff && targetIsLeader) {
                String nearestCompanySysOrgCode = null;
                String depId = this.extSystemOaMapper.getDepId(applySysOrgCode);
                if (StringUtils.isNotEmpty((String)depId)) {
                    log.warn("\u53d1\u8d77\u4eba\u6240\u5728\u90e8\u95e8\u6ca1\u6709\u4e0a\u7ea7\u90e8\u95e8\uff0c\u65e0\u6cd5\u7ee7\u7eed\u67e5\u627e ==> applySysOrgCode={}", (Object)applySysOrgCode);
                    OaDepInfo oaDepInfo = this.findNearestSpecialDepart(depId);
                    nearestCompanySysOrgCode = oaDepInfo.getOrgCode();
                } else {
                    nearestCompanySysOrgCode = applySysOrgCode;
                }
                result = this.getCompanyLeaders(nearestCompanySysOrgCode, Collections.singletonList(targetPositionName));
                if (result.isEmpty()) {
                    log.warn("\u89c4\u52192: \u53d1\u8d77\u4eba\u662f\u804c\u5458\u5c42\u7ea7\uff0c\u76ee\u6807\u662f\u9886\u5bfc\u5c42\u7ea7\uff0c\u67e5\u627e\u8463\u4e8b\u957f\u3001\u603b\u7ecf\u7406\u3001\u526f\u603b\u7ecf\u7406,\u4f46\u662f\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u804c\u7ea7\u4eba\u5458 ==> applySysOrgCode={}, nearestCompanySysOrgCode={}, targetPositionName={}", new Object[]{applySysOrgCode, nearestCompanySysOrgCode, targetPositionName});
                } else {
                    log.info("\u89c4\u52192: \u53d1\u8d77\u4eba\u662f\u804c\u5458\u5c42\u7ea7\uff0c\u76ee\u6807\u662f\u9886\u5bfc\u5c42\u7ea7\uff0c\u67e5\u627e\u8463\u4e8b\u957f\u3001\u603b\u7ecf\u7406\u3001\u526f\u603b\u7ecf\u7406,\u627e\u5230\u5bf9\u5e94\u804c\u7ea7\u4eba\u5458 ==> applySysOrgCode={}, nearestCompanySysOrgCode={}, targetPositionName={}, result={}", new Object[]{applySysOrgCode, nearestCompanySysOrgCode, targetPositionName, result});
                }
            } else if (initiatorIsLeader && targetIsStaff) {
                result = new ArrayList();
                log.warn("\u89c4\u52193: \u53d1\u8d77\u4eba\u662f\u9886\u5bfc\u5c42\u7ea7\uff0c\u76ee\u6807\u662f\u804c\u5458\u5c42\u7ea7\uff0c\u8fd4\u56de\u7a7a ==> applyUserId={}, applySysOrgCode={}, targetPositionId={}", new Object[]{applyUserId, applySysOrgCode, targetPositionId});
            } else if (initiatorIsLeader && targetIsLeader) {
                String nearestCompanySysOrgCode = null;
                String depId = this.extSystemOaMapper.getDepId(applySysOrgCode);
                if (StringUtils.isNotEmpty((String)depId)) {
                    log.warn("\u53d1\u8d77\u4eba\u6240\u5728\u90e8\u95e8\u6ca1\u6709\u4e0a\u7ea7\u90e8\u95e8\uff0c\u65e0\u6cd5\u7ee7\u7eed\u67e5\u627e ==> applySysOrgCode={}", (Object)applySysOrgCode);
                    OaDepInfo oaDepInfo = this.findNearestSpecialDepart(depId);
                    nearestCompanySysOrgCode = oaDepInfo.getOrgCode();
                } else {
                    nearestCompanySysOrgCode = applySysOrgCode;
                }
                result = this.getCompanyLeaders(nearestCompanySysOrgCode, Collections.singletonList(targetPositionName));
                if (result.isEmpty()) {
                    log.warn("\u89c4\u52194: \u53d1\u8d77\u4eba\u662f\u9886\u5bfc\u5c42\u7ea7\uff0c\u76ee\u6807\u4e5f\u662f\u9886\u5bfc\u5c42\u7ea7,\u4f46\u662f\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u804c\u7ea7\u4eba\u5458 ==> applyUserSysOrgCode={}, nearestCompanySysOrgCode={}, targetPositionName={}", new Object[]{applySysOrgCode, nearestCompanySysOrgCode, targetPositionName});
                } else {
                    log.info("\u89c4\u52194: \u53d1\u8d77\u4eba\u662f\u9886\u5bfc\u5c42\u7ea7\uff0c\u76ee\u6807\u4e5f\u662f\u9886\u5bfc\u5c42\u7ea7,\u627e\u5230\u5bf9\u5e94\u804c\u7ea7\u4eba\u5458 ==> applyUserSysOrgCode={}, nearestCompanySysOrgCode={}, targetPositionName={}, result={}", new Object[]{applySysOrgCode, nearestCompanySysOrgCode, targetPositionName, result});
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return result;
    }

    public List<String> getUserSuperPositionLevel1(String applyUserId) {
        List<String> list = this.extSystemOaMapper.getApplyUserSuperPositionLevel1Users(applyUserId);
        log.info("getUserSuperPositionLevel1 called with applyUserId={}, result={}", (Object)applyUserId, list);
        return list;
    }

    public List<String> getUserSuperPositionLevel2(String applyUserId) {
        List<String> list = this.extSystemOaMapper.getApplyUserSuperPositionLevel2Users(applyUserId);
        log.info("getUserSuperPositionLevel2 called with applyUserId={}, result={}", (Object)applyUserId, list);
        return list;
    }

    public List<String> getUserSuperPositionLevel3(String applyUserId) {
        List<String> list = this.extSystemOaMapper.getApplyUserSuperPositionLevel3Users(applyUserId);
        log.info("getUserSuperPositionLevel3 called with applyUserId={}, result={}", (Object)applyUserId, list);
        return list;
    }

    private List<String> getUsersInCurrentDept(String orgCode, List<String> positionNames) {
        try {
            if (CollectionUtils.isEmpty(positionNames)) {
                return new ArrayList<String>();
            }
            Set<String> users = this.extSystemOaMapper.getUsernamesByOrgCodeAndPosition(orgCode, positionNames);
            return CollectionUtils.isEmpty(users) ? new ArrayList() : users.stream().toList();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return new ArrayList<String>();
        }
    }

    private List<String> getCompanyLeaders(String orgCode, List<String> positionNames) {
        try {
            if (CollectionUtils.isEmpty(positionNames)) {
                return new ArrayList<String>();
            }
            Set<String> leaders = this.extSystemOaMapper.getUsernamesByOrgCodeAndPosition(orgCode, positionNames);
            return CollectionUtils.isEmpty(leaders) ? new ArrayList() : leaders.stream().toList();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return new ArrayList<String>();
        }
    }

    public OaDepInfo findNearestSpecialDepart(String departId) {
        OaDepInfo depart = this.extSystemOaMapper.getDepInfoById(departId);
        log.info(" \u9012\u5f52\u67e5\u627e\u6700\u8fd1\u7684\u7279\u6b8a\u90e8\u95e8\uff08\u516c\u53f8\u3001\u5b50\u516c\u53f8\u3001\u96c6\u56e2\uff09==> called with departId={}, depart={}", (Object)departId, (Object)depart);
        if (depart == null) {
            return null;
        }
        if ("1".equals(depart.getOrgCategory()) || "3".equals(depart.getOrgCategory()) || "4".equals(depart.getOrgCategory())) {
            return depart;
        }
        if (depart.getParentId() != null) {
            return this.findNearestSpecialDepart(depart.getParentId());
        }
        return null;
    }
}

