/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.listener.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import lombok.Generated;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.JavaDelegate;
import org.jeecg.common.api.dto.AiragFlowDTO;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.modules.extbpm.listener.service.util.VariableParseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AigcServiceTaskDelegate
implements JavaDelegate {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AigcServiceTaskDelegate.class);
    public static final String AI_SERVICE_TASK_CONFIG = "aiServiceTaskConfig";
    private static ISysBaseAPI sysBaseAPI;

    public void execute(DelegateExecution execution) {
        block11: {
            log.info("AigcServiceTaskDelegate \u5f00\u59cb\u6267\u884c\uff01");
            try {
                FlowElement flowElement = execution.getCurrentFlowElement();
                JSONObject json = VariableParseUtil.parseTaskExtendJson(flowElement, AI_SERVICE_TASK_CONFIG);
                log.info("AigcServiceTaskDelegate \u89e3\u6790\u5230\u7684JSON\u914d\u7f6e\uff1a{}", (Object)json);
                if (json == null) {
                    log.warn("\u672a\u627e\u5230AI\u670d\u52a1\u4efb\u52a1\u914d\u7f6e");
                    return;
                }
                String aiFlowId = json.getString("aiFlowId");
                if (aiFlowId == null || aiFlowId.isEmpty()) {
                    log.error("AI\u6d41\u7a0bID\u4e0d\u80fd\u4e3a\u7a7a");
                    throw new RuntimeException("AI\u6d41\u7a0bID\u4e0d\u80fd\u4e3a\u7a7a");
                }
                HashMap<String, Object> inputs = new HashMap<String, Object>();
                JSONArray inputParamsList = json.getJSONArray("inputParamsList");
                if (inputParamsList != null) {
                    for (int i2 = 0; i2 < inputParamsList.size(); ++i2) {
                        JSONObject inputParam = inputParamsList.getJSONObject(i2);
                        String key = inputParam.getString("key");
                        String value = inputParam.getString("value");
                        Object actualValue = VariableParseUtil.parseVariableValue(value, execution);
                        inputs.put(key, actualValue != null ? actualValue : "");
                    }
                }
                AiragFlowDTO params = new AiragFlowDTO();
                params.setFlowId(aiFlowId);
                params.setInputParams(inputs);
                if (sysBaseAPI == null) {
                    sysBaseAPI = (ISysBaseAPI)SpringContextUtils.getBean(ISysBaseAPI.class);
                }
                Object resultData = sysBaseAPI.runAiragFlow(params);
                log.info("AI\u6d41\u7a0b\u8fd0\u884c\u7ed3\u679c\uff1a{}", resultData);
                if (resultData != null) {
                    JSONArray outputParamsList = json.getJSONArray("outputParamsList");
                    if (outputParamsList != null) {
                        for (int i3 = 0; i3 < outputParamsList.size(); ++i3) {
                            JSONObject outputParam = outputParamsList.getJSONObject(i3);
                            String aiResultKey = outputParam.getString("key");
                            String variableKey = outputParam.getString("value");
                            Object extractedValue = this.extractResultValue(resultData, aiResultKey);
                            if (extractedValue != null) {
                                execution.setVariable(variableKey, extractedValue);
                                log.info("\u8f93\u51fa\u53c2\u6570\u6620\u5c04: {} -> {} = {}", new Object[]{aiResultKey, variableKey, extractedValue});
                                continue;
                            }
                            log.warn("\u672a\u80fd\u4eceAI\u7ed3\u679c\u4e2d\u63d0\u53d6\u5b57\u6bb5\u503c: {}", (Object)aiResultKey);
                        }
                    }
                    break block11;
                }
                throw new RuntimeException("AI\u6d41\u7a0b\u6267\u884c\u5931\u8d25");
            }
            catch (Exception e2) {
                log.error("AigcServiceTaskDelegate \u6267\u884c\u5931\u8d25", (Throwable)e2);
                throw new RuntimeException("AI\u670d\u52a1\u4efb\u52a1\u6267\u884c\u5931\u8d25: " + e2.getMessage(), e2);
            }
        }
        log.info("AigcServiceTaskDelegate \u6267\u884c\u5b8c\u6210\uff01");
    }

    private Object extractResultValue(Object resultData, String fieldKey) {
        if (resultData == null || fieldKey == null) {
            return null;
        }
        try {
            if (resultData instanceof JSONObject) {
                JSONObject jsonResult = (JSONObject)resultData;
                return VariableParseUtil.extractJsonFieldValue(jsonResult, fieldKey);
            }
            if (resultData instanceof String) {
                try {
                    JSONObject jsonResult = JSONObject.parseObject((String)((String)resultData));
                    return VariableParseUtil.extractJsonFieldValue(jsonResult, fieldKey);
                }
                catch (Exception e2) {
                    log.warn("\u7ed3\u679c\u6570\u636e\u4e0d\u662fJSON\u683c\u5f0f\uff0c\u8fd4\u56de\u539f\u59cb\u5b57\u7b26\u4e32");
                    if ("response".equals(fieldKey) || "result".equals(fieldKey)) {
                        return resultData;
                    }
                    return null;
                }
            }
            if ("result".equals(fieldKey) || "data".equals(fieldKey)) {
                return resultData;
            }
            return null;
        }
        catch (Exception e3) {
            log.error("\u63d0\u53d6\u7ed3\u679c\u5b57\u6bb5\u503c\u5931\u8d25: fieldKey={}, error={}", (Object)fieldKey, (Object)e3.getMessage());
            return null;
        }
    }
}

