/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.pay.util;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.RandomUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.util.Md5Util;
import org.jeecg.common.util.TokenUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.vo.WeiXinPay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeiXinPayUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WeiXinPayUtil.class);
    private static final int CONNECT_TIMEOUT = 5000;

    public static boolean isTenPaySign(String characterEncoding, SortedMap<Object, Object> packageParams, String apiKey) {
        if (packageParams == null || packageParams.size() == 0) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        Set<Map.Entry<Object, Object>> es = packageParams.entrySet();
        for (Map.Entry<Object, Object> e : es) {
            String k = (String)e.getKey();
            String v = (String)e.getValue();
            if ("sign".equals(k) || null == v || "".equals(v)) continue;
            sb.append(k).append("=").append(v).append("&");
        }
        sb.append("key=").append(apiKey);
        String mysign = Md5Util.md5Encode((String)sb.toString(), (String)characterEncoding).toLowerCase();
        if (packageParams.get("sign") == null) {
            return false;
        }
        String tenpaySign = ((String)packageParams.get("sign")).toLowerCase();
        return tenpaySign.equals(mysign);
    }

    public static String createSign(String characterEncoding, SortedMap<String, String> packageParams, String apiKey) {
        StringBuilder sb = new StringBuilder();
        Set<Map.Entry<String, String>> es = packageParams.entrySet();
        for (Map.Entry<String, String> e : es) {
            String k = e.getKey();
            String v = e.getValue();
            if (null == v || "".equals(v) || "sign".equals(k) || "key".equals(k)) continue;
            sb.append(k).append("=").append(v).append("&");
        }
        sb.append("key=").append(apiKey);
        return Md5Util.md5Encode((String)sb.toString(), (String)characterEncoding).toUpperCase();
    }

    public static String getRequestXml(Map<String, String> parameters) {
        StringBuilder sb = new StringBuilder();
        sb.append("<xml>");
        Set<Map.Entry<String, String>> es = parameters.entrySet();
        for (Map.Entry<String, String> e : es) {
            String k = e.getKey();
            String v = e.getValue();
            if ("attach".equalsIgnoreCase(k) || "body".equalsIgnoreCase(k) || "sign".equalsIgnoreCase(k)) {
                sb.append("<").append(k).append(">").append("<![CDATA[").append(v).append("]]></").append(k).append(">");
                continue;
            }
            sb.append("<").append(k).append(">").append(v).append("</").append(k).append(">");
        }
        sb.append("</xml>");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postData(String urlStr, String data, String contentType) {
        BufferedReader reader = null;
        try {
            URL url = new URL(urlStr);
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            if (contentType != null) {
                conn.setRequestProperty("content-type", contentType);
            }
            OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream(), StandardCharsets.UTF_8);
            if (data == null) {
                data = "";
            }
            writer.write(data);
            writer.flush();
            writer.close();
            reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append("\r\n");
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            log.info("\u94fe\u63a5\u5230\u5730\u5740" + urlStr + "\u53d1\u751f\u5f02\u5e38: " + e.getMessage());
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static Map<String, String> xmlToMap(String xmlText) {
        if (oConvertUtils.isEmpty((Object)(xmlText = xmlText.replaceFirst("encoding=\".*\"", "encoding=\"UTF-8\"")))) {
            return null;
        }
        HashMap<String, String> m = new HashMap<String, String>();
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(xmlText.getBytes(StandardCharsets.UTF_8));
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build((InputStream)in);
            Element root = doc.getRootElement();
            List list = root.getChildren();
            for (Element e : list) {
                String k = e.getName();
                String v = "";
                List children = e.getChildren();
                v = children.isEmpty() ? e.getTextNormalize() : WeiXinPayUtil.getChildrenText(children);
                m.put(k, v);
            }
            ((InputStream)in).close();
        }
        catch (IOException | JDOMException e) {
            e.printStackTrace();
        }
        return m;
    }

    public static String getChildrenText(List<Element> children) {
        StringBuilder sb = new StringBuilder();
        if (!children.isEmpty()) {
            for (Element e : children) {
                String name = e.getName();
                String value = e.getTextNormalize();
                List list = e.getChildren();
                sb.append("<").append(name).append(">");
                if (!list.isEmpty()) {
                    sb.append(WeiXinPayUtil.getChildrenText(list));
                }
                sb.append(value);
                sb.append("</").append(name).append(">");
            }
        }
        return sb.toString();
    }

    public static String doRefund(String mchId, String url, String data, String certPath) {
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance("PKCS12");
            File file = new File(certPath);
            String filepath = file.getPath();
            FileInputStream is = new FileInputStream(filepath);
            keyStore.load(is, mchId.toCharArray());
            is.close();
            SSLContext sslcontext = SSLContexts.custom().loadKeyMaterial(keyStore, mchId.toCharArray()).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
            CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
            HttpPost httpost = new HttpPost(url);
            httpost.addHeader("Connection", "keep-alive");
            httpost.addHeader("Accept", "*/*");
            httpost.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            httpost.addHeader("Host", "api.mch.weixin.qq.com");
            httpost.addHeader("X-Requested-With", "XMLHttpRequest");
            httpost.addHeader("Cache-Control", "max-age=0");
            httpost.addHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.0) ");
            httpost.setEntity((HttpEntity)new StringEntity(data, "UTF-8"));
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpost);
            HttpEntity entity = response.getEntity();
            String jsonStr = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            EntityUtils.consume((HttpEntity)entity);
            response.close();
            httpclient.close();
            return jsonStr;
        }
        catch (KeyStoreException e) {
            log.info("\u8bc1\u4e66\u89e3\u5bc6\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        catch (FileNotFoundException e) {
            log.info("\u8bc1\u4e66\u8def\u5f84\u672a\u627e\u5230:" + e.getMessage(), (Throwable)e);
        }
        catch (CertificateException e) {
            log.info("SSL:" + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.info("IO\u5f02\u5e38" + e.getMessage(), (Throwable)e);
        }
        catch (KeyManagementException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            log.info(e.getMessage(), (Throwable)e);
        }
        return "";
    }

    public static String getWeiXinCodeUrl(WeiXinPay weiXinPay, String payName, String payNo, String createIp, BigDecimal totalPrice, HttpServletRequest request) {
        String token = TokenUtils.getTokenByRequest((HttpServletRequest)request);
        token = Md5Util.md5Encode((String)token, (String)"UTF-8");
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        paramMap.put("appid", weiXinPay.getAppId());
        paramMap.put("attach", token);
        paramMap.put("body", payName);
        paramMap.put("mch_id", weiXinPay.getMchId());
        paramMap.put("nonce_str", RandomUtil.randomString((int)32));
        paramMap.put("notify_url", weiXinPay.getNotifyUrl());
        paramMap.put("out_trade_no", payNo);
        paramMap.put("spbill_create_ip", createIp);
        if ((double)totalPrice.intValue() - totalPrice.doubleValue() == 0.0) {
            paramMap.put("total_fee", String.valueOf(totalPrice.intValue()));
        } else {
            paramMap.put("total_fee", totalPrice.toString());
        }
        paramMap.put("trade_type", "NATIVE");
        String sign = WeiXinPayUtil.createSign("UTF-8", paramMap, weiXinPay.getApiKey());
        paramMap.put("sign", sign);
        String requestXML = WeiXinPayUtil.getRequestXml(paramMap);
        log.info("requestXML:::" + requestXML);
        String result = WeiXinPayUtil.postData("https://api.mch.weixin.qq.com/pay/unifiedorder", requestXML, null);
        log.info("result:::{}", (Object)result);
        Map<String, String> map = WeiXinPayUtil.xmlToMap(result);
        if (CollectionUtil.isEmpty(map)) {
            throw new JeecgBootException("\u4e0b\u5355\u5931\u8d25");
        }
        log.info("result map:::{}", (Object)(map != null ? map.toString() : null));
        return map.get("code_url");
    }
}

