/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.pay.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.TokenUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.pay.entity.SysVipInvoiceApply;
import org.jeecg.modules.pay.entity.SysVipPayments;
import org.jeecg.modules.pay.service.ISysVipInvoiceApplyService;
import org.jeecg.modules.pay.service.ISysVipInvoicePaymentsService;
import org.jeecg.modules.pay.vo.SysVipInvoiceApplyVo;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@Tag(name="sys_vip_invoice_apply")
@RestController
@RequestMapping(value={"/pay/sysVipInvoiceApply"})
public class SysVipInvoiceApplyController
extends JeecgController<SysVipInvoiceApply, ISysVipInvoiceApplyService> {
    private static final Logger log = LoggerFactory.getLogger(SysVipInvoiceApplyController.class);
    @Autowired
    private ISysVipInvoiceApplyService sysVipInvoiceApplyService;
    @Autowired
    private ISysVipInvoicePaymentsService sysVipInvoicePaymentsService;

    @RequiresPermissions(value={"sys:vip:invoice:apply:list"})
    @Operation(summary="sys_vip_invoice_apply-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<IPage<SysVipInvoiceApply>> queryPageList(SysVipInvoiceApply sysVipInvoiceApply, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)sysVipInvoiceApply, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        String invoiceStatus = req.getParameter("invoiceStatus");
        if (oConvertUtils.isNotEmpty((Object)invoiceStatus)) {
            queryWrapper.in((Object)"status", Arrays.asList(invoiceStatus.split(",")));
        }
        IPage pageList = this.sysVipInvoiceApplyService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.OK((Object)pageList);
    }

    @Operation(summary="\u6839\u636e\u7528\u6237\u540d\u83b7\u53d6\u5f00\u53d1\u7968\u7533\u8bf7\u8bb0\u5f55-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/getInvoiceListByUsername"})
    public Result<IPage<SysVipInvoiceApply>> getInvoiceListByUsername(SysVipInvoiceApply sysVipInvoiceApply, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)sysVipInvoiceApply, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        String invoiceStatus = req.getParameter("invoiceStatus");
        if (oConvertUtils.isNotEmpty((Object)invoiceStatus)) {
            queryWrapper.in((Object)"status", Arrays.asList(invoiceStatus.split(",")));
        }
        queryWrapper.eq((Object)"create_by", (Object)sysUser.getUsername());
        IPage pageList = this.sysVipInvoiceApplyService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.OK((Object)pageList);
    }

    @GetMapping(value={"/getInvoicePrice"})
    public Result<String> getInvoicePrice(@RequestParam(name="paymentIds") String paymentIds) {
        BigDecimal invoicePrice = this.sysVipInvoiceApplyService.getInvoicePrice(paymentIds);
        return Result.ok((String)invoicePrice.toPlainString());
    }

    @AutoLog(value="\u6dfb\u52a0\u53d1\u7968\u7533\u8bf7\u8bb0\u5f55")
    @Operation(summary="\u6dfb\u52a0\u53d1\u7968\u7533\u8bf7\u8bb0\u5f55")
    @PostMapping(value={"/add"})
    public Result<String> add(@RequestBody SysVipInvoiceApplyVo sysVipInvoiceApplyVo) {
        String applyId = this.sysVipInvoiceApplyService.saveInvoiceApply(sysVipInvoiceApplyVo);
        this.sysVipInvoicePaymentsService.saveInvoicePayments(applyId, sysVipInvoiceApplyVo.getPaymentIds());
        return Result.OK((String)"\u53d1\u7968\u7533\u8bf7\u6210\u529f\uff01");
    }

    @AutoLog(value="sys_vip_invoice_apply-\u7f16\u8f91")
    @Operation(summary="sys_vip_invoice_apply-\u7f16\u8f91")
    @RequestMapping(value={"/edit"}, method={RequestMethod.PUT, RequestMethod.POST})
    public Result<String> edit(@RequestBody SysVipInvoiceApply sysVipInvoiceApply) {
        sysVipInvoiceApply.setPrice(null);
        this.sysVipInvoiceApplyService.updateById(sysVipInvoiceApply);
        return Result.OK((String)"\u7f16\u8f91\u6210\u529f!");
    }

    @GetMapping(value={"/queryInvoicePaymentList"})
    public Result<IPage<SysVipPayments>> queryInvoicePaymentList(@RequestParam(name="id") String id, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<SysVipPayments> pageList = this.sysVipInvoiceApplyService.queryPaymentListByInvoiceId(id, (Page<SysVipPayments>)page);
        return Result.OK(pageList);
    }

    @GetMapping(value={"/queryPaymentList"})
    public Result<IPage<SysVipPayments>> queryPaymentList(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        String tenantId = TokenUtils.getTenantIdByRequest((HttpServletRequest)req);
        IPage<SysVipPayments> pageList = this.sysVipInvoiceApplyService.queryPaymentList((Page<SysVipPayments>)page, oConvertUtils.getInt((String)tenantId));
        return Result.OK(pageList);
    }

    @DeleteMapping(value={"/deleteInvoiceApply"})
    public Result<String> deleteInvoiceApply(@RequestParam(name="id") String id) {
        this.sysVipInvoiceApplyService.deleteInvoiceApply(id);
        return Result.OK((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"sys:vip:invoice:apply:exportXls"})
    @RequestMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, SysVipInvoiceApply sysVipInvoiceApply) {
        String invoiceStatus;
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)sysVipInvoiceApply, (Map)request.getParameterMap());
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String selections = request.getParameter("selections");
        if (oConvertUtils.isNotEmpty((Object)selections)) {
            List<String> selectionList = Arrays.asList(selections.split(","));
            queryWrapper.in((Object)"id", selectionList);
        }
        if (oConvertUtils.isNotEmpty((Object)(invoiceStatus = request.getParameter("invoiceStatus")))) {
            queryWrapper.eq((Object)"status", (Object)invoiceStatus);
        }
        List pageList = this.sysVipInvoiceApplyService.list((Wrapper)queryWrapper);
        ModelAndView mv = new ModelAndView((View)new JeecgEntityExcelView());
        mv.addObject("fileName", (Object)"\u53d1\u7968\u7533\u8bf7");
        mv.addObject("entity", SysVipInvoiceApply.class);
        mv.addObject("params", (Object)new ExportParams("\u53d1\u7968\u7533\u8bf7", "\u5bfc\u51fa\u4eba:" + sysUser.getRealname(), "\u53d1\u7968\u7533\u8bf7\u660e\u7ec6"));
        mv.addObject("data", (Object)pageList);
        return mv;
    }
}

