/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.pay.job;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.exceptions.ClientException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.jeecg.common.constant.enums.DySmsEnum;
import org.jeecg.common.util.DateUtils;
import org.jeecg.common.util.DySmsHelper;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.pay.service.ISysVipMembershipService;
import org.jeecg.modules.pay.vo.SysUserVipVo;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PayExpireJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(PayExpireJob.class);
    @Autowired
    private ISysVipMembershipService sysVipMembershipService;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, 3);
        Date time = calendar.getTime();
        String nowStr = DateUtils.formatDate((Date)time);
        List<SysUserVipVo> expireMembers = this.sysVipMembershipService.getExpireMembers(nowStr);
        if (CollectionUtil.isNotEmpty(expireMembers)) {
            JSONObject param = new JSONObject();
            for (SysUserVipVo user : expireMembers) {
                param.put("realname", (Object)oConvertUtils.getString((String)user.getRealname(), (String)user.getPhone()));
                param.put("endTime", (Object)DateUtils.formatDate((Date)user.getEndTime(), (String)"yyyy\u5e74MM\u6708dd\u65e5"));
                try {
                    DySmsHelper.sendSms((String)user.getPhone(), (JSONObject)param, (DySmsEnum)DySmsEnum.VIP_EXPIRE_NOTICE_CODE);
                }
                catch (ClientException e) {
                    log.error("\u77ed\u4fe1\u63a5\u53e3\u672a\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
                }
            }
        }
    }
}

