/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.pay.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jeecg.common.config.TenantContext;
import org.jeecg.common.constant.enums.vip.PayVipResourceEnum;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.vo.SysPayVipVo;
import org.jeecg.common.util.CommonUtils;
import org.jeecg.common.util.DateUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.JeecgBaseConfig;
import org.jeecg.config.vo.WeiXinPay;
import org.jeecg.modules.pay.entity.SysVipMembership;
import org.jeecg.modules.pay.mapper.SysVipMembershipMapper;
import org.jeecg.modules.pay.service.ISysVipMembershipService;
import org.jeecg.modules.pay.vo.SysUserVipVo;
import org.jeecg.modules.pay.vo.SysVipMembershipVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class SysVipMembershipServiceImpl
extends ServiceImpl<SysVipMembershipMapper, SysVipMembership>
implements ISysVipMembershipService {
    private static final Logger log = LoggerFactory.getLogger(SysVipMembershipServiceImpl.class);
    @Autowired
    private SysVipMembershipMapper sysVipMembershipMapper;
    @Autowired
    private JeecgBaseConfig jeecgBaseConfig;
    @Autowired
    @Lazy
    private ISysBaseAPI sysBaseAPI;
    @Autowired
    private RedisTemplate redisTemplate;

    @Override
    public SysVipMembershipVo getUseCount(SysVipMembershipVo sysVipMembershipVo, String username, String userId) {
        Integer tenantId = oConvertUtils.getInt((String)TenantContext.getTenant());
        Long lowAppCount = this.sysVipMembershipMapper.getLowAppCount(tenantId);
        sysVipMembershipVo.setAppCountUsed(lowAppCount);
        Long tableCount = this.sysVipMembershipMapper.getTableCount(tenantId);
        sysVipMembershipVo.setAppTableCountUsed(tableCount);
        Long processCount = this.sysVipMembershipMapper.getProcessCount(tenantId);
        sysVipMembershipVo.setAppFlowCountUsed(processCount);
        Long bigScreenCount = Long.valueOf("0");
        try {
            bigScreenCount = this.sysVipMembershipMapper.getBigScreenCount(tenantId);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        sysVipMembershipVo.setBigscreenCountUsed(bigScreenCount);
        Long userTenantCount = this.sysVipMembershipMapper.getUserTenantCount(tenantId);
        sysVipMembershipVo.setTenantUserCount(userTenantCount);
        Long tenantCount = this.sysVipMembershipMapper.getTenantCount(username);
        sysVipMembershipVo.setTenantCountUsed(tenantCount);
        Long uploadCount = this.getUploadCountByYear(tenantId);
        double count = 0.0;
        if (uploadCount != null && uploadCount > 0L) {
            count = oConvertUtils.calculateFileSizeToMb((Long)uploadCount);
        }
        sysVipMembershipVo.setUploadSizeYearUsed(count);
        Long jmReportCount = this.getJmReportCount(tenantId);
        sysVipMembershipVo.setJmReportCountUsed(jmReportCount);
        Long jmReportSourceCount = this.getJmReportSourceCount(tenantId);
        sysVipMembershipVo.setJmReportSourceCountUsed(jmReportSourceCount);
        Long bigScreenSourceCount = this.getBigScreenSourceCount(tenantId);
        sysVipMembershipVo.setBigScreenSourceCountUsed(bigScreenSourceCount);
        Long dragPageCount = this.getDragPageCount(tenantId);
        sysVipMembershipVo.setMaxDragPageCountUsed(dragPageCount);
        return sysVipMembershipVo;
    }

    @Override
    public Long getLowAppCount(Integer tenantId) {
        return this.sysVipMembershipMapper.getLowAppCount(tenantId);
    }

    @Override
    public Long getTableCount(Integer tenantId) {
        return this.sysVipMembershipMapper.getTableCount(tenantId);
    }

    @Override
    public Long getTenantCount(String username) {
        return this.sysVipMembershipMapper.getTenantCount(username);
    }

    @Override
    public SysVipMembership getUserVipMember(String userId, Integer tenantId) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysVipMembership::getTenantId, (Object)tenantId);
        List sysVipMemberships = this.sysVipMembershipMapper.selectList((Wrapper)query);
        if (CollectionUtil.isEmpty((Collection)sysVipMemberships)) {
            return null;
        }
        return (SysVipMembership)sysVipMemberships.get(0);
    }

    @Override
    public SysVipMembership getOrInitVipMembership(String userId, Integer tenantId) {
        SysVipMembership entity = this.getUserVipMember(userId, oConvertUtils.getInt((Object)tenantId));
        if (entity != null) {
            return entity;
        }
        entity = new SysVipMembership();
        entity.setTenantId(oConvertUtils.getInt((Object)tenantId));
        entity.setUserId(userId);
        entity.setMemberType(PayVipResourceEnum.DEFAULT.getCode());
        entity.setSmsCountTotalUsed(PayVipResourceEnum.DEFAULT.getMaxSmsCount());
        this.save(entity);
        return entity;
    }

    @Override
    public Long getProcessCount(Integer tenantId) {
        return this.sysVipMembershipMapper.getProcessCount(tenantId);
    }

    @Override
    public Long getBigScreenCount(Integer tenantId) {
        return this.sysVipMembershipMapper.getBigScreenCount(tenantId);
    }

    @Override
    public Long getDragPageCount(Integer tenantId) {
        return this.sysVipMembershipMapper.getDragPageCount(tenantId);
    }

    @Override
    public Long getUploadCount(String username) {
        String tenantId = oConvertUtils.getString((String)TenantContext.getTenant());
        return this.sysVipMembershipMapper.getUploadCount(username, tenantId);
    }

    @Override
    public Integer uploadSizeBuy(Integer tenantId) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysVipMembership::getTenantId, (Object)tenantId);
        List sysVipMembership = this.sysVipMembershipMapper.selectList((Wrapper)query);
        if (CollectionUtil.isEmpty((Collection)sysVipMembership)) {
            return 0;
        }
        return ((SysVipMembership)sysVipMembership.get(0)).getUploadSizeBuy();
    }

    @Override
    public SysPayVipVo verifyVipIdentity() {
        Integer tenantId = oConvertUtils.getInt((String)TenantContext.getTenant(), (int)-1);
        String keyString = String.format("sys:cache:vip:user::%s", tenantId);
        if (this.redisTemplate.hasKey((Object)keyString).booleanValue()) {
            log.info("[VIP Redis] \u901a\u8fc7Redis\u7f13\u5b58\u67e5\u8be2\u7528\u6237\u4f1a\u5458\u4fe1\u606f\uff0ctenantId={}", (Object)tenantId);
            return (SysPayVipVo)this.redisTemplate.opsForValue().get((Object)keyString);
        }
        SysPayVipVo sysPayVipVo = new SysPayVipVo();
        WeiXinPay weiXinPay = this.jeecgBaseConfig.getWeiXinPay();
        if (weiXinPay == null || !weiXinPay.getOpenVipLimit().booleanValue()) {
            sysPayVipVo.setIzVip(Boolean.valueOf(true));
            sysPayVipVo.setMemberType(PayVipResourceEnum.DEFAULT.getCode());
            return sysPayVipVo;
        }
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.select(new SFunction[]{SysVipMembership::getEndTime, SysVipMembership::getMemberType});
        query.eq(SysVipMembership::getTenantId, (Object)tenantId);
        query.ne(SysVipMembership::getMemberType, (Object)PayVipResourceEnum.DEFAULT.getCode());
        query.ge(SysVipMembership::getEndTime, (Object)DateUtils.getLocalDate());
        List vipMemberships = this.sysVipMembershipMapper.selectList((Wrapper)query);
        if (CollectionUtil.isEmpty((Collection)vipMemberships) || PayVipResourceEnum.DEFAULT.getCode().equals(((SysVipMembership)vipMemberships.get(0)).getMemberType())) {
            sysPayVipVo.setIzVip(Boolean.valueOf(false));
            sysPayVipVo.setMemberType(PayVipResourceEnum.DEFAULT.getCode());
            return sysPayVipVo;
        }
        SysVipMembership sysVipMembership = (SysVipMembership)vipMemberships.get(0);
        sysPayVipVo.setMemberType(sysVipMembership.getMemberType());
        sysPayVipVo.setIzVip(Boolean.valueOf(true));
        if (tenantId != -1 && tenantId != 0) {
            long days = DateUtils.calculateDaysDifference((Date)sysVipMembership.getEndTime());
            log.info("[VIP Redis] \u901a\u8fc7Redis\u7f13\u5b58\u7528\u6237\u4f1a\u5458\u4fe1\u606f\uff0ctenantId={}\uff0cdays={}\u5929", (Object)tenantId, (Object)days);
            this.redisTemplate.opsForValue().set((Object)keyString, (Object)sysPayVipVo, days, TimeUnit.DAYS);
        }
        return sysPayVipVo;
    }

    @Override
    public List<SysUserVipVo> getExpireMembers(String nowStr) {
        return this.sysVipMembershipMapper.getExpireMembers(nowStr);
    }

    @Override
    public boolean checkSmsSendLimit(String userId, Integer tenantId) {
        WeiXinPay weiXinPay = this.jeecgBaseConfig.getWeiXinPay();
        if (!weiXinPay.getOpenVipLimit().booleanValue()) {
            return false;
        }
        SysVipMembership entity = this.getOrInitVipMembership(userId, tenantId);
        PayVipResourceEnum vipEnum = PayVipResourceEnum.valueOfType((String)entity.getMemberType());
        if (vipEnum == null) {
            log.info("\u4f1a\u5458\u4fe1\u606f\u672a\u627e\u5230\uff0c\u6570\u636e\u5e93code\u548c\u679a\u4e3ecode\u4e0d\u4e00\u81f4");
            return false;
        }
        Integer smsYearCount = entity.getSmsCountYearUsed();
        if (smsYearCount == null) {
            smsYearCount = 0;
        }
        return smsYearCount >= vipEnum.getMaxSmsCount();
    }

    @Override
    public boolean plusSmsCountYearUsed(String userId, Integer tenantId) {
        SysVipMembership entity = this.getOrInitVipMembership(userId, tenantId);
        Integer smsYearCount = entity.getSmsCountYearUsed();
        if (smsYearCount == null) {
            smsYearCount = 0;
        }
        SysVipMembership updateEntity = new SysVipMembership();
        updateEntity.setId(entity.getId());
        updateEntity.setSmsCountYearUsed(smsYearCount + 1);
        return this.updateById(updateEntity);
    }

    @Override
    public SysVipMembership getEndTimeByUserId(Integer tenantId, Date payTime, String buyType, Integer buyYears) {
        List<SysVipMembership> sysVipMemberships = this.sysVipMembershipMapper.getEndTimeByUserId(tenantId);
        if (CollectionUtil.isEmpty(sysVipMemberships)) {
            throw new JeecgBootException("\u9000\u6b3e\u5931\u8d25\uff0c\u672a\u627e\u5230\u5f53\u524d\u4f1a\u5458\u4fe1\u606f\uff01");
        }
        SysVipMembership endTimeByUserId = sysVipMemberships.get(0);
        if (PayVipResourceEnum.DEFAULT.getCode().equals(endTimeByUserId.getMemberType())) {
            throw new JeecgBootException("\u9000\u6b3e\u5931\u8d25\uff0c\u60a8\u5df2\u4e0d\u662f\u4f1a\u5458\uff01");
        }
        if ("sms".equals(buyType) || "file".equals(buyType) || "userCount".equals(buyType)) {
            this.verifyUsedSituation(endTimeByUserId, buyType, buyYears);
            return endTimeByUserId;
        }
        if (null == endTimeByUserId.getEndTime()) {
            throw new JeecgBootException("\u9000\u6b3e\u5931\u8d25\uff0c\u6709\u6548\u671f\u5df2\u8fc7\uff01");
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date nowTime = format.parse(format.format(new Date()));
            Date endTime = endTimeByUserId.getEndTime();
            if (nowTime.getTime() > endTime.getTime()) {
                throw new JeecgBootException("\u9000\u6b3e\u5931\u8d25\uff0c\u6709\u6548\u671f\u5df2\u8fc7\uff01");
            }
            long fiveAfterTime = nowTime.getTime() - 432000000L;
            long paysTime = payTime.getTime();
            if (paysTime < fiveAfterTime) {
                throw new JeecgBootException("\u9000\u6b3e\u5931\u8d25\uff0c\u5df2\u8d85\u8fc75\u5929\uff01");
            }
        }
        catch (ParseException e) {
            throw new JeecgBootException("\u9000\u6b3e\u5931\u8d25\uff01");
        }
        return endTimeByUserId;
    }

    @Override
    public Long getUploadCountByYear(Integer tenantId) {
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        DbType dbType = CommonUtils.getDatabaseTypeEnum();
        assert (dbType != null);
        return this.sysVipMembershipMapper.getUploadCountByYear(year, String.valueOf(tenantId), dbType.getDb());
    }

    @Override
    public Long getJmReportCount(Integer tenantId) {
        return this.sysVipMembershipMapper.getJmReportCount(tenantId);
    }

    @Override
    public Long getJmReportSourceCount(Integer tenantId) {
        return this.sysVipMembershipMapper.getJmReportSourceCount(tenantId);
    }

    @Override
    public Long getBigScreenSourceCount(Integer tenantId) {
        return this.sysVipMembershipMapper.getBigScreenSourceCount(tenantId);
    }

    @Override
    public Long izExistTenantCountVip(String username, Integer tenantId) {
        return this.sysVipMembershipMapper.izExistTenantCountVip(username, tenantId);
    }

    private void verifyUsedSituation(SysVipMembership vipMembership, String buyType, Integer buyYears) {
        PayVipResourceEnum normalVip = PayVipResourceEnum.valueOfType((String)vipMembership.getMemberType());
        if ("sms".equals(buyType)) {
            Integer smsYearUsedCount = oConvertUtils.getInt((Object)vipMembership.getSmsCountYearUsed(), (int)0);
            int maxSmsCount = normalVip.getMaxSmsCount();
            Integer smsCountBuy = oConvertUtils.getInt((Object)vipMembership.getSmsCountBuy(), (int)0);
            if (smsCountBuy <= 0) {
                throw new JeecgBootException("\u5df2\u6ca1\u6709\u77ed\u4fe1\u6269\u5c55\u5305\uff0c\u65e0\u6cd5\u9000\u6b3e\uff01");
            }
            maxSmsCount = maxSmsCount + smsCountBuy - buyYears;
            if (smsYearUsedCount > maxSmsCount) {
                throw new JeecgBootException("\u77ed\u4fe1\u6269\u5c55\u5305\u5df2\u4f7f\u7528\uff0c\u65e0\u6cd5\u9000\u6b3e\uff01");
            }
        } else if ("file".equals(buyType)) {
            Long uploadCountByYear = this.getUploadCountByYear(vipMembership.getTenantId());
            double uploadYearUsedCount = oConvertUtils.calculateFileSizeToMb((Long)(uploadCountByYear == null ? 0L : uploadCountByYear));
            Integer maxUploadSize = normalVip.getMaxUploadSize();
            int uploadCountBuy = oConvertUtils.getInt((Object)vipMembership.getUploadSizeBuy(), (int)0);
            if (uploadCountBuy <= 0) {
                throw new JeecgBootException("\u5df2\u6ca1\u6709\u4e91\u5b58\u50a8\u6269\u5c55\u5305\uff0c\u65e0\u6cd5\u9000\u6b3e\uff01");
            }
            double endUploadCount = maxUploadSize + uploadCountBuy - buyYears;
            if (uploadYearUsedCount > endUploadCount) {
                throw new JeecgBootException("\u4e91\u5b58\u50a8\u6269\u5c55\u5305\u5df2\u4f7f\u7528\uff0c\u65e0\u6cd5\u9000\u6b3e\uff01");
            }
        } else if ("userCount".equals(buyType)) {
            int userCountBuy = oConvertUtils.getInt((Object)vipMembership.getUserCountBuy(), (int)0);
            int maxUserCount = normalVip.getMaxTenantUserCount();
            Long tenantUserCount = this.getTenantUserCount(vipMembership.getTenantId());
            if (userCountBuy <= 0) {
                throw new JeecgBootException("\u5df2\u6ca1\u6709\u4eba\u5458\u6269\u5c55\u5305\uff0c\u65e0\u6cd5\u9000\u6b3e\uff01");
            }
            int refundUserCount = userCountBuy + maxUserCount - buyYears;
            if (tenantUserCount > (long)refundUserCount) {
                throw new JeecgBootException("\u4eba\u5458\u6269\u5c55\u5305\u5df2\u4f7f\u7528\uff0c\u65e0\u6cd5\u9000\u6b3e\uff01");
            }
        }
    }

    @Override
    public Long getTenantUserCount(Integer tenantId) {
        return this.sysVipMembershipMapper.getUserTenantCount(tenantId);
    }
}

