/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.xml;

import de.schlichtherle.xml.GenericCertificateIntegrityException;
import de.schlichtherle.xml.GenericCertificateIsLockedException;
import de.schlichtherle.xml.GenericCertificateNotLockedException;
import de.schlichtherle.xml.PersistenceService;
import de.schlichtherle.xml.PersistenceServiceException;
import de.schlichtherle.xml.XMLConstants;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import org.apache.commons.codec.binary.Base64;

public final class GenericCertificate
implements Serializable,
XMLConstants {
    private static final long serialVersionUID = 6247620498526484734L;
    private static final String BASE64_CHARSET = "US-ASCII";
    private static final String SIGNATURE_ENCODING = "US-ASCII/Base64";
    private volatile transient boolean locked;
    private String encoded;
    private String signature;
    private String signatureAlgorithm;
    private String signatureEncoding;
    private transient PropertyChangeSupport propertyChangeSupport;
    private transient VetoableChangeSupport vetoableChangeSupport;

    public GenericCertificate() {
    }

    public GenericCertificate(GenericCertificate genericCertificate) {
        try {
            this.setEncoded(genericCertificate.getEncoded());
            this.setSignature(genericCertificate.getSignature());
            this.setSignatureAlgorithm(genericCertificate.getSignatureAlgorithm());
            this.setSignatureEncoding(genericCertificate.getSignatureEncoding());
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new AssertionError((Object)propertyVetoException);
        }
    }

    public synchronized void sign(Object object, PrivateKey privateKey, Signature signature) throws NullPointerException, GenericCertificateIsLockedException, PropertyVetoException, PersistenceServiceException, InvalidKeyException {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "locked", this.locked, Boolean.TRUE);
        if (this.locked) {
            throw new GenericCertificateIsLockedException(propertyChangeEvent);
        }
        if (null == privateKey || null == signature) {
            throw new NullPointerException();
        }
        this.fireVetoableChange(propertyChangeEvent);
        try {
            byte[] byArray = PersistenceService.store2ByteArray(object);
            String string = new String(byArray, "UTF-8");
            signature.initSign(privateKey);
            signature.update(byArray);
            byte[] byArray2 = Base64.encodeBase64((byte[])signature.sign());
            String string2 = new String(byArray2, BASE64_CHARSET);
            String string3 = signature.getAlgorithm();
            this.setEncoded(string);
            this.setSignature(string2);
            this.setSignatureAlgorithm(string3);
            this.setSignatureEncoding(SIGNATURE_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
        catch (SignatureException signatureException) {
            throw new AssertionError((Object)signatureException);
        }
        this.locked = true;
        this.firePropertyChange(propertyChangeEvent);
    }

    public synchronized void verify(PublicKey publicKey, Signature signature) throws NullPointerException, GenericCertificateIsLockedException, PropertyVetoException, InvalidKeyException, SignatureException, GenericCertificateIntegrityException {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "locked", this.locked, Boolean.TRUE);
        if (this.locked) {
            throw new GenericCertificateIsLockedException(propertyChangeEvent);
        }
        if (null == publicKey || null == signature) {
            throw new NullPointerException();
        }
        this.fireVetoableChange(propertyChangeEvent);
        try {
            byte[] byArray = this.encoded.getBytes("UTF-8");
            signature.initVerify(publicKey);
            signature.update(byArray);
            byte[] byArray2 = Base64.decodeBase64((byte[])this.signature.getBytes(BASE64_CHARSET));
            if (!signature.verify(byArray2)) {
                throw new GenericCertificateIntegrityException();
            }
            String string = signature.getAlgorithm();
            this.setSignatureAlgorithm(string);
            this.setSignatureEncoding(SIGNATURE_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
        this.locked = true;
        this.firePropertyChange(propertyChangeEvent);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public synchronized Object getContent() throws GenericCertificateNotLockedException, PersistenceServiceException {
        if (!this.locked) {
            throw new GenericCertificateNotLockedException();
        }
        return PersistenceService.load(this.encoded);
    }

    public synchronized String getEncoded() {
        return this.encoded;
    }

    public synchronized void setEncoded(String string) throws GenericCertificateIsLockedException {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "encoded", this.encoded, string);
        if (this.locked) {
            throw new GenericCertificateIsLockedException(propertyChangeEvent);
        }
        if (GenericCertificate.equals(this.encoded, string)) {
            return;
        }
        this.encoded = string;
        this.firePropertyChange(propertyChangeEvent);
    }

    public synchronized String getSignature() {
        return this.signature;
    }

    public synchronized void setSignature(String string) throws GenericCertificateIsLockedException {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "signature", this.signature, string);
        if (this.locked) {
            throw new GenericCertificateIsLockedException(propertyChangeEvent);
        }
        if (GenericCertificate.equals(this.signature, string)) {
            return;
        }
        this.signature = string;
        this.firePropertyChange(propertyChangeEvent);
    }

    public synchronized String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public synchronized void setSignatureAlgorithm(String string) throws GenericCertificateIsLockedException {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "signatureAlgorithm", this.signatureAlgorithm, string);
        if (this.locked) {
            throw new GenericCertificateIsLockedException(propertyChangeEvent);
        }
        if (GenericCertificate.equals(this.signatureAlgorithm, string)) {
            return;
        }
        this.signatureAlgorithm = string;
        this.firePropertyChange(propertyChangeEvent);
    }

    public synchronized String getSignatureEncoding() {
        return this.signatureEncoding;
    }

    public synchronized void setSignatureEncoding(String string) throws GenericCertificateIsLockedException {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "signatureEncoding", this.signatureEncoding, string);
        if (this.locked) {
            throw new GenericCertificateIsLockedException(propertyChangeEvent);
        }
        if (GenericCertificate.equals(this.signatureEncoding, string)) {
            return;
        }
        this.signatureEncoding = string;
        this.firePropertyChange(propertyChangeEvent);
    }

    private static boolean equals(Object object, Object object2) {
        return object == object2 || null != object && object.equals(object2);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (null == this.vetoableChangeSupport) {
            this.vetoableChangeSupport = new VetoableChangeSupport(this);
        }
        this.vetoableChangeSupport.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (null == this.vetoableChangeSupport) {
            return;
        }
        this.vetoableChangeSupport.removeVetoableChangeListener(vetoableChangeListener);
    }

    private void fireVetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if (null == this.vetoableChangeSupport) {
            return;
        }
        this.vetoableChangeSupport.fireVetoableChange(propertyChangeEvent);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (null == this.propertyChangeSupport) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (null == this.propertyChangeSupport) {
            return;
        }
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    private void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (null == this.propertyChangeSupport) {
            return;
        }
        this.propertyChangeSupport.firePropertyChange(propertyChangeEvent);
    }
}

