/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.services;

import de.codecentric.boot.admin.services.ApplicationRegistrator;
import java.util.concurrent.ScheduledFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.TaskScheduler;

public class RegistrationApplicationListener {
    private static Logger LOGGER = LoggerFactory.getLogger(RegistrationApplicationListener.class);
    private final ApplicationRegistrator registrator;
    private final TaskScheduler taskScheduler;
    private boolean autoDeregister = false;
    private boolean autoRegister = true;
    private long registerPeriod = 10000L;
    private volatile ScheduledFuture<?> scheduledTask;

    public RegistrationApplicationListener(ApplicationRegistrator registrator, TaskScheduler taskScheduler) {
        this.registrator = registrator;
        this.taskScheduler = taskScheduler;
    }

    @EventListener
    @Order(value=0x7FFFFFFF)
    public void onApplicationReady(ApplicationReadyEvent event) {
        if (event.getApplicationContext().getParent() == null && this.autoRegister) {
            this.startRegisterTask();
        }
    }

    @EventListener
    @Order(value=0x7FFFFFFF)
    public void onClosedContext(ContextClosedEvent event) {
        if (event.getApplicationContext().getParent() == null) {
            this.stopRegisterTask();
            if (this.autoDeregister) {
                this.registrator.deregister();
            }
        }
    }

    public void startRegisterTask() {
        if (this.scheduledTask != null && !this.scheduledTask.isDone()) {
            return;
        }
        this.scheduledTask = this.taskScheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                RegistrationApplicationListener.this.registrator.register();
            }
        }, this.registerPeriod);
        LOGGER.debug("Scheduled registration task for every {}ms", (Object)this.registerPeriod);
    }

    public void stopRegisterTask() {
        if (this.scheduledTask != null && !this.scheduledTask.isDone()) {
            this.scheduledTask.cancel(true);
            LOGGER.debug("Canceled registration task");
        }
    }

    public void setAutoDeregister(boolean autoDeregister) {
        this.autoDeregister = autoDeregister;
    }

    public void setAutoRegister(boolean autoRegister) {
        this.autoRegister = autoRegister;
    }

    public void setRegisterPeriod(long registerPeriod) {
        this.registerPeriod = registerPeriod;
    }
}

