/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;

public class StatusInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String status;
    private final long timestamp;

    protected StatusInfo(String status, long timestamp) {
        this.status = status.toUpperCase();
        this.timestamp = timestamp;
    }

    public static StatusInfo valueOf(String statusCode) {
        return new StatusInfo(statusCode, System.currentTimeMillis());
    }

    @JsonCreator
    public static StatusInfo valueOf(@JsonProperty(value="status") String statusCode, @JsonProperty(value="timestamp") long timestamp) {
        return new StatusInfo(statusCode, timestamp);
    }

    public static StatusInfo ofUnknown() {
        return StatusInfo.valueOf("UNKNOWN");
    }

    public static StatusInfo ofUp() {
        return StatusInfo.valueOf("UP");
    }

    public static StatusInfo ofDown() {
        return StatusInfo.valueOf("DOWN");
    }

    public static StatusInfo ofOffline() {
        return StatusInfo.valueOf("OFFLINE");
    }

    public String getStatus() {
        return this.status;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StatusInfo other = (StatusInfo)obj;
        return !(this.status == null ? other.status != null : !this.status.equals(other.status));
    }
}

