/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.openapi.util.json.adapter;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.kingdee.bos.json.adapter.EnumTypeAdapter;
import com.kingdee.bos.openapi.util.ClassUtil;
import com.kingdee.util.enums.DoubleEnum;
import com.kingdee.util.enums.DynamicEnum;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.FloatEnum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class EnumTypeWithDeserializerAdapter
extends EnumTypeAdapter
implements JsonDeserializer<Enum> {
    public Enum deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
        try {
            return this._deserialize(element, type, context);
        }
        catch (Exception e) {
            throw new JsonParseException((Throwable)e);
        }
    }

    private Enum _deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws Exception {
        Class clazz = ClassUtil.getClassByName(type.toString().substring(type.toString().indexOf(" ") + 1));
        Method method = null;
        Object value = null;
        if (this.asSubClass(clazz, IntEnum.class)) {
            method = clazz.getMethod("getEnum", Integer.TYPE);
            String num = null;
            if (element.isJsonObject()) {
                num = element.getAsJsonObject().get("value").toString();
                if (num.indexOf(".") >= 0) {
                    num = num.substring(0, num.indexOf("."));
                }
            } else {
                num = element.getAsString();
                if (num.indexOf(".") >= 0) {
                    num = num.substring(0, num.indexOf("."));
                }
            }
            value = Integer.parseInt(num);
        } else if (this.asSubClass(clazz, StringEnum.class)) {
            method = clazz.getMethod("getEnum", String.class);
            String str = null;
            if (element.isJsonObject()) {
                str = element.getAsJsonObject().get("value").getAsString();
                if (str.indexOf(".") >= 0) {
                    str = str.substring(0, str.indexOf("."));
                }
            } else {
                str = element.getAsString();
                if (str.indexOf(".") >= 0) {
                    str = str.substring(0, str.indexOf("."));
                }
            }
            value = str;
        } else {
            if (this.asSubClass(clazz, DynamicEnum.class)) {
                throw new IllegalStateException("not support");
            }
            if (this.asSubClass(clazz, FloatEnum.class)) {
                method = clazz.getMethod("getEnum", Float.TYPE);
                value = element.isJsonObject() ? Float.valueOf(element.getAsJsonObject().get("value").getAsFloat()) : Float.valueOf(element.getAsFloat());
            } else if (this.asSubClass(clazz, DoubleEnum.class)) {
                method = clazz.getMethod("getEnum", Double.TYPE);
                value = element.isJsonObject() ? Double.valueOf(element.getAsJsonObject().get("value").getAsDouble()) : Double.valueOf(element.getAsDouble());
            }
        }
        if (method == null || value == null) {
            throw new IllegalStateException("method or value is null");
        }
        return (Enum)method.invoke((Object)clazz, value);
    }

    private boolean asSubClass(Class<?> source, Class<?> desc) {
        return desc.isAssignableFrom(source);
    }
}

