/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.openapi.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.log4j.Logger;

public class ClassUtil {
    private static final Logger logger = Logger.getLogger(ClassUtil.class);
    private static Map<String, Method> methodCache = new ConcurrentHashMap<String, Method>();
    private static Set<String> methodNullCache = new HashSet<String>();
    private static Map<String, Class<?>> clazzCache = new ConcurrentHashMap();
    public static final String JAR_URL_SEPARATOR = "!/";

    public static String getClassName(Object object) {
        if (null == object) {
            return null;
        }
        return object.getClass().getName();
    }

    public static Object getNewInstance(Class<?> clazz) {
        if (null == clazz) {
            return null;
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getNewInstance(String clazzName) {
        if (null == clazzName) {
            return null;
        }
        Class<?> clazz = clazzCache.get(clazzName);
        try {
            if (clazz == null) {
                clazz = Class.forName(clazzName);
                clazzCache.put(clazzName, clazz);
            }
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object newInstance(String clazzName) {
        if (null == clazzName) {
            return null;
        }
        Class<?> clazz = clazzCache.get(clazzName);
        try {
            if (clazz == null) {
                clazz = Class.forName(clazzName);
                clazzCache.put(clazzName, clazz);
            }
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Class getClassByName(String clazzName) {
        if (null == clazzName) {
            return null;
        }
        Class<?> clazz = clazzCache.get(clazzName);
        try {
            if (clazz == null) {
                clazz = Class.forName(clazzName);
                clazzCache.put(clazzName, clazz);
            }
            return clazz;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final List<Class> findPackageClasses(String configPackage) throws IOException {
        String configPackagePath = configPackage.replace('.', '/');
        ClassLoader loader = ClassUtil.class.getClassLoader();
        Enumeration<URL> urls = loader.getResources(configPackagePath);
        URL url = urls.hasMoreElements() ? urls.nextElement() : null;
        String filePath = ClassUtil.getFilePath(url);
        ArrayList<Class> classList = new ArrayList<Class>();
        if ("jar".equals(url.getProtocol())) {
            JarInputStream jiStream = new JarInputStream(new FileInputStream(new File(filePath)));
            JarEntry jarEntry = null;
            while ((jarEntry = jiStream.getNextJarEntry()) != null) {
                Class clazz;
                String fileName;
                String entryName = jarEntry.getName();
                if (!entryName.startsWith(configPackagePath) || !(fileName = entryName.toLowerCase()).endsWith(".class") || (clazz = ClassUtil.loadClass(loader, entryName)) == null) continue;
                classList.add(clazz);
            }
        } else if ("file".equals(url.getProtocol())) {
            File[] files;
            File dir = new File(filePath);
            for (File file : files = dir.listFiles()) {
                Class clazz;
                String fileName = file.getName().toLowerCase();
                if (!fileName.endsWith(".class") || (clazz = ClassUtil.loadClass(loader, configPackagePath + "/" + file.getName())) == null) continue;
                classList.add(clazz);
            }
        } else {
            throw new RuntimeException("\u67e5\u627e\u5305'" + configPackage + "'\u4e0b\u6240\u6709\u7c7b\u5931\u8d25\uff0c\u4e0d\u652f\u6301\u7684\u67e5\u627e\u8def\u5f84\uff1a" + url.getPath());
        }
        return classList;
    }

    private static String getFilePath(URL jarUrl) {
        String urlFile = jarUrl.getFile();
        int separatorIndex = urlFile.indexOf(JAR_URL_SEPARATOR);
        if (separatorIndex != -1) {
            urlFile = urlFile.substring(0, separatorIndex);
        }
        try {
            return new URI(urlFile).getPath();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private static Class loadClass(ClassLoader loader, String classFile) {
        try {
            classFile = classFile.substring(0, classFile.length() - 6).replace('/', '.');
            return loader.loadClass(classFile);
        }
        catch (ClassNotFoundException e) {
            logger.warn((Object)e.getMessage());
            return null;
        }
    }

    public static Method[] findClassMethods(Class clazz, Class[] paramTypes, Class returnType, int modifier) {
        Method[] methods;
        LinkedList<Method> resultMethods = new LinkedList<Method>();
        for (Method method : methods = clazz.getMethods()) {
            if (modifier != -1 && modifier != method.getModifiers() || !Arrays.equals(paramTypes, method.getParameterTypes()) || returnType != method.getReturnType() && !returnType.equals(method.getReturnType())) continue;
            resultMethods.add(method);
        }
        return resultMethods.toArray(new Method[0]);
    }

    public static Method getMethodIgnoreCaseWithoutParams(Class<?> clazz, String methodName) throws NoSuchMethodException, SecurityException {
        if (methodName == null || methodName.trim().length() == 0 || clazz == null) {
            return null;
        }
        String key = clazz.getName() + methodName;
        Method method = methodCache.get(key);
        if (method == null && !methodNullCache.contains(key)) {
            try {
                method = clazz.getMethod(methodName, new Class[0]);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (method == null) {
                Method[] methods;
                for (Method m : methods = clazz.getMethods()) {
                    if (m.getParameterTypes().length != 0 || !methodName.equalsIgnoreCase(m.getName())) continue;
                    method = m;
                    break;
                }
            }
            if (method == null) {
                methodNullCache.add(key);
            }
            methodCache.put(key, method);
        }
        return method;
    }
}

