/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.openapi.third.login;

import com.kingdee.bos.openapi.third.ctx.IloginContext;
import com.kingdee.bos.openapi.third.ctx.LTPALogin;
import com.kingdee.bos.openapi.third.invoker.AbstractHttpLoginContext;
import com.kingdee.bos.openapi.third.utils.OpenApiTools;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class KGSContext
extends AbstractHttpLoginContext {
    protected final KGSHeader kgsHeader;

    private KGSContext(Builder builder) {
        this.ip = builder.ip;
        this.port = builder.port;
        this.kgsHeader = builder.kgsHeader;
        this.loginContext = builder.loginContext;
        if (builder.isHttps) {
            this.setHttps();
        }
        this.connectTimeout = builder.connectTimeout;
        this.readTimeout = builder.readTimeout;
    }

    @Override
    public String getUrl() {
        if (this.loginContext instanceof LTPALogin) {
            return "/easopenapilogin/ltpalogin";
        }
        return "/easopenapilogin/login";
    }

    @Override
    public String getInvokeUrl() {
        return "/easopenapi/api";
    }

    @Override
    protected void init() throws Exception {
        super.init();
        this.requestHeaders.put("X-Api-SignHeaders", "X-Api-TimeStamp,X-Api-Nonce");
        this.requestHeaders.put("X-Api-ClientID", this.kgsHeader.clienID);
        this.requestHeaders.put("X-Api-Auth-Version", this.kgsHeader.authVersion);
        this.requestHeaders.put("X-Api-TimeStamp", String.valueOf(this.kgsHeader.ts));
        this.requestHeaders.put("X-Api-Nonce", this.kgsHeader.nonce);
        StringBuffer paramStr = new StringBuffer();
        Map<String, String> map = this.getloginMap();
        for (String key : map.keySet()) {
            paramStr.append(key).append("=").append(map.get(key)).append("&");
        }
        paramStr.deleteCharAt(paramStr.length() - 1);
        String signature = OpenApiTools.generateKGSSignature("GET", this.getUrl(), paramStr.toString(), this.kgsHeader.nonce, this.kgsHeader.ts, this.kgsHeader.secret);
        this.requestHeaders.put("X-Api-Signature", signature);
    }

    @Override
    public Map<String, String> getRequestHeaders4Invoke() throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.putAll(this.requestHeaders);
        String paramStr = "token=" + URLEncoder.encode(URLEncoder.encode(this.getToken(), "utf-8"), "utf-8");
        String signature = OpenApiTools.generateKGSSignature("POST", this.getInvokeUrl(), paramStr, this.kgsHeader.nonce, this.kgsHeader.ts, this.kgsHeader.secret);
        headers.put("X-Api-Signature", signature);
        return headers;
    }

    public static class KGSHeader {
        private String clienID;
        private String secret;
        private String authVersion = "2.0";
        private long ts;
        private String nonce;

        public KGSHeader(String clienID, String secret, long ts, String nonce) {
            this.clienID = clienID;
            this.secret = secret;
            this.ts = ts;
            this.nonce = nonce;
        }

        public KGSHeader authVersion(String authVersion) {
            this.authVersion = authVersion;
            return this;
        }
    }

    public static class Builder {
        private final KGSHeader kgsHeader;
        private final String ip;
        private final int port;
        private final IloginContext loginContext;
        private boolean isHttps;
        private int connectTimeout = 120000;
        private int readTimeout = 120000;

        public Builder(String ip, int port, KGSHeader kgsHeader, IloginContext loginContext) {
            this.kgsHeader = kgsHeader;
            this.loginContext = loginContext;
            this.ip = ip;
            this.port = port;
        }

        public Builder https(boolean isHttps) {
            this.isHttps = isHttps;
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public KGSContext build() {
            if (OpenApiTools.isEmpty(this.ip)) {
                throw new IllegalArgumentException("Invalid parameters ip");
            }
            if (this.loginContext == null) {
                throw new IllegalArgumentException("Invalid parameters loginContext");
            }
            if (this.kgsHeader == null) {
                throw new IllegalArgumentException("Invalid parameters kgsHeader");
            }
            if (OpenApiTools.isEmpty(this.kgsHeader.clienID)) {
                throw new IllegalArgumentException("Invalid parameters kgsHeader.clienID");
            }
            if (OpenApiTools.isEmpty(this.kgsHeader.secret)) {
                throw new IllegalArgumentException("Invalid parameters kgsHeader.secret");
            }
            if (OpenApiTools.isEmpty(this.kgsHeader.nonce)) {
                throw new IllegalArgumentException("Invalid parameters kgsHeader.nonce");
            }
            return new KGSContext(this);
        }
    }
}

