/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.openapi.third.ctx;

import com.kingdee.bos.openapi.third.ctx.IloginContext;
import com.kingdee.bos.openapi.third.utils.OpenApiTools;
import java.net.URLEncoder;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class CommonLogin
implements IloginContext {
    private static String URL = "/easportal/openapi/login";
    protected final String userName;
    protected final String password;
    protected final String dcName;
    protected final String language;
    protected final int isEncodePwd;
    protected final String appid;
    protected final String authPattern;
    protected final String slnName;
    protected SortedMap<String, String> map = new TreeMap<String, String>();

    private CommonLogin(Builder builder) {
        this.userName = builder.userName;
        this.password = builder.password;
        this.dcName = builder.dcName;
        this.language = builder.language;
        this.isEncodePwd = builder.isEncodePwd;
        this.appid = builder.appid;
        this.authPattern = builder.authPattern;
        this.slnName = builder.slnName;
        try {
            this.init();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void init() throws Exception {
        this.map.put("user", this.userName);
        this.map.put("password", URLEncoder.encode(this.password, "utf-8"));
        this.map.put("dcName", this.dcName);
        this.map.put("language", this.language);
        this.map.put("isEncodePwd", String.valueOf(this.isEncodePwd));
        if (this.appid != null && this.appid.trim() != "") {
            this.map.put("appid", this.appid);
        }
        if (this.authPattern != null && this.authPattern.trim() != "") {
            this.map.put("authPattern", this.authPattern);
        }
        if (this.slnName != null && this.slnName.trim() != "") {
            this.map.put("slnName", this.slnName);
        }
    }

    @Override
    public Map<String, String> getMap() {
        return this.map;
    }

    @Override
    public String getURL() {
        return URL;
    }

    public static class Builder {
        private final String userName;
        private final String password;
        private final String dcName;
        private final String language;
        private int isEncodePwd = 0;
        private String appid = null;
        protected String authPattern = "BaseDB";
        protected String slnName = null;

        public Builder(String userName, String password, String dcName, String language) {
            this.userName = userName;
            this.password = password;
            this.dcName = dcName;
            this.language = language;
        }

        public Builder isEncodePwd(int isEncodePwd) {
            this.isEncodePwd = isEncodePwd;
            return this;
        }

        public Builder appid(String appid) {
            this.appid = appid;
            return this;
        }

        public Builder authPattern(String authPattern) {
            this.authPattern = authPattern;
            return this;
        }

        public Builder slnName(String slnName) {
            this.slnName = slnName;
            return this;
        }

        public IloginContext build() {
            this.check();
            return new CommonLogin(this);
        }

        public void check() throws IllegalArgumentException {
            if (OpenApiTools.isEmpty(this.userName)) {
                throw new IllegalArgumentException("Invalid parameters userName");
            }
            if (this.password == null) {
                throw new IllegalArgumentException("Invalid parameters password");
            }
            if (OpenApiTools.isEmpty(this.dcName)) {
                throw new IllegalArgumentException("Invalid parameters dcName");
            }
            if (OpenApiTools.isEmpty(this.language)) {
                throw new IllegalArgumentException("Invalid parameters language");
            }
        }
    }
}

