/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.base;

import cn.hutool.core.util.ObjectUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.ConvertUtils;

public class BaseMap
extends HashMap<String, Object> {
    private static final long serialVersionUID = 1L;

    public BaseMap() {
    }

    public BaseMap(Map<String, Object> map) {
        this.putAll(map);
    }

    @Override
    public BaseMap put(String key, Object value) {
        super.put(key, Optional.ofNullable(value).orElse(""));
        return this;
    }

    public BaseMap add(String key, Object value) {
        super.put(key, Optional.ofNullable(value).orElse(""));
        return this;
    }

    public <T> T get(String key) {
        Object obj = super.get(key);
        if (ObjectUtil.isNotEmpty(obj)) {
            return (T)obj;
        }
        return null;
    }

    public Boolean getBoolean(String key) {
        Object obj = super.get(key);
        if (ObjectUtil.isNotEmpty(obj)) {
            return Boolean.valueOf(obj.toString());
        }
        return false;
    }

    public Long getLong(String key) {
        Object v = this.get(key);
        if (ObjectUtil.isNotEmpty(v)) {
            return new Long(v.toString());
        }
        return null;
    }

    public Long[] getLongs(String key) {
        Object v = this.get(key);
        if (ObjectUtil.isNotEmpty(v)) {
            return (Long[])v;
        }
        return null;
    }

    public List<Long> getListLong(String key) {
        List list = (List)this.get(key);
        if (ObjectUtil.isNotEmpty((Object)list)) {
            return list.stream().map(e -> new Long((String)e)).collect(Collectors.toList());
        }
        return null;
    }

    public Long[] getLongIds(String key) {
        Object ids = this.get(key);
        if (ObjectUtil.isNotEmpty(ids)) {
            return (Long[])ConvertUtils.convert((String[])ids.toString().split(","), Long.class);
        }
        return null;
    }

    public Integer getInt(String key, Integer def) {
        Object v = this.get(key);
        if (ObjectUtil.isNotEmpty(v)) {
            return Integer.parseInt(v.toString());
        }
        return def;
    }

    public Integer getInt(String key) {
        Object v = this.get(key);
        if (ObjectUtil.isNotEmpty(v)) {
            return Integer.parseInt(v.toString());
        }
        return 0;
    }

    public BigDecimal getBigDecimal(String key) {
        Object v = this.get(key);
        if (ObjectUtil.isNotEmpty(v)) {
            return new BigDecimal(v.toString());
        }
        return new BigDecimal("0");
    }

    public <T> T get(String key, T def) {
        Object obj = super.get(key);
        if (ObjectUtil.isEmpty(obj)) {
            return def;
        }
        return (T)obj;
    }

    public static BaseMap toBaseMap(Map<String, Object> obj) {
        BaseMap map = new BaseMap();
        map.putAll(obj);
        return map;
    }
}

