/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.util;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class PoiExcelTempUtil {
    public static void reset(Sheet sheet, int startRow, int endRow) {
        if (sheet.getWorkbook() instanceof HSSFWorkbook) {
            return;
        }
        for (int i = startRow; i <= endRow; ++i) {
            Row row = sheet.getRow(i);
            if (row == null) continue;
            int cellNum = row.getLastCellNum();
            block8: for (int j = 0; j < cellNum; ++j) {
                if (row.getCell(j) == null) continue;
                Map map = PoiExcelTempUtil.copyCell(row.getCell(j));
                row.removeCell(row.getCell(j));
                Cell cell = row.createCell(j);
                cell.setCellStyle((CellStyle)map.get("cellStyle"));
                if (((Boolean)map.get("isDate")).booleanValue()) {
                    cell.setCellValue((Date)map.get("value"));
                    continue;
                }
                CellType cellType = (CellType)map.get("cellType");
                switch (cellType) {
                    case NUMERIC: {
                        cell.setCellValue(((Double)map.get("value")).doubleValue());
                        continue block8;
                    }
                    case STRING: {
                        cell.setCellValue((String)map.get("value"));
                        continue block8;
                    }
                    case FORMULA: {
                        cell.setCellFormula((String)map.get("value"));
                        continue block8;
                    }
                    case BLANK: {
                        continue block8;
                    }
                    case BOOLEAN: {
                        cell.setCellValue(((Boolean)map.get("value")).booleanValue());
                        continue block8;
                    }
                }
            }
        }
    }

    private static Map copyCell(Cell cell) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cellType", cell.getCellType());
        map.put("isDate", CellType.NUMERIC == cell.getCellType() && DateUtil.isCellDateFormatted((Cell)cell));
        map.put("value", PoiExcelTempUtil.getValue(cell));
        map.put("cellStyle", cell.getCellStyle());
        return map;
    }

    private static Object getValue(Cell cell) {
        if (CellType.NUMERIC == cell.getCellType() && DateUtil.isCellDateFormatted((Cell)cell)) {
            return cell.getDateCellValue();
        }
        switch (cell.getCellType()) {
            case _NONE: {
                return null;
            }
            case NUMERIC: {
                return cell.getNumericCellValue();
            }
            case STRING: {
                return cell.getStringCellValue();
            }
            case FORMULA: {
                return cell.getCellFormula();
            }
            case BLANK: {
                break;
            }
            case BOOLEAN: {
                return cell.getBooleanCellValue();
            }
        }
        return null;
    }
}

