/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.process.adapter.delegate;

import cn.hutool.core.util.ArrayUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang.StringUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.JavaDelegate;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.variable.api.persistence.entity.VariableInstance;
import org.jeecg.common.api.dto.message.MessageDTO;
import org.jeecg.common.config.TenantContext;
import org.jeecg.common.constant.enums.MessageTypeEnum;
import org.jeecg.common.constant.enums.Vue3MessageHrefEnum;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.vo.UserAccountInfo;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.extbpm.enums.TaskTipTypeEnum;
import org.jeecg.modules.extbpm.process.adapter.delegate.datahandle.service.MessagePushService;
import org.jeecg.modules.extbpm.process.adapter.entity.ChildAttr;
import org.jeecg.modules.extbpm.process.entity.ExtActProcess;
import org.jeecg.modules.extbpm.process.entity.ExtActProcessNodeDeployment;
import org.jeecg.modules.extbpm.service.ProcessUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="messageDelegate")
public class MessageDelegate
implements JavaDelegate {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageDelegate.class);
    @Autowired
    private ISysBaseAPI baseApi;
    @Autowired
    private ProcessUtils processUtils;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private MessagePushService messagePushService;
    public static ExecutorService cachedThreadPool = new ThreadPoolExecutor(0, 1024, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());

    public void execute(DelegateExecution delegateExecution) {
        if (this.baseApi == null) {
            this.baseApi = (ISysBaseAPI)SpringContextUtils.getBean(ISysBaseAPI.class);
        }
        if (this.processUtils == null) {
            this.processUtils = (ProcessUtils)SpringContextUtils.getBean((String)"processUtils");
        }
        if (this.messagePushService == null) {
            this.messagePushService = (MessagePushService)SpringContextUtils.getBean(MessagePushService.class);
        }
        ExecutionEntity executionEntity = (ExecutionEntity)delegateExecution;
        String processDefinitionKey = executionEntity.getProcessDefinitionKey();
        String executionId = executionEntity.getId();
        String processInstanceId = executionEntity.getProcessInstanceId();
        ExtActProcess extActProcess = this.processUtils.getExtActProcessByProcessKey(processDefinitionKey);
        if (ObjectUtils.isNotEmpty((Object)extActProcess)) {
            String processId = extActProcess.getId();
            String activityId = executionEntity.getActivityId();
            Integer tenantId = extActProcess.getTenantId();
            ExtActProcessNodeDeployment extActProcessNode = this.processUtils.getExtActProcessNodeDeployment(processId, activityId);
            String taskDefKey = extActProcessNode.getProcessNodeCode();
            log.info("-------\u3010\u6d88\u606f\u901a\u77e5\u8282\u70b9\u3011-----\u63a8\u9001\u6d88\u606f\u5f00\u59cb--------------");
            log.info("\u3010\u6d88\u606f\u901a\u77e5\u8282\u70b9\u3011\u4f20\u5165\u53c2\u6570 tenantId={}\uff0cexecutionId={}\uff0ctaskId= {}\uff0ctaskName= {} ,processInstanceId= {}", new Object[]{tenantId, executionId, activityId, extActProcessNode.getProcessNodeName(), processId});
            this.sendMessage(extActProcess, delegateExecution, extActProcessNode, executionId, processInstanceId, activityId, taskDefKey, tenantId);
        }
    }

    private void sendMessage(ExtActProcess extActProcess, DelegateExecution delegateExecution, ExtActProcessNodeDeployment extActProcessNode, String executionId, String processInstanceId, String activityId, String taskDefKey, Integer tenantId) {
        String nodeConfig;
        if (ObjectUtils.isNotEmpty((Object)extActProcessNode) && StringUtil.isNotEmpty((String)(nodeConfig = extActProcessNode.getNodeConfigJson()))) {
            log.debug("-----\u3010\u6d88\u606f\u901a\u77e5\u8282\u70b9\u3011--------\u6d88\u606f\u53d1\u9001\u914d\u7f6enodeConfig:{}--------------", (Object)nodeConfig);
            ChildAttr childAttr = (ChildAttr)JSON.parseObject((String)nodeConfig, ChildAttr.class);
            String type = childAttr.getType();
            String templateContext = childAttr.getTemplateContext();
            String jsonContext = childAttr.getJsonContext();
            Map<String, Object> data = this.getData(delegateExecution, type, tenantId, processInstanceId, activityId, taskDefKey);
            log.debug("\u6a21\u677f\u89e3\u6790\uff0c\u539f\u59cb\u7684templateContext = {}", (Object)templateContext);
            log.debug("\u6a21\u677f\u89e3\u6790\uff0c\u6570\u636e\u5bf9\u8c61 data = {}", data);
            templateContext = this.messagePushService.parseContent(extActProcess, templateContext, jsonContext, data, processInstanceId, executionId);
            log.debug("\u6a21\u677f\u89e3\u6790\uff0c\u89e3\u6790\u540e\u7684templateContext = {}", (Object)templateContext);
            String title = childAttr.getTitle();
            String[] toUserIds = childAttr.getToUserIds();
            MessageDTO messageDTO = new MessageDTO();
            HashSet<String> emailList = new HashSet<String>();
            String toUsers = this.getToUsers(toUserIds, executionId, processInstanceId, emailList);
            if (toUsers == null) {
                log.error("\u6d88\u606f\u63a5\u6536\u4eba\u4e3a\u7a7a\uff01");
                messageDTO.setToAll(Boolean.valueOf(true));
            } else {
                messageDTO.setToAll(Boolean.valueOf(false));
                messageDTO.setToUser(toUsers);
                messageDTO.setToEmailList(emailList);
            }
            if (oConvertUtils.isEmpty((Object)toUsers) && emailList.size() == 0) {
                this.sendHandleExceptionMsg(extActProcess, extActProcessNode, processInstanceId, executionId);
                return;
            }
            HashSet<String> ccEmailList = new HashSet<String>();
            String[] copyToUserId = childAttr.getCopyToUserIds();
            String ccUsers = this.getToUsers(copyToUserId, executionId, processInstanceId, ccEmailList);
            if (ccUsers != null) {
                messageDTO.setCopyToUser(ccUsers);
                messageDTO.setCcEmailList(ccEmailList);
            }
            messageDTO.setTitle(title);
            data.put("NOTICE_MSG_BUS_TYPE", Vue3MessageHrefEnum.BPM_SYSTEM_MSG.getBusType());
            messageDTO.setType(type);
            messageDTO.setIsMarkdown(true);
            messageDTO.setFromUser("system");
            messageDTO.setContent(templateContext);
            messageDTO.setData(data);
            cachedThreadPool.execute(() -> {
                log.debug("-------\u3010\u6d88\u606f\u901a\u77e5\u8282\u70b9\u3011-----\u8fdb\u5165\u5f02\u6b65\u63a8\u9001-----------Begin---");
                log.info("------\u3010\u6d88\u606f\u901a\u77e5\u8282\u70b9\u3011------\u5f02\u6b65\u6d88\u606f\u53d1\u9001\u5bf9\u8c61 : {} ", (Object)JSON.toJSONString((Object)messageDTO));
                TenantContext.setTenant((String)oConvertUtils.getString((Object)tenantId));
                this.baseApi.sendTemplateMessage(messageDTO);
                log.debug("-------\u3010\u6d88\u606f\u901a\u77e5\u8282\u70b9\u3011-----\u5f02\u6b65\u63a8\u9001\u7ed3\u675f-----------End---");
            });
        }
    }

    private String getToUsers(String[] toUserIds, String executionId, String processInstanceId, Set<String> emailList) {
        String[] ids;
        List list;
        List tempUserIdList;
        if (toUserIds == null || toUserIds.length == 0) {
            return null;
        }
        HashSet<String> usernames = new HashSet<String>();
        ArrayList<String> roleCodes = new ArrayList<String>();
        ArrayList<String> deptIds = new ArrayList<String>();
        HashSet userIds = new HashSet();
        for (String str : toUserIds) {
            if (str.startsWith("var.")) {
                List<String> tempEmails;
                String jsonStr = str.replace("var.", "");
                JSONObject json = JSON.parseObject((String)jsonStr);
                String fieldType = json.getString("fieldType");
                Object value = this.messagePushService.getValueByJsonObject(json, executionId, processInstanceId);
                if (value == null) continue;
                if ("select-user".equals(fieldType)) {
                    List<String> tempUsers = this.messagePushService.getListValue(value);
                    if (tempUsers.size() <= 0) continue;
                    usernames.addAll(tempUsers);
                    continue;
                }
                if ("select-depart".equals(fieldType)) {
                    List<String> tempDeps = this.messagePushService.getListValue(value);
                    if (tempDeps.size() <= 0) continue;
                    deptIds.addAll(tempDeps);
                    continue;
                }
                if ("org-role".equals(fieldType)) {
                    List<String> tempRoles = this.messagePushService.getListValue(value);
                    if (tempRoles.size() <= 0) continue;
                    roleCodes.addAll(tempRoles);
                    continue;
                }
                if (!"email".equals(fieldType) || (tempEmails = this.messagePushService.getListValue(value)).size() <= 0) continue;
                usernames.add("_email");
                for (String email : tempEmails) {
                    emailList.add(email);
                }
                continue;
            }
            String[] array = str.split("\\.");
            String type = array[0];
            if ("user".equals(type)) {
                usernames.add(array[1]);
                continue;
            }
            if ("role".equals(type)) {
                roleCodes.add(array[1]);
                continue;
            }
            if ("dept".equals(type)) {
                deptIds.add(array[1]);
                continue;
            }
            usernames.add(type);
        }
        if (roleCodes.size() > 0) {
            tempUserIdList = this.baseApi.queryUserIdsByRoleds(roleCodes);
            userIds.addAll(tempUserIdList);
        }
        if (deptIds.size() > 0) {
            tempUserIdList = this.baseApi.queryUserIdsByDeptIds(deptIds);
            userIds.addAll(tempUserIdList);
        }
        if (userIds.size() > 0 && (list = this.baseApi.queryAllUserByIds(ids = userIds.toArray(new String[userIds.size()]))) != null && list.size() > 0) {
            for (UserAccountInfo u : list) {
                usernames.add(u.getUsername());
            }
        }
        if (usernames.size() > 0) {
            String result = String.join((CharSequence)",", usernames);
            return result;
        }
        return null;
    }

    private Map<String, Object> getData(DelegateExecution delegateExecution, String type, Integer tenantId, String processInstanceId, String activityId, String taskDefKey) {
        String ddMobileUrl;
        ExecutionEntity executionEntity = (ExecutionEntity)delegateExecution;
        HashMap<String, Object> data = new HashMap<String, Object>(5);
        Map variableInstanceMaps = delegateExecution.getVariableInstances();
        if (ObjectUtils.isNotEmpty((Object)variableInstanceMaps)) {
            for (Map.Entry entry : variableInstanceMaps.entrySet()) {
                String value;
                String name = (String)entry.getKey();
                VariableInstance variableInstance = (VariableInstance)entry.getValue();
                if (!ObjectUtils.isNotEmpty((Object)variableInstance) || !StringUtil.isNotEmpty((String)(value = variableInstance.getTextValue()))) continue;
                data.put(name, value);
            }
        }
        String processName = executionEntity.getProcessInstance().getProcessDefinitionName();
        String nodeName = executionEntity.getCurrentFlowElement().getName();
        data.put("_FW_NODE_NAME", nodeName);
        data.put("_FW_NAME", processName);
        data.put("_FW_MOBILE_URL", this.messagePushService.getDDMobileHrefUrl(processInstanceId, activityId, taskDefKey, tenantId));
        data.put("_FW_TITLE", executionEntity.getVariable("bpm_biz_title"));
        data.put("NOTICE_MSG_SUMMARY", this.messagePushService.getFormDetailRouteInfo(executionEntity));
        if (!MessageTypeEnum.XT.getType().equals(type)) {
            data.put("NOTICE_MSG_BUS_ID", executionEntity.getId());
        }
        String url = "";
        if (TaskTipTypeEnum.YJ.getType().equals(type)) {
            url = this.messagePushService.getEmailHrefUrl(data);
        }
        if (TaskTipTypeEnum.DD.getType().equals(type)) {
            url = this.messagePushService.getAppHrefUrl(data);
            ddMobileUrl = this.messagePushService.getDDMobileHrefUrl(processInstanceId, activityId, taskDefKey, tenantId);
            data.put("_FW_MOBILE_URL", ddMobileUrl);
        }
        if (TaskTipTypeEnum.QYWX.getType().equals(type)) {
            url = this.messagePushService.getAppHrefUrl(data);
            ddMobileUrl = this.messagePushService.getDDMobileHrefUrl(processInstanceId, activityId, taskDefKey, tenantId);
            data.put("_FW_MOBILE_URL", ddMobileUrl);
        }
        data.put("_FW_URL", url);
        return data;
    }

    public String[] getUserIds(String toUserExpression, String executionId, String processInstanceId) {
        if (StringUtils.isNotEmpty((CharSequence)toUserExpression)) {
            JSONObject jsonObject = JSONObject.parseObject((String)toUserExpression);
            Object value = this.messagePushService.getValueByJsonObject(jsonObject, executionId, processInstanceId);
            if (value == null) {
                return null;
            }
            if (value instanceof JSONArray) {
                if (ObjectUtils.isNotEmpty((Object)value)) {
                    JSONArray jsonArray = (JSONArray)value;
                    List list = jsonArray.toJavaList(String.class);
                    return (String[])ArrayUtil.toArray((Collection)list, String.class);
                }
            } else if (value instanceof String) {
                return value.toString().split(",");
            }
        }
        return null;
    }

    public void sendHandleExceptionMsg(ExtActProcess extActProcess, ExtActProcessNodeDeployment extActProcessNode, String processInstanceId, String executeId) {
        JSONObject json;
        JSONArray arr;
        String str = extActProcess.getErrorNoticeUserIds();
        if (oConvertUtils.isNotEmpty((Object)str) && (arr = (json = JSONObject.parseObject((String)str)).getJSONArray("toUserIds")).size() > 0) {
            String users = this.getErrorNodeToUsers(arr);
            String redisKey = extActProcess.getProcessKey() + extActProcessNode.getId() + "_nodeError";
            log.info("redisKey:" + redisKey);
            boolean sendFlag = false;
            String repeat = extActProcess.getErrorNoticeRepeat();
            long time = 0L;
            if (oConvertUtils.isEmpty((Object)repeat) || "0".equals(repeat)) {
                sendFlag = true;
            } else {
                Object redisVal = this.redisUtil.get(redisKey);
                if (redisVal == null) {
                    sendFlag = true;
                }
                time = (long)Integer.parseInt(repeat) * 60L;
            }
            String error = "\u3010\u6d41\u7a0b\u9519\u8bef\u3011\u5728\u6d41\u7a0b\u201c" + extActProcess.getProcessName() + "\u201d\u4e2d\uff0c\u8282\u70b9\u201c" + extActProcessNode.getProcessNodeName() + "\u201d\u4e2d\uff0c\u6d88\u606f/\u90ae\u4ef6\u63a5\u6536\u4eba\u65e0\u6548\uff0c\u6d41\u7a0b\u65e0\u6cd5\u7ee7\u7eed\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u63a5\u6536\u4eba\uff01";
            if (sendFlag) {
                MessageDTO messageDTO = new MessageDTO();
                messageDTO.setType(MessageTypeEnum.XT.getType());
                messageDTO.setToAll(Boolean.valueOf(false));
                messageDTO.setToUser(users);
                messageDTO.setTitle("\u3010\u6d41\u7a0b\u9519\u8bef\u3011");
                messageDTO.setFromUser("system");
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("NOTICE_MSG_BUS_TYPE", "msg_node");
                messageDTO.setData(data);
                messageDTO.setContent(error);
                this.baseApi.sendTemplateMessage(messageDTO);
                if (time > 0L) {
                    this.redisUtil.set(redisKey, (Object)1, time);
                }
            } else {
                log.error(error);
            }
            this.processUtils.stopProcessInstanceById(processInstanceId, executeId);
        }
    }

    private String getErrorNodeToUsers(JSONArray userArray) {
        String[] ids;
        List list;
        List tempUserIdList;
        HashSet<String> usernames = new HashSet<String>();
        ArrayList<String> roleCodes = new ArrayList<String>();
        ArrayList<String> deptIds = new ArrayList<String>();
        HashSet userIds = new HashSet();
        for (Object str : userArray) {
            String user = str.toString();
            String[] array = user.split("\\.");
            String type = array[0];
            if ("user".equals(type)) {
                usernames.add(array[1]);
                continue;
            }
            if ("role".equals(type)) {
                roleCodes.add(array[1]);
                continue;
            }
            if ("dept".equals(type)) {
                deptIds.add(array[1]);
                continue;
            }
            usernames.add(type);
        }
        if (roleCodes.size() > 0) {
            tempUserIdList = this.baseApi.queryUserIdsByRoleds(roleCodes);
            userIds.addAll(tempUserIdList);
        }
        if (deptIds.size() > 0) {
            tempUserIdList = this.baseApi.queryUserIdsByDeptIds(deptIds);
            userIds.addAll(tempUserIdList);
        }
        if (userIds.size() > 0 && (list = this.baseApi.queryAllUserByIds(ids = userIds.toArray(new String[userIds.size()]))) != null && list.size() > 0) {
            for (UserAccountInfo u : list) {
                usernames.add(u.getUsername());
            }
        }
        if (usernames.size() > 0) {
            String result = String.join((CharSequence)",", usernames);
            return result;
        }
        return null;
    }
}

