/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.bpm.cmd;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import lombok.Generated;
import org.flowable.common.engine.impl.calendar.CronExpression;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.runtime.ClockReader;
import org.flowable.common.engine.impl.util.DefaultClockImpl;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.job.service.TimerJobService;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntity;
import org.jeecg.common.util.DateUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.extbpm.process.common.b;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomTimeStartJobCmd
implements Serializable,
Command<Void> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomTimeStartJobCmd.class);
    protected String processKey;
    protected String formKey;
    protected String dataId;
    protected String applyUserId;
    protected Date dueDate;
    protected String triggerField;
    protected String repeat;

    public CustomTimeStartJobCmd(String processKey, String formKey, String dataId, Date dueDate, String applyUserId, String triggerField) {
        this.formKey = formKey;
        this.dataId = dataId;
        this.processKey = processKey;
        this.applyUserId = applyUserId;
        this.dueDate = dueDate;
        this.triggerField = triggerField;
    }

    public CustomTimeStartJobCmd(String processKey, String formKey, String dataId, Date dueDate, String applyUserId, String repeat, String triggerField) {
        this.formKey = formKey;
        this.dataId = dataId;
        this.processKey = processKey;
        this.applyUserId = applyUserId;
        this.dueDate = dueDate;
        this.repeat = repeat;
        this.triggerField = triggerField;
    }

    public Void execute(CommandContext commandContext) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("activityId", (Object)"start");
        jsonObject.put(b.m, (Object)this.dataId);
        jsonObject.put(b.h, (Object)this.formKey);
        jsonObject.put(b.q, (Object)this.applyUserId);
        jsonObject.put(b.o, (Object)this.triggerField);
        TimerJobService timerJobService = CommandContextUtil.getTimerJobService((CommandContext)commandContext);
        TimerJobEntity job = timerJobService.createTimerJob();
        job.setJobType("timer");
        job.setExclusive(true);
        job.setJobHandlerType("timer-start-event-custom");
        job.setDuedate(this.dueDate);
        job.setExclusive(true);
        if (oConvertUtils.isNotEmpty((Object)this.repeat)) {
            job.setRepeat(this.repeat);
            try {
                if (!this.dueDate.after(new Date())) {
                    CronExpression cronExpression = new CronExpression(this.repeat, (ClockReader)new DefaultClockImpl());
                    Date nextDuteDate = cronExpression.getNextValidTimeAfter(new Date());
                    log.info("\u6267\u884c\u65e5\u671f\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4\uff0c\u91cd\u65b0\u8ba1\u7b97\u4e0b\u6b21\u6267\u884c\u65f6\u95f4\uff01\u6267\u884c\u65e5\u671f\uff1a{}\uff0c\u901a\u8fc7\u8ba1\u7b97\u83b7\u53d6\u4e0b\u6b21\u6267\u884c\u6709\u6548\u671f\uff1a{}\uff0c\u5faa\u73af\u8868\u8fbe\u5f0f\uff1a{}", new Object[]{((SimpleDateFormat)DateUtils.datetimeFormat.get()).format(this.dueDate), ((SimpleDateFormat)DateUtils.datetimeFormat.get()).format(nextDuteDate), this.repeat});
                    job.setDuedate(nextDuteDate);
                }
            }
            catch (ParseException e2) {
                log.error("\u91cd\u65b0\u8ba1\u7b97\u4e0b\u6b21\u6267\u884c\u65f6\u95f4\u5f02\u5e38\uff1a" + e2.getMessage());
            }
        }
        ProcessDefinitionEntity processDefinition = CommandContextUtil.getProcessDefinitionEntityManager().findLatestProcessDefinitionByKey(this.processKey);
        String processDefinitionId = processDefinition.getId();
        job.setProcessDefinitionId(processDefinitionId);
        job.setJobHandlerConfiguration(jsonObject.toJSONString());
        timerJobService.scheduleTimerJob(job);
        return null;
    }
}

