/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.openapi.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.impl.MetaDataPK2;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class WhiteListFilter {
    private static Logger logger = Logger.getLogger(WhiteListFilter.class);
    private static volatile Map<String, Map<String, Set<String>>> whiteListMap = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, Map<String, Set<String>>> _getMetasWhiteList(Context ctx) throws BOSException {
        WhiteListFilter.initWhiteList(ctx);
        if (whiteListMap != null) return whiteListMap;
        Class<WhiteListFilter> clazz = WhiteListFilter.class;
        synchronized (WhiteListFilter.class) {
            if (whiteListMap != null) return whiteListMap;
            WhiteListFilter.initWhiteList(ctx);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return whiteListMap;
        }
    }

    public static void initWhiteList(Context ctx) {
        File[] files = WhiteListFilter.getWhiteListFiles();
        if (files != null && files.length > 0) {
            whiteListMap = new HashMap<String, Map<String, Set<String>>>();
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                try {
                    whiteListMap.putAll(WhiteListFilter.readFromFile(ctx, file));
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }
        }
    }

    private static File[] getWhiteListFiles() {
        File dirFile;
        String dir = System.getProperty("eas.properties.dir");
        if (!StringUtils.isEmpty((String)dir) && (dirFile = new File(dir + "/openapi/whitelist")) != null && dirFile.isDirectory()) {
            return dirFile.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isFile() && file.getName().endsWith(".xml");
                }
            });
        }
        return null;
    }

    private static Map<String, Map<String, Set<String>>> readFromFile(Context ctx, File file) throws Exception {
        HashMap<String, Map<String, Set<String>>> whitelist = new HashMap<String, Map<String, Set<String>>>();
        Document doc = null;
        try {
            FileInputStream in = new FileInputStream(file);
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build((InputStream)in);
            Element root = doc.getRootElement();
            List lists = root.getChildren("meta");
            for (int i = 0; i < lists.size(); ++i) {
                String s;
                MethodInfo method;
                int j;
                Element meta = (Element)lists.get(i);
                String type = meta.getAttributeValue("type");
                HashMap metaMap = (HashMap)whitelist.get(type);
                if (metaMap == null) {
                    metaMap = new HashMap();
                    whitelist.put(type, metaMap);
                }
                String fullName = meta.getAttributeValue("fullName");
                List parameters = meta.getChildren("parameter");
                String allowedMethods = null;
                if (parameters != null && parameters.size() > 0) {
                    for (int j2 = 0; j2 < parameters.size(); ++j2) {
                        Element parameter = (Element)parameters.get(j2);
                        if (!"allowedMethods".equals(parameter.getAttributeValue("name"))) continue;
                        allowedMethods = parameter.getAttributeValue("value");
                    }
                }
                allowedMethods = allowedMethods == null ? ".*" : allowedMethods.replace("*", ".*");
                IObjectValue Object2 = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).get(BOSObjectType.create((String)type), (IMetaDataPK)MetaDataPK2.create((String)fullName));
                HashSet<String> set = new HashSet<String>();
                if (Object2 instanceof BusinessObjectInfo) {
                    MethodCollection methodCollection = ((BusinessObjectInfo)Object2).getMethods();
                    for (j = 0; j < methodCollection.size(); ++j) {
                        method = methodCollection.get(j);
                        s = method.toString();
                        if (!s.matches(allowedMethods)) continue;
                        set.add(s);
                    }
                } else if (Object2 instanceof FunctionObjectInfo) {
                    OperationCollection operations = ((FunctionObjectInfo)Object2).getOperation();
                    for (j = 0; j < operations.size(); ++j) {
                        method = operations.get(j).getMethodRef();
                        s = method.toString();
                        if (!s.matches(allowedMethods)) continue;
                        set.add(s);
                    }
                } else {
                    logger.error((Object)("meta:" + fullName + " is not BusinessObjectInfo"));
                }
                metaMap.put(fullName + "!" + type, set);
            }
        }
        catch (Throwable t) {
            logger.error((Object)t);
        }
        return whitelist;
    }
}

