/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.openapi.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.openapi.common.OpenAPiConstant;
import com.kingdee.bos.openapi.third.utils.OpenApiTools;
import com.kingdee.bos.openapi.util.OpenApiSynFactory;
import com.kingdee.util.db.SQLUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class OpenApiUtils {
    private static final Logger logger = Logger.getLogger(OpenApiUtils.class);

    public static String getCookie(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null && cookies.length > 0) {
            for (Cookie cookie : cookies) {
                if (!name.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public static String sha1(String data) throws Exception {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(data.getBytes("utf-8"));
            byte[] messageDigest = digest.digest();
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < messageDigest.length; ++i) {
                String shaHex = Integer.toHexString(messageDigest[i] & 0xFF);
                if (shaHex.length() < 2) {
                    hexString.append(0);
                }
                hexString.append(shaHex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)e);
            throw e;
        }
    }

    public static void clearCache(Context ctx) {
        OpenApiSynFactory.getInstance().clearCache(ctx);
    }

    public static void ClearAllCache() {
        OpenApiSynFactory.getInstance().ClearAllCache();
    }

    public static String exportDatabySql(Context ctx, List<String> list) throws Exception {
        if (list == null || list.size() == 0) {
            return null;
        }
        String number = "";
        for (String str : list) {
            number = number + "'" + str + "'";
        }
        String sql = "";
        StringBuffer sb = new StringBuffer("select * from t_api_openapiTree where fnumber in (").append(number).append(")");
        String insertSql = OpenApiUtils.gen_InsertScript(ctx, sb.toString());
        sql = sql + insertSql;
        sb = new StringBuffer("select * from T_API_OPENAPI where FTreeID in (select fid from T_API_OPENAPITREE where fnumber in (").append(number).append("))");
        insertSql = OpenApiUtils.gen_InsertScript(ctx, sb.toString());
        sql = sql + insertSql;
        sb = new StringBuffer("select * from T_API_OPENAPIPARAM where FPARENTID in (select fid from T_API_OPENAPI where FTreeID in (select fid from T_API_OPENAPITREE where fnumber in (").append(number).append(")))");
        insertSql = OpenApiUtils.gen_InsertScript(ctx, sb.toString());
        sql = sql + insertSql;
        return sql;
    }

    public static String gen_InsertScript(Context ctx, String string) throws BOSException {
        Connection conn = null;
        PreparedStatement stmt = null;
        String rstValue = null;
        ResultSet rs = null;
        try {
            int e;
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(string);
            rs = stmt.executeQuery();
            String from = "from";
            String lc = string.toLowerCase();
            int s = lc.indexOf(from);
            String tableName = null;
            if (s > 0 && (e = lc.indexOf(" ", s = from.length() + s + 1)) > 0) {
                tableName = lc.substring(s, e).trim();
            }
            rstValue = OpenApiUtils.genInsertSql(tableName, rs);
        }
        catch (SQLException exp) {
            try {
                throw new BOSException((Throwable)exp);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return rstValue;
    }

    private static String genInsertSql(String tableName, ResultSet rs) throws SQLException {
        int i;
        if (rs == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        StringBuffer headSb = new StringBuffer();
        ResultSetMetaData mddata = rs.getMetaData();
        if (OpenApiTools.isEmpty(tableName)) {
            tableName = "T_Temp_Table";
        }
        headSb.append("insert into ");
        headSb.append(tableName);
        headSb.append("(");
        for (i = 1; i <= mddata.getColumnCount(); ++i) {
            if (i > 1) {
                headSb.append(", ");
            }
            headSb.append(mddata.getColumnName(i));
        }
        headSb.append(")");
        headSb.append("\n");
        headSb.append(" values \n");
        headSb.append("(");
        while (rs.next()) {
            sb.append("\n");
            sb.append(headSb.toString());
            for (i = 1; i <= mddata.getColumnCount(); ++i) {
                if (i > 1) {
                    sb.append(", ");
                }
                sb.append(OpenApiUtils.getRowValue(rs, i, mddata.getColumnType(i), mddata.getColumnTypeName(i)));
            }
            sb.append(")");
            sb.append(";\n");
        }
        return sb.toString();
    }

    private static Object getRowValue(ResultSet rs, int i, int type, String dispTypeName) throws SQLException {
        Object o = rs.getObject(i);
        if (o == null) {
            return "null";
        }
        switch (type) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return o.toString();
            }
            case -1: 
            case 1: 
            case 12: 
            case 2004: 
            case 2005: {
                if (o.toString().trim().length() == 44 || o.toString().trim().length() == 28) {
                    return "'" + rs.getString(i) + "'";
                }
                return "N'" + rs.getString(i) + "'";
            }
            case 16: {
                return o.toString();
            }
            case 91: {
                return "{d'" + OpenAPiConstant.FORMAT_DAY.format(o) + "'}";
            }
            case 92: 
            case 93: {
                return "{ts'" + OpenAPiConstant.FORMAT_TIME.format(o) + "'}";
            }
            case 0: {
                return null;
            }
            case 1111: {
                return "'" + rs.getString(i) + "'";
            }
        }
        return "'" + rs.getString(i) + "'";
    }
}

