/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.openapi.app.core.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.openapi.app.core.AbstractProcessor;
import com.kingdee.bos.openapi.app.core.cache.SessionUtil;
import com.kingdee.bos.openapi.common.bo.LoginDataInfo;
import com.kingdee.bos.openapi.common.bo.LoginInfo;
import com.kingdee.bos.openapi.common.bo.LtpaLoginInfo;
import com.kingdee.bos.openapi.common.bo.ResultInfo;
import com.kingdee.bos.openapi.util.ThrowableHelper;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaToken;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaTokenManager;
import com.kingdee.util.StringUtils;
import java.util.Map;
import org.apache.log4j.Logger;

public class OpenApiLoginProcessor
extends AbstractProcessor {
    private static final Logger logger = Logger.getLogger(OpenApiLoginProcessor.class);
    public static final String EAS_DEFAULT_AUTH_PATTERN = "BaseDB";
    private static final String EAS_LTPA_URL = "/login/ltpa/";

    @Override
    public String getTargetURI() {
        return "/login/";
    }

    @Override
    public ResultInfo process(Map<String, Object> params, Object reqBody) throws Exception {
        ResultInfo resultInfo = null;
        try {
            resultInfo = this.reqUrl.startsWith(EAS_LTPA_URL) ? this.loginByLtpa(params, reqBody) : this.login(params, reqBody);
        }
        catch (Exception e) {
            logger.error((Object)e);
            resultInfo = this.handleError(e);
        }
        return resultInfo;
    }

    private ResultInfo login(Map<String, Object> params, Object reqBody) throws Exception {
        String userName = null;
        String password = null;
        String dcName = null;
        String language = null;
        String slnName = null;
        String authPattern = null;
        int isEncodePwd = 0;
        String appid = null;
        LoginInfo loginInfo = this.dataType.parse2Object(null, (String)reqBody, LoginInfo.class);
        if (loginInfo == null) {
            userName = (String)params.get("user");
            password = (String)params.get("password");
            dcName = (String)params.get("dcName");
            language = (String)params.get("language");
            authPattern = (String)params.get("authPattern");
            slnName = (String)params.get("slnName");
            isEncodePwd = params.get("isEncodePwd") == null ? 0 : Integer.valueOf((String)params.get("isEncodePwd"));
            appid = (String)params.get("appid");
        } else {
            userName = loginInfo.getUser();
            password = loginInfo.getPassword();
            dcName = loginInfo.getDcName();
            language = loginInfo.getLanguage();
            authPattern = loginInfo.getAuthPattern();
            slnName = loginInfo.getSlnName();
            isEncodePwd = loginInfo.getIsEncodePwd();
            appid = loginInfo.getAppid();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("openapi login. %s,%s,%s,%s,%s,%d,%s,%s", userName, password, dcName, language, this.clientIp, isEncodePwd, appid, authPattern));
        }
        if (StringUtils.isEmpty((String)userName) || StringUtils.isEmpty((String)dcName) || StringUtils.isEmpty((String)language)) {
            return new ResultInfo(1010, "Invalid parameters");
        }
        if ("BaseTrdLtpaToken".equals(authPattern)) {
            if (!OpenApiLoginProcessor.authenticate(userName, password)) {
                throw new BOSException("loginByLtpaToken fail,ltpaToken is wrong. userName:" + userName + ", password:" + password);
            }
            LtpaToken token = LtpaTokenManager.generate((String)userName, (String)LtpaTokenManager.getDefaultLtpaConfig());
            password = token.getTokenStr();
            isEncodePwd = 0;
        }
        String encodePwd = null;
        encodePwd = isEncodePwd == 0 ? SessionUtil.encodePassword(userName, password) : (isEncodePwd == 1 ? password : password);
        String token = SessionUtil.getTokenId(userName, encodePwd, dcName, language, slnName, authPattern, this.clientIp, appid);
        return this.handleResult(0, "\u6267\u884c\u6210\u529f", token);
    }

    private ResultInfo loginByLtpa(Map<String, Object> params, Object reqBody) throws Exception {
        String appid = null;
        String dcName = null;
        String timestamp = null;
        String signiture = null;
        String username = null;
        String language = null;
        String solution = null;
        LtpaLoginInfo loginInfo = this.dataType.parse2Object(null, (String)reqBody, LtpaLoginInfo.class);
        if (loginInfo == null) {
            appid = (String)params.get("appid");
            dcName = (String)params.get("dcName");
            timestamp = (String)params.get("timestamp");
            signiture = (String)params.get("signiture");
            username = (String)params.get("username");
            language = (String)params.get("language");
            solution = (String)params.get("solution");
        } else {
            appid = loginInfo.getAppid();
            dcName = loginInfo.getDcName();
            timestamp = loginInfo.getTimestamp();
            signiture = loginInfo.getSigniture();
            username = loginInfo.getUsername();
            language = loginInfo.getLanguage();
            solution = loginInfo.getSolution();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("openapi login by ltpa. %s,%s,%s,%s,%s,%s,%s,%s", appid, dcName, timestamp, signiture, username, language, solution, this.clientIp));
        }
        if (StringUtils.isEmpty((String)appid) || StringUtils.isEmpty((String)dcName) || StringUtils.isEmpty((String)timestamp) || StringUtils.isEmpty((String)signiture) || StringUtils.isEmpty((String)username) || StringUtils.isEmpty((String)language)) {
            return this.handleResult(1010, "Invalid parameters", null);
        }
        long now = System.currentTimeMillis();
        long ts = Long.parseLong(timestamp);
        if (Math.abs(ts - now) > 3600000L) {
            return this.handleResult(1010, "Invalid parameters", null);
        }
        String token = SessionUtil.getTokenByLtpa(appid, dcName, signiture, username, language, solution, ts, this.clientIp);
        return this.handleResult(0, "", token);
    }

    private ResultInfo handleResult(int errCode, String errmsg, String token) {
        LoginDataInfo dataInfo = null;
        if (!StringUtils.isEmpty((String)token)) {
            dataInfo = new LoginDataInfo(token);
        }
        return new ResultInfo(errCode, errmsg, this.dataType.parse2String(null, dataInfo));
    }

    private ResultInfo handleError(Throwable t) {
        String errStackTace = ThrowableHelper.toString(t);
        ResultInfo resultInfo = new ResultInfo();
        resultInfo.setErrCode(1010);
        resultInfo.setErrMsg("Invalid parameters");
        resultInfo.setErrStackTrace(errStackTace);
        return resultInfo;
    }

    private static boolean authenticate(String userNumber, String password) {
        boolean result = false;
        LtpaTokenManager.loadDefaultConfig();
        if (StringUtils.isEmpty((String)password)) {
            return false;
        }
        String token = password;
        if (LtpaTokenManager.isValid((String)token)) {
            result = LtpaTokenManager.compare((String)token, (String)userNumber);
        }
        logger.debug((Object)("BaseLtpaToken:" + userNumber + "/" + password));
        return result;
    }
}

